/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.model;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.FileNotReadException;

public final class Parameter {
    private Logger ioFileLogger = Logger.getLogger((String)"l7gui_I/O.File");
    private static Logger ioFileLogger_s = Logger.getLogger((String)"l7gui_I/O.File");
    private static final String FILENAME = "/etc/l7vs/l7gui.cf";
    public static final String SESSION_TIMEOUT = "max_session_time";
    public static final String L7VSADM_TIMEOUT_FLAG = "l7vsadm_timeout_flag";
    protected static Parameter instance = null;
    protected HashMap<String, String> paramMap = null;

    protected Parameter() {
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)"11001 class Parameter created.");
        }
        this.paramMap = new HashMap();
        try {
            this.loadFromFile();
        }
        catch (Exception e) {
            this.ioFileLogger.error((Object)"41001 Cannot read l7gui.cf file.");
        }
    }

    public static synchronized Parameter getInstance() {
        if (ioFileLogger_s.isDebugEnabled()) {
            ioFileLogger_s.debug((Object)"11002 Parameter::getInstance() in");
        }
        if (instance == null) {
            instance = new Parameter();
        }
        if (ioFileLogger_s.isDebugEnabled()) {
            ioFileLogger_s.debug((Object)("11003 Parameter::getInstance() out return=(" + instance + ")"));
        }
        return instance;
    }

    protected void loadFromFile() throws FileNotReadException {
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)"11004 Parameter::loadFromFile() throws FileNotReadException in");
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(FILENAME)));
            String str = br.readLine();
            while (str != null) {
                String[] params = (str = str.replaceAll("\\s", "")).split("=", 2);
                if (params.length == 2 && !params[0].startsWith("#")) {
                    this.setValue(params[0], params[1]);
                }
                str = br.readLine();
            }
        }
        catch (Exception e) {
            StringBuffer buf = new StringBuffer();
            FileNotReadException ex = new FileNotReadException();
            buf.append("Cannot open file: ");
            buf.append(FILENAME);
            buf.append(" / Exception Message: ");
            buf.append(e.getMessage());
            ex.setFileName(FILENAME);
            ex.setErrMessage(buf.toString());
            if (this.ioFileLogger.isDebugEnabled()) {
                this.ioFileLogger.debug((Object)("11005 Parameter::loadFromFile() throws FileNotReadException out exception=\"" + ex.toString() + "\""));
            }
            throw ex;
        }
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)"11006 Parameter::loadFromFile() throws FileNotReadException out");
        }
    }

    public String setValue(String key, String value) {
        if (this.ioFileLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Parameter::setValue(String key, String value) in ");
            buf.append("key=\"" + key + "\", ");
            buf.append("value=\"" + value + "\"");
            this.ioFileLogger.debug((Object)("11007 " + buf.toString()));
        }
        String oldValue = null;
        if (key != null) {
            oldValue = this.paramMap.put(key, value);
        }
        if (this.ioFileLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Parameter::setValue(String key, String value) out ");
            buf.append("return=\"" + oldValue + "\"");
            this.ioFileLogger.debug((Object)("11008 " + buf.toString()));
        }
        return oldValue;
    }

    public String getValue(String key) {
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)("11009 Parameter::getValue(String key) in key=\"" + key + "\""));
        }
        String value = this.paramMap.get(key);
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)("11010 Parameter::getValue(String key) out return=\"" + value + "\""));
        }
        return value;
    }

    public String toString() {
        return "paramMap=(" + this.paramMap + ")";
    }
}

