/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.EndPoint;
import org.ultramonkey.l7.controller.VirtualSetting;
import org.ultramonkey.l7.model.ExecuteMode;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.SessionTransData;
import org.ultramonkey.l7.view.CommandExecuter;
import org.ultramonkey.l7.view.L7guiServletBase;
import org.ultramonkey.l7.view.ValidationCheck;

public class VSModServlet
extends L7guiServletBase {
    static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger((String)"l7gui_I/O");

    public VSModServlet() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11349 class VSModServlet created.");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("VSModServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11350 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            this.logger.debug((Object)("11351 QueryString=\"" + request.getQueryString() + "\""));
        }
        response.sendRedirect("index.jsp");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11352 VSModServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String redirectPage;
        ExecuteMode mode;
        MessageView error;
        Object p;
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("VSModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11353 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            Enumeration keys = request.getParameterNames();
            String post = "";
            while (keys.hasMoreElements()) {
                if (post.length() != 0) {
                    post = String.valueOf(post) + "&";
                }
                String key = (String)keys.nextElement();
                post = String.valueOf(post) + key + "=" + request.getParameter(key);
            }
            this.logger.debug((Object)("11354 PostData=\"" + post + "\""));
        }
        super.doPost(request, response);
        HttpSession session = request.getSession(false);
        if (!this.login || session == null) {
            if (session != null) {
                MessageView error2 = new MessageView(41087, "l7gui_UserAuthentication", "Invalid session.");
                session.setAttribute("resultMessage", (Object)error2);
            }
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11355 VSModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        request.setCharacterEncoding("UTF-8");
        HashMap tmpMap = (HashMap)request.getParameterMap();
        if (tmpMap == null) {
            MessageView error3 = new MessageView(41088, "l7gui_VirtualService", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error3);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11356 VSModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        HashMap<String, String> inputVsMap = new HashMap<String, String>();
        ArrayList<Integer> realRemoveKey = new ArrayList<Integer>();
        for (String key : tmpMap.keySet()) {
            p = Pattern.compile("rs(\\d+)_remove");
            Matcher m = ((Pattern)p).matcher(key);
            if (m.matches()) {
                realRemoveKey.add(Integer.parseInt(m.group(1)));
            }
            inputVsMap.put(key, ((String[])tmpMap.get(key))[0]);
        }
        if (inputVsMap.containsKey("Remove") && realRemoveKey.size() > 0) {
            p = realRemoveKey.iterator();
            while (p.hasNext()) {
                int key = (Integer)p.next();
                try {
                    inputVsMap.remove("rs" + key + "_ip");
                    inputVsMap.remove("rs" + key + "_port");
                    inputVsMap.remove("rs" + key + "_weight");
                }
                catch (Exception m) {
                    // empty catch block
                }
            }
        }
        HashMap<String, String> invalidMap = new HashMap<String, String>();
        boolean validationFlag = true;
        VirtualSetting vs = new VirtualSetting();
        ValidationCheck val = new ValidationCheck();
        validationFlag = val.vsCheck(inputVsMap, invalidMap, vs);
        if (inputVsMap.containsKey("Add")) {
            String new_ip = inputVsMap.get("new_ip");
            String new_port = inputVsMap.get("new_port");
            String new_weight = inputVsMap.get("new_weight");
            if (new_ip != null && new_port != null && new_weight != null && new_ip.length() != 0 && new_ip.length() != 0 && new_weight.length() != 0) {
                try {
                    EndPoint new_real = new EndPoint(new_ip, new_port, Integer.parseInt(new_weight), 0L, 0L);
                    for (EndPoint real : vs.real) {
                        if (!real.equals(new_real)) continue;
                        new_real = null;
                        error = new MessageView(41089, "l7gui_VirtualService", "Already the same RealServer exists.");
                        session.setAttribute("resultMessage", (Object)error);
                        break;
                    }
                    if (new_real != null) {
                        vs.real.add(new_real);
                    }
                }
                catch (Exception new_real) {
                    // empty catch block
                }
            }
        }
        if (inputVsMap.containsKey("Remove") || inputVsMap.containsKey("Add")) {
            session.setAttribute("inputVsData", (Object)vs);
            response.sendRedirect("vs_modify.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11357 VSModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        if (!validationFlag) {
            MessageView error4 = new MessageView(21048, "l7gui_VirtualService", "Validation error.");
            session.setAttribute("resultMessage", (Object)error4);
            session.setAttribute("inputVsData", (Object)vs);
            session.setAttribute("invalidMessage", invalidMap);
            response.sendRedirect("vs_modify.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11358 VSModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        VirtualSetting oldVs = (VirtualSetting)session.getAttribute("oldVsData");
        if (oldVs == null) {
            MessageView error5 = new MessageView(41090, "l7gui_VirtualService", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error5);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11359 VSModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        String vsName = String.valueOf(oldVs.virtual.host) + ":" + oldVs.virtual.port + " " + oldVs.protomod + " " + oldVs.option;
        session.setAttribute("vsName", (Object)vsName);
        CommandExecuter thread = new CommandExecuter(session);
        String button_mode = inputVsMap.get("button");
        if (button_mode != null && button_mode.equals("Apply")) {
            mode = ExecuteMode.VS_MODIFY_APPLY;
            redirectPage = "vs_modify_executive.jsp";
        } else if (button_mode != null && button_mode.equals("Save")) {
            mode = ExecuteMode.VS_MODIFY_SAVE;
            redirectPage = "vs_modify_executive.jsp";
        } else if (button_mode != null && button_mode.equals("Save + Sync")) {
            mode = ExecuteMode.VS_MODIFY_SAVESYNC;
            redirectPage = "savesync_executive.jsp";
            SessionTransData trans = new SessionTransData();
            trans.sourceURI = "vs_modify.jsp";
            trans.destURI = "um7state_info.jsp";
            trans.errorURI = "vs_modify_fail.jsp";
            session.setAttribute("pageTrans", (Object)trans);
        } else {
            error = new MessageView(41091, "l7gui_VirtualService", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11360 VSModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        try {
            thread.setExecute(mode, oldVs, vs);
            thread.start();
        }
        catch (Exception e) {
            MessageView error6 = new MessageView(41092, "l7gui_VirtualService", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error6);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11361 VSModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        response.sendRedirect(redirectPage);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11362 VSModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }
}

