/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.model;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.FileNotReadException;
import org.ultramonkey.l7.model.FileNotWriteException;
import org.ultramonkey.l7.model.UserData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UserManager {
    static final long serialVersionUID = 1L;
    protected static final String FileName = "/opt/l7vsd/userdata.dat";
    protected static UserManager instance = null;
    protected Vector<UserData> uservec = null;
    protected Vector<UserData> olduservec = null;

    protected UserManager() throws FileNotReadException {
        Logger userLogger = Logger.getLogger((String)"l7gui_UserManage");
        if (userLogger.isDebugEnabled()) {
            userLogger.debug((Object)"11011 class UserManager created.");
        }
        this.uservec = new Vector();
        this.loadFromFile();
    }

    public static synchronized UserManager getInstance() {
        Logger userLogger = Logger.getLogger((String)"l7gui_UserManage");
        if (userLogger.isDebugEnabled()) {
            userLogger.debug((Object)"11012 UserManager::getInstance() in");
        }
        if (instance == null) {
            try {
                instance = new UserManager();
            }
            catch (FileNotReadException e) {
                userLogger.error((Object)("41002 Exception occured: " + e.getMessage()));
                if (userLogger.isDebugEnabled()) {
                    userLogger.debug((Object)"11013 UserManager::getInstance() out return=null");
                }
                return null;
            }
        }
        if (userLogger.isDebugEnabled()) {
            userLogger.debug((Object)("11014 UserManager::getInstance() out return=(" + instance + ")"));
        }
        return instance;
    }

    protected void saveToFile() throws FileNotWriteException {
        Logger userLogger = Logger.getLogger((String)"l7gui_UserManage");
        if (userLogger.isDebugEnabled()) {
            userLogger.debug((Object)"11015 UserManager::saveToFile() throws FileNotWriteException in");
        }
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(FileName));
            oos.writeObject(this.uservec);
            oos.close();
        }
        catch (IOException e) {
            this.uservec = this.olduservec;
            FileNotWriteException exception = new FileNotWriteException();
            exception.setFileName(FileName);
            exception.setErrMessage("Cannot write file.");
            userLogger.error((Object)("41003 Exception occured: " + e.getMessage()));
            if (userLogger.isDebugEnabled()) {
                userLogger.debug((Object)("11016 UserManager::saveToFile() throws FileNotWriteException out exception=\"" + exception.toString() + "\""));
            }
            throw exception;
        }
        if (userLogger.isDebugEnabled()) {
            userLogger.debug((Object)"11017 UserManager::saveToFile() throws FileNotWriteException out");
        }
    }

    protected void loadFromFile() throws FileNotReadException {
        Logger userLogger = Logger.getLogger((String)"l7gui_UserManage");
        if (userLogger.isDebugEnabled()) {
            userLogger.debug((Object)"11018 UserManager::loadFromFile() throws FileNotReadException in");
        }
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(FileName));
            this.uservec = (Vector)ois.readObject();
            ois.close();
        }
        catch (FileNotFoundException ex) {
            FileNotReadException exception = new FileNotReadException();
            exception.setFileName(FileName);
            exception.setErrMessage("Cannot read file.");
            userLogger.error((Object)("41004 Exception occured: " + ex.getMessage()));
            if (userLogger.isDebugEnabled()) {
                userLogger.debug((Object)("11019 UserManager::loadFromFile() throws FileNotReadException out exception=\"" + exception.toString() + "\""));
            }
            throw exception;
        }
        catch (IOException ex) {
            FileNotReadException exception = new FileNotReadException();
            exception.setFileName(FileName);
            exception.setErrMessage("Catch IOException: " + ex.getMessage());
            userLogger.error((Object)("41005 Exception occured: " + ex.getMessage()));
            if (userLogger.isDebugEnabled()) {
                userLogger.debug((Object)("11020 UserManager::loadFromFile() throws FileNotReadException out exception=\"" + exception.toString() + "\""));
            }
            throw exception;
        }
        catch (ClassNotFoundException ex) {
            FileNotReadException exception = new FileNotReadException();
            exception.setFileName(FileName);
            exception.setErrMessage("Catch ClassNotFoundException.");
            userLogger.error((Object)("41006 Exception occured: " + ex.getMessage()));
            if (userLogger.isDebugEnabled()) {
                userLogger.debug((Object)("11021 UserManager::loadFromFile() throws FileNotReadException out exception=\"" + exception.toString() + "\""));
            }
            throw exception;
        }
        if (userLogger.isDebugEnabled()) {
            userLogger.debug((Object)"11022 UserManager::loadFromFile() throws FileNotReadException out");
        }
    }

    public UserData authUser(String userid, String userpass) {
        Logger userLogger = Logger.getLogger((String)"l7gui_UserManage");
        if (userLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("UserManager::authUser(String userid, String userpass) in ");
            buf.append("userid=\"" + userid + "\", ");
            buf.append("userpass=\"" + userpass + "\"");
            userLogger.debug((Object)("11023 " + buf.toString()));
        }
        UserData ret = null;
        if (userid != null || userpass != null) {
            for (UserData data : this.uservec) {
                if (!data.userName.equals(userid) || !data.passwd.equals(userpass)) continue;
                ret = data;
                break;
            }
        }
        if (userLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("UserManager::authUser(String userid, String userpass) out ");
            buf.append("return=(" + ret + ")");
            userLogger.debug((Object)("11024 " + buf.toString()));
        }
        return ret;
    }

    public void closeUser(HttpServletRequest request) {
        HttpSession session;
        Logger userLogger = Logger.getLogger((String)"l7gui_UserManage");
        if (userLogger.isDebugEnabled()) {
            userLogger.debug((Object)("11025 UserManager::closeUser(HttpServletRequest request) in request=(" + request + ")"));
        }
        if (request != null && (session = request.getSession()) != null) {
            session.invalidate();
        }
        if (userLogger.isDebugEnabled()) {
            userLogger.debug((Object)"11026 UserManager::closeUser(HttpServletRequest request) out");
        }
    }

    public UserData findUser(String userid) {
        Logger userLogger = Logger.getLogger((String)"l7gui_UserManage");
        if (userLogger.isDebugEnabled()) {
            userLogger.debug((Object)("11027 UserManager::findUser(String userid) in userid=\"" + userid + "\""));
        }
        UserData ret = null;
        if (userid != null) {
            for (UserData data : this.uservec) {
                if (!data.userName.equals(userid)) continue;
                ret = data;
            }
        }
        if (userLogger.isDebugEnabled()) {
            userLogger.debug((Object)("11028 UserManager::findUser(String userid) out return=(" + ret + ")"));
        }
        return ret;
    }

    public boolean addUser(String userid, String password, int acl, String description) throws FileNotWriteException {
        Logger userLogger = Logger.getLogger((String)"l7gui_UserManage");
        if (userLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("UserManager::addUser(String userid, String password, int acl, String description) throws FileNotWriteException in ");
            buf.append("userid=\"" + userid + "\", ");
            buf.append("password=\"" + password + "\", ");
            buf.append("acl=" + acl + ", ");
            buf.append("description=\"" + description + "\"");
            userLogger.debug((Object)("11029 " + buf.toString()));
        }
        if (userid == null || password == null || description == null) {
            if (userLogger.isDebugEnabled()) {
                userLogger.debug((Object)"11030 UserManager::addUser(String userid, String password, int acl, String description) throws FileNotWriteException out return=false");
            }
            return false;
        }
        UserData data = this.findUser(userid);
        if (data != null) {
            if (userLogger.isDebugEnabled()) {
                userLogger.debug((Object)"11031 UserManager::addUser(String userid, String password, int acl, String description) throws FileNotWriteException out return=false");
            }
            return false;
        }
        data = new UserData();
        data.userName = userid;
        data.passwd = password;
        data.acl = acl;
        data.description = description;
        this.deepCopy();
        this.uservec.add(data);
        this.saveToFile();
        if (userLogger.isDebugEnabled()) {
            userLogger.debug((Object)"11032 UserManager::addUser(String userid, String password, int acl, String description) throws FileNotWriteException out return=true");
        }
        return true;
    }

    public boolean changeUser(UserData data) throws FileNotWriteException {
        Logger userLogger = Logger.getLogger((String)"l7gui_UserManage");
        if (userLogger.isDebugEnabled()) {
            userLogger.debug((Object)("11033 UserManager::changeUser(UserData data) throws FileNotWriteException in data=(" + data + ")"));
        }
        if (data == null) {
            if (userLogger.isDebugEnabled()) {
                userLogger.debug((Object)"11034 UserManager::changeUser(UserData data) throws FileNotWriteException out return=false");
            }
            return false;
        }
        UserData found = this.findUser(data.userName);
        if (found == null) {
            if (userLogger.isDebugEnabled()) {
                userLogger.debug((Object)"11035 UserManager::changeUser(UserData data) throws FileNotWriteException out return=false");
            }
            return false;
        }
        this.deepCopy();
        found.passwd = data.passwd;
        found.acl = data.acl;
        found.description = data.description;
        this.saveToFile();
        if (userLogger.isDebugEnabled()) {
            userLogger.debug((Object)"11036 UserManager::changeUser(UserData data) throws FileNotWriteException out return=true");
        }
        return true;
    }

    public boolean delUser(String userid) throws FileNotWriteException {
        Logger userLogger = Logger.getLogger((String)"l7gui_UserManage");
        if (userLogger.isDebugEnabled()) {
            userLogger.debug((Object)("11037 UserManager::delUser(String userid) throws FileNotWriteException in userid=\"" + userid + "\""));
        }
        if (userid == null) {
            if (userLogger.isDebugEnabled()) {
                userLogger.debug((Object)"11038 UserManager::delUser(String userid) throws FileNotWriteException out return=false");
            }
            return false;
        }
        UserData data = this.findUser(userid);
        if (data != null && this.uservec.size() > 1) {
            this.deepCopy();
            this.uservec.remove(data);
            this.saveToFile();
            if (userLogger.isDebugEnabled()) {
                userLogger.debug((Object)"11039 UserManager::delUser(String userid) throws FileNotWriteException out return=true");
            }
            return true;
        }
        if (userLogger.isDebugEnabled()) {
            userLogger.debug((Object)"11040 UserManager::delUser(String userid) throws FileNotWriteException out return=false");
        }
        return false;
    }

    public Vector<UserData> getUserList() throws FileNotReadException {
        Logger userLogger = Logger.getLogger((String)"l7gui_UserManage");
        if (userLogger.isDebugEnabled()) {
            userLogger.debug((Object)"11041 UserManager::getUserList() in");
            userLogger.debug((Object)("11042 UserManager::getUserList() out return=(" + this.uservec + ")"));
        }
        this.loadFromFile();
        return this.uservec;
    }

    public void setUserList(Vector<UserData> uservec) throws FileNotWriteException {
        Logger userLogger = Logger.getLogger((String)"l7gui_UserManage");
        if (userLogger.isDebugEnabled()) {
            userLogger.debug((Object)("11043 UserManager::setUserList(Vector<UserData> uservec) in uservec=(" + uservec + ")"));
        }
        this.deepCopy();
        this.uservec = uservec;
        this.saveToFile();
        if (userLogger.isDebugEnabled()) {
            userLogger.debug((Object)"11044 UserManager::setUserList(Vector<UserData> uservec) out");
        }
    }

    protected void deepCopy() {
        this.olduservec = new Vector();
        for (UserData cur : this.uservec) {
            UserData copy = new UserData(cur);
            this.olduservec.add(copy);
        }
    }
}

