<%@ page import="org.ultramonkey.l7.model.*, org.ultramonkey.l7.controller.*, org.ultramonkey.l7.view.*" 
    language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>


<%
    /*
     * check session
     */
    if (session.isNew()) {
        MessageView error = new MessageView(41377, LogCategorySet.GUI_USER_AUTHENTICATION, Message.INVALID_SESSSION);
        session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
        response.sendRedirect(RedirectPages.LOGIN);
        return;
    }


	/*
	 * get command message
	 */
	MessageView message = (MessageView)session.getAttribute(SessionKeys.COMMAND_MESSAGE);
	
	String errorMessage = "";
	int errorNumber = 0;
	String category = "";
	
	if (message != null) {
	  errorMessage = message.getMessage();
	  errorNumber = message.getErrno();
	  category = message.getCategory();
	  session.setAttribute(SessionKeys.COMMAND_MESSAGE, null);    
	}

	
	/*
	 * get cluster status
	 */
	L7guiFramework framework = new L7guiFramework();
	ClusterData cd = framework.getClusterData();
	if (cd == null) {
		MessageView error = new MessageView(41378, LogCategorySet.GUI_IO_COMMAND,
				Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * fix style seat
	 */
	String cssSeat = "l7gui_single_style.css";
	if ( cd.self_status == ClusterStatus.ACTIVE ){
		cssSeat = "l7gui_act_style.css";
	}
	else if ( cd.self_status == ClusterStatus.STANDBY ){
		cssSeat = "l7gui_sby_style.css";
	}
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
  	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
  	<meta http-equiv="Pragma" content="no-cache">
	<meta http-equiv="Cache-Control" content="no-cache">
	<meta http-equiv="Expires" content="0"> 
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<noscript> 
		<meta http-equiv="refresh" content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>"/>
	</noscript>
	<link rel="stylesheet" type="text/css" href="<%=cssSeat %>" />
	<link rel="shortcut icon" href="images/favicon.ico" />
	<title>Failed : Modify SNMP Agent</title>
</head>


<body class="normal">

<jsp:include page="menu.jsp" flush="false"/>



<div id="content">
<h1 class="title">Failed : Modify SNMP Agent</h1>

    <h2> Error Reason : </h2>
<%
	if (errorMessage != null) {
		out.println("<p class=\"error\"> [" + category + " - " + errorNumber + "] </p>");
		out.println("<p class=\"error\">"  + errorMessage + "</p>");
	}
%>

</div>
</body>
</html>
