/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.ClusterController;
import org.ultramonkey.l7.controller.ClusterData;
import org.ultramonkey.l7.controller.DirectorController;
import org.ultramonkey.l7.controller.DirectorData;
import org.ultramonkey.l7.controller.L7vsAdmController;
import org.ultramonkey.l7.controller.L7vsAdmData;
import org.ultramonkey.l7.controller.L7vsConfCategory;
import org.ultramonkey.l7.controller.L7vsConfController;
import org.ultramonkey.l7.controller.L7vsConfData;
import org.ultramonkey.l7.controller.L7vsLogController;
import org.ultramonkey.l7.controller.LogData;
import org.ultramonkey.l7.controller.ReplicationData;
import org.ultramonkey.l7.controller.ReplicationStatus;
import org.ultramonkey.l7.controller.SnmpAgentData;
import org.ultramonkey.l7.controller.VirtualSetting;
import org.ultramonkey.l7.model.FileNotReadException;
import org.ultramonkey.l7.model.FileNotWriteException;
import org.ultramonkey.l7.model.L7SyncManager;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.SaveCategoryIdSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L7guiFramework {
    private Logger ioCommandLogger = Logger.getLogger((String)"l7gui_I/O.Command");
    private Logger ioFileLogger = Logger.getLogger((String)"l7gui_I/O.File");
    private Logger saveLogger = Logger.getLogger((String)"l7gui_Save");
    private Logger syncLogger = Logger.getLogger((String)"l7gui_Sync");
    private Logger repLogger = Logger.getLogger((String)"l7gui_Replication");
    private Logger snmpLogger = Logger.getLogger((String)"l7gui_SnmpAgent");

    public boolean addVirtualSetting(VirtualSetting vs) {
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)("11101 L7guiFramework::addVirtualSetting(VirtualSetting vs) in vs=(" + vs + ")"));
        }
        L7vsAdmController admController = new L7vsAdmController();
        boolean ret = admController.addVirtualService(vs);
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)("11102 L7guiFramework::addVirtualSetting(VirtualSetting vs) out return=" + ret));
        }
        return ret;
    }

    public boolean delVirtualSetting(VirtualSetting vs) {
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)("11103 L7guiFramework::delVirtualSetting(VirtualSetting vs) in vs=(" + vs + ")"));
        }
        L7vsAdmController admController = new L7vsAdmController();
        boolean ret = admController.delVirtualService(vs);
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)("11104 L7guiFramework::delVirtualSetting(VirtualSetting vs) out return=" + ret));
        }
        return ret;
    }

    public L7vsAdmData getAdmData() {
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)"11105 L7guiFramework::getAdmData() in");
        }
        L7vsAdmController admController = new L7vsAdmController();
        L7vsAdmData ret = admController.getData();
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)("11106 L7guiFramework::getAdmData() out return=(" + ret + ")"));
        }
        return ret;
    }

    public boolean reloadAdmData(L7vsConfCategory category) {
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)("11107 L7guiFramework::reloadAdmData() in category=" + (Object)((Object)category)));
        }
        L7vsAdmController admController = new L7vsAdmController();
        boolean ret = admController.reloadConf(category);
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)("11108 L7guiFramework::reloadAdmData() out return=" + ret));
        }
        return ret;
    }

    public ClusterData getClusterData() {
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)"11109 L7guiFramework::getClusterData() in");
        }
        ClusterController cluster = new ClusterController();
        ClusterData ret = cluster.getData();
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)("11110 L7guiFramework::getClusterData() out return=(" + ret + ")"));
        }
        return ret;
    }

    public void setClusterData(ClusterData c) {
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)("11111 L7guiFramework::setClusterData(ClusterData c) in c=(" + c + ")"));
        }
        ClusterController cluster = new ClusterController();
        cluster.setData(c);
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)"11112 L7guiFramework::setClusterData(ClusterData c) out");
        }
    }

    public boolean setClusterMode() {
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)"11113 L7guiFramework::setClusterMode() in");
        }
        ClusterController cluster = new ClusterController();
        boolean ret = cluster.changeClusterMode();
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)("11114 L7guiFramework::setClusterMode() out return=" + ret));
        }
        return ret;
    }

    public DirectorData getDirectorData() {
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)"11115 L7guiFramework::getDirectorData() in");
        }
        DirectorData d = null;
        DirectorController directord = new DirectorController();
        try {
            d = directord.getDirectorData();
        }
        catch (Exception e) {
            this.ioFileLogger.error((Object)("41016 Exception occured: " + e.getMessage()));
        }
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)("11116 L7guiFramework::getDirectorData() out return=(" + d + ")"));
        }
        return d;
    }

    public boolean setDirectorData(DirectorData d) {
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)("11117 L7guiFramework::setDirectorData(DirectorData d) in d=(" + d + ")"));
        }
        boolean ret = true;
        DirectorController directord = new DirectorController();
        try {
            directord.setDirectorData(d);
        }
        catch (FileNotWriteException e) {
            this.ioFileLogger.error((Object)("41017 Exception occured: " + e.getMessage()));
            ret = false;
        }
        catch (Exception e) {
            this.ioFileLogger.error((Object)("41018 Exception occured: " + e.getMessage()));
            ret = false;
        }
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)("11118 L7guiFramework::setDirectorData() out return=" + ret));
        }
        return ret;
    }

    public String checkDirectorData(DirectorData d) {
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)("11119 L7guiFramework::checkDirectorData(DirectorData d) in d=(" + d + ")"));
        }
        String result = null;
        DirectorController directord = new DirectorController();
        try {
            result = directord.checkDirectorData(d);
        }
        catch (FileNotWriteException e) {
            this.ioFileLogger.error((Object)("41019 Exception occured: " + e.getMessage()));
        }
        catch (Exception e) {
            this.ioFileLogger.error((Object)("41020 Exception occured: " + e.getMessage()));
        }
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)("11120 L7guiFramework::setDirectorData() out return=\"" + result + "\""));
        }
        return result;
    }

    public ReplicationData getReplicationData() {
        if (this.repLogger.isDebugEnabled()) {
            this.repLogger.debug((Object)"11121 L7guiFramework::getReplicationData() in");
        }
        ReplicationData replicationData = new ReplicationData();
        L7vsAdmController admController = new L7vsAdmController();
        L7vsAdmData admData = admController.getData();
        L7vsConfController confController = new L7vsConfController();
        try {
            L7vsConfData confData = confController.getConfData();
            replicationData.interval = confData.replicationInterval;
            replicationData.otherNode = confData.replicationOtherNode;
            replicationData.component = confData.component;
            replicationData.nic = confData.replicationNic;
            replicationData.replicationMode = admData.replicationMode;
        }
        catch (FileNotReadException e) {
            this.ioFileLogger.error((Object)("41021 Exception occured: " + e.getMessage()));
            replicationData = null;
        }
        catch (NullPointerException e) {
            this.ioFileLogger.error((Object)("41022 Exception occured: " + e.getMessage()));
            replicationData = null;
        }
        catch (Exception e) {
            this.ioFileLogger.error((Object)("41023 Exception occured: " + e.getMessage()));
            replicationData = null;
        }
        if (this.repLogger.isDebugEnabled()) {
            this.repLogger.debug((Object)("11122 L7guiFramework::getReplicationData() out return=(" + replicationData + ")"));
        }
        return replicationData;
    }

    public boolean setReplicationData(ReplicationData r) {
        if (this.repLogger.isDebugEnabled()) {
            this.repLogger.debug((Object)("11123 L7guiFramework::setReplicationData(ReplicationData r) in r=(" + r + ")"));
        }
        boolean ret = true;
        L7vsConfController confController = new L7vsConfController();
        try {
            L7vsConfData cf = confController.getConfData();
            cf.replicationInterval = r.interval;
            confController.setConfData(cf);
        }
        catch (FileNotReadException e) {
            this.ioFileLogger.error((Object)("41024 Exception occured: " + e.getMessage()));
            ret = false;
        }
        catch (FileNotWriteException e) {
            this.ioFileLogger.error((Object)("41025 Exception occured: " + e.getMessage()));
            ret = false;
        }
        catch (NullPointerException e) {
            this.ioFileLogger.error((Object)("41026 Exception occured: " + e.getMessage()));
            ret = false;
        }
        catch (Exception e) {
            this.ioFileLogger.error((Object)("41027 Exception occured: " + e.getMessage()));
            ret = false;
        }
        if (this.repLogger.isDebugEnabled()) {
            this.repLogger.debug((Object)("11124 L7guiFramework::setReplicationData(ReplicationData r) out return=" + ret));
        }
        return ret;
    }

    public boolean setReplicationMode(ReplicationStatus mode) {
        if (this.repLogger.isDebugEnabled()) {
            this.repLogger.debug((Object)("11125 L7guiFramework::setReplicationMode(ReplicationStatus mode) in mode=" + (Object)((Object)mode)));
        }
        L7vsAdmController admController = new L7vsAdmController();
        boolean ret = admController.setReplicationMode(mode);
        if (this.repLogger.isDebugEnabled()) {
            this.repLogger.debug((Object)("11126 L7guiFramework::setReplicationMode(ReplicationStatus mode) out return=" + ret));
        }
        return ret;
    }

    public boolean dumpReplicationData() {
        if (this.repLogger.isDebugEnabled()) {
            this.repLogger.debug((Object)"11127 L7guiFramework::dumpReplicationData() in");
        }
        L7vsAdmController admController = new L7vsAdmController();
        boolean ret = admController.dumpReplicationData();
        if (this.repLogger.isDebugEnabled()) {
            this.repLogger.debug((Object)("11128 L7guiFramework::dumpReplicationData() out return=" + ret));
        }
        return ret;
    }

    public SnmpAgentData getSnmpAgentData() {
        if (this.snmpLogger.isDebugEnabled()) {
            this.snmpLogger.debug((Object)"11129 L7guiFramework::getSnmpAgentData() in");
        }
        SnmpAgentData snmpData = new SnmpAgentData();
        L7vsAdmController admController = new L7vsAdmController();
        L7vsAdmData admData = admController.getData();
        L7vsConfController confController = new L7vsConfController();
        try {
            snmpData.status = admData.snmpStatus;
            L7vsConfData confData = confController.getConfData();
            snmpData.interval = confData.snmpInterval;
        }
        catch (FileNotReadException e) {
            this.ioFileLogger.error((Object)("41028 Exception occured: " + e.getMessage()));
            snmpData = null;
        }
        catch (NullPointerException e) {
            this.ioFileLogger.error((Object)("41029 Exception occured: " + e.getMessage()));
            snmpData = null;
        }
        catch (Exception e) {
            this.ioFileLogger.error((Object)("41030 Exception occured: " + e.getMessage()));
            snmpData = null;
        }
        if (this.snmpLogger.isDebugEnabled()) {
            this.snmpLogger.debug((Object)("11130 L7guiFramework::getSnmpAgentData() out return=(" + snmpData + ")"));
        }
        return snmpData;
    }

    public boolean setSnmpAgentData(SnmpAgentData s) {
        if (this.snmpLogger.isDebugEnabled()) {
            this.snmpLogger.debug((Object)("11131 L7guiFramework::setSnmpAgentData(SnmpAgentData s) in s=(" + s + ")"));
        }
        boolean ret = true;
        L7vsConfController confController = new L7vsConfController();
        try {
            L7vsConfData cf = confController.getConfData();
            cf.snmpInterval = s.interval;
            confController.setConfData(cf);
        }
        catch (FileNotReadException e) {
            this.ioFileLogger.error((Object)("41031 Exception occured: " + e.getMessage()));
            ret = false;
        }
        catch (FileNotWriteException e) {
            this.ioFileLogger.error((Object)("41032 Exception occured: " + e.getMessage()));
            ret = false;
        }
        catch (NullPointerException e) {
            this.ioFileLogger.error((Object)("41033 Exception occured: " + e.getMessage()));
            ret = false;
        }
        catch (Exception e) {
            this.ioFileLogger.error((Object)("41034 Exception occured: " + e.getMessage()));
            ret = false;
        }
        if (this.snmpLogger.isDebugEnabled()) {
            this.snmpLogger.debug((Object)("11132 L7guiFramework::setSnmpAgentData(SnmpAgentData s) out return=" + ret));
        }
        return ret;
    }

    public L7vsConfData getL7vsConfData() {
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)"11133 L7guiFramework::getL7vsConfData() in");
        }
        L7vsConfController confController = new L7vsConfController();
        L7vsConfData ret = null;
        try {
            ret = confController.getConfData();
        }
        catch (FileNotReadException e) {
            this.ioFileLogger.error((Object)("41035 Exception occured: " + e.getMessage()));
            ret = null;
        }
        catch (Exception e) {
            this.ioFileLogger.error((Object)("41036 Exception occured: " + e.getMessage()));
            ret = null;
        }
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)("11134 L7guiFramework::getL7vsConfData() out return=" + ret));
        }
        return ret;
    }

    public boolean setL7vsConfData(L7vsConfData cf) {
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)("11135 L7guiFramework::setL7vsConfData(L7vsConfData cf) in cf=(" + cf + ")"));
        }
        boolean ret = true;
        L7vsConfController confController = new L7vsConfController();
        try {
            confController.setConfData(cf);
        }
        catch (FileNotWriteException e) {
            this.ioFileLogger.error((Object)("41037 Exception occured: " + e.getMessage()));
            ret = false;
        }
        catch (Exception e) {
            this.ioFileLogger.error((Object)("41038 Exception occured: " + e.getMessage()));
            ret = false;
        }
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)("11136 L7guiFramework::setL7vsConfData(L7vsConfData cf) out return=" + ret));
        }
        return ret;
    }

    public LogData getLogData() {
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)"11137 L7guiFramework::getLogData() in");
        }
        L7vsLogController logController = new L7vsLogController();
        LogData ret = logController.getData();
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)("11138 L7guiFramework::getLogData() out return=(" + ret + ")"));
        }
        return ret;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean saveExecute(HashSet<SaveCategoryIdSet> h) {
        if (this.saveLogger.isDebugEnabled()) {
            this.saveLogger.debug((Object)("11139 L7guiFramework::saveExecute(HashSet<SaveCategoryIdSet> h) in h=(" + h + ")"));
        }
        if (h == null) {
            this.saveLogger.warn((Object)"31001 Invalid null argument.");
            if (this.saveLogger.isDebugEnabled()) {
                this.saveLogger.debug((Object)"11140 L7guiFramework::saveExecute(HashSet<SaveCategoryIdSet> h) out return=false");
            }
            return false;
        }
        L7vsAdmController admController = new L7vsAdmController();
        L7vsConfController confController = new L7vsConfController();
        for (SaveCategoryIdSet s : h) {
            switch (s) {
                case LOG_ID: {
                    L7vsAdmData admData = admController.getData();
                    try {
                        L7vsConfData cf = confController.getConfData();
                        if (admData.l7vsdLogLevel.equals(cf.logger.lbLog.logLevel) && admData.snmpLogLevel.equals(cf.logger.snmpLog.logLevel)) {
                            this.saveLogger.info((Object)"21030 All log level settings have not changed.");
                            if (this.saveLogger.isDebugEnabled()) {
                                this.saveLogger.debug((Object)"11141 L7guiFramework::saveExecute(HashSet<SaveCategoryIdSet> h) out return=false");
                            }
                            return true;
                        }
                        cf.logger.lbLog.logLevel = admData.l7vsdLogLevel;
                        cf.logger.snmpLog.logLevel = admData.snmpLogLevel;
                        confController.setConfData(cf);
                        break;
                    }
                    catch (FileNotReadException e) {
                        this.ioFileLogger.error((Object)("41039 Exception occured: " + e.getMessage()));
                        if (this.saveLogger.isDebugEnabled()) {
                            this.saveLogger.debug((Object)"11142 L7guiFramework::saveExecute(HashSet<SaveCategoryIdSet> h) out return=false");
                        }
                        return false;
                    }
                    catch (FileNotWriteException e) {
                        this.ioFileLogger.error((Object)("41040 Exception occured: " + e.getMessage()));
                        if (this.saveLogger.isDebugEnabled()) {
                            this.saveLogger.debug((Object)"11143 L7guiFramework::saveExecute(HashSet<SaveCategoryIdSet> h) out return=false");
                        }
                        return false;
                    }
                    catch (Exception e) {
                        this.ioFileLogger.error((Object)("41041 Exception occured: " + e.getMessage()));
                        if (this.saveLogger.isDebugEnabled()) {
                            this.saveLogger.debug((Object)"11144 L7guiFramework::saveExecute(HashSet<SaveCategoryIdSet> h) out return=false");
                        }
                        return false;
                    }
                }
                case VS_ID: {
                    L7vsAdmData admData = admController.getData();
                    DirectorController directord = new DirectorController();
                    try {
                        DirectorData directorData = directord.getDirectorData();
                        boolean sameFlag = true;
                        int admVsCount = admData.virtualSettings.size();
                        Vector<VirtualSetting> delVsList = new Vector<VirtualSetting>();
                        for (VirtualSetting directorVs : directorData.virtualSettings) {
                            boolean found = false;
                            for (VirtualSetting admVs : admData.virtualSettings) {
                                if (!admVs.isSameService(directorVs)) continue;
                                if (!admVs.equalsAdm(directorVs)) {
                                    directorVs.sched = admVs.sched;
                                    directorVs.qosclient = admVs.qosclient;
                                    directorVs.qosservice = admVs.qosservice;
                                    directorVs.maxconn = admVs.maxconn;
                                    directorVs.sorryserver = admVs.sorryserver;
                                    directorVs.real = admVs.real;
                                    sameFlag = false;
                                }
                                admData.virtualSettings.remove(admVs);
                                found = true;
                                break;
                            }
                            if (found) continue;
                            delVsList.add(directorVs);
                        }
                        for (VirtualSetting admVs : admData.virtualSettings) {
                            directorData.virtualSettings.add(admVs);
                            sameFlag = false;
                        }
                        for (VirtualSetting delVs : delVsList) {
                            directorData.virtualSettings.remove(delVs);
                            sameFlag = false;
                        }
                        if (sameFlag) {
                            this.saveLogger.info((Object)"21031 All Virtual Service setting have not changed.");
                            if (this.saveLogger.isDebugEnabled()) {
                                this.saveLogger.debug((Object)"11145 L7guiFramework::saveExecute(HashSet<SaveCategoryIdSet> h) out return=false");
                            }
                            return true;
                        }
                        directord.setDirectorData(directorData);
                        break;
                    }
                    catch (FileNotReadException e) {
                        this.ioFileLogger.error((Object)("41042 Exception occured: " + e.getMessage()));
                        if (this.saveLogger.isDebugEnabled()) {
                            this.saveLogger.debug((Object)"11146 L7guiFramework::saveExecute(HashSet<SaveCategoryIdSet> h) out return=false");
                        }
                        return false;
                    }
                    catch (FileNotWriteException e) {
                        this.ioFileLogger.error((Object)("41043 Exception occured: " + e.getMessage()));
                        if (this.saveLogger.isDebugEnabled()) {
                            this.saveLogger.debug((Object)"11147 L7guiFramework::saveExecute(HashSet<SaveCategoryIdSet> h) out return=false");
                        }
                        return false;
                    }
                    catch (Exception e) {
                        this.ioFileLogger.error((Object)("41044 Exception occured: " + e.getMessage()));
                        if (this.saveLogger.isDebugEnabled()) {
                            this.saveLogger.debug((Object)"11148 L7guiFramework::saveExecute(HashSet<SaveCategoryIdSet> h) out return=false");
                        }
                        return false;
                    }
                }
                default: {
                    this.saveLogger.warn((Object)"31002 Unknown save category was specified.");
                    if (this.saveLogger.isDebugEnabled()) {
                        this.saveLogger.debug((Object)"11149 L7guiFramework::saveExecute(HashSet<SaveCategoryIdSet> h) out return=false");
                    }
                    return false;
                }
            }
        }
        if (this.saveLogger.isDebugEnabled()) {
            this.saveLogger.debug((Object)"11150 L7guiFramework::saveExecute(HashSet<SaveCategoryIdSet> h) out return=true");
        }
        return true;
    }

    public boolean syncExecute(HashSet<Integer> h) {
        if (this.syncLogger.isDebugEnabled()) {
            this.syncLogger.debug((Object)("11151 L7guiFramework::syncExecute(HashSet<Integer> h) in h=(" + h + ")"));
        }
        L7SyncManager sync = new L7SyncManager();
        try {
            sync.syncAct(h);
        }
        catch (MessageView mv) {
            this.syncLogger.error((Object)("41045 Exception occured: " + mv.getMessage()));
            if (this.syncLogger.isDebugEnabled()) {
                this.syncLogger.debug((Object)"11152 L7guiFramework::syncExecute(HashSet<Integer> h) out return=false");
            }
            return false;
        }
        if (this.syncLogger.isDebugEnabled()) {
            this.syncLogger.debug((Object)"11153 L7guiFramework::syncExecute(HashSet<Integer> h) out return=true");
        }
        return true;
    }

    public boolean getL7vsdProcessStatus() {
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)"11154 L7guiFramework::getL7vsdProcessStatus() in");
        }
        boolean ret = this.processCheck("l7vsd");
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)("11155 L7guiFramework::getL7vsdProcessStatus() out return=" + ret));
        }
        return ret;
    }

    public boolean getL7directordProcessStatus() {
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)"11156 L7guiFramework::getL7directordProcessStatus() in");
        }
        boolean ret = this.processCheck("l7directord");
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)("11157 L7guiFramework::getL7directordProcessStatus() out return=" + ret));
        }
        return ret;
    }

    public boolean setLogLevel(HashMap<LogData.LogCategory, LogData.LogLevel> category) {
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)("11158 L7guiFramework::setLogLevel(HashMap<LogData.LogCategory, LogData.LogLevel> category in category=(" + category + ")"));
        }
        L7vsAdmController admController = new L7vsAdmController();
        boolean ret = admController.setLogLevel(category);
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)("11159 L7guiFramework::setLogLevel(HashMap<LogData.LogCategory, LogData.LogLevel> category out return=" + ret));
        }
        return ret;
    }

    protected boolean processCheck(String regex) {
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)("11160 L7guiFramework::processCheck(String regex) in regex=\"" + regex + "\""));
        }
        boolean found = false;
        String proc = "/proc";
        Pattern p = Pattern.compile("^\\d+$");
        Pattern l7vsd = Pattern.compile("^Name:\t" + regex + "$");
        try {
            File dir = new File(proc);
            File[] procdir = dir.listFiles();
            int i = 0;
            while (i < procdir.length) {
                block26: {
                    Matcher m = p.matcher(procdir[i].getName());
                    if (m.matches()) {
                        BufferedReader f = null;
                        try {
                            String line;
                            f = new BufferedReader(new FileReader("/proc/" + procdir[i].getName() + "/status"));
                            while ((line = f.readLine()) != null) {
                                Matcher mt = l7vsd.matcher(line);
                                if (!mt.matches()) continue;
                                found = true;
                                break;
                            }
                        }
                        catch (FileNotFoundException e) {
                            this.ioFileLogger.error((Object)("41046 Exception occured: " + e.getMessage()));
                            try {
                                if (f != null) {
                                    f.close();
                                }
                                break block26;
                            }
                            catch (Exception e2) {
                                this.ioFileLogger.error((Object)("41048 Exception occured: " + e2.getMessage()));
                            }
                            break block26;
                        }
                        catch (IOException e) {
                            try {
                                this.ioFileLogger.error((Object)("41047 Exception occured: " + e.getMessage()));
                                break block26;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                try {
                                    if (f != null) {
                                        f.close();
                                    }
                                }
                                catch (Exception e3) {
                                    this.ioFileLogger.error((Object)("41048 Exception occured: " + e3.getMessage()));
                                }
                            }
                        }
                        try {
                            if (f != null) {
                                f.close();
                            }
                        }
                        catch (Exception e) {
                            this.ioFileLogger.error((Object)("41048 Exception occured: " + e.getMessage()));
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.ioFileLogger.error((Object)("41049 Exception occured: " + e.getMessage()));
        }
        if (this.ioFileLogger.isDebugEnabled()) {
            this.ioFileLogger.debug((Object)("11161 L7guiFramework::processCheck(String regex) out return=" + found));
        }
        return found;
    }
}

