/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.ReplicationData;
import org.ultramonkey.l7.model.ExecuteMode;
import org.ultramonkey.l7.model.L7guiFramework;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.SessionTransData;
import org.ultramonkey.l7.view.CommandExecuter;
import org.ultramonkey.l7.view.L7guiServletBase;

public class ReplicationInfoChangeServlet
extends L7guiServletBase {
    static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger((String)"l7gui_I/O");

    public ReplicationInfoChangeServlet() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11297 class ReplicationInfoChangeServlet created.");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("ReplicationInfoChangeServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11298 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            this.logger.debug((Object)("11299 QueryString=\"" + request.getQueryString() + "\""));
        }
        response.sendRedirect("index.jsp");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11300 ReplicationInfoChangeServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String redirectPage;
        ExecuteMode mode;
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("ReplicationInfoChangeServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11301 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            Enumeration keys = request.getParameterNames();
            String post = "";
            while (keys.hasMoreElements()) {
                if (post.length() != 0) {
                    post = String.valueOf(post) + "&";
                }
                String key = (String)keys.nextElement();
                post = String.valueOf(post) + key + "=" + request.getParameter(key);
            }
            this.logger.debug((Object)("11302 PostData=\"" + post + "\""));
        }
        super.doPost(request, response);
        HttpSession session = request.getSession(false);
        if (!this.login || session == null) {
            if (session != null) {
                MessageView error = new MessageView(41073, "l7gui_UserAuthentication", "Invalid session.");
                session.setAttribute("resultMessage", (Object)error);
            }
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11303 ReplicationInfoChangeServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        L7guiFramework framework = new L7guiFramework();
        ReplicationData rep = framework.getReplicationData();
        if (rep == null) {
            MessageView error = new MessageView(41074, "l7gui_I/O.File", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11304 ReplicationInfoChangeServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        request.setCharacterEncoding("UTF-8");
        String str_repInterval = request.getParameter("rep_interval");
        String str_beforeRepData = Integer.toString(rep.interval);
        boolean validationFrag = this.validationCheck(session, str_repInterval, rep);
        if (!validationFrag) {
            session.setAttribute("inputRepData", (Object)rep);
            MessageView error = new MessageView(21040, "l7gui_Replication", "Invalid value.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("replication_modify.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11305 ReplicationInfoChangeServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        CommandExecuter thread = new CommandExecuter(session);
        String button_mode = request.getParameter("button");
        if (button_mode != null && button_mode.equals("Save")) {
            mode = ExecuteMode.REP_INFO_SAVE;
            redirectPage = "replication_modify_executive.jsp";
        } else if (button_mode != null && button_mode.equals("Save + Sync")) {
            mode = ExecuteMode.REP_INFO_SAVESYNC;
            redirectPage = "savesync_executive.jsp";
            SessionTransData trans = new SessionTransData();
            trans.sourceURI = "replication_modify.jsp";
            trans.destURI = "replication.jsp";
            trans.errorURI = "replication_modify_fail.jsp";
            session.setAttribute("pageTrans", (Object)trans);
        } else {
            MessageView error = new MessageView(41075, "l7gui_Replication", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11306 ReplicationInfoChangeServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        try {
            thread.setExecute(mode, rep);
            thread.start();
        }
        catch (Exception e) {
            MessageView error = new MessageView(41076, "l7gui_Replication", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11307 ReplicationInfoChangeServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        session.setAttribute("beforeRepTime", (Object)str_beforeRepData);
        String str_afterRepData = Integer.toString(rep.interval);
        session.setAttribute("afterRepTime", (Object)str_afterRepData);
        response.sendRedirect(redirectPage);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11308 ReplicationInfoChangeServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }

    protected boolean validationCheck(HttpSession session, String str_repInterval, ReplicationData rep) {
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("ReplicationInfoChangeServlet::validationCheck(HttpSession session, String str_repInterval, ReplicationData rep) in ");
            buf.append("session=(" + session + "), ");
            buf.append("str_repInterval=(" + str_repInterval + "), ");
            buf.append("rep=(" + rep + ")");
            this.logger.debug((Object)("11309 " + buf.toString()));
        }
        boolean validationFlag = true;
        int MIN_REP_INTERVAL = 10;
        int MAX_REP_INTERVAL = 10000;
        int repInterval = 0;
        if (session == null || rep == null) {
            validationFlag = false;
        } else if (str_repInterval == null || str_repInterval.length() == 0) {
            session.setAttribute("invalidMessage", (Object)"Required fields.");
            validationFlag = false;
        } else {
            try {
                repInterval = Integer.parseInt(str_repInterval);
                if (repInterval < 10 || repInterval > 10000) {
                    session.setAttribute("invalidMessage", (Object)"Validation error.");
                    validationFlag = false;
                } else {
                    rep.interval = repInterval;
                }
            }
            catch (NumberFormatException e) {
                session.setAttribute("invalidMessage", (Object)"Validation error.");
                validationFlag = false;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("11310 ReplicationInfoChangeServlet::validationCheck(HttpSession session, String str_repInterval, ReplicationData rep) out return=" + validationFlag));
        }
        return validationFlag;
    }
}

