<%@ page
	import="org.ultramonkey.l7.model.*,org.ultramonkey.l7.controller.*,org.ultramonkey.l7.view.*"
	language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>

<%
	 /*
	 * check session
	 */
	L7guiServletBase base = new L7guiServletBase();
	if (session.isNew() || base.checkSession(session) == false) {
		MessageView error = new MessageView(41283,
		LogCategorySet.GUI_USER_AUTHENTICATION,
		Message.INVALID_SESSSION);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get sessionTrans
	 */
	SessionTransData sessionTrans = (SessionTransData) session
			.getAttribute(SessionKeys.PAGE_TRANSDATA);
	String successpage = "";
	String failpage = "";
	if (sessionTrans == null) {
		MessageView error = new MessageView(41284, LogCategorySet.GUI_LOG,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	successpage = sessionTrans.destURI;
	failpage = sessionTrans.errorURI;
	if ((successpage == null) || (failpage == null)) {
		MessageView error = new MessageView(41285, LogCategorySet.GUI_LOG,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get thread status
	 */
	String threadStatus = (String) session
			.getAttribute(SessionKeys.THREAD_STATUS);
	if (threadStatus == null) {
		MessageView error = new MessageView(41286, LogCategorySet.GUI_LOG,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	if (threadStatus.equals(SessionKeys.THREAD_SUCCESS)) {
		response.sendRedirect(successpage);
		return;
	} else if (threadStatus.equals(SessionKeys.THREAD_RUNNING)) {
		//
	} else if (threadStatus.equals(SessionKeys.THREAD_FAIL)) {
		response.sendRedirect(failpage);
		return;
	} else {
		MessageView error = new MessageView(41287, LogCategorySet.GUI_LOG,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get sourcepage
	 */
	String logname = "";
	String sourcepage = "";
	sourcepage = sessionTrans.sourceURI;

	if (sourcepage == null) {
		MessageView error = new MessageView(41288, LogCategorySet.GUI_LOG,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	if (sourcepage.equals("log_lb.jsp")) {
		logname = "Load balancer";
	} else if (sourcepage.equals("log_adm.jsp")) {
		logname = "Admin command";
	} else if (sourcepage.equals("log_snmp.jsp")) {
		logname = "SNMP Agent";
	} else if (sourcepage.equals("log_gui.jsp")) {
		logname = "GUI";
	} else if (sourcepage.equals("log_sync.jsp")) {
		logname = "Sync Resource";
	} else {
		MessageView error = new MessageView(41289, LogCategorySet.GUI_LOG,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
%>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
   	<meta http-equiv="Pragma" content="no-cache">
	<meta http-equiv="Cache-Control" content="no-cache">
	<meta http-equiv="Expires" content="0"> 		
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<meta http-equiv="refresh" content="<%= RedirectPages.REFRESH_TIME %>" />
	<noscript>
		<meta http-equiv="refresh"
		content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>" />
	</noscript>
	
	<link rel="stylesheet" type="text/css" href="l7gui_basic_style.css" />
	<link rel="shortcut icon" href="images/favicon.ico" />
	<title>Changing Log Level</title>
</head>

<body>
<h1 class="title">Changing Log Level</h1>
<h2>Please wait.</h2>

</body>
</html>
