<%@ page
	import="org.ultramonkey.l7.model.*,org.ultramonkey.l7.controller.*,org.ultramonkey.l7.view.*,java.util.*"
	language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>

<%
    /*
     * check session
     */
    L7guiServletBase base = new L7guiServletBase();
	if (session.isNew() || base.checkSession(session) == false) {	 
	MessageView error = new MessageView(41322, LogCategorySet.GUI_USER_AUTHENTICATION, Message.INVALID_SESSSION); 
        session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
        response.sendRedirect(RedirectPages.LOGIN);
        return;
    }

    /*
     * get result message
     */
    MessageView message = (MessageView) session.getAttribute(SessionKeys.RESULT_MESSAGE);
    String errorMessage = "";
    int errorNumber = 0;
    String category = "";
    if (message != null) {
    	errorMessage = message.getMessage();
    	errorNumber = message.getErrno();
    	category = message.getCategory();
    	session.setAttribute(SessionKeys.RESULT_MESSAGE, null);
    }

	/*
	 * get validation error message
	 */
	HashMap<String,String> errMessage = (HashMap<String,String>) session.getAttribute(SessionKeys.INVALID_MESSAGE);
	session.setAttribute(SessionKeys.INVALID_MESSAGE, null);
    
    /*
     * get previous inputvalue
     */
     L7guiFramework framework = new L7guiFramework();
     DirectorData dd = (DirectorData) session.getAttribute(SessionKeys.INPUT_MONITOR);
    
     if (dd != null){
         session.setAttribute(SessionKeys.INPUT_MONITOR, null);
     }
     else{  
         /*
          * get DirectorData
          */ 
         dd = framework.getDirectorData();
         if (dd == null){
             MessageView error = new MessageView(41323, LogCategorySet.GUI_IO_FILE, Message.UNEXPECTED_ERROR);
             session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
             response.sendRedirect(RedirectPages.LOGIN);
             return;
         }      
     }
     
     /*
      * get cluster status
      */
     ClusterData cd = framework.getClusterData();
     if (cd == null){
         MessageView error = new MessageView(41324, LogCategorySet.GUI_IO_COMMAND, Message.CLUSTER_DATA_ERROR);
         session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
         response.sendRedirect(RedirectPages.LOGIN);
     }
      
 	/*
 	 * fix style seat
 	 */
 	String cssSeat = "l7gui_single_style.css";
 	if ( cd.self_status == ClusterStatus.ACTIVE ){
 		cssSeat = "l7gui_act_style.css";
 	}
 	else if ( cd.self_status == ClusterStatus.STANDBY ){
 		cssSeat = "l7gui_sby_style.css";
 	}
%>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta http-equiv="Pragma" content="no-cache">
	<meta http-equiv="Cache-Control" content="no-cache">
	<meta http-equiv="Expires" content="0"> 		
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<script src="l7gui.js" type="text/javascript"></script>
	<noscript>
	<meta http-equiv="refresh"
		content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>" />
	</noscript>
	<link rel="stylesheet" type="text/css" href="<%=cssSeat %>" />
	<link rel="shortcut icon" href="images/favicon.ico" />
	
	<title>Modify Monitor Info</title>

</head>

<body class="normal">
<jsp:include page="menu.jsp" flush="false" />

<div id="content">

<h1>Modify Monitor Setting</h1>

<%
if ( (message != null) && (errorMessage != null) ) {
%>
<p class="error">[<%=category%>-<%=errorNumber%>]</p>
<p class="error"><%=errorMessage%></p>
<%
}
%>


<form method="post" action="MonitorSetServlet">

<fieldset><legend>Monitor Setting</legend>

<table class="status">
	<tr>
		<th><label for="checkTimeOut">CheckTimeOut</label></th>
		<td>
		<%
            {
	            String invalidMessage = null;
	            if ( null != errMessage ){
	                invalidMessage = errMessage.get("checkTimeOut");
	            }
	            if ( null == dd.checkTimeOut ){
	                out.print("<input type=\"text\" id=\"checkTimeOut\" value=\"\" name=\"checkTimeOut\" size=\"11\" maxlength=\"11\" /> [sec]");
	            }
	            else{
	                out.print("<input type=\"text\" id=\"checkTimeOut\" value=\"" + dd.checkTimeOut + "\" name=\"checkTimeOut\" size=\"11\" maxlength=\"11\" /> [sec]");
	            }
	            if ( null != invalidMessage ){
	                out.print("<p class=\"invalid\">" + invalidMessage + "</p>");
	            }
	        }
		%>
		</td>
		<td>
		<p class="required">1-2147483647(sec)<br>
		Default : 5(sec)</p>
		</td>
	</tr>
	<tr>
		<th><label for="negotiateTimeOut">NegotiateTimeOut</label></th>
		<td>
		<%
            {
	            String invalidMessage = null;
	            if ( null != errMessage ){
	                invalidMessage = errMessage.get("negotiateTimeOut");
	            }
	            if ( null == dd.negotiateTimeOut ){
	                out.print("<input type=\"text\" id=\"negotiateTimeOut\" value=\"\" name=\"negotiateTimeOut\" size=\"11\" maxlength=\"11\" /> [sec]");
	            }
	            else{
	                out.print("<input type=\"text\" id=\"negotiateTimeOut\" value=\"" + dd.negotiateTimeOut + "\" name=\"negotiateTimeOut\" size=\"11\" maxlength=\"11\" /> [sec]");
	            }
	            if ( null != invalidMessage ){
	                out.print("<p class=\"invalid\">" + invalidMessage + "</p>");
	            }
	        }
		%>
		</td>
		<td>
		<p class="required">1-2147483647(sec)<br>
		Default is defined by the operating system.</p>
		</td>
	</tr>
	<tr>
		<th><label for="checkInterval">CheckInterval</label></th>
		<td>
		<%
            {
	            String invalidMessage = null;
	            if ( null != errMessage ){
	                invalidMessage = errMessage.get("checkInterval");
	            }
	            if ( null == dd.checkInterval ){
	                out.print("<input type=\"text\" id=\"checkInterval\" value=\"\" name=\"checkInterval\" size=\"11\" maxlength=\"11\" /> [sec]");
	            }
	            else{
	                out.print("<input type=\"text\" id=\"checkInterval\" value=\"" + dd.checkInterval + "\" name=\"checkInterval\" size=\"11\" maxlength=\"11\" /> [sec]");
	            }
	            if ( null != invalidMessage ){
	                out.print("<p class=\"invalid\">" + invalidMessage + "</p>");
	            }
	        }
		%>
		</td>
		<td>
		<p class="required">1-2147483647(sec)<br>
		Default : 10(sec)</p>
		</td>
	</tr>
	<tr>
		<th><label for="checkCount">CheckCount</label></th>
		<td>
		<%
            {
	            String invalidMessage = null;
	            if ( null != errMessage ){
	                invalidMessage = errMessage.get("checkCount");
	            }
	            if ( null == dd.checkCount ){
	                out.print("<input type=\"text\" id=\"checkCount\" value=\"\" name=\"checkCount\" size=\"11\" maxlength=\"11\" /> [time]");
	            }
	            else{
	                out.print("<input type=\"text\" id=\"checkCount\" value=\"" + dd.checkCount + "\" name=\"checkCount\" size=\"11\" maxlength=\"11\" /> [time]");
	            }
	            if ( null != invalidMessage ){
	                out.print("<p class=\"invalid\">" + invalidMessage + "</p>");
	            }
	        }
		%>
		</td>
		<td>
		<p class="required">1-2147483647(time)<br>
		Default : 1(time)</p>
		</td>
	</tr>
	<tr>
		<th><label for="callback">Callback</label></th>
		<td>
		<%
            {
	            String invalidMessage = null;
	            if ( null != errMessage ){
	                invalidMessage = errMessage.get("callback");
	            }
	            if ( null == dd.callback ){
	                out.print("<input type=\"text\" id=\"callback\" value=\"\" name=\"callback\"/>");
	            }
	            else{
	                out.print("<input type=\"text\" id=\"callback\" value=\"" + dd.callback + "\" name=\"callback\" />");
	            }
	            if ( null != invalidMessage ){
	                out.print("<p class=\"invalid\">" + invalidMessage + "</p>");
	            }
	        }
		%>
		</td>
		<td>
		<p class="required"></p>
		</td>
	</tr>
	<tr>
		<th><label for="fallback">Fallback</label></th>
		<td>
		<%
            {
	            String invalidMessage = null;
	            if ( null != errMessage ){
	                invalidMessage = errMessage.get("fallback");
	            }
	            if ( null == dd.fallback ){
	                out.print("<input type=\"text\" id=\"fallback\" value=\"\" name=\"fallback\"/>");
	            }
	            else{
	                out.print("<input type=\"text\" id=\"fallback\" value=\"" + dd.fallback + "\" name=\"fallback\" />");
	            }
	            if ( null != invalidMessage ){
	                out.print("<p class=\"invalid\">" + invalidMessage + "</p>");
	            }
	        }
		%>
		</td>
		<td>
		<p class="required"></p>
		</td>
	</tr>
	<tr>
		<th><label for="logfile">Logfile</label></th>
		<td>
		<%
            {
	            String invalidMessage = null;
	            if ( null != errMessage ){
	                invalidMessage = errMessage.get("logfile");
	            }
	            if ( null == dd.logfile ){
	                out.print("<input type=\"text\" id=\"logfile\" value=\"\" name=\"logfile\"/>");
	            }
	            else{
	                out.print("<input type=\"text\" id=\"logfile\" value=\"" + dd.logfile + "\" name=\"logfile\" />");
	            }
	            if ( null != invalidMessage ){
				    out.print("<p class=\"invalid\">" + invalidMessage + "</p>");
		        }
	        }
		%>
		</td>
		<td>
		<p class="required">Default : /var/log/l7directord.log</p>
		</td>
	</tr>
	<tr>
		<th><label for="execute">Execute</label></th>
		<td>
		<%
            {
	            String invalidMessage = null;
	            if ( null != errMessage ){
	                invalidMessage = errMessage.get("execute");
	            }
	            if ( null == dd.execute ){
	                out.print("<input type=\"text\" id=\"execute\" value=\"\" name=\"execute\"/>");
	            }
	            else{
	                out.print("<input type=\"text\" id=\"execute\" value=\"" + dd.execute + "\" name=\"execute\" />");
	            }
	            if ( null != invalidMessage ){
	                out.print("<p class=\"invalid\">" + invalidMessage + "</p>");
	            }
	        }
		%>
		</td>
		<td>
		<p class="required"></p>
		</td>
	</tr>
 
	<tr>
		<th><label for="supervised">Supervised</label></th>
		<td><select id="supervised" name="supervised">
			<option value=""></option>
			<option value="yes"<%
			   if ( ( null != dd.supervised ) && (dd.supervised.equals("yes")) )
                        out.print(" selected");
               %>>Yes</option>
			<option value="no"<%
			   if ( ( null != dd.supervised ) && (dd.supervised.equals("no")) )
                        out.print(" selected");
               %>>No</option>
		</select> <%
			if ( null != errMessage ){
            	String invalidMessage = errMessage.get("supervised");
                if ( null != invalidMessage ){
                	out.print("<p class=\"invalid\">" + invalidMessage + "</p>");
                }
            }
 %>
		</td>
		<td>
		<p class="required">Default : No</p>
		</td>

	</tr>
  
	<tr>
		<th><label for="quiescent">Quiescent</label></th>
		<td><select id="quiescent" name="quiescent">
			<option value=""></option>
			<option value="yes"<%
			   if ( ( null != dd.quiescent ) && (dd.quiescent.equals("yes")) )
                        out.print(" selected");
               %>>Yes</option>
			<option value="no"<%
			   if ( ( null != dd.quiescent ) && (dd.quiescent.equals("no")) )
                        out.print(" selected");
               %>>No</option>
		</select> <%
			if ( null != errMessage ){
            	String invalidMessage = errMessage.get("quiescent");
                if ( null != invalidMessage ){
                	out.print("<p class=\"invalid\">" + invalidMessage + "</p>");
                }
            }
 %>
		</td>
		<td>
		<p class="required">Default : No</p>
		</td>
	</tr>
</table>
</fieldset>

<br />

<input type="submit" name="button" value="<%=ButtonMode.SAVE %>" onClick="return confirm(monitor_modify_save)" />
<%
if (cd.self_status == ClusterStatus.ACTIVE || cd.self_status == ClusterStatus.STANDBY) {
%>
<input type="submit" name="button" value="<%=ButtonMode.SAVESYNC %>" onClick="return confirm(monitor_modify_savesync)" />
<%
}
%> <input type="reset" value="Reset" /></form>
</div>
</body>
</html>
