<%@ page import="org.ultramonkey.l7.model.*, org.ultramonkey.l7.controller.*, org.ultramonkey.l7.view.*, java.util.*"
	language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%

	/*
	 * check session
 	 */
	if (session.isNew()) {
	MessageView error = new MessageView(41427, LogCategorySet.GUI_USER_AUTHENTICATION,
			Message.INVALID_SESSSION);
	session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
	response.sendRedirect(RedirectPages.LOGIN);
	return;
	}

	
	/*
	 * get result message
	 */
	MessageView message = (MessageView) session.getAttribute(SessionKeys.RESULT_MESSAGE);
	String errorMessage = null;
	int errorNumber = 0;
	String category = "";
	if (message != null) {
		errorMessage = message.getMessage();
		errorNumber = message.getErrno();
		category = message.getCategory();
		session.setAttribute(SessionKeys.RESULT_MESSAGE, null);
	}

	/*
	 * get post user data
	 */
	UserData user = (UserData)session.getAttribute(SessionKeys.INPUT_USERDATA);
	if ( user != null ){
		session.setAttribute(SessionKeys.INPUT_USERDATA, null);
	}
	
	if (user == null ){		
		user = (UserData)session.getAttribute(SessionKeys.LOGIN_SESSION);
		if (user == null){
			MessageView error = new MessageView(41428, LogCategorySet.GUI_USER_AUTHENTICATION,
					Message.CLUSTER_DATA_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			return;
		}
	}
	
	if (user.description == null){
		user.description = "";
	}
	
	/*
	 * get cluster status
	 */
	L7guiFramework framework = new L7guiFramework(); 
	ClusterData cd = framework.getClusterData();
	if (cd == null) {
		MessageView error = new MessageView(41429, LogCategorySet.GUI_IO_COMMAND,
				Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * fix style seat
	 */
	String cssSeat = "l7gui_single_style.css";
	if ( cd.self_status == ClusterStatus.ACTIVE ){
		cssSeat = "l7gui_act_style.css";
	}
	else if ( cd.self_status == ClusterStatus.STANDBY ){
		cssSeat = "l7gui_sby_style.css";
	}

	
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		<meta http-equiv="Pragma" content="no-cache">
		<meta http-equiv="Cache-Control" content="no-cache">
		<meta http-equiv="Expires" content="0"> 
		<meta http-equiv="Content-Script-Type" content="text/javascript" />
		<meta http-equiv="Content-Style-Type" content="text/css" />
		<script src="l7gui.js" type="text/javascript"></script>
		<noscript> 
    	<meta http-equiv="refresh" content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>"/>
  		</noscript> 
		<link rel="stylesheet" type="text/css" href="<%= cssSeat %>" />
		<link rel="shortcut icon" href="images/favicon.ico"/>

		<title>Modify User</title>


	</head>


	<body class="normal">
	<jsp:include page="menu.jsp" flush="false"/>

		<div id="content">
	
		<h1>Modify User</h1>
	
		<%
			if ((message != null) || (errorMessage != null)){
		%>
			<p class="error">[ <%=category %> - <%=errorNumber %>]</p>
			<p class="error"><%= errorMessage %></p>	
		<%
			}
		%>
			
		<form method="post" action="UserModServlet">
 
		<fieldset>
		<legend>Modify User Info</legend>	
		<table class="status">
		<tr>
			<th>
				<label for="description">Description</label>
			</th>
			<td>
				<input type="text" name="description" value="<%=user.description %>" size="32" maxlength="64">
			</td>
			<td>
				<p class="required">Up to 64 one-byte characters in English</p>
			</td>
		</tr>
		<tr>
			<th>
				<label for="current_password">Current Password</label>
			</th>
			<td>
				<input type="password" name="password" size="18" maxlength="16">
			</td>
			<td>
				<p class="item">Required Field</p>
			</td>		
		</tr>
		<tr>
			<th>
				<label for="new_password">New Password</label>
			</th>
			<td>
				<input type="password" name="new1_passwd" size="18" maxlength="16">
			</td>
			<td>
				<p class="item">Required Field</p>
				<p class="required">Up to 16 one-byte characters in English</p>
			</td>
		</tr>
		<tr>
			<th>
				<label for="re-type_new_password">Re-type New Password</label>
			</th>
			<td>
				<input type="password" name="new2_passwd" size="18" maxlength="16">
			</td>
			<td>
				<p class="item">Required Field</p>
				<p class="required">Up to 16 one-byte characters in English</p>
			</td>
		</tr>
		</table>
		</fieldset>
		
	
	<br />
	
	<input type="submit" name="button" value="<%= ButtonMode.CHANGE %>" onClick="return confirm(user_modify)" />
	<input type="reset" value="Clear" />
	</form>

	</div>
</body>
</html>
