/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.controller;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.EndPoint;
import org.ultramonkey.l7.controller.L7vsAdmData;
import org.ultramonkey.l7.controller.L7vsConfCategory;
import org.ultramonkey.l7.controller.LogData;
import org.ultramonkey.l7.controller.ReplicationStatus;
import org.ultramonkey.l7.controller.SnmpAgentStatus;
import org.ultramonkey.l7.controller.VirtualSetting;
import org.ultramonkey.l7.model.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L7vsAdmController {
    private static final String l7vsadm = "/usr/sbin/l7vsadm";
    private Logger ioCommandLogger = Logger.getLogger((String)"l7gui_I/O.Command");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addVirtualService(VirtualSetting vs) {
        if (this.ioCommandLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7vsAdmController::addVirtualService(VirtualSetting vs) in ");
            buf.append("vs=(" + vs + ")");
            this.ioCommandLogger.debug((Object)("11524 " + buf.toString()));
        }
        L7vsAdmController l7vsAdmController = this;
        synchronized (l7vsAdmController) {
            String result;
            if (vs == null || vs.virtual == null) {
                this.ioCommandLogger.warn((Object)"31003 Invalid null argument.");
                if (this.ioCommandLogger.isDebugEnabled()) {
                    this.ioCommandLogger.debug((Object)"11525 L7vsAdmController::addVirtualService(VirtualSetting vs) out return=false");
                }
                return false;
            }
            StringBuffer command = new StringBuffer("/usr/sbin/l7vsadm -A -t " + vs.virtual.host + ":" + vs.virtual.port + " -m " + vs.protomod + " " + vs.option + " -s " + vs.sched);
            if (vs.maxconn > 0) {
                command.append(" -u " + vs.maxconn);
            }
            if (vs.sorryserver != null && vs.sorryserver.host.length() > 0 && vs.sorryserver.port.length() > 0) {
                command.append(" -b " + vs.sorryserver.host + ":" + vs.sorryserver.port);
            }
            if (vs.sorryflag) {
                command.append(" -f 1");
            }
            if (vs.qosservice > 0L) {
                long qoss;
                if (vs.qosservice >= 1000000000L) {
                    qoss = vs.qosservice / 1000000000L;
                    command.append(" -Q " + qoss + "G");
                } else if (vs.qosservice >= 1000000L) {
                    qoss = vs.qosservice / 1000000L;
                    command.append(" -Q " + qoss + "M");
                } else if (vs.qosservice >= 1000L) {
                    qoss = vs.qosservice / 1000L;
                    command.append(" -Q " + qoss + "K");
                } else {
                    command.append(" -Q " + vs.qosservice);
                }
            }
            if (vs.qosclient > 0L) {
                long qosc;
                if (vs.qosclient >= 1000000000L) {
                    qosc = vs.qosclient / 1000000000L;
                    command.append(" -q " + qosc + "G");
                } else if (vs.qosclient >= 1000000L) {
                    qosc = vs.qosclient / 1000000L;
                    command.append(" -q " + qosc + "M");
                } else if (vs.qosclient >= 1000L) {
                    qosc = vs.qosclient / 1000L;
                    command.append(" -q " + qosc + "K");
                } else {
                    command.append(" -q " + vs.qosclient);
                }
            }
            if ((result = this.runProcess(command.toString())) == null || result.length() != 0) {
                this.ioCommandLogger.error((Object)("41220 Command error: command=" + command));
                this.ioCommandLogger.error((Object)("41221 Command error:  result=" + result));
                if (this.ioCommandLogger.isDebugEnabled()) {
                    this.ioCommandLogger.debug((Object)"11526 L7vsAdmController::addVirtualService(VirtualSetting vs) out return=false");
                }
                return false;
            }
            if (vs.real != null) {
                int i = 0;
                while (i < vs.real.size()) {
                    EndPoint real = vs.real.elementAt(i);
                    String realCommand = "/usr/sbin/l7vsadm -a -t " + vs.virtual.host + ":" + vs.virtual.port + " -m " + vs.protomod + " " + vs.option + " -r " + real.host + ":" + real.port + " -w " + real.weight;
                    result = this.runProcess(realCommand);
                    if (result == null || result.length() != 0) {
                        this.ioCommandLogger.error((Object)("41222 Command error: command=" + command));
                        this.ioCommandLogger.error((Object)("41223 Command error:  result=" + result));
                        if (this.ioCommandLogger.isDebugEnabled()) {
                            this.ioCommandLogger.debug((Object)"11527 L7vsAdmController::addVirtualService(VirtualSetting vs) out return=false");
                        }
                        return false;
                    }
                    ++i;
                }
            }
            if (this.ioCommandLogger.isDebugEnabled()) {
                this.ioCommandLogger.debug((Object)"11528 L7vsAdmController::addVirtualService(VirtualSetting vs) out return=true");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delVirtualService(VirtualSetting vs) {
        if (this.ioCommandLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7vsAdmController::delVirtualService(VirtualSetting vs) in ");
            buf.append("vs=(" + vs + ")");
            this.ioCommandLogger.debug((Object)("11529 " + buf.toString()));
        }
        L7vsAdmController l7vsAdmController = this;
        synchronized (l7vsAdmController) {
            block10: {
                block9: {
                    if (vs != null && vs.virtual != null) break block9;
                    this.ioCommandLogger.warn((Object)"31004 Invalid null argument.");
                    if (this.ioCommandLogger.isDebugEnabled()) {
                        this.ioCommandLogger.debug((Object)"11530 L7vsAdmController::delVirtualService(VirtualSetting vs) out return=false");
                    }
                    return false;
                }
                String command = "/usr/sbin/l7vsadm -D -t " + vs.virtual.host + ":" + vs.virtual.port + " -m " + vs.protomod + " " + vs.option;
                String result = this.runProcess(command);
                if (result != null && result.length() == 0) break block10;
                this.ioCommandLogger.error((Object)("41224 Command error: command=" + command));
                this.ioCommandLogger.error((Object)("41225 Command error:  result=" + result));
                if (this.ioCommandLogger.isDebugEnabled()) {
                    this.ioCommandLogger.debug((Object)"11531 L7vsAdmController::delVirtualService(VirtualSetting vs) out return=false");
                }
                return false;
            }
            if (this.ioCommandLogger.isDebugEnabled()) {
                this.ioCommandLogger.debug((Object)"11532 L7vsAdmController::delVirtualService(VirtualSetting vs) out return=true");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L7vsAdmData getData() {
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)"11533 L7vsAdmController::getData() in");
        }
        L7vsAdmController l7vsAdmController = this;
        synchronized (l7vsAdmController) {
            Pattern snmpStatus;
            Matcher snmp;
            String result;
            L7vsAdmData admData;
            block85: {
                admData = new L7vsAdmData();
                String command = "/usr/sbin/l7vsadm -V -n";
                result = this.runProcess(command);
                if (result != null) break block85;
                this.ioCommandLogger.error((Object)("41226 Command error: command=" + command));
                this.ioCommandLogger.error((Object)"41227 Command error:  result=null");
                if (this.ioCommandLogger.isDebugEnabled()) {
                    this.ioCommandLogger.debug((Object)"11534 L7vsAdmController::getData() out return=null");
                }
                return null;
            }
            Pattern l7vsdLogLevel = Pattern.compile("^(l7vsd_[\\w\\.]+)\\s+(debug|info|warn|error|fatal)$", 8);
            Matcher l7vsdLog = l7vsdLogLevel.matcher(result);
            while (l7vsdLog.find()) {
                LogData.LogLevel level;
                if (l7vsdLog.group(2).equals("debug")) {
                    level = LogData.LogLevel.DEBUG;
                } else if (l7vsdLog.group(2).equals("info")) {
                    level = LogData.LogLevel.INFO;
                } else if (l7vsdLog.group(2).equals("warn")) {
                    level = LogData.LogLevel.WARN;
                } else if (l7vsdLog.group(2).equals("error")) {
                    level = LogData.LogLevel.ERROR;
                } else if (l7vsdLog.group(2).equals("fatal")) {
                    level = LogData.LogLevel.FATAL;
                } else {
                    this.ioCommandLogger.info((Object)("21092 Unknown log level: " + l7vsdLog.group(2)));
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_network")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_NETWORK, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_network.bandwidth")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_NETWORK_BANDWIDTH, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_network.num_connection")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_NETWORK_NUM_CONNECTION, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_network.qos")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_NETWORK_QOS, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_virtual_service")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_VIRTUAL_SERVICE, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_real_server")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_REAL_SERVER, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_sorry_server")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_SORRY_SERVER, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_real_server.balancing")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_REAL_SERVER_BALANCING, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_replication")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_REPLICATION, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_start_stop")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_START_STOP, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_system")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_SYSTEM, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_system.memory")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_SYSTEM_MEMORY, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_system.socket")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_SYSTEM_SOCKET, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_system.signal")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_SYSTEM_SIGNAL, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_environment")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_ENVIRONMENT, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_environment.parameter")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_ENVIRONMENT_PARAMETER, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_logger")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_LOGGER, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_parameter")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_PARAMETER, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_event")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_EVENT, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_schedule")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_SCHEDULE, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_program")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_PROGRAM, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_protocol")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_PROTOCOL, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_module")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_MODULE, level);
                    continue;
                }
                if (l7vsdLog.group(1).equals("l7vsd_all")) {
                    admData.l7vsdLogLevel.put(LogData.LogCategory.L7VSD_ALL, level);
                    continue;
                }
                this.ioCommandLogger.info((Object)("21093 Unknown log category: " + l7vsdLog.group(1)));
            }
            Pattern snmpLogLevel = Pattern.compile("^(snmpagent_\\w+)\\s+(debug|info|warn|error|fatal)$", 8);
            Matcher snmpLog = snmpLogLevel.matcher(result);
            while (snmpLog.find()) {
                LogData.LogLevel level;
                if (snmpLog.group(2).equals("debug")) {
                    level = LogData.LogLevel.DEBUG;
                } else if (snmpLog.group(2).equals("info")) {
                    level = LogData.LogLevel.INFO;
                } else if (snmpLog.group(2).equals("warn")) {
                    level = LogData.LogLevel.WARN;
                } else if (snmpLog.group(2).equals("error")) {
                    level = LogData.LogLevel.ERROR;
                } else if (snmpLog.group(2).equals("fatal")) {
                    level = LogData.LogLevel.FATAL;
                } else {
                    this.ioCommandLogger.info((Object)("21094 Unknown log level: " + snmpLog.group(2)));
                    continue;
                }
                if (snmpLog.group(1).equals("snmpagent_start_stop")) {
                    admData.snmpLogLevel.put(LogData.LogCategory.SNMPAGENT_START_STOP, level);
                    continue;
                }
                if (snmpLog.group(1).equals("snmpagent_manager_receive")) {
                    admData.snmpLogLevel.put(LogData.LogCategory.SNMPAGENT_MANAGER_RECEIVE, level);
                    continue;
                }
                if (snmpLog.group(1).equals("snmpagent_manager_send")) {
                    admData.snmpLogLevel.put(LogData.LogCategory.SNMPAGENT_MANAGER_SEND, level);
                    continue;
                }
                if (snmpLog.group(1).equals("snmpagent_l7vsd_receive")) {
                    admData.snmpLogLevel.put(LogData.LogCategory.SNMPAGENT_L7VSD_RECEIVE, level);
                    continue;
                }
                if (snmpLog.group(1).equals("snmpagent_l7vsd_send")) {
                    admData.snmpLogLevel.put(LogData.LogCategory.SNMPAGENT_L7VSD_SEND, level);
                    continue;
                }
                if (snmpLog.group(1).equals("snmpagent_logger")) {
                    admData.snmpLogLevel.put(LogData.LogCategory.SNMPAGENT_LOGGER, level);
                    continue;
                }
                if (snmpLog.group(1).equals("snmpagent_parameter")) {
                    admData.snmpLogLevel.put(LogData.LogCategory.SNMPAGENT_PARAMETER, level);
                    continue;
                }
                if (snmpLog.group(1).equals("snmpagent_all")) {
                    admData.snmpLogLevel.put(LogData.LogCategory.SNMPAGENT_ALL, level);
                    continue;
                }
                this.ioCommandLogger.info((Object)("21095 Unknown log level: " + snmpLog.group(1)));
            }
            Pattern replicationMode = Pattern.compile("^Replication Mode:\\s+(\\w+)", 8);
            Matcher rep = replicationMode.matcher(result);
            if (rep.find()) {
                if (rep.group(1).equals("MASTER")) {
                    admData.replicationMode = ReplicationStatus.MASTER;
                } else if (rep.group(1).equals("MASTER_STOP")) {
                    admData.replicationMode = ReplicationStatus.MASTER_STOP;
                } else if (rep.group(1).equals("SLAVE")) {
                    admData.replicationMode = ReplicationStatus.SLAVE;
                } else if (rep.group(1).equals("SLAVE_STOP")) {
                    admData.replicationMode = ReplicationStatus.SLAVE_STOP;
                } else if (rep.group(1).equals("SINGLE")) {
                    admData.replicationMode = ReplicationStatus.SINGLE;
                } else if (rep.group(1).equals("OUT")) {
                    admData.replicationMode = ReplicationStatus.OUT;
                } else {
                    this.ioCommandLogger.info((Object)("21096 Unknown replication status: " + rep.group(1)));
                }
            }
            if ((snmp = (snmpStatus = Pattern.compile("^SNMPAgent Connection Status:\\s+([-\\w]+)", 8)).matcher(result)).find()) {
                if (snmp.group(1).equals("connecting")) {
                    admData.snmpStatus = SnmpAgentStatus.CONNECTING;
                } else if (snmp.group(1).equals("non-connecting")) {
                    admData.snmpStatus = SnmpAgentStatus.NON_CONNECTING;
                } else {
                    this.ioCommandLogger.info((Object)("21097 Unknown SNMP Agent status: " + snmp.group(1)));
                }
            }
            VirtualSetting vs = null;
            String virtualLine = "TCP (\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}):(\\d{1,5}) (\\w+) (\\w+) (0|1) (.*)\\s+([^\\s]+) (\\d+) (0|1)\\s+(\\d+) (\\d+) (\\d+)\\s*";
            String realLine = "\\s+-> (\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}):(\\d{1,5})\\s+Masq\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s*";
            Pattern virtualService = Pattern.compile("^(?:" + virtualLine + "|" + realLine + ")$", 8);
            Matcher virtual = virtualService.matcher(result);
            while (virtual.find()) {
                if (virtual.group(1) != null) {
                    if (vs != null) {
                        admData.virtualSettings.add(vs);
                    }
                    vs = new VirtualSetting();
                    vs.virtual = new EndPoint(virtual.group(1), virtual.group(2));
                    vs.protomod = virtual.group(3);
                    vs.sched = virtual.group(4);
                    vs.reschedule = !virtual.group(5).equals("0");
                    vs.option = virtual.group(6);
                    String[] sorry = virtual.group(7).split(":");
                    if (sorry.length == 2 && sorry[1] != null) {
                        vs.sorryserver = new EndPoint(sorry[0], sorry[1]);
                    }
                    vs.maxconn = Integer.parseInt(virtual.group(8));
                    vs.sorryflag = !virtual.group(9).equals("0");
                    vs.qosservice = Long.parseLong(virtual.group(10));
                    vs.qosclient = Long.parseLong(virtual.group(11));
                    vs.throughput = Long.parseLong(virtual.group(12));
                    continue;
                }
                if (vs.real == null) {
                    vs.real = new Vector();
                }
                vs.real.add(new EndPoint(virtual.group(13), virtual.group(14), Integer.parseInt(virtual.group(15)), Long.parseLong(virtual.group(16)), Long.parseLong(virtual.group(17))));
            }
            if (vs != null) {
                admData.virtualSettings.add(vs);
            }
            if (this.ioCommandLogger.isDebugEnabled()) {
                this.ioCommandLogger.debug((Object)("11535 L7vsAdmController::getData() out return=" + admData));
            }
            return admData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setReplicationMode(ReplicationStatus mode) {
        if (this.ioCommandLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7vsAdmController::setReplicationMode(ReplicationStatus mode) in ");
            buf.append("mode=" + (Object)((Object)mode));
            this.ioCommandLogger.debug((Object)("11536 " + buf.toString()));
        }
        L7vsAdmController l7vsAdmController = this;
        synchronized (l7vsAdmController) {
            if (mode == null) {
                this.ioCommandLogger.error((Object)("41228 Invalid replication status: " + (Object)((Object)mode)));
                if (this.ioCommandLogger.isDebugEnabled()) {
                    this.ioCommandLogger.debug((Object)"11537 L7vsAdmController::setReplicationMode(ReplicationStatus mode) out return=false");
                }
                return false;
            }
            String command = "/usr/sbin/l7vsadm -R -s ";
            switch (mode) {
                case MASTER: 
                case SLAVE: {
                    command = String.valueOf(command) + "start";
                    break;
                }
                case MASTER_STOP: 
                case SLAVE_STOP: {
                    command = String.valueOf(command) + "stop";
                    break;
                }
                default: {
                    this.ioCommandLogger.error((Object)("41229 Invalid replication status: " + (Object)((Object)mode)));
                    if (this.ioCommandLogger.isDebugEnabled()) {
                        this.ioCommandLogger.debug((Object)"11538 L7vsAdmController::setReplicationMode(ReplicationStatus mode) out return=false");
                    }
                    return false;
                }
            }
            String result = this.runProcess(command);
            if (result == null || result.length() != 0) {
                this.ioCommandLogger.error((Object)("41230 Command error: command=" + command));
                this.ioCommandLogger.error((Object)("41231 Command error:  result=" + result));
                if (this.ioCommandLogger.isDebugEnabled()) {
                    this.ioCommandLogger.debug((Object)"11539 L7vsAdmController::setReplicationMode(ReplicationStatus mode) out return=false");
                }
                return false;
            }
            if (this.ioCommandLogger.isDebugEnabled()) {
                this.ioCommandLogger.debug((Object)"11540 L7vsAdmController::setReplicationMode(ReplicationStatus mode) out return=true");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setLogLevel(HashMap<LogData.LogCategory, LogData.LogLevel> category) {
        if (this.ioCommandLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7vsAdmController::setLogLevel(HashMap<LogData.LogCategory, LogData.LogLevel> category) in ");
            buf.append("category=" + category);
            this.ioCommandLogger.debug((Object)("11541 " + buf.toString()));
        }
        L7vsAdmController l7vsAdmController = this;
        synchronized (l7vsAdmController) {
            String result;
            String command;
            if (category == null) {
                this.ioCommandLogger.error((Object)("41232 Invalid log category map: " + category));
                if (this.ioCommandLogger.isDebugEnabled()) {
                    this.ioCommandLogger.debug((Object)"11542 L7vsAdmController::setLogLevel(HashMap<LogData.LogCategory, LogData.LogLevel> category) out return=false");
                }
                return false;
            }
            Iterator<LogData.LogCategory> keys = category.keySet().iterator();
            block140: while (true) {
                if (!keys.hasNext()) {
                    if (this.ioCommandLogger.isDebugEnabled()) {
                        this.ioCommandLogger.debug((Object)"11546 L7vsAdmController::setLogLevel(HashMap<LogData.LogCategory, LogData.LogLevel> category) out return=true");
                    }
                    return true;
                }
                command = l7vsadm;
                LogData.LogCategory c = keys.next();
                block2 : switch (c) {
                    case L7VSD_NETWORK: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_network";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_NETWORK_BANDWIDTH: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_network.bandwidth";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_NETWORK_NUM_CONNECTION: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_network.num_connection";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_NETWORK_QOS: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_network.qos";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_VIRTUAL_SERVICE: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_virtual_service";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_REAL_SERVER: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_real_server";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_SORRY_SERVER: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_sorry_server";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_REAL_SERVER_BALANCING: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_real_server.balancing";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_REPLICATION: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_replication";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_START_STOP: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_start_stop";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_SYSTEM: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_system";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_SYSTEM_MEMORY: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_system.memory";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_SYSTEM_SOCKET: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_system.socket";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_SYSTEM_SIGNAL: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_system.signal";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_ENVIRONMENT: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_environment";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_ENVIRONMENT_PARAMETER: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_environment.parameter";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_LOGGER: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_logger";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_PARAMETER: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_parameter";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_EVENT: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_event";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_SCHEDULE: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_schedule";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_PROGRAM: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_program";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_PROTOCOL: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_protocol";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_MODULE: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c l7vsd_module";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case L7VSD_ALL: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -L -c all";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case SNMPAGENT_START_STOP: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -S -c snmpagent_start_stop";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case SNMPAGENT_MANAGER_RECEIVE: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -S -c snmpagent_manager_receive";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case SNMPAGENT_MANAGER_SEND: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -S -c snmpagent_manager_send";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case SNMPAGENT_L7VSD_RECEIVE: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -S -c snmpagent_l7vsd_receive";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case SNMPAGENT_L7VSD_SEND: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -S -c snmpagent_l7vsd_send";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case SNMPAGENT_LOGGER: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -S -c snmpagent_logger";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case SNMPAGENT_PARAMETER: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -S -c snmpagent_parameter";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    case SNMPAGENT_ALL: {
                        switch (category.get((Object)c)) {
                            case DEBUG: 
                            case INFO: 
                            case WARN: 
                            case ERROR: 
                            case FATAL: {
                                command = String.valueOf(command) + " -S -c all";
                                break block2;
                            }
                        }
                        continue block140;
                    }
                    default: {
                        this.ioCommandLogger.info((Object)("21098 Unknown log category: " + (Object)((Object)c)));
                        if (this.ioCommandLogger.isDebugEnabled()) {
                            this.ioCommandLogger.debug((Object)"11543 L7vsAdmController::setLogLevel(HashMap<LogData.LogCategory, LogData.LogLevel> category) out return=false");
                        }
                        return false;
                    }
                }
                switch (category.get((Object)c)) {
                    case DEBUG: {
                        command = String.valueOf(command) + " -l debug";
                        break;
                    }
                    case INFO: {
                        command = String.valueOf(command) + " -l info";
                        break;
                    }
                    case WARN: {
                        command = String.valueOf(command) + " -l warn";
                        break;
                    }
                    case ERROR: {
                        command = String.valueOf(command) + " -l error";
                        break;
                    }
                    case FATAL: {
                        command = String.valueOf(command) + " -l fatal";
                        break;
                    }
                    default: {
                        this.ioCommandLogger.info((Object)("21099 Unknown log level: " + (Object)((Object)category.get((Object)c))));
                        if (this.ioCommandLogger.isDebugEnabled()) {
                            this.ioCommandLogger.debug((Object)"11544 L7vsAdmController::setLogLevel(HashMap<LogData.LogCategory, LogData.LogLevel> category) out return=false");
                        }
                        return false;
                    }
                }
                if ((result = this.runProcess(command)) == null || result.length() != 0) break;
            }
            this.ioCommandLogger.error((Object)("41233 Command error: command=" + command));
            this.ioCommandLogger.error((Object)("41234 Command error:  result=" + result));
            if (this.ioCommandLogger.isDebugEnabled()) {
                this.ioCommandLogger.debug((Object)"11545 L7vsAdmController::setLogLevel(HashMap<LogData.LogCategory, LogData.LogLevel> category) out return=false");
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dumpReplicationData() {
        if (this.ioCommandLogger.isDebugEnabled()) {
            this.ioCommandLogger.debug((Object)"11547 L7vsAdmController::dumpReplicationData() in");
        }
        L7vsAdmController l7vsAdmController = this;
        synchronized (l7vsAdmController) {
            block7: {
                String command = "/usr/sbin/l7vsadm -R -d";
                String result = this.runProcess(command);
                if (result != null && result.length() == 0) break block7;
                this.ioCommandLogger.error((Object)("41235 Command error: command=" + command));
                this.ioCommandLogger.error((Object)("41236 Command error:  result=" + result));
                if (this.ioCommandLogger.isDebugEnabled()) {
                    this.ioCommandLogger.debug((Object)"11548 L7vsAdmController::dumpReplicationData() out return=false");
                }
                return false;
            }
            if (this.ioCommandLogger.isDebugEnabled()) {
                this.ioCommandLogger.debug((Object)"11549 L7vsAdmController::dumpReplicationData() out return=true");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reloadConf(L7vsConfCategory c) {
        if (this.ioCommandLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7vsAdmController::reloadConf(L7vsConfCategory c) in ");
            buf.append("c=" + (Object)((Object)c));
            this.ioCommandLogger.debug((Object)("11550 " + buf.toString()));
        }
        L7vsAdmController l7vsAdmController = this;
        synchronized (l7vsAdmController) {
            if (c == null) {
                this.ioCommandLogger.error((Object)("41237 Invalid argument: " + (Object)((Object)c)));
                if (this.ioCommandLogger.isDebugEnabled()) {
                    this.ioCommandLogger.debug((Object)"11551 L7vsAdmController::reloadConf(L7vsConfCategory c) out return=false");
                }
                return false;
            }
            String command = "/usr/sbin/l7vsadm -P -r ";
            switch (c) {
                case ALL: {
                    command = String.valueOf(command) + "all";
                    break;
                }
                case L7VSD: {
                    command = String.valueOf(command) + "l7vsd";
                    break;
                }
                case IOMUX: {
                    command = String.valueOf(command) + "iomux";
                    break;
                }
                case LSOCK: {
                    command = String.valueOf(command) + "lsock";
                    break;
                }
                case CONN: {
                    command = String.valueOf(command) + "conn";
                    break;
                }
                case DEST: {
                    command = String.valueOf(command) + "dest";
                    break;
                }
                case SERVICE: {
                    command = String.valueOf(command) + "service";
                    break;
                }
                case MODULE: {
                    command = String.valueOf(command) + "module";
                    break;
                }
                case REPLICATION: {
                    command = String.valueOf(command) + "replication";
                    break;
                }
                case LOGGER: {
                    command = String.valueOf(command) + "logger";
                    break;
                }
                case L7VSADM: {
                    command = String.valueOf(command) + "l7vsadm";
                    break;
                }
                case SNMPAGENT: {
                    command = String.valueOf(command) + "snmpagent";
                    break;
                }
                default: {
                    this.ioCommandLogger.error((Object)("41238 Unknown log category: " + (Object)((Object)c)));
                    if (this.ioCommandLogger.isDebugEnabled()) {
                        this.ioCommandLogger.debug((Object)"11552 L7vsAdmController::reloadConf(L7vsConfCategory c) out return=false");
                    }
                    return false;
                }
            }
            String result = this.runProcess(command);
            if (result == null || result.length() != 0) {
                this.ioCommandLogger.error((Object)("41239 Command error: command=" + command));
                this.ioCommandLogger.error((Object)("41240 Command error:  result=" + result));
                if (this.ioCommandLogger.isDebugEnabled()) {
                    this.ioCommandLogger.debug((Object)"11553 L7vsAdmController::reloadConf(L7vsConfCategory c) out return=false");
                }
                return false;
            }
            if (this.ioCommandLogger.isDebugEnabled()) {
                this.ioCommandLogger.debug((Object)"11554 L7vsAdmController::reloadConf(L7vsConfCategory c) out return=true");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String runProcess(String command) {
        if (this.ioCommandLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7vsAdmController::runProcess(String command) in ");
            buf.append("command=\"" + command + "\"");
            this.ioCommandLogger.debug((Object)("11555 " + buf.toString()));
        }
        L7vsAdmController l7vsAdmController = this;
        synchronized (l7vsAdmController) {
            StringBuffer result = new StringBuffer();
            try {
                Process ps = Runtime.getRuntime().exec("sudo " + command);
                InputStream stderr = ps.getErrorStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(stderr));
                String line = null;
                while ((line = br.readLine()) != null) {
                    result.append(String.valueOf(line) + "\n");
                }
                InputStream stdout = ps.getInputStream();
                br = new BufferedReader(new InputStreamReader(stdout));
                while ((line = br.readLine()) != null) {
                    result.append(String.valueOf(line) + "\n");
                }
                Pattern p = Pattern.compile("^COMMON ERROR.*timeout");
                Matcher m = p.matcher(result);
                if (m.find()) {
                    Parameter param = Parameter.getInstance();
                    param.setValue("l7vsadm_timeout_flag", "yes");
                } else {
                    Parameter param = Parameter.getInstance();
                    param.setValue("l7vsadm_timeout_flag", null);
                }
            }
            catch (Exception e) {
                this.ioCommandLogger.error((Object)("41241 Exception occured: " + e.getMessage()));
                result = null;
            }
            if (this.ioCommandLogger.isDebugEnabled()) {
                this.ioCommandLogger.debug((Object)("11556 L7vsAdmController::runProcess(String command) out return=" + result));
            }
            return result == null ? null : result.toString();
        }
    }
}

