/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.FileNotWriteException;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.UserData;
import org.ultramonkey.l7.model.UserManager;
import org.ultramonkey.l7.view.L7guiServletBase;

public class UserModServlet
extends L7guiServletBase {
    static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger((String)"l7gui_I/O");

    public UserModServlet() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11414 class UserModServlet created.");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("UserModServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11415 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            this.logger.debug((Object)("11416 QueryString=\"" + request.getQueryString() + "\""));
        }
        response.sendRedirect("index.jsp");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11417 UserModServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11418 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            Enumeration keys = request.getParameterNames();
            String post = "";
            while (keys.hasMoreElements()) {
                if (post.length() != 0) {
                    post = String.valueOf(post) + "&";
                }
                String key = (String)keys.nextElement();
                post = String.valueOf(post) + key + "=" + request.getParameter(key);
            }
            this.logger.debug((Object)("11419 PostData=\"" + post + "\""));
        }
        super.doPost(request, response);
        HttpSession session = request.getSession(false);
        if (!this.login || session == null) {
            if (session != null) {
                MessageView error = new MessageView(41184, "l7gui_UserAuthentication", "Invalid session.");
                session.setAttribute("resultMessage", (Object)error);
            }
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11420 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        UserData currentUser = (UserData)session.getAttribute("onLogin");
        if (currentUser == null) {
            MessageView error = new MessageView(41185, "l7gui_UserAuthentication", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11421 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        request.setCharacterEncoding("UTF-8");
        String description = request.getParameter("description");
        String curPass = request.getParameter("password");
        String newPass1 = request.getParameter("new1_passwd");
        String newPass2 = request.getParameter("new2_passwd");
        String button_mode = request.getParameter("button");
        if (description == null || curPass == null || newPass1 == null || newPass2 == null || button_mode == null || !button_mode.equals("Change")) {
            MessageView error = new MessageView(41186, "l7gui_UserManage", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11422 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        boolean validationFlag = true;
        validationFlag = this.validationCheck(session, description, curPass, newPass1, newPass2);
        if (!validationFlag) {
            UserData inputUser = new UserData();
            inputUser.description = description;
            session.setAttribute("inputUserData", (Object)inputUser);
            response.sendRedirect("user_modify.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11423 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        UserManager user = UserManager.getInstance();
        UserData authCheck = null;
        try {
            authCheck = user.authUser(currentUser.userName, curPass);
        }
        catch (Exception e) {
            MessageView error = new MessageView(41187, "l7gui_StartStop", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11424 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        if (authCheck == null) {
            MessageView error = new MessageView(21076, "l7gui_UserManage", "Invalid current Password.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("user_modify.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11425 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        UserData modUser = new UserData();
        modUser.userName = currentUser.userName;
        modUser.description = description;
        modUser.passwd = newPass1;
        boolean passChange = true;
        try {
            passChange = user.changeUser(modUser);
        }
        catch (FileNotWriteException e) {
            MessageView error = new MessageView(41188, "l7gui_I/O.File", "Cannot write file.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11426 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        catch (Exception e) {
            MessageView error = new MessageView(41189, "l7gui_UserManage", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11427 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        if (passChange) {
            session.setAttribute("onLogin", (Object)modUser);
            MessageView error = new MessageView(21077, "l7gui_UserManage", "User data changed.");
            session.setAttribute("resultMessage", (Object)error);
            session.setAttribute("guiSyncState", (Object)"noSync");
            response.sendRedirect("user_modify_success.jsp");
        } else {
            session.setAttribute("onLogin", (Object)authCheck);
            MessageView error = new MessageView(41190, "l7gui_UserManage", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("user_modify_fail.jsp");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11428 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }

    boolean validationCheck(HttpSession session, String description, String curPass, String newPass1, String newPass2) {
        MessageView error;
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("UserModServlet::validationCheck(HttpSession session, String description, String newPass1, String newPass2) in ");
            buf.append("session=(" + session + "), ");
            buf.append("description=\"" + description + "\", ");
            buf.append("newPass1=\"" + newPass1 + "\", ");
            buf.append("newPass2=\"" + newPass2);
            this.logger.debug((Object)("11429 " + buf.toString()));
        }
        boolean validationFlag = true;
        int MAX_DESCRIPTION_LENGTH = 64;
        int MIN_PASS_LENGTH = 6;
        int MAX_PASS_LENGTH = 16;
        Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
        if (description.length() == 0 && curPass.length() == 0 && newPass1.length() == 0 && newPass2.length() == 0) {
            error = new MessageView(21078, "l7gui_UserManage", "All fields are empty.");
            session.setAttribute("resultMessage", (Object)error);
            validationFlag = false;
        } else if (description.length() != 0) {
            Matcher matcher = pattern.matcher(description);
            if (description.length() > 64 || matcher.find()) {
                MessageView error2 = new MessageView(21079, "l7gui_UserManage", "Description : Invalid value.");
                session.setAttribute("resultMessage", (Object)error2);
                validationFlag = false;
            }
        }
        if (curPass.length() == 0 || newPass1.length() == 0 || newPass2.length() == 0) {
            error = new MessageView(21080, "l7gui_UserManage", "Password : Required fields.");
            session.setAttribute("resultMessage", (Object)error);
            validationFlag = false;
        } else {
            Matcher matcherCurPass = pattern.matcher(curPass);
            Matcher matcherNewPass1 = pattern.matcher(newPass1);
            Matcher matcherNewPass2 = pattern.matcher(newPass2);
            if (matcherCurPass.find() || matcherNewPass1.find() || matcherNewPass2.find()) {
                MessageView error3 = new MessageView(21081, "l7gui_UserManage", "Input item : Invalid value.");
                session.setAttribute("resultMessage", (Object)error3);
                validationFlag = false;
            } else if (!newPass1.equals(newPass2)) {
                MessageView error4 = new MessageView(21082, "l7gui_UserManage", "The Password and confirmation Password do not match.");
                session.setAttribute("resultMessage", (Object)error4);
                validationFlag = false;
            } else if (newPass1.length() < 6 || newPass1.length() > 16) {
                MessageView error5 = new MessageView(21083, "l7gui_UserManage", "Invalid value.");
                session.setAttribute("resultMessage", (Object)error5);
                validationFlag = false;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("11430 UserModServlet::validationCheck(HttpSession session, String description, String newPass1, String newPass2) out return=" + validationFlag));
        }
        return validationFlag;
    }
}

