<%@ page import="org.ultramonkey.l7.model.*,
				 org.ultramonkey.l7.controller.*,
				 org.ultramonkey.l7.view.*, java.util.*"
	language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"
%>
<%

	/*
	 * check session
 	 */
 	L7guiServletBase base = new L7guiServletBase();
	if (session.isNew() || base.checkSession(session) == false) {
		MessageView error = new MessageView(41387, LogCategorySet.GUI_USER_AUTHENTICATION,
				Message.INVALID_SESSSION);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get result message
	 */
	MessageView message = (MessageView) session.getAttribute(SessionKeys.RESULT_MESSAGE);
	String errorMessage = "";
	int errorNumber = 0;
	String category = "";
	if (message != null) {
		errorMessage = message.getMessage();
		errorNumber = message.getErrno();
		category = message.getCategory();
		session.setAttribute(SessionKeys.RESULT_MESSAGE, null);
	}
	
	/*
	 * get command message
	 */
	MessageView commandmessage = (MessageView) session.getAttribute(SessionKeys.COMMAND_MESSAGE);
	String commandMessage = "";
	int commandNumber = 0;
	String commandCategory = "";
	if (commandmessage != null) {
		commandMessage = commandmessage.getMessage();
		commandNumber = commandmessage.getErrno();
		commandCategory = commandmessage.getCategory();
		session.setAttribute(SessionKeys.COMMAND_MESSAGE, null);
	}
	
	/*
	 * get cluster status
	 */
	L7guiFramework framework = new L7guiFramework(); 
	ClusterData cd = framework.getClusterData();
	if (cd == null) {
		MessageView error = new MessageView(41388, LogCategorySet.GUI_USER_AUTHENTICATION,
				Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	session.setAttribute("cd",cd);
	
	/*
	 * get sync status and get self/other IP
	 */
	String syncLogStatus = null;
	String syncMonitorStatus = null;
	String syncServiceStatus = null;
	String syncRepStatus = null;
	String syncSnmpStatus = null;
	String syncGuiStatus = null;
	String selfIp = null;
	String otherIp = null;
	
	
	if ( (cd.self_status == ClusterStatus.ACTIVE ) || (cd.self_status == ClusterStatus.STANDBY) ){
		// get sync Status
		syncLogStatus = (String)session.getAttribute(SessionKeys.LOG_SYNC_STATE);
		syncMonitorStatus = (String)session.getAttribute(SessionKeys.MONITOR_SYNC_STATE);
		syncServiceStatus = (String)session.getAttribute(SessionKeys.VS_SYNC_STATE);
		syncRepStatus = (String)session.getAttribute(SessionKeys.REP_SYNC_STATE);
		syncSnmpStatus = (String)session.getAttribute(SessionKeys.SNMP_SYNC_STATE);
		syncGuiStatus = (String)session.getAttribute(SessionKeys.GUI_SYNC_STATE);
		if ( (syncLogStatus == null) || (syncMonitorStatus == null) || (syncServiceStatus == null) 
				|| (syncRepStatus == null) || (syncSnmpStatus == null) || (syncGuiStatus == null) ){

			MessageView error = new MessageView(41389, LogCategorySet.GUI_USER_AUTHENTICATION,
					Message.CLUSTER_DATA_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			return;
		}
	
		// get Self/Other IP
		selfIp = cd.self_ip;
		otherIp = cd.other_ip;
		if ( (selfIp == null) || (otherIp == null) ){
			MessageView error = new MessageView(41390, LogCategorySet.GUI_IO_COMMAND,
					Message.CLUSTER_DATA_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			return;
		}
	}
	
	
	/*
	 * fix style seat
	 */
	String cssSeat = "l7gui_single_style.css";
	if ( cd.self_status == ClusterStatus.ACTIVE ){
		cssSeat = "l7gui_act_style.css";
	}
	else if ( cd.self_status == ClusterStatus.STANDBY ){
		cssSeat = "l7gui_sby_style.css";
	}

	
%>

	<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
	<html>
		<head>
			<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
			<meta http-equiv="Pragma" content="no-cache">
			<meta http-equiv="Cache-Control" content="no-cache">
			<meta http-equiv="Expires" content="0"> 
			<meta http-equiv="Content-Script-Type" content="text/javascript" />
			<meta http-equiv="Content-Style-Type" content="text/css" />
			<script src="l7gui.js" type="text/javascript"></script>
			<noscript> 
	    	<meta http-equiv="refresh" content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>"/>
	  		</noscript> 
			<link rel="stylesheet" type="text/css" href="<%=cssSeat %>" />
			<link rel="shortcut icon" href="images/favicon.ico" />

			<title>Sync Resources</title>
		</head>

		<body class="normal">
		<jsp:include page="menu.jsp" flush="false"/>

		<div id="content">

		<h1>Sync Resources</h1>
	<% if ( (cd.self_status != ClusterStatus.ACTIVE ) && (cd.self_status != ClusterStatus.STANDBY) ){
	%>
			<p class="error">"Sync Resources" function is effective only when cluster is applied. </p>
	<% 
		}
		else {
	
			if (message != null) {
		%>
		
		<p class="error">[<%=category %>-<%=errorNumber %>]</p>
		<p class="error"><%=errorMessage %></p>
		
		<%
			}
			else if (commandmessage != null ){
		%>
		<p class="success">[<%=commandCategory %>-<%=commandNumber %>]</p>
		<p class="success"><%=commandMessage %></p>
		<%		
			}
		%>	
		

		<form method="post" action="SyncStateServlet" name="sync">
		<fieldset class="">
		<legend>Sync Info</legend>
		<h3> <%= selfIp %> <img class="arrow2" src="images/arrowlogo2.gif" alt="arrowlogo" /> <%=otherIp %> </h3>
		

		<table  class="infotable" cellspacing="0">
			<thead>
			<tr>
				<th>Sync<br />CHECK</th><th>Category</th><th>Description</th>
			</tr>
			</thead>
			<tbody>
			<tr>
				<td class="center"><input type="checkbox" name="sync_category" value="log_all"></td>
				<td class="left">Log</td>
				<td class="left"> Log settings</td>
			</tr>
			<tr>
				<td class="center"><input type="checkbox" name="sync_category" value="monitor"></td>
				<td class="left">Monitor</td>
				<td class="left">Monitor settings</td>
			</tr>
			<tr>
				<td class="center"><input type="checkbox" name="sync_category" value="service"></td>
				<td class="left">Service</td>
				<td class="left">VirtualService settings</td>
			</tr>
			<tr>
				<td class="center"><input type="checkbox" name="sync_category" value="replication_info"></td>
				<td class="left">Replication</td>
				<td class="left">Replication settings</td>
			</tr>
			<tr>
				<td class="center"><input type="checkbox" name="sync_category" value="snmp_info"></td>
				<td class="left">SNMP Agent</td>
				<td class="left">SNMP Agent settings</td>
			</tr>
			<tr>
				<td class="center"><input type="checkbox" name="sync_category" value="userdata"></td>
				<td class="left">GUI</td>
				<td class="left">GUI User Management (Users &amp; Password)</td>
			</tr>
			</tbody>
		</table>
		</fieldset>

	<input type="submit" name="button" value="<%=ButtonMode.SAVESYNC%>" onClick="return confirm(savesync)" />

</form>
	<%
	}
	%>
	</div>
	</body>
</html>