<%@ page import="org.ultramonkey.l7.model.*,org.ultramonkey.l7.controller.*,org.ultramonkey.l7.view.*,java.util.*"
	language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"
%>
<%
	/*
	 * check session
 	 */
 	L7guiServletBase base = new L7guiServletBase();
	if (session.isNew() || base.checkSession(session) == false) {
		MessageView error = new MessageView(41421, LogCategorySet.GUI_USER_AUTHENTICATION,
		Message.INVALID_SESSSION);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}


	/*
	 * get self info
	 */	
	UserData currentUser = (UserData) session.getAttribute(SessionKeys.LOGIN_SESSION);
	if ( currentUser == null) {
		MessageView error = new MessageView(41422, LogCategorySet.GUI_USER_AUTHENTICATION,
	Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	String currentUserName = currentUser.userName;
	if (currentUserName == null){
		MessageView error = new MessageView(41423, LogCategorySet.GUI_USER_AUTHENTICATION,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get user info 
	 */	
	UserManager user = UserManager.getInstance();
	Vector<UserData> userList;
	try {
		userList = user.getUserList();
	}
	catch(Exception e){
		MessageView error = new MessageView(41424, LogCategorySet.GUI_IO_FILE,
		Message.READ_ERROR);
	session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
	response.sendRedirect(RedirectPages.LOGIN);
	return;
	}
	if ( userList == null ){
		MessageView error = new MessageView(41425, LogCategorySet.GUI_IO_FILE,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	 
	
	/*
	 * get result message
	 */
	MessageView message = (MessageView) session.getAttribute(SessionKeys.RESULT_MESSAGE);
	String errorMessage = "";
	int errorNumber = 0;
	String category = "";
	String resultClass = "success";
	
	if (message != null) {
		errorMessage = message.getMessage();
		errorNumber = message.getErrno();
		category = message.getCategory();
		session.setAttribute(SessionKeys.RESULT_MESSAGE, null);
	}
	if (errorMessage.equals(Message.USER_REMOVE_SELECT_ERROR)) {
		resultClass = "error";
	}
		

	/*
	 * get cluster status
	 */
	L7guiFramework framework = new L7guiFramework();
	ClusterData cd = framework.getClusterData();
	if (cd == null) {
		MessageView error = new MessageView(41426, LogCategorySet.GUI_IO_COMMAND,
		Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * fix style seat
	 */
	String cssSeat = "l7gui_single_style.css";
	if ( cd.self_status == ClusterStatus.ACTIVE ){
		cssSeat = "l7gui_act_style.css";
	}
	else if ( cd.self_status == ClusterStatus.STANDBY ){
		cssSeat = "l7gui_sby_style.css";
	}
%>

	<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
	<html>
		<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		<meta http-equiv="Pragma" content="no-cache">
		<meta http-equiv="Cache-Control" content="no-cache">
		<meta http-equiv="Expires" content="0"> 
		<meta http-equiv="Content-Script-Type" content="text/javascript" />
		<meta http-equiv="Content-Style-Type" content="text/css" />
		<script src="l7gui.js" type="text/javascript"></script>
		<noscript> 
    	<meta http-equiv="refresh" content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>"/>
  		</noscript> 
		<link rel="stylesheet" type="text/css" href="<%= cssSeat %>" />
		<link rel="shortcut icon" href="images/favicon.ico"/>

			<title>Manage Users</title>
		</head>
		
		<body class="normal">
		<jsp:include page="menu.jsp" flush="false"/>

		<div id="content">

		<h1>Manage Users </h1>
	<%
	if ( (message != null) && (errorMessage != null)) {
	%>
	<p class="<%=resultClass %>">[<%=category%> - <%=errorNumber%>]</p>
	<p class="<%=resultClass %>"><%=errorMessage%></p>
	<%
	}
	%>
		


		<form method="post" action="UserRemoveServlet" name="user_remove">
		<fieldset>
		<legend>Current User list</legend>	
		
		<table  class="infotable" cellspacing="0">
		<thead>
		<tr><th>Delete CHECK</th><th>User ID</th><th>Description</th></tr>
		</thead>
		<tbody>
		<%
			for ( UserData userInfo : userList){
			out.println("<tr><td class=\"center\">");
			if ( !userInfo.userName.equals(currentUserName) )
				out.println("<input type=\"checkbox\" name=\"ck_user\" value=\"" + userInfo.userName + "\"/>");		
			out.println("</td>");
			out.println("<td>"+ userInfo.userName + "</td>");
			out.println("<td>");
			if (userInfo.description != null){
				out.println(userInfo.description);
			}
			out.println("</td></tr>");
		}
		%>
		</tbody>
		</table>
		</fieldset>

		<%
			int userCount = userList.size(); 
			if (userCount < 16){
		%>
				<h2>Add a New User</h2>
				<h4>Please push the following button, if you add a new user.</h4><br />
				<input type="button" value="<%= ButtonMode.ADD %>" onClick="location.href='<%= RedirectPages.USER_ADD %>'" />	
		<%		
			}
		%>

		<h2>Modify User</h2>
		<h4>Please push the following button, if you modify your account.</h4><br />
		<input type="button" value="<%= ButtonMode.MODIFY %>" onClick="location.href='<%= RedirectPages.USER_MODIFY %>'" />

		<%
		if (userCount > 1) {
		%>
		<h2>Delete Users</h2>
		<h4>Please select and push the following button, if you delete user.</h4><br />
		<input type="submit" name="button" value="<%= ButtonMode.DELETE %>" onClick="return confirm(user_delete)" />
		<%
		}
		%>
		</form>

	</div>
	</body>
</html>
