package org.ultramonkey.l7.controller;

/**
 * l7vs config file controller,
 *      Confing file reader and writer.
 * <p>class L7vsConfController</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * @author nakai.
 */

public class L7vsConfController {

    /**
     * l7vs config file position and name.
     */
    protected static String FILENAME = "/etc/l7vs/l7vs.cf";

    protected static String LOGGER_MASTER_KEY = "logger";

    protected static String L7VSADM_MASTER_KEY = "l7vsadm";

    protected static String REPLICATION_MASTER_KEY = "replication";

    protected static String SNMPAGENT_MASTER_KEY = "snmpagent";

    /**
     * l7vsd log File Name key
     */
    protected static String LB_LOG_FILENAME_KEY = "l7vsd_log_filename";

    /**
     *  l7vsd log rotate key
     */
    protected static String LB_LOG_ROTATION_KEY = "l7vsd_rotation";

    /**
     * l7vsd log max backup index key
     */
    protected static String LB_LOG_MAXBACKUPINDEX_KEY = "l7vsd_max_backup_index";

    /**
     * l7vsd log rotate timing key
     */
    protected static String LB_LOG_ROTATE_TIMING_KEY = "l7vsd_rotation_timing";

    /**
     * l7vsd log rotate timing type key
     */
    protected static String LB_LOG_ROTATE_TIMING_VALUE_KEY = "l7vsd_rotation_timing_value";

    /**
     * l7vsd log file size max value key
     */
    protected static String LB_LOG_MAXFILESIZE_KEY = "l7vsd_max_filesize";

    /**
     * l7vsd log level for network category key
     */
    protected static String LB_LOGCATEGORY_NETWORK_KEY = "l7vsd_network";

    /**
     * l7vsd log level for network.bandwidth category key
     */
    protected static String LB_LOGCATEGORY_NETWORK_BANDWIDTH_KEY = "l7vsd_network.bandwidth";

    /**
     * k7vsd log level for network.connection category key
     */
    protected static String LB_LOGCATEGORY_NETWORK_NUM_CONNECTION_KEY = "l7vsd_network.num_connection";

    /**
     * l7vsd log level for network qos category key
     */
    protected static String LB_LOGCATEGORY_NETWORK_QOS_KEY = "l7vsd_network.qos";

    /**
     * l7vsd log level for virtual service category key
     */
    protected static String LB_LOGCATEGORY_VIRTUALSERVICE_KEY = "l7vsd_virtual_service";

    /**
     * l7vsd log level for real server category key
     */
    protected static String LB_LOGCATEOGRY_REALSERVER_KEY = "l7vsd_real_server";

    /**
     * l7vsd log level for sorry server category key
     */
    protected static String LB_LOGCATEOGRY_SORRYSERVER_KEY = "l7vsd_sorry_server";

    /**
     * l7vsd log level for realserver balancing category key
     */
    protected static String LB_LOGCATEOGRY_REALSERVER_BALANCING_KEY = "l7vsd_real_server.balancing";

    /**
     * l7vsd log level for replication category key
     */
    protected static String LB_LOGCATEOGRY_REPLICATION_KEY = "l7vsd_replication";

    /**
     * l7vsd log level for start and stop messege category key
     */
    protected static String LB_LOGCATEOGRY_STARTSTOP_KEY = "l7vsd_start_stop";

    /**
     * l7vsd log level for system category key
     */
    protected static String LB_LOGCATEOGRY_SYSTEM_KEY = "l7vsd_system";

    /**
     * l7vsd log level for memory in system category key
     */
    protected static String LB_LOGCATEOGRY_SYSTEMMEMORY_KEY = "l7vsd_system.memory";

    /**
     * l7vsd log level for socket category key
     */
    protected static String LB_LOGCATEOGRY_SYSTEMSOCKET_KEY = "l7vsd_system.socket";

    /**
     * l7vsd log level for signal category key
     */
    protected static String LB_LOGCATEOGRY_SYSTEMSIGNAL_KEY = "l7vsd_system.signal";

    /**
     * l7vsd log level for environment key
     */
    protected static String LB_LOGCATEOGRY_ENVIROMENT_KEY = "l7vsd_environment";

    /**
     * l7vsd log level for environment parameter category key
     */
    protected static String LB_LOGCATEOGRY_ENVIROMENTPARAMTER_KEY = "l7vsd_environment.parameter";

    /**
     * l7vsd log level for logger category key
     */
    protected static String LB_LOGCATEGORY_LOGGER_KEY = "l7vsd_logger";

    /**
     * l7vsd log level for parameter category key
     */
    protected static String LB_LOGCATEGORY_PARAMTER = "l7vsd_parameter";

    /**
     * l7vsd log level for event category key
     */
    protected static String LB_LOGCATEGORY_EVENT_KEY = "l7vsd_event";

    /**
     * l7vsd log level for schedule category key
     */
    protected static String LB_LOGCATEGORY_SCHEDULE_KEY = "l7vsd_schedule";

    /**
     * l7vsd log level for program category key
     */
    protected static String LB_LOGCATEGORY_PROGRAM_KEY = "l7vsd_program";

    /**
     * l7vsd log level for protocol category key
     */
    protected static String LB_LOGCATEGORY_PROTOCOL_KEY = "l7vsd_protocol";

    /**
     * l7vsd log level for module category key
     */
    protected static String LB_LOGCATEGORY_MODULE_KEY = "l7vsd_module";

    /**
     * l7vsadm log file name key
     */
    protected static String ADM_LOG_FILENAME_KEY = "l7vsadm_log_filename";

    /**
     * l7vsadm log rotation key
     */
    protected static String ADM_LOG_ROTATION_KEY = "l7vsadm_rotation";

    /**
     * l7vsadm log maxbackup indexn key
     */
    protected static String ADM_LOG_MAXBACKUPINDEX_KEY = "l7vsadm_max_backup_index";

    /**
     * l7vsadm log rotate timing key
     */
    protected static String ADM_LOG_ROTATE_TIMING_KEY = "l7vsadm_rotation_timing";

    /**
     * l7vsadm log rotate timing 
     */
    protected static String ADM_LOG_ROTATE_TIMING_VALUE_KEY = "l7vsadm_rotation_timing_value";

    /**
     * l7vsadm log maxfilesize key
     */
    protected static String ADM_LOG_MAXFILESIZE_KEY = "l7vsadd_max_filesize";

    /**
     * l7vsadm log level for pase key
     */
    protected static String ADM_LOGCATEGORY_PARSE_KEY = "l7vsadm_parse";

    /**
     * l7vsadm log level for operate key
     */
    protected static String ADM_LOGCATEGORY_OPERATE_KEY = "l7vsadm_operate";

    /**
     * l7vsadm log level for communicate key
     */
    protected static String ADM_LOGCATEGORY_COMMUNICATE_KEY = "l7vsadm_communicate";

    /**
     * l7vsadm log level for config result key
     */
    protected static String ADM_LOGCATEGORY_CONFIG_RESULT_KEY = "l7vsadm_config_result";

    /**
     * l7vsadm log level for common key
     */
    protected static String ADM_LOGCATEOGRY_COMMON = "l7vsadm_common";

    /**
     * l7vsadm logl level for logger key
     */
    protected static String ADM_LOGCATEGORY_LOGGER = "l7vsadm_logger";

    /**
     * l7vsadm log level for parameter key
     */
    protected static String ADM_LOGCATEGORY_PARAMETER = "l7vsadm_parameter";

    /**
     * l7vsadm log level for protocol key
     */
    protected static String ADM_LOGCATEOGRY_PROTOCOL = "l7vsadm_protocol";

    /**
     * l7vsadm log level for module key
     */
    protected static String ADM_LOGCATEOGRY_MODULE = "l7vsadm_module";

    /**
     * snmp log filename kay
     */
    protected static String SNMP_LOG_FILENAME_KEY = "snmpagent_log_filename";

    /**
     * snmp log rotatetion key
     */
    protected static String SNMP_LOG_ROTATION_KEY = "snmpagent_rotation";

    /**
     * snmp max backup num key
     */
    protected static String SNMP_LOG_MAXBACKUPINDEX_KEY = "snmpagent_max_backup_index";

    /**
     * snmp log rotate timing key
     */
    protected static String SNMP_LOG_ROTATE_TIMING_KEY = "snmpagent_rotation_timing";

    /**
     * snmp log rotate timing value key
     */
    protected static String SNMP_LOG_ROTATE_TIMING_VALUE_KEY = "snmpagent_rotation_timing_value";

    /**
     * snmp log max filesize key
     */
    protected static String SNMP_MAX_FILESIZE_KEY = "snmpagent_max_filesize";

    /**
     * snmp log level for start stop message category key
     */
    protected static String SNMP_LOGCATEOGRY_STARTSTOP_KEY = "snmpagent_start_stop";

    /**
     * snmp log level for manager recive category key
     */
    protected static String SNMP_LOGCATEGORY_MANAGER_RECEIVE_KEY = "snmpagent_manager_receive";

    /**
     * snmp log level for manager send category key
     */
    protected static String SNMP_LOGCATEGORY_MANAGER_SEND_KEY = "snmpagent_manager_send";

    /**
     * snmp log level for l7vsd recive category key
     */
    protected static String SNMP_LOGCATEGORY_L7VSD_RECEIVE_KEY = "snmpagent_l7vsd_receive";

    /**
     * snmp log level for l7vsd send category key
     */
    protected static String SNMP_LOGCATEGORY_L7VSD_SEND_KEY = "snmpagent_l7vsd_send";

    /**
     * snmp log level for logger category key
     */
    protected static String SNMP_LOGCATEGORY_LOGGER = "snmpagent_logger";

    /**
     * snmp log level for parameter category key
     */
    protected static String SNMP_LOGCATEGORY_PARAMETER = "snmpagent_parameter";

    /**
     * l7vsadm command interval key
     */
    protected static String ADM_CMD_INTERVAL_KEY = "cmd_interval";

    /**
     * l7vsadm command retry count key
     */
    protected static String ADM_CMD_COUNT_KEY = "cmd_count";

    /**
     * l7vsadm connection retry interval timing key
     */
    protected static String ADM_CON_INTERVAL_KEY = "con_interval";

    /**
     * l7vsadm connection retry count key
     */
    protected static String ADM_CON_COUNT_KEY = "con_count";

    /**
     * l7vsd replication target ipaddress key
     */
    protected static String REPLICATION_IPADDR_KEY = "ip_addr";

    /**
     * l7vsd replication using portno key
     */
    protected static String REPLICATION_SERVICENAME_KEY = "service_name";

    /**
     * l7vsd replication using NIC kay
     */
    protected static String REPLICATION_NIC_KEY = "nic";

    /**
     * l7vsd replication interval timing key
     */
    protected static String REPLICATION_INTERVAL_KEY = "interval";

    /**
     * l7vsd replication interval timing key
     */
    protected static String REPLICATION_COMPULSORILY_INTERVAL_KEY = "compulsorily_interval";

    /**
     * l7vsd replication component base key
     */
    protected static String REPLICATION_COMPONENT_ID_BASE_KEY = "cmponent_id_";

    /**
     * l7vsd replication component size base key
     */
    protected static String REPLICATION_COMPONENT_SIZE_BASE_KEY = "cmponent_size_";

    /**
     * SNMPAgent using NIC key
     */
    protected static String SNMPAGENT_NIC_KEY = "nic";

    /**
     * SNMPAgent using ipaddress key
     */
    protected static String SNMPAGENT_IPADDR_KEY = "ip_addr";

    /**
     * SNMPAgent using service port key
     */
    protected static String SNMPAGENT_PORT_KEY = "port";

    /**
     * SNMPAgent using interval key
     */
    protected static String SNMPAGENT_INTERVAL_KEY = "interval";

    /**
     * SNMPAgent using status key(this value is temp)
     */
    protected static String SNMPAGENT_STATUS_KEY = "status";

    /**
     * l7vsd replication using max component num
     */
    protected static int MAX_REPLICATION_COMPONENT_COUNT = 99;

    /**
     * pair class
     * <p>class pair</p>
     * <p>Copyright(c) NTT COMWARE 2008</p>
     * @author kubota
     */
    protected class Pair<E, N> {
        protected E elementFirst;

        protected N elementSecond;

        public Pair(E firstIn, N secondIn) {
            elementFirst = firstIn;
            elementSecond = secondIn;
        }

        public void set(E firstIn, N secondIn) {
            elementFirst = firstIn;
            elementSecond = secondIn;
        }

        public E first() {
            return elementFirst;
        }

        public N second() {
            return elementSecond;
        }
    }

    protected Pair<String, String> paseKey(String inLine) {
        if (inLine == null)
            return null;
        int pos = inLine.indexOf("=");
        if (pos == -1)
            return new Pair(inLine, "");
        String first = inLine.substring(0, pos);
        String second = inLine.substring(pos + 1, inLine.length());
        if (first.indexOf('#') != -1)
            return new Pair<String, String>("", "");
        if (second.indexOf('#') != -1) {
            pos = second.indexOf('#');
            second = second.substring(0, pos);
        }
        first = first.trim();
        second = second.trim();
        if (second.matches("^\".*\"$"))
            second = second.substring(1, second.length() - 1);
        Pair<String, String> pair = new Pair<String, String>(first, second);
        return pair;
    }

    /**
     * component use set.
     * <p>class ComponentSet</p>
     * <p>Copyright(c) NTT COMWARE 2008</p>
     * @author kubota
     */
    protected class ComponentSet {
        public Pair<String, String> idPair;

        public Pair<String, String> sizePair;
    }

    protected static LogData.LogLevel convStringToLogLevel(String instr)
                    throws org.ultramonkey.l7.model.FileNotReadException {
        if (instr == null) {
            org.ultramonkey.l7.model.FileNotReadException exception = new org.ultramonkey.l7.model.FileNotReadException();
            exception
                            .setErrMessage("function L7vsConfController::convStringToLogLevel(String) param is null");
            throw exception;
        }
        if (instr.equals("debug"))
            return LogData.LogLevel.DEBUG;
        else if (instr.equals("DEBUG"))
            return LogData.LogLevel.DEBUG;
        else if (instr.equals("error"))
            return LogData.LogLevel.ERROR;
        else if (instr.equals("ERROR"))
            return LogData.LogLevel.ERROR;
        else if (instr.equals("fatal"))
            return LogData.LogLevel.FATAL;
        else if (instr.equals("FATAL"))
            return LogData.LogLevel.FATAL;
        else if (instr.equals("info"))
            return LogData.LogLevel.INFO;
        else if (instr.equals("INFO"))
            return LogData.LogLevel.INFO;
        else if (instr.equals("warn"))
            return LogData.LogLevel.WARN;
        else if (instr.endsWith("WARN"))
            return LogData.LogLevel.WARN;
        org.ultramonkey.l7.model.FileNotReadException exception = new org.ultramonkey.l7.model.FileNotReadException();
        exception.setErrMessage("");
        throw exception;
    }

    protected static String convLogLevelToLogString(LogData.LogLevel inlevel) {
        if (inlevel == LogData.LogLevel.DEBUG)
            return "\"debug\"";
        if (inlevel == LogData.LogLevel.ERROR)
            return "\"error\"";
        if (inlevel == LogData.LogLevel.FATAL)
            return "\"fatal\"";
        if (inlevel == LogData.LogLevel.INFO)
            return "\"info\"";
        if (inlevel == LogData.LogLevel.WARN)
            return "\"warn\"";
        return "";
    }

    // list to data for LoggerParameter.
    protected void readLoggerParameter(L7vsConfData data,
                    java.util.LinkedList<String> inList)
                    throws org.ultramonkey.l7.model.FileNotReadException {
        if (data == null || inList == null)
            return;
        for (java.util.Iterator<String> itr = inList.iterator(); itr.hasNext();) {
            String buffer = itr.next();
            Pair<String, String> pair = paseKey(buffer);
            if (pair.first().equals(LB_LOG_FILENAME_KEY) )
                data.logger.lbLog.fileName = pair.second();
            else if (pair.first().equals(LB_LOG_ROTATION_KEY))
                data.logger.lbLog.rotation = pair.second();
            else if (pair.first().equals(LB_LOG_MAXBACKUPINDEX_KEY) ) {
                try {
                    data.logger.lbLog.maxBackupIndex = Integer.parseInt(pair.second());
                } catch (java.lang.NumberFormatException e) {
                    data.logger.lbLog.maxBackupIndex = 0;
                }
              }
            else if (pair.first().equals(LB_LOG_ROTATE_TIMING_KEY))
                data.logger.lbLog.rotationTiming = pair.second();
            else if (pair.first().equals(LB_LOG_ROTATE_TIMING_VALUE_KEY))
                data.logger.lbLog.rotationTimingValue = pair.second();
            else if (pair.first().equals(LB_LOG_MAXFILESIZE_KEY))
                data.logger.lbLog.maxFileSize = pair.second();
            else if (pair.first().equals(LB_LOGCATEGORY_NETWORK_KEY) )
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_NETWORK,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEGORY_NETWORK_BANDWIDTH_KEY))
                data.logger.lbLog.logLevel.put(
                                LogData.LogCategory.L7VSD_NETWORK_BANDWIDTH,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEGORY_NETWORK_NUM_CONNECTION_KEY))
                data.logger.lbLog.logLevel.put(
                                LogData.LogCategory.L7VSD_NETWORK_NUM_CONNECTION,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEGORY_NETWORK_QOS_KEY))
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_NETWORK_QOS,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEGORY_VIRTUALSERVICE_KEY))
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_VIRTUAL_SERVICE,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEOGRY_REALSERVER_KEY))
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_REAL_SERVER,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEOGRY_SORRYSERVER_KEY))
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_SORRY_SERVER,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEOGRY_REALSERVER_BALANCING_KEY))
                data.logger.lbLog.logLevel.put(
                                LogData.LogCategory.L7VSD_REAL_SERVER_BALANCING,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEOGRY_REPLICATION_KEY))
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_REPLICATION,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEOGRY_STARTSTOP_KEY))
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_START_STOP,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEOGRY_SYSTEM_KEY))
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_SYSTEM,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEOGRY_SYSTEMMEMORY_KEY))
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_SYSTEM_MEMORY,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEOGRY_SYSTEMSOCKET_KEY))
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_SYSTEM_SOCKET,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEOGRY_SYSTEMSIGNAL_KEY))
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_SYSTEM_SIGNAL,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEOGRY_ENVIROMENT_KEY))
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_ENVIRONMENT,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEOGRY_ENVIROMENTPARAMTER_KEY))
                data.logger.lbLog.logLevel.put(
                                LogData.LogCategory.L7VSD_ENVIRONMENT_PARAMETER,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEGORY_LOGGER_KEY))
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_LOGGER,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEGORY_PARAMTER))
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_PARAMETER,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEGORY_EVENT_KEY))
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_EVENT,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEGORY_SCHEDULE_KEY))
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_SCHEDULE,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEGORY_PROGRAM_KEY))
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_PROGRAM,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEGORY_PROTOCOL_KEY))
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_PROTOCOL,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(LB_LOGCATEGORY_MODULE_KEY))
                data.logger.lbLog.logLevel.put(LogData.LogCategory.L7VSD_MODULE,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(ADM_LOG_FILENAME_KEY))
                data.logger.admLog.fileName = pair.second();
            else if (pair.first().equals(ADM_LOG_ROTATION_KEY))
                data.logger.admLog.rotation = pair.second();
            else if (pair.first().equals(ADM_LOG_MAXBACKUPINDEX_KEY)) {
                try {
                    data.logger.admLog.maxBackupIndex = Integer.parseInt(pair.second());
                } catch (java.lang.NumberFormatException e) {
                    data.logger.admLog.maxBackupIndex = 0;
                }
            } else if (pair.first().equals(ADM_LOG_ROTATE_TIMING_KEY))
                data.logger.admLog.rotationTiming = pair.second();
            else if (pair.first().equals(ADM_LOG_ROTATE_TIMING_VALUE_KEY))
                data.logger.admLog.rotationTimingValue = pair.second();
            else if (pair.first().equals(ADM_LOG_MAXFILESIZE_KEY))
                data.logger.admLog.maxFileSize = pair.second();
            else if (pair.first().equals(ADM_LOGCATEGORY_PARSE_KEY))
                data.logger.admLog.logLevel.put(LogData.LogCategory.L7VSADM_PARSE,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(ADM_LOGCATEGORY_OPERATE_KEY))
                data.logger.admLog.logLevel.put(LogData.LogCategory.L7VSADM_OPERATE,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(ADM_LOGCATEGORY_COMMUNICATE_KEY))
                data.logger.admLog.logLevel.put(LogData.LogCategory.L7VSADM_COMMUNICATE,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(ADM_LOGCATEGORY_CONFIG_RESULT_KEY))
                data.logger.admLog.logLevel.put(
                                LogData.LogCategory.L7VSADM_CONFIG_RESULT,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(ADM_LOGCATEOGRY_COMMON))
                data.logger.admLog.logLevel.put(LogData.LogCategory.L7VSADM_COMMON,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(ADM_LOGCATEGORY_LOGGER))
                data.logger.admLog.logLevel.put(LogData.LogCategory.L7VSADM_LOGGER,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(ADM_LOGCATEGORY_PARAMETER))
                data.logger.admLog.logLevel.put(LogData.LogCategory.L7VSADM_PARAMETER,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(ADM_LOGCATEOGRY_PROTOCOL))
                data.logger.admLog.logLevel.put(LogData.LogCategory.L7VSADM_PROTOCOL,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(ADM_LOGCATEOGRY_MODULE))
                data.logger.admLog.logLevel.put(LogData.LogCategory.L7VSADM_MODULE,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(SNMP_LOG_FILENAME_KEY))
                data.logger.snmpLog.fileName = pair.second();
            else if (pair.first().equals(SNMP_LOG_ROTATION_KEY))
                data.logger.snmpLog.rotation = pair.second();
            else if (pair.first().equals(SNMP_LOG_MAXBACKUPINDEX_KEY)) {
                try {
                    data.logger.snmpLog.maxBackupIndex = Integer.parseInt(pair.second());
                } catch (java.lang.NumberFormatException e) {
                    data.logger.snmpLog.maxBackupIndex = 0;
                }
            } else if (pair.first().equals(SNMP_LOG_ROTATE_TIMING_KEY))
                data.logger.snmpLog.rotationTiming = pair.second();
            else if (pair.first().equals(SNMP_LOG_ROTATE_TIMING_VALUE_KEY))
                data.logger.snmpLog.rotationTimingValue = pair.second();
            else if (pair.first().equals(SNMP_MAX_FILESIZE_KEY))
                data.logger.snmpLog.maxFileSize = pair.second();
            else if (pair.first().equals(SNMP_LOGCATEOGRY_STARTSTOP_KEY))
                data.logger.snmpLog.logLevel.put(
                                LogData.LogCategory.SNMPAGENT_START_STOP,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(SNMP_LOGCATEGORY_MANAGER_RECEIVE_KEY))
                data.logger.snmpLog.logLevel.put(
                                LogData.LogCategory.SNMPAGENT_MANAGER_RECEIVE,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(SNMP_LOGCATEGORY_MANAGER_SEND_KEY))
                data.logger.snmpLog.logLevel.put(
                                LogData.LogCategory.SNMPAGENT_MANAGER_SEND,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(SNMP_LOGCATEGORY_L7VSD_RECEIVE_KEY))
                data.logger.snmpLog.logLevel.put(
                                LogData.LogCategory.SNMPAGENT_L7VSD_RECEIVE,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(SNMP_LOGCATEGORY_L7VSD_SEND_KEY))
                data.logger.snmpLog.logLevel.put(
                                LogData.LogCategory.SNMPAGENT_L7VSD_SEND,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(SNMP_LOGCATEGORY_LOGGER))
                data.logger.snmpLog.logLevel.put(LogData.LogCategory.SNMPAGENT_LOGGER,
                                convStringToLogLevel(pair.second()));
            else if (pair.first().equals(SNMP_LOGCATEGORY_PARAMETER))
                data.logger.snmpLog.logLevel.put(LogData.LogCategory.SNMPAGENT_PARAMETER,
                                convStringToLogLevel(pair.second()));
        }
    }

    protected void readAdmParameter(L7vsConfData data, java.util.LinkedList<String> inList)
                    throws org.ultramonkey.l7.model.FileNotReadException {
        if (data == null || inList == null)
            return;
        for (java.util.Iterator<String> itr = inList.iterator(); itr.hasNext();) {
            String buffer = itr.next();
            Pair<String, String> pair = paseKey(buffer);
            if (pair.first().indexOf(ADM_CMD_INTERVAL_KEY) != -1) {
                try {
                    data.admCmdInterval = Integer.parseInt(pair.second());
                } catch (java.lang.NumberFormatException e) {
                    data.admCmdInterval = 0;
                }
            } else if (pair.first().indexOf(ADM_CMD_COUNT_KEY) != -1) {
                try {
                    data.admCmdCount = Integer.parseInt(pair.second());
                } catch (java.lang.NumberFormatException e) {
                    data.admCmdCount = 0;
                }
            } else if (pair.first().indexOf(ADM_CON_INTERVAL_KEY) != -1) {
                try {
                    data.admConInterval = Integer.parseInt(pair.second());
                } catch (java.lang.NumberFormatException e) {
                    data.admConInterval = 0;
                }
            } else if (pair.first().indexOf(ADM_CON_COUNT_KEY) != -1) {
                try {
                    data.admConCount = Integer.parseInt(pair.second());
                } catch (java.lang.NumberFormatException e) {
                    data.admConCount = 0;
                }
            }

        }
    }

    protected void readSNMPAgentParameter(L7vsConfData data,
                    java.util.LinkedList<String> inList)
                    throws org.ultramonkey.l7.model.FileNotReadException {
        if (data == null || inList == null)
            return;
        for (java.util.Iterator<String> itr = inList.iterator(); itr.hasNext();) {
            String buffer = itr.next();
            Pair<String, String> pair = paseKey(buffer);
            if (pair.first().indexOf(SNMPAGENT_NIC_KEY) != -1)
                data.snmpNIC = pair.second();
            else if (pair.first().indexOf(SNMPAGENT_IPADDR_KEY) != -1)
                data.snmpIpAddr = pair.second();
            else if (pair.first().indexOf(SNMPAGENT_PORT_KEY) != -1)
                data.snmpPort = pair.second();
            else if (pair.first().indexOf(SNMPAGENT_INTERVAL_KEY) != -1) {
                try {
                    data.snmpInterval = Integer.parseInt(pair.second());
                } catch (java.lang.NumberFormatException e) {
                    data.snmpInterval = 0;
                }
            }
        }
    }

    protected void readReplicationParameter(L7vsConfData data,
                    java.util.LinkedList<String> inList)
                    throws org.ultramonkey.l7.model.FileNotReadException {
        if (data == null || inList == null)
            return;
        java.util.HashMap<String, Pair<String,String>> map = new java.util.HashMap<String, Pair<String,String>>();
        for (java.util.Iterator<String> itr = inList.iterator(); itr.hasNext();) {
            String buffer = itr.next();
            Pair<String, String> pair = paseKey(buffer);
            if (pair.first().indexOf(REPLICATION_IPADDR_KEY) != -1)
                data.replicationOtherNode.host = pair.second();
            else if (pair.first().indexOf(REPLICATION_SERVICENAME_KEY) != -1)
                data.replicationOtherNode.port = pair.second();
            else if (pair.first().indexOf(REPLICATION_NIC_KEY) != -1)
                data.replicationNic = pair.second();
            else if (pair.first().indexOf(REPLICATION_INTERVAL_KEY) != -1 &&
            		pair.first().indexOf(REPLICATION_COMPULSORILY_INTERVAL_KEY) == -1) {
                try {
                    data.replicationInterval = Integer.parseInt(pair.second());
                } catch (java.lang.NumberFormatException e) {
                    data.replicationInterval = 0;
                }
            } else if (pair.first().indexOf(REPLICATION_COMPONENT_ID_BASE_KEY) != -1) {
            	String number = pair.first().substring(REPLICATION_COMPONENT_ID_BASE_KEY.length(), REPLICATION_COMPONENT_ID_BASE_KEY.length() + 2);
            	Pair<String,String> tmpPair = map.get(number);
            	if( tmpPair == null )
            		map.put(number, new Pair<String,String>(pair.second(), "" ));
            	else
            		tmpPair.set(pair.first(), tmpPair.second());
            } else if (pair.first().indexOf(REPLICATION_COMPONENT_SIZE_BASE_KEY) != -1) {
            	String number = pair.first().substring(REPLICATION_COMPONENT_SIZE_BASE_KEY.length(), REPLICATION_COMPONENT_SIZE_BASE_KEY.length() + 2);
            	Pair<String,String> tmpPair = map.get(number);
            	if( tmpPair == null )
            		map.put(number, new Pair<String,String>("", pair.second()));
            	else
            		tmpPair.set(tmpPair.first(), pair.second());
            }
        }
        //data puts COMPONENTID and SIZE
        data.component = new java.util.HashMap<String, Integer>();
        for (java.util.Iterator<java.util.Map.Entry<String, Pair<String,String>>> itr = map.entrySet().iterator(); itr
                        .hasNext();) {
        	java.util.Map.Entry<String, Pair<String,String>> entry = itr.next();
            Pair<String, String> pair = entry.getValue();
            try {
                data.component.put(pair.first(), Integer.parseInt(pair.second()));
            } catch (java.lang.NumberFormatException e) {
                data.component.put(pair.first(), 0);
            }
        }
    }

    /**
     * l7vs.cf load function.
     * @return L7vsConfData create from l7vs.cf file.
     * @throws org.ultramonkey.l7/model.FileNotReadException
     */
    protected L7vsConfData loadFromFile()
                    throws org.ultramonkey.l7.model.FileNotReadException {

        // data read on stack
        java.util.Stack<String> stack = new java.util.Stack<String>();
        try {
            java.io.FileReader file = new java.io.FileReader(FILENAME);
            java.io.BufferedReader reader = new java.io.BufferedReader(file);
            String buffer;
            while ((buffer = reader.readLine()) != null) {
                if (buffer.length() != 0 && buffer.charAt(0) != '#') {
                    stack.push(buffer);
                }
            }
        } catch (Exception e) {
            org.ultramonkey.l7.model.FileNotReadException ex = new org.ultramonkey.l7.model.FileNotReadException();
            ex.setErrMessage("Cannot read file : " + FILENAME + "/ base exception = "
                            + e.getMessage());
            throw ex;
        }
        //category search.

        L7vsConfData data = new L7vsConfData();
        java.util.LinkedList<String> tmpList = new java.util.LinkedList<String>();
        while (!stack.empty()) {
            String buffer = stack.pop();
            buffer = buffer.trim();
            int pos = buffer.indexOf('#');
            if( pos == 0 ) continue;
            if( pos != -1 ) buffer = buffer.substring(0, pos);
            else if (buffer.charAt(0) == '[' && buffer.charAt(buffer.length()-1) == ']') {
                // select service;
                if (buffer.indexOf(LOGGER_MASTER_KEY) != -1) {
                    readLoggerParameter(data, tmpList);
                    tmpList.clear();
                    continue;
                } else if (buffer.indexOf(L7VSADM_MASTER_KEY) != -1) {
                    readAdmParameter(data, tmpList);
                    tmpList.clear();
                    continue;
                } else if (buffer.indexOf(REPLICATION_MASTER_KEY) != -1) {
                    readReplicationParameter(data, tmpList);
                    tmpList.clear();
                    continue;
                } else if (buffer.indexOf(SNMPAGENT_MASTER_KEY) != -1) {
                    readSNMPAgentParameter(data, tmpList);
                    tmpList.clear();
                    continue;
                }
            }
            tmpList.addFirst(buffer);
        }

        return data;
    }

	private static String trimQuote(String s) {
		if (s != null && s.matches("^\".*\"$")) {
			s = s.substring(1, s.length() - 1);
		}
		return s;
	}

    protected void searchInsertData(String key, String value,
                    java.util.LinkedList<String> list, int start, int end) {
        for (int i = start; i < end; ++i) {
            String buffer = list.get(i).trim();
            if (buffer.length() == 0)
                continue;
            int commentpos = buffer.indexOf("#");
            if (commentpos != -1)
                buffer = buffer.substring(commentpos, buffer.length());
            Pair<String, String> pair = paseKey(buffer);
            if (pair.first().length() == 0)
                continue;
            if (pair.first().equals(key)) {
            	if (pair.second().equals(trimQuote(value)))
            		return;
                StringBuffer buf = new StringBuffer();
                if (commentpos == -1)
                	buf.append('#');
                buf.append(list.get(i));
                list.remove(i);
                list.add(i, buf.toString());
                list.add(i + 1, key + "=" + value);
                return;
            }
        }
        list.add(end + 1, key + "=" + value);
    }

    /**
     * 
     * <p> saveToFile method</p>
     *
     */
    protected void saveToFile(L7vsConfData data)
                    throws org.ultramonkey.l7.model.FileNotWriteException {
        java.util.LinkedList<String> datas = new java.util.LinkedList();
        try {
            java.io.FileReader file = new java.io.FileReader(FILENAME);
            java.io.BufferedReader reader = new java.io.BufferedReader(file);
            String buffer;
            while ((buffer = reader.readLine()) != null) {
                datas.addLast(buffer);
            }
        } catch (Exception e) {
            org.ultramonkey.l7.model.FileNotWriteException ex = new org.ultramonkey.l7.model.FileNotWriteException();
            ex.setErrMessage("Cannot open file : " + FILENAME);
            throw ex;
        }

        //[logger]
        int startpos = 0;
        int endpos = 0; //logger value.
        for (int i = 0; i < datas.size(); ++i) {
            String buffer = datas.get(i).trim();
            if (buffer.length() == 0)
                continue;
            if (buffer.charAt(0) == '#')
                continue;
            int cmntpos = buffer.indexOf("#");
            if (cmntpos != -1)
                buffer = buffer.substring(0, cmntpos).trim();
            if (buffer.charAt(0) == '[' && buffer.charAt(buffer.length()-1) == ']') {
                if (buffer.indexOf("logger") != -1 || buffer.indexOf("LOGGER") != -1) {
                    startpos = i + 1;
                } else {
                    if (startpos != 0) {
                        endpos = i;
                        break;
                    }
                }
            }
        }
        if( endpos == 0 ) endpos = datas.size();
        if (data.logger.lbLog.fileName != null
                        && data.logger.lbLog.fileName.length() != 0)
            searchInsertData(LB_LOG_FILENAME_KEY,
                            "\"" + data.logger.lbLog.fileName + "\"", datas, startpos,
                            endpos);
        if (data.logger.lbLog.rotation != null
                        && data.logger.lbLog.rotation.length() != 0)
            searchInsertData(LB_LOG_ROTATION_KEY,
                            "\"" + data.logger.lbLog.rotation + "\"", datas, startpos,
                            endpos += 1);
        if (data.logger.lbLog.maxBackupIndex != 0)
            searchInsertData(LB_LOG_MAXBACKUPINDEX_KEY, String
                            .valueOf(data.logger.lbLog.maxBackupIndex), datas, startpos,
                            endpos += 1);
        if (data.logger.lbLog.rotationTiming != null
                        && data.logger.lbLog.rotationTiming.length() != 0)
            searchInsertData(LB_LOG_ROTATE_TIMING_KEY, "\""
                            + data.logger.lbLog.rotationTiming + "\"", datas, startpos,
                            endpos += 1);
        if (data.logger.lbLog.rotationTimingValue != null
                        && data.logger.lbLog.rotationTimingValue.length() != 0)
            searchInsertData(LB_LOG_ROTATE_TIMING_KEY, "\""
                            + data.logger.lbLog.rotationTimingValue + "\"", datas,
                            startpos, endpos += 1);
        if (data.logger.lbLog.maxFileSize != null
                        && data.logger.lbLog.maxFileSize.length() != 0)
            searchInsertData(LB_LOG_MAXFILESIZE_KEY, "\"" + data.logger.lbLog.maxFileSize
                            + "\"", datas, startpos, endpos += 1);
        LogData.LogLevel level = data.logger.lbLog.logLevel
                        .get(LogData.LogCategory.L7VSD_NETWORK);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEGORY_NETWORK_KEY, buf, datas, startpos, endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel
                        .get(LogData.LogCategory.L7VSD_NETWORK_BANDWIDTH);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEGORY_NETWORK_BANDWIDTH_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel
                        .get(LogData.LogCategory.L7VSD_NETWORK_NUM_CONNECTION);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEGORY_NETWORK_NUM_CONNECTION_KEY, buf, datas,
                            startpos, endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel.get(LogData.LogCategory.L7VSD_NETWORK_QOS);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEGORY_NETWORK_QOS_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel.get(LogData.LogCategory.L7VSD_VIRTUAL_SERVICE);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEGORY_VIRTUALSERVICE_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel.get(LogData.LogCategory.L7VSD_REAL_SERVER);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEOGRY_REALSERVER_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel.get(LogData.LogCategory.L7VSD_SORRY_SERVER);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEOGRY_SORRYSERVER_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel
                        .get(LogData.LogCategory.L7VSD_REAL_SERVER_BALANCING);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEOGRY_REALSERVER_BALANCING_KEY, buf, datas,
                            startpos, endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel.get(LogData.LogCategory.L7VSD_REPLICATION);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEOGRY_REPLICATION_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel.get(LogData.LogCategory.L7VSD_START_STOP);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEOGRY_STARTSTOP_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel.get(LogData.LogCategory.L7VSD_SYSTEM);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEOGRY_SYSTEM_KEY, buf, datas, startpos, endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel.get(LogData.LogCategory.L7VSD_SYSTEM_MEMORY);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEOGRY_SYSTEMMEMORY_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel.get(LogData.LogCategory.L7VSD_SYSTEM_SOCKET);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEOGRY_SYSTEMSOCKET_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel.get(LogData.LogCategory.L7VSD_SYSTEM_SIGNAL);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEOGRY_SYSTEMSIGNAL_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel.get(LogData.LogCategory.L7VSD_ENVIRONMENT);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEOGRY_ENVIROMENT_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel
                        .get(LogData.LogCategory.L7VSD_ENVIRONMENT_PARAMETER);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEOGRY_ENVIROMENTPARAMTER_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel.get(LogData.LogCategory.L7VSD_LOGGER);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEGORY_LOGGER_KEY, buf, datas, startpos, endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel.get(LogData.LogCategory.L7VSD_PARAMETER);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEGORY_PARAMTER, buf, datas, startpos, endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel.get(LogData.LogCategory.L7VSD_SCHEDULE);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEGORY_SCHEDULE_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel.get(LogData.LogCategory.L7VSD_EVENT);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEGORY_EVENT_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel.get(LogData.LogCategory.L7VSD_PROGRAM);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEGORY_PROGRAM_KEY, buf, datas, startpos, endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel.get(LogData.LogCategory.L7VSD_PROTOCOL);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEGORY_PROTOCOL_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.lbLog.logLevel.get(LogData.LogCategory.L7VSD_MODULE);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(LB_LOGCATEGORY_MODULE_KEY, buf, datas, startpos, endpos += 1);
            }
        }
        if (data.logger.admLog.fileName != null
                        && data.logger.admLog.fileName.length() != 0)
            searchInsertData(ADM_LOG_FILENAME_KEY, "\"" + data.logger.admLog.fileName
                            + "\"", datas, startpos, endpos += 1);
        if (data.logger.admLog.rotation != null
                        && data.logger.admLog.rotation.length() != 0)
            searchInsertData(ADM_LOG_ROTATION_KEY, "\"" + data.logger.admLog.rotation
                            + "\"", datas, startpos, endpos += 1);
        if (data.logger.admLog.maxBackupIndex != 0)
            searchInsertData(ADM_LOG_MAXBACKUPINDEX_KEY, String
                            .valueOf(data.logger.admLog.maxBackupIndex), datas, startpos,
                            endpos += 1);
        if (data.logger.admLog.rotationTiming != null
                        && data.logger.admLog.rotationTiming.length() != 0)
            searchInsertData(ADM_LOG_ROTATE_TIMING_KEY, "\""
                            + data.logger.admLog.rotationTiming + "\"", datas, startpos,
                            endpos += 1);
        if (data.logger.admLog.rotationTimingValue != null
                        && data.logger.admLog.rotationTimingValue.length() != 0)
            searchInsertData(ADM_LOG_ROTATE_TIMING_VALUE_KEY, "\""
                            + data.logger.admLog.rotationTimingValue + "\"", datas,
                            startpos, endpos += 1);
        if (data.logger.admLog.maxFileSize != null
                        && data.logger.admLog.maxFileSize.length() != 0)
            searchInsertData(ADM_LOG_MAXFILESIZE_KEY, "\""
                            + data.logger.admLog.maxFileSize + "\"", datas, startpos,
                            endpos += 1);
        level = data.logger.admLog.logLevel.get(LogData.LogCategory.L7VSADM_PARSE);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(ADM_LOGCATEGORY_PARSE_KEY, buf, datas, startpos, endpos += 1);
            }
        }
        level = data.logger.admLog.logLevel.get(LogData.LogCategory.L7VSADM_OPERATE);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(ADM_LOGCATEGORY_OPERATE_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.admLog.logLevel.get(LogData.LogCategory.L7VSADM_COMMUNICATE);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(ADM_LOGCATEGORY_COMMUNICATE_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.admLog.logLevel
                        .get(LogData.LogCategory.L7VSADM_CONFIG_RESULT);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(ADM_LOGCATEGORY_CONFIG_RESULT_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.admLog.logLevel.get(LogData.LogCategory.L7VSADM_COMMON);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(ADM_LOGCATEOGRY_COMMON, buf, datas, startpos, endpos += 1);
            }
        }
        level = data.logger.admLog.logLevel.get(LogData.LogCategory.L7VSADM_LOGGER);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(ADM_LOGCATEGORY_LOGGER, buf, datas, startpos, endpos += 1);
            }
        }
        level = data.logger.admLog.logLevel.get(LogData.LogCategory.L7VSADM_PARAMETER);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(ADM_LOGCATEGORY_PARAMETER, buf, datas, startpos, endpos += 1);
            }
        }
        level = data.logger.admLog.logLevel.get(LogData.LogCategory.L7VSADM_PROTOCOL);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(ADM_LOGCATEOGRY_PROTOCOL, buf, datas, startpos, endpos += 1);
            }
        }
        level = data.logger.admLog.logLevel.get(LogData.LogCategory.L7VSADM_MODULE);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(ADM_LOGCATEOGRY_MODULE, buf, datas, startpos, endpos += 1);
            }
        }
        if (data.logger.snmpLog.fileName != null
                        && data.logger.snmpLog.fileName.length() != 0)
            searchInsertData(SNMP_LOG_FILENAME_KEY, "\"" + data.logger.snmpLog.fileName
                            + "\"", datas, startpos, endpos += 1);
        if (data.logger.snmpLog.rotation != null
                        && data.logger.snmpLog.rotation.length() != 0)
            searchInsertData(SNMP_LOG_ROTATION_KEY, "\"" + data.logger.snmpLog.rotation
                            + "\"", datas, startpos, endpos += 1);
        if (data.logger.snmpLog.maxBackupIndex != 0)
            searchInsertData(SNMP_LOG_MAXBACKUPINDEX_KEY, String
                            .valueOf(data.logger.snmpLog.maxBackupIndex), datas,
                            startpos, endpos += 1);
        if (data.logger.snmpLog.rotationTiming != null
                        && data.logger.snmpLog.rotationTiming.length() != 0)
            searchInsertData(SNMP_LOG_ROTATE_TIMING_KEY, "\""
                            + data.logger.snmpLog.rotationTiming + "\"", datas,
                            startpos, endpos += 1);
        if (data.logger.snmpLog.rotationTimingValue != null
                        && data.logger.snmpLog.rotationTimingValue.length() != 0)
            searchInsertData(SNMP_LOG_ROTATE_TIMING_VALUE_KEY, "\""
                            + data.logger.snmpLog.rotationTimingValue + "\"", datas,
                            startpos, endpos += 1);
        if (data.logger.snmpLog.maxFileSize != null
                        && data.logger.snmpLog.maxFileSize.length() != 0)
            searchInsertData(SNMP_MAX_FILESIZE_KEY, "\"" + data.logger.snmpLog.maxFileSize
                            + "\"", datas, startpos, endpos += 1);
        level = data.logger.snmpLog.logLevel
                        .get(LogData.LogCategory.SNMPAGENT_START_STOP);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(SNMP_LOGCATEOGRY_STARTSTOP_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.snmpLog.logLevel
                        .get(LogData.LogCategory.SNMPAGENT_MANAGER_RECEIVE);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(SNMP_LOGCATEGORY_MANAGER_RECEIVE_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.snmpLog.logLevel
                        .get(LogData.LogCategory.SNMPAGENT_MANAGER_SEND);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(SNMP_LOGCATEGORY_MANAGER_SEND_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.snmpLog.logLevel
                        .get(LogData.LogCategory.SNMPAGENT_L7VSD_RECEIVE);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(SNMP_LOGCATEGORY_L7VSD_RECEIVE_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.snmpLog.logLevel
                        .get(LogData.LogCategory.SNMPAGENT_L7VSD_SEND);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(SNMP_LOGCATEGORY_L7VSD_SEND_KEY, buf, datas, startpos,
                            endpos += 1);
            }
        }
        level = data.logger.snmpLog.logLevel.get(LogData.LogCategory.SNMPAGENT_LOGGER);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(SNMP_LOGCATEGORY_LOGGER, buf, datas, startpos, endpos += 1);
            }
        }
        level = data.logger.snmpLog.logLevel.get(LogData.LogCategory.SNMPAGENT_PARAMETER);
        if (level != null) {
            String buf = convLogLevelToLogString(level);
            if (buf.length() != 0) {
            	searchInsertData(SNMP_LOGCATEGORY_PARAMETER, buf, datas, startpos, endpos += 1);
            }
        }

        //
        //[l7vsadm]
        startpos = 0;
        endpos = 0;
        for (int i = 0; i < datas.size(); ++i) {
            String buffer = datas.get(i).trim();
            if (buffer.length() == 0)
                continue;
            if (buffer.charAt(0) == '#')
                continue;
            int cmntpos = buffer.indexOf("#");
            if (cmntpos != -1)
                buffer = buffer.substring(0, cmntpos).trim();
            if (buffer.charAt(0) == '[' && buffer.charAt(buffer.length()-1) == ']') {
                if (buffer.indexOf("l7vsadm") != -1 || buffer.indexOf("L7VSADM") != -1) {
                    startpos = i + 1;
                } else {
                    if (startpos != 0) {
                        endpos = i;
                        break;
                    }
                }
            }
        }
        if( endpos == 0 ) endpos = datas.size();
        if (data.admConInterval != 0)
            searchInsertData(ADM_CMD_INTERVAL_KEY, String.valueOf(data.admCmdInterval),
                            datas, startpos, endpos += 1);
        if (data.admCmdCount != 0)
            searchInsertData(ADM_CMD_COUNT_KEY, String.valueOf(data.admCmdCount), datas,
                            startpos, endpos += 1);
        if (data.admConInterval != 0)
            searchInsertData(ADM_CON_INTERVAL_KEY, String.valueOf(data.admConInterval),
                            datas, startpos, endpos += 1);
        if (data.admConCount != 0)
            searchInsertData(ADM_CON_COUNT_KEY, String.valueOf(data.admConCount), datas,
                            startpos, endpos += 1);

        //
        //[replication]
        startpos = 0;
        endpos = 0;
        for (int i = 0; i < datas.size(); ++i) {
            String buffer = datas.get(i).trim();
            if (buffer.length() == 0)
                continue;
            if (buffer.charAt(0) == '#')
                continue;
            int cmntpos = buffer.indexOf("#");
            if (cmntpos != -1)
                buffer = buffer.substring(0, cmntpos).trim();
            if (buffer.charAt(0) == '[' && buffer.charAt(buffer.length()-1) == ']') {
                if (buffer.indexOf("replication") != -1
                                || buffer.indexOf("REPLICATION") != -1) {
                    startpos = i + 1;
                } else {
                    if (startpos != 0) {
                        endpos = i;
                        break;
                    }
                }
            }
        }
        if( endpos == 0 ) endpos = datas.size();
        if (data.replicationOtherNode.host != null
                        && data.replicationOtherNode.host.length() != 0)
            searchInsertData(REPLICATION_IPADDR_KEY, "\"" + data.replicationOtherNode.host
                            + "\"", datas, startpos, endpos += 1);
        if (data.replicationOtherNode.port != null
                        && data.replicationOtherNode.port.length() != 0)
            searchInsertData(REPLICATION_SERVICENAME_KEY, "\""
                            + data.replicationOtherNode.port + "\"", datas, startpos,
                            endpos += 1);
        if (data.replicationNic != null && data.replicationNic.length() != 0)
            searchInsertData(REPLICATION_NIC_KEY, "\"" + data.replicationNic + "\"",
                            datas, startpos, endpos += 1);
        if (data.replicationInterval != 0)
            searchInsertData(REPLICATION_INTERVAL_KEY, String
                            .valueOf(data.replicationInterval), datas, startpos,
                            endpos += 1);
        if (data.component != null) {
            int cmpno = 0;
            for (java.util.Iterator<java.util.Map.Entry<String, Integer>> itr = data.component
                            .entrySet().iterator(); itr.hasNext();) {
                java.util.Map.Entry<String, Integer> entry = itr.next();
                StringBuffer compIdKey = new StringBuffer();
                StringBuffer compSizeKey = new StringBuffer();
                compIdKey.append(REPLICATION_COMPONENT_ID_BASE_KEY);
                compSizeKey.append(REPLICATION_COMPONENT_SIZE_BASE_KEY);
                if (cmpno < 10) {
                    compIdKey.append("0");
                    compSizeKey.append("0");
                }
                compIdKey.append(cmpno);
                compSizeKey.append(cmpno);
                searchInsertData(compIdKey.toString(), "\"" + entry.getKey() + "\"",
                                datas, startpos, endpos += 1);
                searchInsertData(compSizeKey.toString(), String.valueOf(entry.getValue()),
                                datas, startpos, endpos += 1);
                ++cmpno;
            }
        }

        //
        //[snmpagent]
        //
        startpos = 0;
        endpos = 0;
        for (int i = 0; i < datas.size(); ++i) {
            String buffer = datas.get(i).trim();
            if (buffer.length() == 0)
                continue;
            if (buffer.charAt(0) == '#')
                continue;
            int cmntpos = buffer.indexOf("#");
            if (cmntpos != -1)
                buffer = buffer.substring(0, cmntpos).trim();
            if (buffer.charAt(0) == '[' || buffer.charAt(buffer.length()-1) == ']') {
                if (buffer.indexOf("snmpagent") != -1
                                || buffer.indexOf("SNMPAGENT") != -1) {
                    startpos = i + 1;
                } else {
                    if (startpos != 0) {
                        endpos = i;
                        break;
                    }
                }
            }
        }
        if( endpos == 0 ) endpos = datas.size();
        if (data.snmpNIC != null && data.snmpNIC.length() != 0)
            searchInsertData(SNMPAGENT_NIC_KEY, "\"" + data.snmpNIC + "\"", datas,
                            startpos, endpos += 1);
        if (data.snmpIpAddr != null && data.snmpIpAddr.length() != 0)
            searchInsertData(SNMPAGENT_IPADDR_KEY, "\"" + data.snmpIpAddr + "\"", datas,
                            startpos, endpos += 1);
        if (data.snmpPort != null && data.snmpPort.length() != 0)
            searchInsertData(SNMPAGENT_PORT_KEY, "\"" + data.snmpPort + "\"", datas,
                            startpos, endpos += 1);
        if (data.snmpInterval != 0)
            searchInsertData(SNMPAGENT_INTERVAL_KEY, String.valueOf(data.snmpInterval),
                            datas, startpos, endpos);

        try {
            java.io.File file = new java.io.File(FILENAME);
            if (file.exists()) {
                java.util.Date date = new java.util.Date();
                java.io.File backfile = new java.io.File(FILENAME + ".back_"
                                + String.valueOf(date.getTime()));
                file.renameTo(backfile);
                file = new java.io.File(FILENAME);
            }
            java.io.FileWriter writer = new java.io.FileWriter(file);
            for (java.util.Iterator<String> itr = datas.iterator(); itr.hasNext();) {
                StringBuffer buf = new StringBuffer(itr.next());
                buf.append('\n');
                writer.write(buf.toString());
            }
            writer.flush();
        } catch (Exception e) {
            org.ultramonkey.l7.model.FileNotWriteException ex = new org.ultramonkey.l7.model.FileNotWriteException();
            ex.setErrMessage("Cannot write file : " + FILENAME);
            throw ex;
        }

    }

    /**
     * 
     * <p> getConfData method</p>
     *
     * @return l7vs.cf data
     */
    public synchronized L7vsConfData getConfData()
                    throws org.ultramonkey.l7.model.FileNotReadException {
        return loadFromFile();
    }

    /**
     * 
     * <p> setConfData method</p>
     *
     */
    public synchronized void setConfData(L7vsConfData cf)
                    throws org.ultramonkey.l7.model.FileNotWriteException {
        if (cf == null) {
            org.ultramonkey.l7.model.FileNotWriteException exception = new org.ultramonkey.l7.model.FileNotWriteException();
            exception.setErrMessage("L7vConfData class is null!");
            exception.setErrNo(0);
            throw exception;
        }
        saveToFile(cf);
    }

}
