package org.ultramonkey.l7.controller;

import java.io.Serializable;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.LogCategorySet;

/**
 * 
 * <p>class LogData</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * @author tanuma
 */
public class LogData extends LogSet implements Serializable{
	static final long serialVersionUID = 1;

	/**
	 * 
	 * <p>class LogCategory</p>
	 * <p>Copyright(c) NTT COMWARE 2008</p>
	 * @author tanuma
	 */
	public enum LogCategory {
		L7VSD_NETWORK,
		L7VSD_NETWORK_BANDWIDTH,
		L7VSD_NETWORK_NUM_CONNECTION,
		L7VSD_NETWORK_QOS,
		L7VSD_VIRTUAL_SERVICE,
		L7VSD_REAL_SERVER,
		L7VSD_SORRY_SERVER,
		L7VSD_REAL_SERVER_BALANCING,
		L7VSD_REPLICATION,
		L7VSD_START_STOP,
		L7VSD_SYSTEM,
		L7VSD_SYSTEM_MEMORY,
		L7VSD_SYSTEM_SOCKET,
		L7VSD_SYSTEM_SIGNAL,
		L7VSD_ENVIRONMENT,
		L7VSD_ENVIRONMENT_PARAMETER,
		L7VSD_LOGGER,
		L7VSD_PARAMETER,
		L7VSD_EVENT,
		L7VSD_SCHEDULE,
		L7VSD_PROGRAM,
		L7VSD_PROTOCOL,
		L7VSD_MODULE,
		L7VSD_ALL,
		SNMPAGENT_START_STOP,
		SNMPAGENT_MANAGER_RECEIVE,
		SNMPAGENT_MANAGER_SEND,
		SNMPAGENT_L7VSD_RECEIVE,
		SNMPAGENT_L7VSD_SEND,
		SNMPAGENT_LOGGER,
		SNMPAGENT_PARAMETER,
		SNMPAGENT_ALL,
		L7VSADM_PARSE,
		L7VSADM_OPERATE,
		L7VSADM_COMMUNICATE,
		L7VSADM_CONFIG_RESULT,
		L7VSADM_COMMON,
		L7VSADM_LOGGER,
		L7VSADM_PARAMETER,
		L7VSADM_PROTOCOL,
		L7VSADM_MODULE
	}
	
	/**
	 * 
	 * <p>class LogLevel</p>
	 * <p>Copyright(c) NTT COMWARE 2008</p>
	 * @author tanuma
	 */
	public enum LogLevel {
		NONE,
		DEBUG,
		INFO,
		WARN,
		ERROR,
		FATAL
	}
	
	/**
	 * l7vsadm logging information
	 */
	public LogSet admLog;

	/**
	 * l7directord logging information
	 */
	public LogSet directorLog;

	/**
	 * l7gui logging information
	 */
	public LogSet guiLog;

	/**
	 * cluster logging information
	 */
	public LogSet haLog;

	/**
	 * l7vsd logging information
	 */
	public LogSet lbLog;

	/**
	 * l7agent logging information
	 */
	public LogSet snmpLog;

	/**
	 * l7sync logging information
	 */
	public LogSet syncLog;

	/**
	 * 
	 * Constructor
	 *
	 */
	public LogData() {
        // --- debug log (constructor) ---
		Logger ioFileLogger = Logger.getLogger(LogCategorySet.GUI_IO_FILE);
        if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11522 class LogData created.");
        }
        // --- debug log (constructor) ---

        admLog      = new LogSet();
		directorLog = new LogSet();
		guiLog      = new LogSet();
		haLog       = new LogSet();
		lbLog       = new LogSet();
		snmpLog     = new LogSet();
		syncLog     = new LogSet();
	}
	
	/**
	 * 
	 * {@inheritDoc}
	 */
	public String toString() {
		return
			"admLog=(" + this.admLog + "), " +
			"directorLog=(" + this.directorLog + "), " +
			"guiLog=(" + this.guiLog + "), " +
			"haLog=(" + this.haLog + "), " +
			"lbLog=(" + this.lbLog + "), " +
			"snmpLog=(" + this.snmpLog + "), " +
			"syncLog=(" + this.syncLog + ")";
	}
}
