package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.*;
import org.ultramonkey.l7.model.*;


/**
 * <p>class LogLevelServlet</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * @author tsubone
 */
public class LogLevelServlet extends L7guiServletBase {
    static final long serialVersionUID = 1L;

	private Logger logger = Logger.getLogger(LogCategorySet.GUI_IO);

	/* (non-Java-doc)
     * @see javax.servlet.http.HttpServlet#HttpServlet()
     */
    public LogLevelServlet() {
        super();
        // --- debug log (constructor) ---
        if (logger.isDebugEnabled()) {
            logger.debug("11467 class LogLevelServlet created.");
        }
        // --- debug log (constructor) ---
    }

    /* (non-Java-doc)
     * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
                    throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("LogLevelServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
			buf.append("request=(" + request + "), ");
			buf.append("response=(" + response + ")");
			logger.debug("11468 " + buf.toString());
			request.setCharacterEncoding("UTF-8");
			logger.debug("11469 QueryString=\"" + request.getQueryString() + "\"");
		}
		// --- debug log (in method) ---

        response.sendRedirect(RedirectPages.LOGIN);

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11470 LogLevelServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
        return;
    }

    /* (non-Java-doc)
     * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
                    throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("LogLevelServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
			buf.append("request=(" + request + "), ");
			buf.append("response=(" + response + ")");
			logger.debug("11471 " + buf.toString());
			request.setCharacterEncoding("UTF-8");
			Enumeration keys = request.getParameterNames();
			String post = "";
			while (keys.hasMoreElements()) {
				if (post.length() != 0)
					post += "&";
				String key = (String) keys.nextElement();
				post += key + "=" + request.getParameter(key);
			}
			logger.debug("11472 PostData=\"" + post + "\"");
		}
		// --- debug log (in method) ---

        /*
         * check login session
         */
        super.doPost(request, response);

        HttpSession session = request.getSession(false);
        if (login == false || session == null) {
            if (session != null) {
                MessageView error = new MessageView(41203, LogCategorySet.GUI_USER_AUTHENTICATION, Message.INVALID_SESSSION);
                session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
            }
            response.sendRedirect(RedirectPages.LOGIN);

            // --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11473 LogLevelServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
            return;
        }

        /*
         * get logSetInfo
         */
        request.setCharacterEncoding("UTF-8");
        HashMap<String, String[]> tmpMap = (HashMap<String, String[]>) request
                        .getParameterMap();
            if (tmpMap == null) {
                MessageView error = new MessageView(41204, LogCategorySet.GUI_LOG, Message.UNEXPECTED_ERROR);
                session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
                response.sendRedirect(RedirectPages.LOGIN);
                // --- debug log (out method) ---
    			if (logger.isDebugEnabled()) {
    	            logger.debug("11474 LogLevelServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
    			}
    			// --- debug log (out method) ---
                return;
            }
        
        HashMap<String, String> inputLogLevelMap = new HashMap<String, String>();
        Iterator i = tmpMap.keySet().iterator();
        while (i.hasNext()) {
            String key = (String) i.next();
            inputLogLevelMap.put(key, tmpMap.get(key)[0]);
        }

        String logType = (String) inputLogLevelMap.get("type");
            if (logType == null) {
                MessageView error = new MessageView(41205, LogCategorySet.GUI_LOG, Message.UNEXPECTED_ERROR);
                session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
                response.sendRedirect(RedirectPages.LOGIN);
                // --- debug log (out method) ---
    			if (logger.isDebugEnabled()) {
    	            logger.debug("11475 LogLevelServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
    			}
    			// --- debug log (out method) ---
                return;
            }

        HashMap<LogData.LogCategory, LogData.LogLevel> logLevelList = null;

        L7guiFramework frame = new L7guiFramework();
        LogData logInfo = frame.getLogData();
            if (logInfo == null) {
                MessageView error = new MessageView(41206, LogCategorySet.GUI_LOG, Message.UNEXPECTED_ERROR);
                session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
                response.sendRedirect(RedirectPages.LOGIN);
                // --- debug log (out method) ---
    			if (logger.isDebugEnabled()) {
    	            logger.debug("11476 LogLevelServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
    			}
    			// --- debug log (out method) ---
                return;
            }

        SessionTransData pagetrans = new SessionTransData();
        String level = null;
        LogData.LogLevel logLevel = null;
        boolean levelCheckFlag = true;

        try {
            if (logType.equals(LogCategorySet.L7VSD)) {
                logLevelList = logInfo.lbLog.logLevel;
                pagetrans.sourceURI = RedirectPages.LOG_L7VSD;
                pagetrans.destURI = RedirectPages.LOG_L7VSD;
                pagetrans.errorURI = RedirectPages.LOG_L7VSD;
                session.setAttribute(SessionKeys.PAGE_TRANSDATA, pagetrans);

                level = inputLogLevelMap.get("L7VSD_NETWORK");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_NETWORK, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_NETWORK_BANDWIDTH");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_NETWORK_BANDWIDTH,
                                    logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_NETWORK_NUM_CONNECTION");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_NETWORK_NUM_CONNECTION,
                                    logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_NETWORK_QOS");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_NETWORK_QOS, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_VIRTUAL_SERVICE");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_VIRTUAL_SERVICE, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_REAL_SERVER");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_REAL_SERVER, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_SORRY_SERVER");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_SORRY_SERVER, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_REAL_SERVER_BALANCING");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_REAL_SERVER_BALANCING,
                                    logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_REPLICATION");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_REPLICATION, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_START_STOP");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_START_STOP, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_SYSTEM");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_SYSTEM, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_SYSTEM_MEMORY");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_SYSTEM_MEMORY, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_SYSTEM_SOCKET");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_SYSTEM_SOCKET, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_SYSTEM_SIGNAL");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_SYSTEM_SIGNAL, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_ENVIRONMENT");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_ENVIRONMENT, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_ENVIRONMENT_PARAMETER");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_ENVIRONMENT_PARAMETER,
                                    logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_LOGGER");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_LOGGER, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_PARAMETER");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_PARAMETER, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_EVENT");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_EVENT, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_SCHEDULE");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_SCHEDULE, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_PROGRAM");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_PROGRAM, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_PROTOCOL");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_PROTOCOL, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSD_MODULE");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSD_MODULE, logLevel);
                } else {
                    levelCheckFlag = false;
                }   
            } else if (logType.equals(LogCategorySet.L7VSADM)) {
                logLevelList = logInfo.admLog.logLevel;
                pagetrans.sourceURI = RedirectPages.LOG_L7VSADM;
                pagetrans.destURI = RedirectPages.LOG_L7VSADM;
                pagetrans.errorURI = RedirectPages.LOG_L7VSADM;
                session.setAttribute(SessionKeys.PAGE_TRANSDATA, pagetrans);
                
                level = inputLogLevelMap.get("L7VSADM_PARSE");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSADM_PARSE, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSADM_OPERATE");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSADM_OPERATE, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSADM_COMMUNICATE");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSADM_COMMUNICATE, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSADM_CONFIG_RESULT");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSADM_CONFIG_RESULT, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSADM_COMMON");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSADM_COMMON, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSADM_LOGGER");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSADM_LOGGER, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSADM_PARAMETER");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSADM_PARAMETER, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSADM_PROTOCOL");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSADM_PROTOCOL, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("L7VSADM_MODULE");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.L7VSADM_MODULE, logLevel);
                } else {
                    levelCheckFlag = false;
                }
            } else if (logType.equals(LogCategorySet.SNMPAGENT)) {
                logLevelList = logInfo.snmpLog.logLevel;
                pagetrans.sourceURI = RedirectPages.LOG_SNMPAGENT;
                pagetrans.destURI = RedirectPages.LOG_SNMPAGENT;
                pagetrans.errorURI = RedirectPages.LOG_SNMPAGENT;
                session.setAttribute(SessionKeys.PAGE_TRANSDATA, pagetrans);
                
                level = inputLogLevelMap.get("SNMPAGENT_START_STOP");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.SNMPAGENT_START_STOP, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("SNMPAGENT_MANAGER_RECEIVE");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.SNMPAGENT_MANAGER_RECEIVE,
                                    logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("SNMPAGENT_MANAGER_SEND");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.SNMPAGENT_MANAGER_SEND,
                                                    logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("SNMPAGENT_L7VSD_RECEIVE");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.SNMPAGENT_L7VSD_RECEIVE,
                                    logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("SNMPAGENT_L7VSD_SEND");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.SNMPAGENT_L7VSD_SEND, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("SNMPAGENT_LOGGER");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.SNMPAGENT_LOGGER, logLevel);
                } else {
                    levelCheckFlag = false;
                }
                level = inputLogLevelMap.get("SNMPAGENT_PARAMETER");
                logLevel = levelCheck(level);
                if (logLevel != null) {
                    logLevelList.put(LogData.LogCategory.SNMPAGENT_PARAMETER, logLevel);
                } else {
                    levelCheckFlag = false;
                }
            } else if (logType.equals(LogCategorySet.L7GUI)) {
                logLevelList = logInfo.guiLog.logLevel;
                pagetrans.sourceURI = RedirectPages.LOG_L7GUI;
                pagetrans.destURI = RedirectPages.LOG_L7GUI;
                pagetrans.errorURI = RedirectPages.LOG_L7GUI;
                session.setAttribute(SessionKeys.PAGE_TRANSDATA, pagetrans);
            } else if (logType.equals(LogCategorySet.GUI_SYNC)) {
                logLevelList = logInfo.syncLog.logLevel;
                pagetrans.sourceURI = RedirectPages.LOG_SYNC;
                pagetrans.destURI = RedirectPages.LOG_SYNC;
                pagetrans.errorURI = RedirectPages.LOG_SYNC;
                session.setAttribute(SessionKeys.PAGE_TRANSDATA, pagetrans);
            } else {
                MessageView error = new MessageView(41207, LogCategorySet.GUI_LOG, Message.UNEXPECTED_ERROR);
                session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
                response.sendRedirect(RedirectPages.LOGIN);
    			// --- debug log (out method) ---
    			if (logger.isDebugEnabled()) {
    	            logger.debug("11477 LogLevelServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
    			}
    			// --- debug log (out method) ---
                return;
            }
        } catch (NullPointerException e) {
            MessageView error = new MessageView(41208, LogCategorySet.GUI_LOG, Message.UNEXPECTED_ERROR);
            session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
            response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11478 LogLevelServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
            return;
        }

        if (levelCheckFlag == false) {
            MessageView error = new MessageView(21090, LogCategorySet.GUI_LOG, Message.VALIDATION_ERROR);
            session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
            session.setAttribute(SessionKeys.INPUT_LOGLEVEL, logInfo);
            response.sendRedirect(pagetrans.sourceURI);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11479 LogLevelServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
            return;
        }

        /*
         * choice button mode, commandExecute mode
         */
        CommandExecuter thread = new CommandExecuter(session);

        String redirectPage;
        ExecuteMode mode;
        String button_mode = inputLogLevelMap.get("button");

        // button mode : apply
        if (button_mode != null && button_mode.equals(ButtonMode.APPLY)) {
            mode = ExecuteMode.LOGLEVEL_CHANGE_APPLY;
            redirectPage = RedirectPages.LOG_LEVEL_EXECUTIVE;
        }

        // button mode : save
        else if (button_mode != null && button_mode.equals(ButtonMode.SAVE)) {
            mode = ExecuteMode.LOGLEVEL_CHANGE_SAVE;
            redirectPage = RedirectPages.LOG_LEVEL_EXECUTIVE;
        }

        // button mode : save and sync
        else if (button_mode != null && button_mode.equals(ButtonMode.SAVESYNC)) {
            mode = ExecuteMode.LOGLEVEL_CHANGE_SAVESYNC;
            redirectPage = RedirectPages.SAVE_SYNC_EXECUTIVE;
        } else {
            MessageView error = new MessageView(41209, LogCategorySet.GUI_LOG, Message.UNEXPECTED_ERROR);
            session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
            response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11480 LogLevelServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
            return;
        }
        try {
            thread.setExecute(mode, logInfo);
            thread.start();
        } catch (Exception e) {
            MessageView error = new MessageView(41210, LogCategorySet.GUI_LOG, Message.UNEXPECTED_ERROR);
            session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
            response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11481 LogLevelServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
            return;
        }
        response.sendRedirect(redirectPage);

        // --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11482 LogLevelServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
        return;

    }

    /**
     * 
     * <p> levelCheck method</p>
     *
     * @param level
     * @return
     */
    private LogData.LogLevel levelCheck(String level) {
        // --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11483 LogLevelServlet::levelCheck(String level) in level=\"" + level + "\"");
		}
		// --- debug log (in method) ---

		LogData.LogLevel ret = null;
		if (level == null) {
            ret = null;
        } else if (level.equals("NONE")) {
            ret = LogData.LogLevel.NONE;
        } else if (level.equals("DEBUG")) {
            ret = LogData.LogLevel.DEBUG;
        } else if (level.equals("ERROR")) {
            ret = LogData.LogLevel.ERROR;
        } else if (level.equals("WARN")) {
            ret = LogData.LogLevel.WARN;
        } else if (level.equals("FATAL")) {
            ret = LogData.LogLevel.FATAL;
        } else if (level.equals("INFO")) {
            ret = LogData.LogLevel.INFO;
        }
		
        // --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11484 LogLevelServlet::levelCheck(String level) out return=" + ret);
		}
		// --- debug log (out method) ---
		return ret;
    }

}
