package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.Enumeration;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.L7vsAdmData;
import org.ultramonkey.l7.controller.VirtualSetting;
import org.ultramonkey.l7.model.ExecuteMode;
import org.ultramonkey.l7.model.L7guiFramework;
import org.ultramonkey.l7.model.LogCategorySet;
import org.ultramonkey.l7.model.Message;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.SessionTransData;

/**
 * Servlet implementation class for Servlet: VSRemoveServlet
 */
 public class VSRemoveServlet extends org.ultramonkey.l7.view.L7guiServletBase{
	static final long serialVersionUID = 1L;	

	private Logger logger = Logger.getLogger(LogCategorySet.GUI_IO);

	/* (non-Java-doc)
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public VSRemoveServlet() {
		super();
        // --- debug log (constructor) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11400 class VSRemoveServlet created.");
		}
		// --- debug log (constructor) ---
	}   	

	
	/* (non-Java-doc)
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("VSRemoveServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11401 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			logger.debug("11402 QueryString=\"" + request.getQueryString() + "\"");
		}
		// --- debug log (in method) ---

		response.sendRedirect(RedirectPages.LOGIN);

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11403 VSRemoveServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
    }
	
	
	/* (non-Java-doc)
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("VSRemoveServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11404 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			Enumeration keys = request.getParameterNames();
			String post = "";
			while (keys.hasMoreElements()) {
				if (post.length() != 0)
					post += "&";
				String key = (String) keys.nextElement();
				post += key + "=" + request.getParameter(key);
			}
			logger.debug("11405 PostData=\"" + post + "\"");
		}
		// --- debug log (in method) ---

		// check login session
		super.doPost(request, response);
		
		HttpSession session = request.getSession(false);
		if (login == false || session == null) {
			if (session != null) {
				MessageView error = new MessageView(41178, LogCategorySet.GUI_USER_AUTHENTICATION,
						Message.INVALID_SESSSION);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			}
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11406 VSRemoveServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		
		/*
		 * get post data
		 */
        request.setCharacterEncoding("UTF-8");
		String post = request.getParameter("vs"); // ex. "10.10.10.10:80:cinsert:--cookie-name monkey"
		if (post == null) {
			MessageView error = new MessageView(21075, LogCategorySet.GUI_VIRTUALSERVICE,
					Message.VS_SELECT_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.STATE_INFO);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11407 VSRemoveServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		String params[] = post.split(":", 4);
		if (params == null || params.length != 4) {
			MessageView error = new MessageView(41179, LogCategorySet.GUI_VIRTUALSERVICE,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11408 VSRemoveServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		String vsName = params[0] + ":" + params[1] + " " + params[2] + " " + params[3];
		session.setAttribute(SessionKeys.VS_NAME, vsName);
				
		
		L7guiFramework framework = new L7guiFramework();
		L7vsAdmData admDataList = framework.getAdmData();
		if (admDataList == null){
			MessageView error = new MessageView(41180, LogCategorySet.GUI_VIRTUALSERVICE,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11409 VSRemoveServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		
		VirtualSetting vs = null;
		/*
		 * get l7vsadm data from L7guiFramework
		 *  & compare add l7vsadm data with post data
		 */
		for (int i = 0; i < admDataList.virtualSettings.size(); i++) {
			VirtualSetting v = (VirtualSetting) admDataList.virtualSettings.elementAt(i);
			if (v.virtual.host.equals(params[0]) && v.virtual.port.equals(params[1]) &&
					v.protomod.equals(params[2]) && v.option.equals(params[3])) {
				vs = v;
				break;
			}
		}

		/*
		 * error. no such VirtualService
		 */
		if (vs == null) {
			MessageView error = new MessageView(41181, LogCategorySet.GUI_VIRTUALSERVICE,
					Message.NO_VS);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.VS_REMOVE_NG);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11410 VSRemoveServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		
		
		CommandExecuter thread = new CommandExecuter(session);
		
		ExecuteMode mode;
		String redirectPage;

		
		String button_mode = request.getParameter("button_remove");
		
		// button mode : apply
		if (button_mode != null && button_mode.equals(ButtonMode.APPLY)) {
			mode = ExecuteMode.VS_REMOVE_APPLY;
			redirectPage = RedirectPages.VS_REMOVE_EXECUTIVE;
		}
		// button mode : save
		else if (button_mode != null && button_mode.equals(ButtonMode.SAVE)) {
			mode = ExecuteMode.VS_REMOVE_SAVE;
			redirectPage = RedirectPages.VS_REMOVE_EXECUTIVE;
		}
		// button mode : save and sync
		else if (button_mode != null && button_mode.equals(ButtonMode.SAVESYNC)) {
			mode = ExecuteMode.VS_REMOVE_SAVESYNC;
			redirectPage = RedirectPages.SAVE_SYNC_EXECUTIVE;

			SessionTransData trans = new SessionTransData();
			trans.sourceURI = RedirectPages.STATE_INFO;
			trans.destURI   = RedirectPages.VS_REMOVE_SUCCESS;
			trans.errorURI  = RedirectPages.VS_REMOVE_NG;
			session.setAttribute(SessionKeys.PAGE_TRANSDATA, trans);
		}
		else {
			MessageView error = new MessageView(41182, LogCategorySet.GUI_VIRTUALSERVICE,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11411 VSRemoveServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		
		try {
			thread.setExecute(mode,vs);
			thread.start();
		}
		catch(Exception e)
		{
			MessageView error = new MessageView(41183, LogCategorySet.GUI_VIRTUALSERVICE,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11412 VSRemoveServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		response.sendRedirect(redirectPage);
		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11413 VSRemoveServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}   	  	    
}
