/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.L7vsAdmData;
import org.ultramonkey.l7.controller.VirtualSetting;
import org.ultramonkey.l7.model.ExecuteMode;
import org.ultramonkey.l7.model.L7guiFramework;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.SessionTransData;
import org.ultramonkey.l7.view.CommandExecuter;
import org.ultramonkey.l7.view.L7guiServletBase;

public class VSRemoveServlet
extends L7guiServletBase {
    static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger((String)"l7gui_I/O");

    public VSRemoveServlet() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11400 class VSRemoveServlet created.");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("VSRemoveServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11401 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            this.logger.debug((Object)("11402 QueryString=\"" + request.getQueryString() + "\""));
        }
        response.sendRedirect("index.jsp");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11403 VSRemoveServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String redirectPage;
        ExecuteMode mode;
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("VSRemoveServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11404 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            Enumeration keys = request.getParameterNames();
            String post = "";
            while (keys.hasMoreElements()) {
                if (post.length() != 0) {
                    post = String.valueOf(post) + "&";
                }
                String key = (String)keys.nextElement();
                post = String.valueOf(post) + key + "=" + request.getParameter(key);
            }
            this.logger.debug((Object)("11405 PostData=\"" + post + "\""));
        }
        super.doPost(request, response);
        HttpSession session = request.getSession(false);
        if (!this.login || session == null) {
            if (session != null) {
                MessageView error = new MessageView(41178, "l7gui_UserAuthentication", "Invalid session.");
                session.setAttribute("resultMessage", (Object)error);
            }
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11406 VSRemoveServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        request.setCharacterEncoding("UTF-8");
        String post = request.getParameter("vs");
        if (post == null) {
            MessageView error = new MessageView(21075, "l7gui_VirtualService", "Please select one of the following VirtualServices.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("um7state_info.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11407 VSRemoveServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        String[] params = post.split(":", 4);
        if (params == null || params.length != 4) {
            MessageView error = new MessageView(41179, "l7gui_VirtualService", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11408 VSRemoveServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        String vsName = String.valueOf(params[0]) + ":" + params[1] + " " + params[2] + " " + params[3];
        session.setAttribute("vsName", (Object)vsName);
        L7guiFramework framework = new L7guiFramework();
        L7vsAdmData admDataList = framework.getAdmData();
        if (admDataList == null) {
            MessageView error = new MessageView(41180, "l7gui_VirtualService", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11409 VSRemoveServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        VirtualSetting vs = null;
        int i = 0;
        while (i < admDataList.virtualSettings.size()) {
            VirtualSetting v = admDataList.virtualSettings.elementAt(i);
            if (v.virtual.host.equals(params[0]) && v.virtual.port.equals(params[1]) && v.protomod.equals(params[2]) && v.option.equals(params[3])) {
                vs = v;
                break;
            }
            ++i;
        }
        if (vs == null) {
            MessageView error = new MessageView(41181, "l7gui_VirtualService", "Such VirtualService does not exist.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("vs_remove_fail.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11410 VSRemoveServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        CommandExecuter thread = new CommandExecuter(session);
        String button_mode = request.getParameter("button_remove");
        if (button_mode != null && button_mode.equals("Apply")) {
            mode = ExecuteMode.VS_REMOVE_APPLY;
            redirectPage = "vs_remove_executive.jsp";
        } else if (button_mode != null && button_mode.equals("Save")) {
            mode = ExecuteMode.VS_REMOVE_SAVE;
            redirectPage = "vs_remove_executive.jsp";
        } else if (button_mode != null && button_mode.equals("Save + Sync")) {
            mode = ExecuteMode.VS_REMOVE_SAVESYNC;
            redirectPage = "savesync_executive.jsp";
            SessionTransData trans = new SessionTransData();
            trans.sourceURI = "um7state_info.jsp";
            trans.destURI = "vs_remove.jsp";
            trans.errorURI = "vs_remove_fail.jsp";
            session.setAttribute("pageTrans", (Object)trans);
        } else {
            MessageView error = new MessageView(41182, "l7gui_VirtualService", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11411 VSRemoveServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        try {
            thread.setExecute(mode, vs);
            thread.start();
        }
        catch (Exception e) {
            MessageView error = new MessageView(41183, "l7gui_VirtualService", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11412 VSRemoveServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        response.sendRedirect(redirectPage);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11413 VSRemoveServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }
}

