<%@ page
	import="org.ultramonkey.l7.model.*,org.ultramonkey.l7.controller.*,org.ultramonkey.l7.view.*"
	language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>

<%
	/*
	 * check session
	 */
    L7guiServletBase base = new L7guiServletBase();
	if (session.isNew() || base.checkSession(session) == false) {
		MessageView error = new MessageView(41391,
		LogCategorySet.GUI_USER_AUTHENTICATION,
		Message.INVALID_SESSSION);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get sync info (VS IPaddress)
	 */
	L7guiFramework framework = new L7guiFramework();
	ClusterData cd = framework.getClusterData();

	String self = "";
	String other = "";

	if (cd == null) {
		MessageView error = new MessageView(41392,
		LogCategorySet.GUI_IO_COMMAND,
		Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	} else {
		self = cd.self_ip;
		other = cd.other_ip;
	}

	/*
	 * get thread status
	 */
	String threadStatus = (String) session
			.getAttribute(SessionKeys.THREAD_STATUS);
	if (threadStatus == null) {
		MessageView error = new MessageView(41393, LogCategorySet.GUI_SYNC,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	} else if (threadStatus == SessionKeys.THREAD_RUNNING) {
		// nothing to do
	} else if (threadStatus == SessionKeys.THREAD_SUCCESS) {
		response.sendRedirect(RedirectPages.SYNC);
		return;
	} else if (threadStatus == SessionKeys.THREAD_FAIL) {
		response.sendRedirect(RedirectPages.SYNC_NG);
		return;
	} else {
		MessageView error = new MessageView(41394, LogCategorySet.GUI_SYNC,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta http-equiv="Pragma" content="no-cache">
	<meta http-equiv="Cache-Control" content="no-cache">
	<meta http-equiv="Expires" content="0"> 
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<noscript>
	<meta http-equiv="refresh"
		content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>" />
	</noscript>
	<meta http-equiv="refresh" content="<%= RedirectPages.REFRESH_TIME %>" />
	
	<link rel="stylesheet" type="text/css" href="l7gui_basic_style.css" />
	<link rel="shortcut icon" href="images/favicon.ico" />
	<title>Running : Sync Resources</title>
</head>

<body>

<h1 class="title">Running : Sync Resources</h1>
<h2>Please wait.</h2>


<%
     if ((self != null) && (other != null)){
%>
		<h2><%=self %> (<%=cd.self_status %>) <img class="arrow2" src="images/arrowlogo2.gif"
		     alt="arrowlogo" /><%=other %> (<%=cd.other_status %>)</h2>

<%
     }
%>


</body>
</html>

