package org.ultramonkey.l7.model;

import java.io.*;
import java.util.*;

import org.apache.log4j.Logger;

/**
 * 
 * <p>class Parameter</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * @author tanuma
 */
public final class Parameter {
	
	private Logger ioFileLogger = Logger.getLogger(LogCategorySet.GUI_IO_FILE);
	private static Logger ioFileLogger_s = Logger.getLogger(LogCategorySet.GUI_IO_FILE);
	
	private static final String FILENAME = "/etc/l7vs/l7gui.cf";
	
	/**
	 * parameter key name of session timeout
	 */
	public static final String SESSION_TIMEOUT = "max_session_time";

	/**
	 * parameter key name of session timeout
	 */
	public static final String L7VSADM_TIMEOUT_FLAG = "l7vsadm_timeout_flag";

	/**
	 * instance of this class (singleton)
	 */
	protected static Parameter instance = null;

	/**
	 * parameter map
	 */
	protected HashMap<String, String> paramMap = null;

	/**
	 * 
	 * Constructor
	 *
	 */
	protected Parameter() {
        // --- debug log (constructor) ---
        if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11001 class Parameter created.");
        }
        // --- debug log (constructor) ---
		paramMap = new HashMap<String, String>();
		try {
			loadFromFile();
		} catch(Exception e) {
			ioFileLogger.error("41001 Cannot read l7gui.cf file.");
		}
	}

	/**
	 * 
	 * <p> getInstance method</p>
	 *
	 * @return instance of this class
	 */
	public synchronized static Parameter getInstance() {
		// --- debug log (in method) ---
		if (ioFileLogger_s.isDebugEnabled()) {
            ioFileLogger_s.debug("11002 Parameter::getInstance() in");
		}
		// --- debug log (in method) ---

		if (instance == null) {
			instance = new Parameter();
		}

		// --- debug log (out method) ---
		if (ioFileLogger_s.isDebugEnabled()) {
            ioFileLogger_s.debug("11003 Parameter::getInstance() out return=(" + instance + ")");
		}
		// --- debug log (out method) ---
		return instance;
	}

	/**
	 * 
	 * <p> loadFromFile method</p>
	 *
	 * @throws FileNotReadException
	 */
	protected void loadFromFile() throws FileNotReadException {
		// --- debug log (in method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11004 Parameter::loadFromFile() throws FileNotReadException in");
		}
		// --- debug log (in method) ---

		BufferedReader br = null;
		try {
			br = new BufferedReader(new InputStreamReader(new FileInputStream(
					FILENAME)));
			String str = br.readLine();
			while (str != null) {
				str = str.replaceAll("\\s", "");
				String[] params = str.split("=", 2);
				if (params.length == 2) {
					if (params[0].startsWith("#") == false)
						this.setValue(params[0], params[1]);
				}
				str = br.readLine();
			}
		} catch (Exception e) {
			StringBuffer buf = new StringBuffer();
			FileNotReadException ex = new FileNotReadException();
			buf.append("Cannot open file: ");
			buf.append(FILENAME);
			buf.append(" / Exception Message: ");
			buf.append(e.getMessage());
			ex.setFileName(FILENAME);
			ex.setErrMessage(buf.toString());
			// --- debug log (out method) ---
			if (ioFileLogger.isDebugEnabled()) {
	            ioFileLogger.debug("11005 Parameter::loadFromFile() throws FileNotReadException out exception=\"" + ex.toString() + "\"");
			}
			// --- debug log (out method) ---
			throw ex;
		}
		// --- debug log (out method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11006 Parameter::loadFromFile() throws FileNotReadException out");
		}
		// --- debug log (out method) ---
	}

	/**
	 * 
	 * <p> setValue method</p>
	 *
	 * @param key key with which the specified value is to be associated.
	 * @param value value to be associated with the specified key.
	 * @return previous value associated with specified key, or null if there was no mapping for key.
	 */
	public String setValue(String key, String value) {
		// --- debug log (in method) ---
		if (ioFileLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Parameter::setValue(String key, String value) in ");
            buf.append("key=\"" + key + "\", ");
            buf.append("value=\"" + value + "\"");
            ioFileLogger.debug("11007 " + buf.toString());
		}
		// --- debug log (in method) ---

		String oldValue = null;
		if (key != null)
			oldValue = paramMap.put(key, value);
		
		// --- debug log (in method) ---
		if (ioFileLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Parameter::setValue(String key, String value) out ");
            buf.append("return=\"" + oldValue + "\"");
            ioFileLogger.debug("11008 " + buf.toString());
		}
		// --- debug log (in method) ---
		return oldValue;
	}

	/**
	 * 
	 * <p> getValue method</p>
	 *
	 * @param key the key whose associated value is to be returned.
	 * @return the value to which this map maps the specified key, or null if the map contains no mapping for this key.
	 */
	public String getValue(String key) {
		// --- debug log (in method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11009 Parameter::getValue(String key) in key=\"" + key + "\"");
		}
		// --- debug log (in method) ---

		String value = paramMap.get(key);
		
		// --- debug log (out method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11010 Parameter::getValue(String key) out return=\"" + value + "\"");
		}
		// --- debug log (out method) ---
		return value;
	}
	
	/**
	 * 
	 * {@inheritDoc}
	 */
	public String toString() {
		return "paramMap=(" + paramMap + ")";
	}
}
