package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.Enumeration;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.ExecuteMode;
import org.ultramonkey.l7.model.L7guiFramework;
import org.ultramonkey.l7.model.LogCategorySet;
import org.ultramonkey.l7.model.Message;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.SessionTransData;
import org.ultramonkey.l7.controller.*;


/**
 * 
 * <p>class ReplicationInfoChangeServlet</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * @author kubota
 */

public class ReplicationInfoChangeServlet extends org.ultramonkey.l7.view.L7guiServletBase{
	static final long serialVersionUID = 1L;	

	private Logger logger = Logger.getLogger(LogCategorySet.GUI_IO);

	/* (non-Java-doc)
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public ReplicationInfoChangeServlet() {
		super();
        // --- debug log (constructor) ---
        if (logger.isDebugEnabled()) {
            logger.debug("11297 class ReplicationInfoChangeServlet created.");
        }
        // --- debug log (constructor) ---
	}   	
	
	/* (non-Java-doc)
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("ReplicationInfoChangeServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11298 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			logger.debug("11299 QueryString=\"" + request.getQueryString() + "\"");
		}
		// --- debug log (in method) ---

		response.sendRedirect(RedirectPages.LOGIN);

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11300 ReplicationInfoChangeServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}

	
	/* (non-Java-doc)
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("ReplicationInfoChangeServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11301 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			Enumeration keys = request.getParameterNames();
			String post = "";
			while (keys.hasMoreElements()) {
				if (post.length() != 0)
					post += "&";
				String key = (String) keys.nextElement();
				post += key + "=" + request.getParameter(key);
			}
			logger.debug("11302 PostData=\"" + post + "\"");
		}
		// --- debug log (in method) ---

		// check login session
		super.doPost(request, response);
		
		HttpSession session = request.getSession(false);
		if (login == false || session == null) {
			if (session != null) {
				MessageView error = new MessageView(41073, LogCategorySet.GUI_USER_AUTHENTICATION,
						Message.INVALID_SESSSION);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			}
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger.debug("11303 ReplicationInfoChangeServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
				
		L7guiFramework framework = new L7guiFramework();
		ReplicationData rep = framework.getReplicationData();
		if ( rep == null ){
			MessageView error = new MessageView(41074, LogCategorySet.GUI_IO_FILE, 
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger.debug("11304 ReplicationInfoChangeServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

        request.setCharacterEncoding("UTF-8");
		String str_repInterval = request.getParameter("rep_interval");
		String str_beforeRepData = Integer.toString(rep.interval);

		boolean validationFrag = validationCheck(session, str_repInterval, rep);
		if (validationFrag == false ){
			session.setAttribute(SessionKeys.INPUT_REP, rep);
			MessageView error = new MessageView(21040, LogCategorySet.GUI_REPLICATION,
					Message.INVALID_VALUE);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.REPLICATION_MODIFY);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger.debug("11305 ReplicationInfoChangeServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		
		CommandExecuter thread = new CommandExecuter(session);
		
		ExecuteMode mode;
		String redirectPage;
		
		String button_mode = request.getParameter("button");

		// button mode : save
		if (button_mode != null && button_mode.equals(ButtonMode.SAVE)) {
			mode = ExecuteMode.REP_INFO_SAVE;
			redirectPage = RedirectPages.REPLICATION_INFO_EXECUTIVE;
		}
		// button mode : save and sync
		else if (button_mode != null && button_mode.equals(ButtonMode.SAVESYNC)) {
			mode = ExecuteMode.REP_INFO_SAVESYNC;
			redirectPage = RedirectPages.SAVE_SYNC_EXECUTIVE;

			SessionTransData trans = new SessionTransData();
			trans.sourceURI = RedirectPages.REPLICATION_MODIFY;
			trans.destURI   = RedirectPages.REPLICATION_INFO;
			trans.errorURI  = RedirectPages.REPLICATION_MODIFY_NG;
			session.setAttribute(SessionKeys.PAGE_TRANSDATA, trans);
		}
		else {
			MessageView error = new MessageView(41075, LogCategorySet.GUI_REPLICATION,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger.debug("11306 ReplicationInfoChangeServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		
		try {
			thread.setExecute(mode, rep);
			thread.start();
		}
		catch(Exception e)
		{
			MessageView error = new MessageView(41076, LogCategorySet.GUI_REPLICATION, 
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger.debug("11307 ReplicationInfoChangeServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		session.setAttribute(SessionKeys.BEFORE_REP_TIME, str_beforeRepData);
		String str_afterRepData = Integer.toString(rep.interval);		
		session.setAttribute(SessionKeys.AFTER_REP_TIME, str_afterRepData);
		response.sendRedirect(redirectPage);
		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11308 ReplicationInfoChangeServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	} 
	
	/**
	 * 
	 * <p> validationCheck method</p>
	 *
	 * @param session
	 * @param str_repInterval
	 * @param rep
	 * @return
	 */
	protected boolean validationCheck(HttpSession session, String str_repInterval, ReplicationData rep ){
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("ReplicationInfoChangeServlet::validationCheck(HttpSession session, String str_repInterval, ReplicationData rep) in ");
			buf.append("session=(" + session + "), ");
			buf.append("str_repInterval=(" + str_repInterval + "), ");
			buf.append("rep=(" + rep + ")");
			logger.debug("11309 " + buf.toString());
		}
		// --- debug log (in method) ---

		boolean  validationFlag = true;
		
		final int MIN_REP_INTERVAL = 10;
		final int MAX_REP_INTERVAL = 10000;
		int repInterval = 0;
		
		if (session == null || rep == null) {
			validationFlag = false;
		} else if ( (str_repInterval == null) || str_repInterval.length() == 0){
			session.setAttribute(SessionKeys.INVALID_MESSAGE, Message.REQUIED_ITEM);
			 validationFlag = false;
		}
		else {
			try {
				repInterval = Integer.parseInt(str_repInterval); 
				if ( (repInterval < MIN_REP_INTERVAL) || (repInterval > MAX_REP_INTERVAL) )	{
					session.setAttribute(SessionKeys.INVALID_MESSAGE, Message.VALIDATION_ERROR);
					 validationFlag = false;	
				} else {
					rep.interval = repInterval;
				}
			}
			catch (NumberFormatException e) {
				session.setAttribute(SessionKeys.INVALID_MESSAGE, Message.VALIDATION_ERROR);
				 validationFlag = false;	
			}
		}
		
		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11310 ReplicationInfoChangeServlet::validationCheck(HttpSession session, String str_repInterval, ReplicationData rep) out return=" + validationFlag);
		}
		// --- debug log (out method) ---
		return  validationFlag; 
	}
}