package org.ultramonkey.l7.controller;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.LogCategorySet;

public class LogSet extends LogFileData implements Serializable {
    static final long serialVersionUID = 1;

	/**
     * log file name
     */
    public String fileName = "";

    /**
     * rotate setting
     */
    public String rotation = "";

    /**
     * backup file number
     */
    public int maxBackupIndex = 0;

    /**
     * rotate size
     */
    public String maxFileSize = "";

    /**
     * rotation timing pattern
     */
    public String rotationTiming = "";

    /**
     * rotation timing value
     */
    public String rotationTimingValue = "";

    /**
     * log files data
     */
    public Vector<LogFileData> logFiles;

    /**
     * log level data
     */
    public HashMap<LogData.LogCategory, LogData.LogLevel> logLevel;

    /**
     * 
     * Constructor
     *
     */
    public LogSet() {
        // --- debug log (constructor) ---
    	Logger ioFileLogger = Logger.getLogger(LogCategorySet.GUI_IO_FILE);
        if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11523 class LogSet created.");
        }
        // --- debug log (constructor) ---

        this.logFiles = new Vector<LogFileData>();
        this.logLevel = new HashMap<LogData.LogCategory, LogData.LogLevel>();
    }
    
    /**
     * 
     * {@inheritDoc}
     */
    public String toString() {
    	return
    		"fileName=\"" + this.fileName + "\", " +
    		"maxBackupIndex=" + this.maxBackupIndex + ", " +
    		"maxFileSize=\"" + this.maxFileSize + "\", " +
    		"rotation=\"" + this.rotation + "\", " +
    		"rotationTiming=\"" + this.rotationTiming + "\", " +
    		"rotationTimingValue=\"" + this.rotationTimingValue + "\", " +
    		"logFiles=(" + this.logFiles + "), " +
    		"logLevel=(" + this.logLevel + ")";
    }
}
