package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.*;
import org.ultramonkey.l7.controller.*;

/**
 * Servlet implementation class for Servlet: Login
 * 
 */
public final class LoginServlet extends L7guiServletBase implements Servlet {
	static final long serialVersionUID = 1L;

	private Logger logger = Logger.getLogger(LogCategorySet.GUI_IO);

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public LoginServlet() {
		super();
        // --- debug log (constructor) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11279 class LoginServlet created.");
		}
		// --- debug log (constructor) ---
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("LoginServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
			buf.append("request=(" + request + "), ");
			buf.append("response=(" + response + ")");
			logger.debug("11280 " + buf.toString());
			request.setCharacterEncoding("UTF-8");
			logger.debug("11281 QueryString=\"" + request.getQueryString() + "\"");
		}
		// --- debug log (in method) ---

		response.sendRedirect(RedirectPages.LOGIN);

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11282 LoginServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
			buf.append("request=(" + request + "), ");
			buf.append("response=(" + response + ")");
			logger.debug("11283 " + buf.toString());
			request.setCharacterEncoding("UTF-8");
			Enumeration keys = request.getParameterNames();
			String post = "";
			while (keys.hasMoreElements()) {
				if (post.length() != 0)
					post += "&";
				String key = (String) keys.nextElement();
				post += key + "=" + request.getParameter(key);
			}
			logger.debug("11284 PostData=\"" + post + "\"");
		}
		// --- debug log (in method) ---

		boolean validationFlag = true;
		HttpSession session = request.getSession(true);
		if (session == null) {
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11285 LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		request.setCharacterEncoding("UTF-8");
		String userName = request.getParameter("uid");
		String userPass = request.getParameter("passwd");

		if ( (userName == null) || (userPass == null) ){
				MessageView error = new MessageView(41066, LogCategorySet.GUI_USER_MANAGE,
						Message.UNEXPECTED_ERROR);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
				response.sendRedirect(RedirectPages.LOGIN);
				// --- debug log (out method) ---
				if (logger.isDebugEnabled()) {
		            logger.debug("11286 LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
				}
				// --- debug log (out method) ---
				return;	
		}
		
		
		// UserID,Password validationCheck
		validationFlag = validationCheck(userName, userPass);
		if (false == validationFlag) {
			MessageView error = new MessageView(21039, LogCategorySet.GUI_USER_AUTHENTICATION,
					Message.USERID_PASSWORD_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11287 LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		UserManager manager = UserManager.getInstance();
		if (manager == null) {
			MessageView error = new MessageView(41067, LogCategorySet.GUI_START_STOP, Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11288 LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		UserData user = manager.authUser(userName, userPass);
		if (user != null) {
			Parameter param = Parameter.getInstance();
			if (param == null) {
				MessageView error = new MessageView(41068, LogCategorySet.GUI_START_STOP,
						Message.UNEXPECTED_ERROR);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
				response.sendRedirect(RedirectPages.LOGIN);
				// --- debug log (out method) ---
				if (logger.isDebugEnabled()) {
		            logger.debug("11289 LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
				}
				// --- debug log (out method) ---
				return;
			}
			String sessionTimeout = param.getValue(Parameter.SESSION_TIMEOUT);
			if (sessionTimeout != null) {
				try{
				session.setMaxInactiveInterval(Integer
						.parseInt(sessionTimeout));
				}catch(Exception e){
					MessageView error = new MessageView(41069, LogCategorySet.GUI_START_STOP,
							Message.UNEXPECTED_ERROR);
					session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
					response.sendRedirect(RedirectPages.LOGIN);
					// --- debug log (out method) ---
					if (logger.isDebugEnabled()) {
			            logger.debug("11290 LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
					}
					// --- debug log (out method) ---
					return;
				}
			}

			session.setAttribute(SessionKeys.LOGIN_SESSION, user);
		} else {
			MessageView error = new MessageView(41070, LogCategorySet.GUI_USER_AUTHENTICATION,
						Message.USER_AUTH_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11291 LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		// Session Key Initialize
		session.setAttribute(SessionKeys.LOG_SYNC_STATE, SessionKeys.SYNC);
		session.setAttribute(SessionKeys.VS_SYNC_STATE, SessionKeys.SYNC);
		session.setAttribute(SessionKeys.MONITOR_SYNC_STATE, SessionKeys.SYNC);
		session.setAttribute(SessionKeys.REP_SYNC_STATE, SessionKeys.SYNC);
		session.setAttribute(SessionKeys.SNMP_SYNC_STATE, SessionKeys.SYNC);
		session.setAttribute(SessionKeys.GUI_SYNC_STATE, SessionKeys.SYNC);

		// Get Data
		L7guiFramework framework = new L7guiFramework();
		L7vsAdmData admDataList = framework.getAdmData();
		DirectorData directorData = framework.getDirectorData();
		L7vsConfData confData = framework.getL7vsConfData();
		

		if (admDataList == null || directorData == null || confData == null) {
			MessageView error = new MessageView(41071, LogCategorySet.GUI_IO, Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11292 LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		boolean vsSave = false;
		if (admDataList.virtualSettings.size() == directorData.virtualSettings.size()) {
			for (int i = 0; i < admDataList.virtualSettings.size(); i++) {
				VirtualSetting admVs = admDataList.virtualSettings.elementAt(i);
				for (int j = 0; j < directorData.virtualSettings.size(); j++) {
					VirtualSetting directorVs = directorData.virtualSettings.elementAt(j);
					if (vsSave = directorVs.equalsAdm(admVs))
						break;
				}
				if (vsSave == false)
					break;
			}
			if (admDataList.virtualSettings.size() == 0)
				vsSave = true;
		}
		if (vsSave == true) {
			session.setAttribute(SessionKeys.VS_SAVE_STATE, SessionKeys.SAVE);
		} else {
			session.setAttribute(SessionKeys.VS_SAVE_STATE, SessionKeys.NO_SAVE);
		}

		try{
			boolean logL7vsdSave = true;
			boolean logSnmpSave = true;
	
			// l7vsdLog compare
			HashMap<LogData.LogCategory, LogData.LogLevel> admL7vsdLogLevel =  admDataList.l7vsdLogLevel;
			HashMap<LogData.LogCategory, LogData.LogLevel> confL7vsdLogLevel = confData.logger.lbLog.logLevel;
			logL7vsdSave = admL7vsdLogLevel.equals(confL7vsdLogLevel);
	
			// SNMPLog compare
			HashMap<LogData.LogCategory, LogData.LogLevel> admSnmpLogLevel = admDataList.snmpLogLevel;
			HashMap<LogData.LogCategory, LogData.LogLevel> confSnmpLogLevel = confData.logger.snmpLog.logLevel;
			logSnmpSave = admSnmpLogLevel.equals(confSnmpLogLevel);
	
			// compare logData
			if ((logL7vsdSave == true) && (logSnmpSave == true)) {
				session.setAttribute(SessionKeys.LOG_SAVE_STATE, SessionKeys.SAVE);
			} else {
				session.setAttribute(SessionKeys.LOG_SAVE_STATE,
						SessionKeys.NO_SAVE);
			}
		}catch(NullPointerException e){
			MessageView error = new MessageView(41072, LogCategorySet.GUI_USER_MANAGE, Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11293 LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
			
		response.sendRedirect(RedirectPages.TOPMENU);
		
		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11294 LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}

	/**
	 * 
	 * <p>
	 * validationCheck method
	 * </p>
	 * 
	 * @param userName
	 * @param userPass
	 * @return validationFlag : true/false
	 */
	private boolean validationCheck(String userName, String userPass) {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("LoginServlet::validationCheck(String userName, String userPass) in ");
			buf.append("userName=\"" + userName + "\", ");
			buf.append("userPass=\"" + userPass + "\"");
			logger.debug("11295 " + buf.toString());
		}
		// --- debug log (in method) ---

		boolean validationFlag = true;
		final int MIN_LENGTH = 1;
		final int MAX_LENGTH = 16;
		final int MIN_PASS_LENGTH = 6;

		if ((userName.length() < MIN_LENGTH)
				|| (userName.length() > MAX_LENGTH)) {
			validationFlag = false;
		} else if ((userPass.length() < MIN_PASS_LENGTH)
				|| (userPass.length() > MAX_LENGTH)) {
			validationFlag = false;
		}

		else {
			Pattern pattern = Pattern.compile("([^\\x20-\\x7e])");
			Matcher userNameMatcher = pattern.matcher(userName);
			Matcher userPassMatcher = pattern.matcher(userPass);

			if (userNameMatcher.find() || userPassMatcher.find()) {
				validationFlag = false;
			}
		}

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11296 LoginServlet::validationCheck(String userName, String userPass) out return=" + validationFlag);
		}
		// --- debug log (in method) ---
		return validationFlag;
	}

}
