/*
 * @file  http_request.h
 * @brief HTTP Request Message Header
 *
 * Copyright (C) 2009  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/

#ifndef __HTTP_REQUEST_H__
#define __HTTP_REQUEST_H__

#include <boost/multi_index_container.hpp>
#include <boost/multi_index/member.hpp>
#include <boost/multi_index/hashed_index.hpp>
#include <boost/multi_index/sequenced_index.hpp>
#include <string>
#include "http_message.h"
#include "http_request_enum.h"
#include "logger_wrapper.h"

//! HTTP Request Class (RFC2616)
class http_request : public http_message
{
private:
    std::string         _method;
    std::string         _request_uri;
    std::string         _http_version;

public:
    http_request();
    http_request( std::string );
    ~http_request();

    std::string method() const;
    std::string method( std::string );
    std::string request_uri() const;
    std::string request_uri( std::string );
    std::string http_version() const;
    std::string http_version( std::string );
    std::string request_line() const;
    std::string as_string();
    void parse( std::string );
    void rebuild();
};

#endif //__HTTP_REQUEST_H__
