/*
 * @file  parameter.h
 * @brief parameter module creation class.
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2008  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *      
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/

#ifndef __PARAMETER_H__
#define __PARAMETER_H__

#include <iostream>
#include <map>
#include "parameter_enum.h"

namespace l7vs
{
	class ParameterImpl;
	class Parameter
	{
	private:
		static Parameter instance;
		
	protected:
		Parameter();
		Parameter( const Parameter& );
		Parameter&	operator=( const Parameter& );
		~Parameter();
		
	public:
		bool	rereadFile(const PARAMETER_COMPONENT_TAG, const std::string&);
	
		static	Parameter& getInstance(){
			return	instance;
		}
		bool	isIntExist(const PARAMETER_COMPONENT_TAG, const std::string&);
		bool	isStringExist(const PARAMETER_COMPONENT_TAG, const std::string&);
		int	getIntValue(const PARAMETER_COMPONENT_TAG, const std::string&);
		std::string	getStringValue(const PARAMETER_COMPONENT_TAG, const std::string&);
		void	getStringMapValue( const PARAMETER_COMPONENT_TAG, const std::string&, std::multimap<std::string, std::string>&);
		void	registerFunctionPointer(const PARAMETER_COMPONENT_TAG, void(*)());
	};
}
	
#endif	//__PARAMETER_H__
