#ifndef __L7VS_SNMPBRIDGE_H__
#define __L7VS_SNMPBRIDGE_H__

#include <stdint.h>
#include "l7vs.h"
#include "l7vs_iom.h"
#include "tag_trapid.h"
#include "logger_wrapper.h"


struct	bridge_mibdata{

};

//初期化処理
extern	int	l7vs_snmpbridge_initialize();
//終了処理
extern	void	l7vs_snmpbridge_finalize();
//TRAP送信要求
extern	int	l7vs_snmpbridge_send_trap( TRAPID_TAG trapid, char* message );
//パラメータファイル再読込み指示
extern	void	l7vs_snmpbridge_reload_config();
//ログレベル設定指示
extern	int	l7vs_snmpbridge_change_loglevel( LOG_CATEGORY_TAG snmp_log_category, LOG_LEVEL_TAG loglevel );
//ログレベル設定指示(カテゴリ全指定)
extern	int	l7vs_snmpbridge_change_loglevel_allcategory( LOG_LEVEL_TAG loglevel );
//接続状態取得
extern	int	l7vs_snmpbridge_get_connectionstate();
//ログレベル取得
extern	LOG_LEVEL_TAG	l7vs_snmpbridge_get_loglevel( LOG_CATEGORY_TAG snmp_log_category );
//コールバック
extern	int	l7vs_snmpbridge_callback( l7vs_iomux* iom );

#endif //__L7VS_SNMPBRIDGE_H__
