﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;

namespace URI_DB
{
    static class Program
    {
        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);

            // ThreadExceptionイベントハンドラを追加
            Application.ThreadException +=
                new System.Threading.ThreadExceptionEventHandler(
                    Application_ThreadException);

            Application.Run(new MainForm());
        }

        /// <summary>
        /// ThreadExceptionイベントハンドラ
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        static void Application_ThreadException(object sender,
            System.Threading.ThreadExceptionEventArgs e)
        {
            try
            {
                // エラーメッセージを表示する
                using (NotifyForm errDialog = new NotifyForm())
                {
                    errDialog.setMessage(e.Exception.ToString());
                    errDialog.ShowDialog();
                }
            }
            finally
            {
                // アプリケーションを終了する
                Application.Exit();
            }
        }

    }
}
