package jp.sourceforge.masasa.xlsXmlTemplate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import jp.sourceforge.masasa.xlsXmlTemplate.ExcelXMLConstants.Dom;
import jp.sourceforge.masasa.xlsXmlTemplate.ExcelXMLConstants.SpreadSheet;
import jp.sourceforge.masasa.xlsXmlTemplate.ExcelXMLConstants.Template;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/**
 * スプレッド形式の {@code XML} に対してテンプレート処理を行います.</br>
 *
 * @author masasa
 */
public class ExcelXMLTemplate {

    /** 入力テンプレートファイル. */
    private InputStream in;
    /** 出力ファイル. */
    private OutputStream out;
    /**
     * テンプレートするマッピングファイル.
     * <ul>
     * <li><code>key</code> : シート名.</li>
     * <li><code>value</code> : シートに対応するデータ.</li>
     * </ul>
     */
    private Map<String, Object> data;
    /** 入力ファイルの解析情報. */
    private Document doc;

    /**
     * テーブルデータ.
     *
     * @author masasa
     */
    protected static class LoopInfo {
        /** テーブルデータ. */
        @SuppressWarnings("rawtypes")
        protected List tableData;
        /** 行数. */
        protected int verticalCount;
        /** #VLoopインデックス. */
        protected int vloopIndex;
        /** #VLoopプロパティ. */
        protected String vloopProperty;

        /**
         * コンストラクタ.
         */
        @SuppressWarnings("unqualified-field-access")
        protected LoopInfo() {
            verticalCount = -1;
            vloopIndex = -1;
            vloopProperty = null;
        }
    }

    /**
     * 本インスタンスを初期化します.
     *
     * @param inFile
     *            入力テンプレートファイル.
     * @param outFile
     *            出力ファイル.
     * @param mapData
     *            テンプレートするマッピングファイル.
     * @throws IOException
     *             IOException.
     */
    public ExcelXMLTemplate(File inFile, File outFile, Map mapData) throws IOException {
        this(new FileInputStream(inFile), new FileOutputStream(outFile), mapData);
    }

    /**
     * 本インスタンスを初期化します.
     *
     * @param inStream
     *            入力テンプレートファイル.
     * @param outStream
     *            出力ファイル.
     * @param mapData
     *            テンプレートするマッピングファイル.
     */
    @SuppressWarnings("unchecked")
    public ExcelXMLTemplate(InputStream inStream, OutputStream outStream, Map mapData) {
        this.doc = null;
        this.in = inStream;
        this.out = outStream;
        this.data = mapData;
    }

    /**
     * テンプレート処理を実行します.
     *
     * @throws ParserConfigurationException
     *             XML解析時例外.
     * @throws IOException
     *             IO例外.
     * @throws SAXException
     *             XML解析時例外.
     */
    public void execute() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.doc = builder.parse(this.in);
        Element[] aelement = ExcelDOMUtil.getElements(this.doc.getDocumentElement(), Dom.WORKSHEET);
        int i = 0;
        Element worksheet;
        Element pane;
        String sheetName;
        String[] dim;
        Object sheetData;
        Element[] aelement1;
        Element table;
        Element[] aelement2;
        Element row;
        Element dataValidation;
        Element dataHide;
        for (int j = aelement.length; i < j; i++) {
            worksheet = aelement[i];
            pane = ExcelDOMUtil.getElement(worksheet, new String[] { Dom.WORKSHEET_OPTIONS, Dom.PANES, Dom.PANE });
            if (pane != null) pane.getParentNode().removeChild(pane);
            sheetName = worksheet.getAttribute(SpreadSheet.NAME);
            if (sheetName.startsWith(Template.SHEET)) {
                dim = sheetName.split("\\.");
                if (dim.length == 3 && (ReflectionUtil.getProperty(this.data, dim[1]) instanceof List)) {
                    processSheet(worksheet, dim);
                    continue;
                }
            }
            sheetData = ReflectionUtil.getProperty(this.data, sheetName);
            if (sheetData == null) continue;
            aelement1 = ExcelDOMUtil.getElements(worksheet, Dom.TABLE);
            int k = 0;
            for (int l = aelement1.length; k < l; k++) {
                table = aelement1[k];
                aelement2 = ExcelDOMUtil.getElements(table, Dom.ROW);
                int j1 = 0;
                for (int k1 = aelement2.length; j1 < k1; j1++) {
                    row = aelement2[j1];
                    processRow(table, row, sheetData);
                }

            }
            aelement1 = ExcelDOMUtil.getElements(worksheet, Dom.DATA_VALIDATION);
            k = 0;
            for (int i1 = aelement1.length; k < i1; k++) {
                dataValidation = aelement1[k];
                dataHide = ExcelDOMUtil.getElement(dataValidation, Dom.ERROR_HIDE);
                if (dataHide != null) dataValidation.removeChild(dataHide);
            }
        }
        // ExcelDOMUtil.writeXML(doc, out);
        return;
    }

    /**
     * テンプレート処理を実行します.
     *
     * @throws ParserConfigurationException
     *             XML解析時例外.
     * @throws IOException
     *             IO例外.
     * @throws SAXException
     *             XML解析時例外.
     * @throws TransformerException
     *             トランスフォーマ設定時例外.
     */
    public void executeXML() throws ParserConfigurationException, SAXException, IOException, TransformerException {
        execute();
        ExcelDOMUtil.writeXML(this.doc, this.out);
    }

    /**
     * テンプレート処理を実行します.
     *
     * @return バイト配列.
     * @throws ParserConfigurationException
     *             XML解析時例外.
     * @throws IOException
     *             IO例外.
     * @throws SAXException
     *             XML解析時例外.
     * @throws TransformerException
     *             トランスフォーマ設定時例外.
     * @deprecated {@link ExcelXLSTemplate#executeByByte(String, String, Map)}
     */
    @Deprecated
    public byte[] executeByByte() throws ParserConfigurationException, SAXException, IOException, TransformerException {
        execute();
        return ExcelDOMUtil.getByteXML(this.doc, this.out);
        // return ExcelRemoteConverter.converXmlToXLS(ExcelDOMUtil.getByteXML(doc, out));
    }

    /**
     * @param worksheet
     *            ワークシート.
     * @param dim
     */
    @SuppressWarnings({ "rawtypes", "unchecked" })
    protected void processSheet(Element worksheet, String[] dim) {
        List worksheetList = new ArrayList();
        List sheetDataList = (List) ReflectionUtil.getProperty(data, dim[1]);
        for (int i = 0; i < sheetDataList.size(); i++) {
            if (i == 0) {
                worksheetList.add(0, worksheet);
            } else {
                Element insertSheet = (Element) worksheet.cloneNode(true);
                worksheet.getParentNode().insertBefore(insertSheet, worksheet);
                worksheetList.add(i != 1 ? 1 : 0, insertSheet);
            }
        }
        for (int i = 0; i < worksheetList.size(); i++) {
            Object sheetData = sheetDataList.get(i);
            Element sheet = (Element) worksheetList.get(i);
            String sheetName = ReflectionUtil.getPropertyAsString(sheetData, dim[2]);
            sheet.setAttribute(SpreadSheet.NAME, sheetName);
            Element[] aelement = ExcelDOMUtil.getElements(sheet, Dom.NAMES);
            int j = 0;
            for (int k = aelement.length; j < k; j++) {
                Element names = aelement[j];
                Element[] aelement1 = ExcelDOMUtil.getElements(names, Dom.NAMED_RANGE);
                int i1 = 0;
                for (int k1 = aelement1.length; i1 < k1; i1++) {
                    Element namedRange = aelement1[i1];
                    if ("Print_Area".equals(namedRange.getAttribute(SpreadSheet.NAME))) {
                        String refersTo = namedRange.getAttribute(SpreadSheet.REFERS_TO);
                        refersTo = refersTo.replaceFirst((new StringBuilder("#Sheet\\.")).append(dim[1]).append("\\.")
                                .append(dim[2]).toString(), sheetName);
                        namedRange.setAttribute(SpreadSheet.REFERS_TO, refersTo);
                    }
                }
            }
            aelement = ExcelDOMUtil.getElements(sheet, Dom.TABLE);
            j = 0;
            for (int l = aelement.length; j < l; j++) {
                Element table = aelement[j];
                Element[] aelement2 = ExcelDOMUtil.getElements(table, Dom.ROW);
                int j1 = 0;
                for (int l1 = aelement2.length; j1 < l1; j1++) {
                    Element row = aelement2[j1];
                    processRow(table, row, sheetData);
                }
            }
        }
    }

    /**
     * 行にデータを設定します.
     *
     * @param table
     *            テーブル.
     * @param row
     *            行.
     * @param rowData
     *            データ.
     */
    protected void processRow(Element table, Element row, Object rowData) {
        Element[] aelement = ExcelDOMUtil.getElements(row, Dom.CELL);
        int i = 0;
        Element cell;
        Element[] aelement1;
        Element dataElement;
        String text;
        for (int j = aelement.length; i < j; i++) {
            cell = aelement[i];
            aelement1 = ExcelDOMUtil.getElements(cell, Dom.DATA);
            int k = 0;
            for (int l = aelement1.length; k < l; k++) {
                dataElement = aelement1[k];
                text = ExcelDOMUtil.getText(dataElement).trim();
                if (text.startsWith(ExcelXMLConstants.TEMPLATE_PLEFIX)) {
                    if (ReflectionUtil.hasProperty(rowData, text.substring(1))) {
                        ExcelDOMUtil
                                .setTextToCell(cell, ReflectionUtil.getPropertyAsString(rowData, text.substring(1)));
                    } else if (text.startsWith(Template.HLOOP)) {
                        processHorizontalLoop(table, row, rowData, text);
                    } else if (text.startsWith(Template.ITERATE) && text.endsWith(Template.BEGIN)) {
                        processIterateTable(table, row, rowData, text);
                    }
                }
            }
        }
    }

    /**
     * イテレートループにデータを設定します.
     *
     * @param table
     *            テーブル.
     * @param row
     *            行.
     * @param data
     *            データ.
     * @param text
     *            テキスト.
     */
    @SuppressWarnings({ "rawtypes", "unchecked" })
    protected void processIterateTable(Element table, Element row, Object data, String text) {
        String[] dim = text.split("\\.");
        if (dim.length == 3 && ReflectionUtil.getProperty(data, dim[1]) instanceof List
                && ((List) ReflectionUtil.getProperty(data, dim[1])).size() > 0) {
            List rows = new ArrayList();
            Element endRow = null;
            Element[] aelement1 = ExcelDOMUtil.getElements(table, Dom.ROW);
            Element[] aelement3;
            Element rowCell;
            Element[] aelement5;
            Element rowData;
            String dataText;
            int i1 = 0;
            for (int j1 = aelement1.length; i1 < j1; i1++) {
                Element element = aelement1[i1];
                if (element == row) {
                    ExcelDOMUtil.clearRowData(row);
                    rows.add(element);
                    continue;
                }
                if (rows.size() <= 0) continue;
                aelement3 = ExcelDOMUtil.getElements(element, Dom.CELL);
                int i2 = 0;
                for (int j2 = aelement3.length; i2 < j2; i2++) {
                    rowCell = aelement3[i2];
                    aelement5 = ExcelDOMUtil.getElements(rowCell, Dom.DATA);
                    int i3 = 0;
                    for (int j3 = aelement5.length; i3 < j3; i3++) {
                        rowData = aelement5[i3];
                        dataText = ExcelDOMUtil.getText(rowData).trim();
                        if (!dataText.equals(new StringBuilder(Template.ITERATE).append(dim[1]).append(Template.END)
                                .toString())) continue;
                        ExcelDOMUtil.clearRowData(element);
                        endRow = element;
                        break;
                    }
                }
                rows.add(element);
            }

            if (endRow != null) {
                List tableDatas = (List) ReflectionUtil.getProperty(data, dim[1]);
                List insertedRows = null;
                List clonedListList = new ArrayList();
                for (int i = 0; i < tableDatas.size(); i++) {
                    Object tableData = tableDatas.get(i);
                    if (i == 0) {
                        for (int j = 0; j < tableDatas.size() - 1; j++) {
                            List clonedList = new ArrayList();
                            Node cloned;
                            for (Iterator iterator1 = rows.iterator(); iterator1.hasNext(); clonedList.add(cloned)) {
                                Element insertRow = (Element) iterator1.next();
                                cloned = insertRow.cloneNode(true);
                            }
                            clonedListList.add(clonedList);
                        }
                        insertedRows = rows;
                    } else {
                        insertedRows = (List) clonedListList.get(i - 1);
                    }
                    Element element;
                    for (Iterator iterator = insertedRows.iterator(); iterator.hasNext(); processRow(table, element,
                            tableData)) {
                        element = (Element) iterator.next();
                    }
                    if (i < tableDatas.size() - 1) {
                        Element lastInsertRow = null;
                        List clonedList = (List) clonedListList.get(i);
                        for (Iterator iterator2 = clonedList.iterator(); iterator2.hasNext();) {
                            Element cloned = (Element) iterator2.next();
                            row.getParentNode().insertBefore(cloned, endRow);
                            lastInsertRow = cloned;
                        }
                        ExcelDOMUtil.incrementRowCount(table, lastInsertRow, rows.size());
                    }
                }
            }
        } else {
            Element[] aelement = ExcelDOMUtil.getElements(table, Dom.ROW);
            int k = 0;
            for (int l = aelement.length; k < l; k++) {
                Element element = aelement[k];
                Element[] aelement2 = ExcelDOMUtil.getElements(element, Dom.CELL);
                int k1 = 0;
                for (int l1 = aelement2.length; k1 < l1; k1++) {
                    Element rowCell = aelement2[k1];
                    Element[] aelement4 = ExcelDOMUtil.getElements(rowCell, Dom.DATA);
                    int k2 = 0;
                    for (int l2 = aelement4.length; k2 < l2; k2++) {
                        Element rowData = aelement4[k2];
                        String dataText = ExcelDOMUtil.getText(rowData).trim();
                        if (dataText.startsWith(ExcelXMLConstants.TEMPLATE_PLEFIX)) {
                            ExcelDOMUtil.setTextToCell(rowCell, "");
                        }
                    }
                }
            }
        }
    }

    /**
     * 横ループにデータを設定します.
     *
     * @param table
     *            テーブル.
     * @param row
     *            行.
     * @param data
     *            データ.
     * @param text
     *            テキスト.
     */
    @SuppressWarnings("unchecked")
    protected void processHorizontalLoop(Element table, Element row, Object data, String text) {
        String[] dim = text.split("\\.");
        if (dim.length == 3 && (ReflectionUtil.getProperty(data, dim[1]) instanceof List)) {
            Element[] rows = ExcelDOMUtil.getElements(table, Dom.ROW);
            Element beginRow = null;
            Element dataRow = null;
            Element endRow = null;
            Element[] aelement = rows;
            int j = 0;
            for (int k = aelement.length; j < k; j++) {
                Element element = aelement[j];
                if (element == row) {
                    beginRow = element;
                    continue;
                }
                if (beginRow != null && dataRow == null) {
                    dataRow = element;
                    continue;
                }
                if (dataRow == null) continue;
                endRow = element;
                break;
            }

            if (beginRow != null && dataRow != null && endRow != null) {
                List dataList = (List) ReflectionUtil.getProperty(data, dim[1]);
                int rowCount = 0;
                String[] columns = extractLoopColumns(beginRow);
                ExcelDOMUtil.clearRowData(beginRow);
                ExcelDOMUtil.clearRowData(dataRow);
                ExcelDOMUtil.clearRowData(endRow);
                for (int i = 0; i < dataList.size() - 3; i++) {
                    Node newRow = dataRow.cloneNode(true);
                    dataRow.getParentNode().insertBefore(newRow, endRow);
                    rowCount++;
                }

                boolean flag = false;
                int dataIndex = 0;
                LoopInfo loopInfo = new LoopInfo();
                loopInfo.tableData = dataList;
                Element[] aelement1 = ExcelDOMUtil.getElements(table, Dom.ROW);
                int l = 0;
                for (int i1 = aelement1.length; l < i1; l++) {
                    Element row1 = aelement1[l];
                    if (row1 == beginRow) flag = true;
                    if (flag && dataIndex < dataList.size()) {
                        insertRowData(row1, dim[1], columns, dataList.get(dataIndex), loopInfo);
                        dataIndex++;
                    }
                    if (row1 == endRow) break;
                }
                // 空回し
                for (int i = dataIndex + 1; i <= 3; i++) {
                    Object obj = getEmptyObject(dataList);
                    if (obj == null) break;
                    Element row1 = aelement1[i];
                    insertRowData(row1, dim[1], columns, obj, loopInfo);
                }
                if (loopInfo.verticalCount > 3) {
                    for (int i = 0; i < 3 - dataIndex; i++) {
                        Element row1 = null;
                        switch (i) {
                            case 0: // '\0'
                                row1 = endRow;
                                break;
                            case 1: // '\001'
                                row1 = dataRow;
                                break;
                            case 2: // '\002'
                                row1 = beginRow;
                                break;
                            default:
                                // do nothing
                        }
                        appendColumns(row1, ExcelDOMUtil.getElements(row1, Dom.CELL), loopInfo.vloopIndex,
                                loopInfo.verticalCount);
                    }
                }
                ExcelDOMUtil.incrementRowCount(table, endRow, rowCount);
            }
        }
    }

    /**
     * 行を追加します.
     *
     * @param row
     *            行.
     * @param target
     *            ターゲット.
     * @param columns
     *            カラム.
     * @param data
     *            データ.
     * @param loopInfo
     *            ループ情報.
     */
    protected void insertRowData(Element row, String target, String[] columns, Object data, LoopInfo loopInfo) {
        Element[] elements = ExcelDOMUtil.getElements(row, Dom.CELL);
        String prefix;
        for (int i = 0; i < elements.length/* - 1 */; i++) {
            prefix = (new StringBuilder(Template.HLOOP)).append(target).append(".").toString();
            if (columns[i].startsWith(prefix)
                    && ReflectionUtil.hasProperty(data, columns[i].substring(prefix.length()))) {
                ExcelDOMUtil.setTextToCell(elements[i],
                        ReflectionUtil.getPropertyAsString(data, columns[i].substring(prefix.length())));
            } else {
                processVloop(row, elements, ExcelDOMUtil.getElements(elements[i], Dom.DATA), i, data, loopInfo);
            }
        }
    }

    /**
     * 縦ループにデータを設定します.
     *
     * @param row
     *            行.
     * @param cells
     *            セル.
     * @param datas
     *            データ配列.
     * @param cellIndex
     *            セルインデックス.
     * @param data
     *            データ.
     * @param loopInfo
     *            ループ情報.
     */
    @SuppressWarnings("rawtypes")
    protected static void processVloop(Element row, Element[] cells, Element[] datas, int cellIndex, Object data,
            LoopInfo loopInfo) {
        String text = datas.length != 1 ? "" : ExcelDOMUtil.getText(datas[0]);
        if (loopInfo.vloopIndex == cellIndex || text.startsWith(Template.VLOOP)) {
            String[] dim = text.split("\\.");
            if (dim.length == 3 && loopInfo.verticalCount == -1) {
                loopInfo.vloopIndex = cellIndex;
                loopInfo.vloopProperty = dim[2];
                loopInfo.verticalCount = ExcelDOMUtil.getVerticalLoopMaxLength(loopInfo.tableData, dim[2]);
                Element headerRow = ExcelDOMUtil.getHeaderRow(row);
                Element[] mapColumnCells = appendColumns(headerRow, ExcelDOMUtil.getElements(headerRow, Dom.CELL),
                        loopInfo.vloopIndex, loopInfo.verticalCount);
                insertMapColumnData(mapColumnCells, (Map) ReflectionUtil.getProperty(data, loopInfo.vloopProperty),
                        true);
                Element mergedHeaderRow = ExcelDOMUtil.getHeaderRow(headerRow);
                if (loopInfo.verticalCount > 3) {
                    Element[] mergedHeaderCells = ExcelDOMUtil.getElements(mergedHeaderRow, Dom.CELL);
                    int count = 0;
                    Element[] aelement1 = mergedHeaderCells;
                    int j = 0;
                    for (int l = aelement1.length; j < l; j++) {
                        Element cell = aelement1[j];
                        if (count >= loopInfo.vloopIndex) {
                            String mergeCount = cell.getAttribute(SpreadSheet.MERGE_ACROSS);
                            if (mergeCount != null && mergeCount.length() > 0) {
                                cell.setAttribute(SpreadSheet.MERGE_ACROSS, String.valueOf(loopInfo.verticalCount - 1));
                            }
                            break;
                        }
                        String value = cell.getAttribute(SpreadSheet.MERGE_ACROSS);
                        if (value != null && value.length() > 0) {
                            count += Integer.parseInt(value);
                        }
                        count++;
                    }
                }
                if (loopInfo.verticalCount > 3) {
                    Element worksheet = (Element) row.getParentNode().getParentNode();
                    Element[] aelement = ExcelDOMUtil.getElements(worksheet, Dom.NAMES);
                    int i = 0;
                    for (int k = aelement.length; i < k; i++) {
                        Element names = aelement[i];
                        Element[] aelement2 = ExcelDOMUtil.getElements(names, Dom.NAMED_RANGE);
                        int i1 = 0;
                        for (int j1 = aelement2.length; i1 < j1; i1++) {
                            Element namedRange = aelement2[i1];
                            if ("Print_Area".equals(namedRange.getAttribute(SpreadSheet.NAME))) {
                                ExcelDOMUtil.incrementPrintArea(namedRange, 0, loopInfo.verticalCount - 3);
                            }
                        }
                    }
                }
            }
            Element[] mapColumnCells = appendColumns(row, cells, loopInfo.vloopIndex, loopInfo.verticalCount);
            insertMapColumnData(mapColumnCells, (Map) ReflectionUtil.getProperty(data, loopInfo.vloopProperty), false);
        }
    }

    /**
     * @param mapColumnCells
     * @param data
     * @param isHeader
     */
    @SuppressWarnings("rawtypes")
    protected static void insertMapColumnData(Element[] mapColumnCells, Map data, boolean isHeader) {
        Object[] entries = data.entrySet().toArray();
        Entry entry;
        for (int index = 0; index < entries.length; index++) {
            entry = (Entry) entries[index];
            ExcelDOMUtil
                    .setTextToCell(mapColumnCells[index], (isHeader ? entry.getKey() : entry.getValue()).toString());
        }

    }

    /**
     * @param row
     * @param cells
     * @param begin
     * @param append
     * @return
     */
    protected static Element[] appendColumns(Element row, Element[] cells, int begin, int append) {
        Element beginCell = cells[begin];
        Element dataCell = cells[begin + 1];
        Element endCell = cells[begin + 2];
        List<Element> list = new ArrayList<Element>();
        list.add(beginCell);
        list.add(dataCell);
        Node insertNode;
        for (int i = 0; i < append - 3; i++) {
            insertNode = dataCell.cloneNode(true);
            dataCell.getParentNode().insertBefore(insertNode, endCell);
            list.add((Element) insertNode);
        }
        list.add(endCell);
        return list.toArray(new Element[list.size()]);
    }

    /**
     * @param dataRow
     * @return
     */
    protected static String[] extractLoopColumns(Element dataRow) {
        List<String> columns = new ArrayList<String>();
        Element[] aelement = ExcelDOMUtil.getElements(dataRow, Dom.CELL);
        int i = 0;
        Element column;
        Element[] elements;
        for (int j = aelement.length; i < j; i++) {
            column = aelement[i];
            elements = ExcelDOMUtil.getElements(column, Dom.DATA);
            if (elements.length > 0) {
                columns.add(ExcelDOMUtil.getText(elements[0]));
            } else {
                columns.add("");
            }
        }
        return columns.toArray(new String[columns.size()]);
    }

    /**
     * @param list
     * @return
     */
    private Object getEmptyObject(List<? extends Object> list) {
        if (list == null || list.isEmpty()) return null;
        Object item = null;
        try {
            item = list.get(0).getClass().newInstance();
        } catch (Exception e) {
            // Do Nothing
        }
        return item;
    }
}
