package jp.sourceforge.masasa.xlsXmlTemplate;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

/**
 * リフレクションユーティリティ.
 *
 * @author masasa
 */
public final class ReflectionUtil {

    /**
     * シングルトン.
     */
    private ReflectionUtil() {
        // do nothing
    }

    /** getter. */
    private static final String GET = "get"; //$NON-NLS-1$
    /** getter. */
    private static final String IS = "is"; //$NON-NLS-1$

    /**
     * フィールドのGetterメソッドを返却します.
     *
     * @param obj
     *            対象オブジェクト.
     * @param name
     *            フィールド名.
     * @return メソッドオブジェクト.
     */
    public static Method getGetter(Object obj, String name) {
        Method method = null;
        try {
            method = obj.getClass().getMethod(new StringBuilder(GET).append(name).toString(), new Class[0]);
        } catch (Exception e) {
            try {
                method = obj.getClass().getMethod(new StringBuilder(IS).append(name).toString(), new Class[0]);
            } catch (Exception e1) {
                method = null;
            }
        }
        return method;
    }

    /**
     * {@code name} に対応する {@code getter} メソッド(getXXX またはisXXX)が {@code obj} 存在するかチェックします.
     *
     * @param obj
     *            対象オブジェクト.
     * @param name
     *            対象フィールド名.
     * @return チェック結果.
     *         <ul>
     *         <li>{@code true} : 存在する.</li>
     *         <li>{@code false} : 存在しない.</li>
     *         </ul>
     */
    public static boolean hasProperty(Object obj, String name) {
        return obj instanceof Map ? ((Map) obj).containsKey(name) : getGetter(obj, getCamelizedName(name)) != null;
    }

    /**
     * {@code name} に対応する値を {@code obj} から取得して返却します.
     *
     * @param obj
     *            対象オブジェクト.
     * @param name
     *            対象フィールド名.
     * @return 取得値.
     *         <ul>
     *         <li>存在する場合 {@code name} に対応する {@code obj} の値を返却する.</li>
     *         <li>上記以外の場合は {@code NULL} を返却する.</li>
     *         </ul>
     */
    public static String getPropertyAsString(Object obj, String name) {
        Object value = getProperty(obj, name);
        return value == null ? "" : value.toString();
    }

    /**
     * インスタンス<code>obj</code>から<code>name</code>に該当する値を返却します.
     *
     * @param obj
     *            インスタンス.
     * @param name
     *            対象フィールド.
     * @return 値.
     */
    public static Object getProperty(Object obj, String name) {
        if (obj instanceof Map) return ((Map) obj).get(name);
        Method method = getGetter(obj, getCamelizedName(name));
        if (method == null) return null;
        Object value = null;
        try {
            value = method.invoke(obj, (Object[]) null);
        } catch (IllegalArgumentException e) {
            return value;
        } catch (IllegalAccessException e) {
            return value;
        } catch (InvocationTargetException e) {
            return value;
        }
        return value;
    }

    /**
     * キャメライズした名称を返却します.
     *
     * @param name
     *            対象名称.
     * @return キャメライズ.
     */
    public static String getCamelizedName(String name) {
        return new StringBuilder(name.substring(0, 1).toUpperCase()).append(name.substring(1)).toString();
    }
}
