#----------------------------------------------------------------------------#
#  Copyright 2019 Levashev Ivan Aleksandrovich                               #
#                                                                            #
#  Licensed under the Apache License, Version 2.0 (the "License");           #
#  you may not use this file except in compliance with the License.          #
#  You may obtain a copy of the License at                                   #
#                                                                            #
#      http://www.apache.org/licenses/LICENSE-2.0                            #
#                                                                            #
#  Unless required by applicable law or agreed to in writing, software       #
#  distributed under the License is distributed on an "AS IS" BASIS,         #
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  #
#  See the License for the specific language governing permissions and       #
#  limitations under the License.                                            #
#----------------------------------------------------------------------------#

#DEFINE COMMAND, OLE
#DEFINE FUNCTION, OLE
EXTERNAL VDSOLEAUT.DLL,ignored

%S = @OLE(variant, SAPI.SpVoice, THREADEDOBJECT)

INFO SAPI.SpVoice created with type @OLE(variant, %S, TYPEOF)
# OBJECT if Speech API is installed

OLE INVOKE, variant, %S, DO, Speak, This is a test, STRING
# Speak text synchronously with default voice

%P = @OLE(variant, %S, DO, promise, Speak, This is another test. You should hear speech and see message at the same time, STRING)
# Speak text asynchronously with default voice

INFO Asynchronous method invocation
# One should see this message in parallel with actual voice

WHILE @OLE(promise, %P, ISRUNNING)
  # WAIT EVENT
  # Only valid when dialog is displayed
  
  WAIT 1
  # UI is responding while background thread executes
WEND

OLE CLOSE, promise, %P

INFO Volume property by default: @OLE(variant, %S, GET, string, Volume)
# 100 by default

OLE MODIFY, variant, %S, PUT, Volume, 80, INTEGER
# Set volume to 80

INFO Volume property after synchronous modification: @OLE(variant, %S, GET, string, Volume)
# Now it is 80

%P = @OLE(variant, %S, PUT, promise, Volume, 100, INTEGER)
# Asynchronous property modification

INFO Volume property after asynchronous modification: @OLE(variant, %S, GET, string, Volume)
# Can be still 80 if background thread starts slow (didn't manage to get this)
# Changes to 100 if THREADEDOBJECT changed to OBJECT in the beginning

WHILE @OLE(promise, %P, ISRUNNING)
  WAIT 1
  # UI is responding while background thread executes
WEND

INFO Volume property after waiting for completion: @OLE(variant, %S, GET, string, Volume)

OLE CLOSE, promise, %P

%V = @OLE(variant, %S, DO, variant, GetVoices)
%E = @OLE(variant, %V, ENUMERATE)
OLE CLOSE, variant, %V

%V = @OLE(enumerator, %E, NEXT)
WHILE %V
  INFO Voice detected: @OLE(variant, %V, DO, string, GetDescription)
  
  OLE CLOSE, variant, %V
  %V = @OLE(enumerator, %E, NEXT)
WEND

OLE CLOSE, enumerator, %E

OLE CLOSE, variant, %S
