package jp.co.versus;

import jp.co.versus.R;
import jp.co.versus.adapter.TeamEditorListAdapter;
import jp.co.versus.adapter.TeamEditorListAdapter.TeamEditorListItem;
import jp.co.versus.provider.VersusContract.Member;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.DialogInterface;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager.LoaderCallbacks;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.text.InputType;
import android.util.Log;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.View;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.MenuItem.OnMenuItemClickListener;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.AdapterView.AdapterContextMenuInfo;

public class MemberEditorActivity extends FragmentActivity implements
		OnClickListener, LoaderCallbacks<Cursor> {
	final static private String TAG = "MemberEditorActivity";
	private ContentResolver mContentResolver;
	private TeamEditorListAdapter mAdapter;
	private ListView mListView;
	final static private int ID = 0;
	final static private int NAME = 1;
	final static private String DIALOG_ADD = "追加";
	final static private String DIALOG_EDIT = "編集";
	final static private String DIALOG_DELETE = "削除";

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.membereditor_layout_activity);

		headerInitialize();

		getSupportLoaderManager().initLoader(0, null, this);
		mContentResolver = getContentResolver();
		mAdapter = new TeamEditorListAdapter(getApplicationContext());

		mListView = (ListView) findViewById(R.id.listview);
		mListView.setAdapter(mAdapter);
		registerForContextMenu(mListView);

		Button button = (Button) findViewById(R.id.member_editor_btn);
		button.setOnClickListener(this);
	}

	@Override
	public void onCreateContextMenu(ContextMenu menu, View v,
			ContextMenuInfo menuinfo) {
		AdapterContextMenuInfo adapterMenuInfo = (AdapterContextMenuInfo) menuinfo;
		ListView listView = (ListView) v;
		final int position = adapterMenuInfo.position;
		TeamEditorListItem listItem = (TeamEditorListItem) listView
				.getItemAtPosition(position);
		final String name = listItem.getName();
		Log.d(TAG, "name = " + name);
		menu.add(0, 0, 0, DIALOG_EDIT).setOnMenuItemClickListener(
				new OnMenuItemClickListener() {
					public boolean onMenuItemClick(MenuItem item) {
						createDialog(DIALOG_EDIT, name, position);
						return false;
					}
				});
		menu.add(0, 1, 1, DIALOG_DELETE).setOnMenuItemClickListener(
				new OnMenuItemClickListener() {
					public boolean onMenuItemClick(MenuItem item) {
						deleteDB(name);
						mAdapter.removeItem(position);
						return false;
					}
				});
	}

	private void insertDB(String name) {
		ContentValues cv = new ContentValues();
		cv.put(Member.NAME, name);
		mContentResolver.insert(Member.CONTENT_URI, cv);
	}

	private void deleteDB(String name) {
		mContentResolver.delete(Member.CONTENT_URI, Member.NAME + "=?",
				new String[] { name });
	}

	private void updateDB(String upName, String baseName, int position) {
		ContentValues cv = new ContentValues();
		cv.put(Member.NAME, upName);
		mContentResolver.update(Member.CONTENT_URI, cv, Member.NAME + "=?",
				new String[] { baseName });
		// リスト更新処理
		mAdapter.removeItem(position);
		mAdapter.addItem(upName, position);
	}

	// ダイアログ作成
	public void createDialog(final String title, final String baseName,
			final int position) {
		final EditText editView = new EditText(this);
		editView.setText(baseName);
		editView.setInputType(InputType.TYPE_TEXT_VARIATION_PERSON_NAME);
		GreenAlertDialog dialog = new GreenAlertDialog(this,
				R.style.GreenDialog);
		// ダイアログ
		dialog.setIcon(android.R.drawable.ic_dialog_info);
		// アイコン
		dialog.setTitle(title);
		// タイトル
		dialog.setView(editView);
		// エディター
		dialog.setButton("OK", new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int whichButton) {
				String name = editView.getText().toString();
				if (name.equals("")) {
					return;
				} else if (title.equals(DIALOG_ADD)) { // 追加処理
					insertDB(name);
					mAdapter.addItem(name);
				} else if (title.equals(DIALOG_EDIT)) {// 編集処理
					updateDB(name, baseName, position);
				}
				Log.v("dialog", name);
			}
		});
		dialog.setButton2("Cancel", new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int whichButton) {
			}
		});
		dialog.show();
	}

	@Override
	public Loader<Cursor> onCreateLoader(int id, Bundle args) {
		Log.d(getClass().getSimpleName(), "onCreateLoader called.");
		return new CursorLoader(getApplicationContext(), Member.CONTENT_URI,
				new String[] { Member._ID, Member.NAME }, null, null,
				Member.NAME + " asc");
	}

	@Override
	public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
		Log.d(getClass().getSimpleName(), "onLoadFinished called.");
		if (cursor != null) {
			cursor.moveToFirst();
			do {
				try {
					String id = cursor.getString(0);
					String member_name = cursor.getString(1);
					mAdapter.addItem(member_name);
					Log.d(TAG, "ID = " + id);
					Log.d(TAG, "Name = " + member_name);
				} catch (Exception e) {
				}
			} while (cursor.moveToNext());
		}
	}

	@Override
	public void onLoaderReset(Loader<Cursor> cursor) {
		Log.d(getClass().getSimpleName(), "onLoaderReset called.");
	}

	@Override
	public void onClick(View v) {
		int id = v.getId();
		if (id == R.id.member_editor_btn) {
			createDialog(DIALOG_ADD, "", 0);
		}
	}

    /**
     * ヘッダの初期化処理を行います。
     */
    private void headerInitialize() {
    	TextView headerText = (TextView)findViewById(R.id.header_title);
    	headerText.setText(R.string.header_member_edit);
    }
}
