package jp.co.versus;

import jp.co.versus.R;
import jp.co.versus.adapter.PlayResultDateListAdapter;
import jp.co.versus.adapter.PlayResultDateListAdapter.PlayResultDateListItem;
import jp.co.versus.adapter.PlayResultListAdapter.PlayResultListItem;
import jp.co.versus.adapter.PlayResultListAdapter;
import jp.co.versus.provider.VersusContract.Point;
import jp.co.versus.provider.VersusContract.Result;
import jp.co.versus.provider.VersusContract.Team;
import android.content.ContentResolver;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager.LoaderCallbacks;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;

public class ResultListActivity extends FragmentActivity implements OnClickListener, LoaderCallbacks<Cursor>{
    private PlayResultListAdapter mAdapter;
    private ListView mListView;
    private ContentResolver mContentResolver;
    private String mPlayDate;
    final private int REQUEST_EDIT_RESULT = 23;

    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.result_list_layout);

        mContentResolver = getContentResolver();
        mListView = (ListView) findViewById(R.id.listview);
        Intent intent = getIntent();
        mPlayDate = intent.getStringExtra(VersusActivity.KEY_DATE);

        headerInitialize();
        getSupportLoaderManager().initLoader(0, null, this);

        mAdapter = new PlayResultListAdapter(getApplicationContext());
        mListView.setAdapter(mAdapter);
        mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position,
                    long id) {
                ListView listView = (ListView)parent;
                long item = listView.getItemIdAtPosition(position);
                PlayResultListItem listItem = (PlayResultListItem) mAdapter.getItem((int)item);
                Intent intent = new Intent(ResultListActivity.this, PlayResultEditorActivity.class);
                intent.putExtra(PlayInfoEditorActivity.DATE_KEY, listItem.getDate());
                intent.putExtra(PlayInfoEditorActivity.TEAM1_KEY, listItem.getTeam1());
                intent.putExtra(PlayInfoEditorActivity.TEAM2_KEY, listItem.getTeam2());
                intent.putExtra(PlayInfoEditorActivity.RESULT_ID_KEY, listItem.getResultId());
                intent.putExtra(PlayInfoEditorActivity.MODE_KEY, PlayInfoEditorActivity.MODE_EDIT);
                startActivityForResult(intent, REQUEST_EDIT_RESULT);
            }
        });
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent intent){
        super.onActivityResult(requestCode, resultCode, intent);
        if(intent != null){
            switch(requestCode){
            case REQUEST_EDIT_RESULT:
            	mAdapter.removeAllItem();
            	getSupportLoaderManager().restartLoader(0, null, this);
                break;
            }
        }
    }

    /**
     * ヘッダの初期化処理を行います。
     */
    private void headerInitialize() {
    	TextView headerText = (TextView)findViewById(R.id.header_title);
    	headerText.setText(mPlayDate);
    }

	@Override
	public Loader<Cursor> onCreateLoader(int id, Bundle args) {
		return new CursorLoader(getApplicationContext(),
				Result.CONTENT_URI,
				new String[] {
			        Result._ID,
			        Result.RESULTID,
			        Result.TEAM1,
			        Result.TEAM2
			    },
			    Result.DATE + " = ?", new String[]{mPlayDate},
			    Result._ID + " asc");
	}

	@Override
	public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
		if (cursor != null) {
			cursor.moveToFirst();
			do {
				String id = cursor.getString(0);
				String resultId = cursor.getString(1);
				String team1 = cursor.getString(2);
				String team2 = cursor.getString(3);
				int teamid_1 = 0;
				int teamid_2 = 0;
				int point_1 = 0;
				int point_2 = 0;
	            Cursor cursor1 = mContentResolver.query(Team.CONTENT_URI, new String[]{
	                    Team._ID}, Team.TEAM + "=?", new String[]{team1}, null);
	            if(cursor1.moveToFirst()){	//チーム名に対するID取り出し
	            	teamid_1 = cursor1.getInt(0);
	            }
	            cursor1.close();
	            cursor1 = mContentResolver.query(Team.CONTENT_URI, new String[]{
	                    Team._ID}, Team.TEAM + "=?", new String[]{team2}, null);
	            if(cursor1.moveToFirst()){	//チーム名に対するID取り出し
	            	teamid_2 = cursor1.getInt(0);
	            }
	            cursor1.close();
	            cursor1 = mContentResolver.query(Point.CONTENT_URI, new String[]{
	                    Point.SCORER}, Point.RESULTID + "=? and " + Point.TEAMID + "=?", new String[]{resultId, Integer.toString(teamid_1)}, null);
	            if (cursor1.moveToFirst()) {
	            	do {
	            		String score = cursor1.getString(0);
	            		if (!score.isEmpty()) {
	            			point_1++;
	            		}
	            	} while (cursor1.moveToNext());
	            }
	            cursor1.close();

	            cursor1 = mContentResolver.query(Point.CONTENT_URI, new String[]{
	                    Point.SCORER}, Point.RESULTID + "=? and " + Point.TEAMID + "=?", new String[]{resultId, Integer.toString(teamid_2)}, null);
	            if (cursor1.moveToFirst()) {
	            	do {
	            		String score = cursor1.getString(0);
	            		if (!score.isEmpty()) {
	            			point_2++;
	            		}
	            	} while (cursor1.moveToNext());
	            }
	            cursor1.close();

	            mAdapter.addItem(team1, team2, point_1, point_2, resultId, mPlayDate);
			} while (cursor.moveToNext());
			cursor.close();
		}
	}

	@Override
	public void onLoaderReset(Loader<Cursor> cursor) {
	}

	@Override
	public void onClick(View view) {
	}
}