package jp.co.versus;

import jp.co.versus.R;
import jp.co.versus.adapter.TeamEditorListAdapter;
import jp.co.versus.adapter.TeamEditorListAdapter.TeamEditorListItem;
import jp.co.versus.provider.VersusContract.Member;
import jp.co.versus.provider.VersusContract.Team;
import jp.co.versus.provider.VersusContract.TeamMember;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager.LoaderCallbacks;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.text.InputType;
import android.util.Log;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.View;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.MenuItem.OnMenuItemClickListener;
import android.view.View.OnClickListener;
import android.view.WindowManager.LayoutParams;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.AdapterView.AdapterContextMenuInfo;
import android.widget.SimpleCursorAdapter;

public class TeamEditorActivity extends FragmentActivity
        implements
            SimpleCursorAdapter.ViewBinder,
            OnClickListener,
            LoaderCallbacks<Cursor> {
    final static private int REQUEST_CODE = 1048576; // onActivityResultの返し分岐コード
    final static private String DIALOG_DELETE = "削除";
    final static private String DIALOG_EDIT = "編集";

    private ContentResolver mContentResolver;
    private TeamEditorListAdapter mAdapter;
    private ListView mListView;
    private EditText mTeamForm;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().setSoftInputMode(
                LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
        setContentView(R.layout.teameditor_layout);

        headerInitialize();
        getSupportLoaderManager().initLoader(0, null, this);
        mContentResolver = getContentResolver();

        mAdapter = new TeamEditorListAdapter(this);

        mListView = (ListView) findViewById(R.id.listview);
        mListView.setAdapter(mAdapter);
        registerForContextMenu(mListView);

        mTeamForm = (EditText) findViewById(R.id.teamname_et);

        setButton(R.id.add_btn);
        setButton(R.id.ok_btn);
        setButton(R.id.cancel_btn);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode,
            Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        if (intent != null) {
            Bundle bundle = intent.getExtras();

            switch (requestCode) {
                case REQUEST_CODE :
                    String data = bundle
                            .getString(MemberSelectActivity.KEY_STRINGDATA);
                    if (!data.equals("")) {
                        String[] datas = data.split(",");
                        mAdapter.removeAllItem();
                        for (int i = 0; i < datas.length; i++) {
                            mAdapter.addItem(datas[i]);
                        }
                    }
                    break;
            }
        }
    }

    // コンテキストメニュー作成
    @Override
    public void onCreateContextMenu(ContextMenu menu, View v,
            ContextMenuInfo menuinfo) {
        AdapterContextMenuInfo adapterMenuInfo = (AdapterContextMenuInfo) menuinfo;
        ListView listView = (ListView) v;
        final int position = adapterMenuInfo.position;
        TeamEditorListItem listItem = (TeamEditorListItem)listView.getItemAtPosition(position);
        final String name = listItem.getName();
		menu.add(0, 0, 0, DIALOG_EDIT).setOnMenuItemClickListener(
				new OnMenuItemClickListener() {
					public boolean onMenuItemClick(MenuItem item) {
						createDialog(DIALOG_EDIT, name, position);
						return false;
					}
				});
		menu.add(0, 1, 1, DIALOG_DELETE).setOnMenuItemClickListener(
				new OnMenuItemClickListener() {
					public boolean onMenuItemClick(MenuItem item) {
						deleteDB(name);
						mAdapter.removeItem(position);
						return false;
					}
				});
    }

	// ダイアログ作成
	public void createDialog(final String title, final String baseName,
			final int position) {
		final EditText editView = new EditText(this);
		editView.setText(baseName);
		editView.setInputType(InputType.TYPE_TEXT_VARIATION_PERSON_NAME);
		new AlertDialog.Builder(this)
				// ダイアログ
				.setIcon(android.R.drawable.ic_dialog_info)
				// アイコン
				.setTitle(title)
				// タイトル
				.setView(editView)
				// エディター
				.setPositiveButton("OK", new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int whichButton) {
						String name = editView.getText().toString();
						if (name.equals("")) {
							return;
						} else if (title.equals(DIALOG_EDIT)) {// 編集処理
							updateDB(name, baseName, position);
						}
						Log.v("dialog", name);
					}
				})
				.setNegativeButton("Cancel",
						new DialogInterface.OnClickListener() {
							public void onClick(DialogInterface dialog,
									int whichButton) {
							}
						}).show();
	}

	private void updateDB(String upName, String baseName, int position) {
		ContentValues cv = new ContentValues();
		cv.put(Team.TEAM, upName);
		mContentResolver.update(Team.CONTENT_URI, cv, Team.TEAM + "=?",
				new String[] { baseName });
		// リスト更新処理
		mAdapter.removeItem(position);
		mAdapter.addItem(upName, position);
	}

	private void deleteDB(String name) {
        mContentResolver.delete(Team.CONTENT_URI, Team.TEAM + "=?",
                new String[]{name});
    }

    // ボタン動作
    private void setButton(int id) {
        Button button = (Button) findViewById(id);
        button.setOnClickListener(this);
    }

    public void register() {
        ContentValues cv = new ContentValues();
        String teamname = mTeamForm.getText().toString();
        cv.put(Team.TEAM, teamname);
        mContentResolver.insert(Team.CONTENT_URI, cv);
        Cursor c = mContentResolver.query(Team.CONTENT_URI,
                new String[]{Team._ID}, Team.TEAM + "=?",
                new String[]{teamname}, null); // チームID
        c.moveToFirst();
        int teamid = c.getInt(0);
        for (int i = 0; i < mAdapter.getCount(); i++) {
            TeamEditorListItem listItem = (TeamEditorListItem) mAdapter
                    .getItem(i);
            c = mContentResolver.query(Member.CONTENT_URI,
                    new String[]{Member._ID}, Member.NAME + "=?",
                    new String[]{listItem.getName()}, null);
            cv = new ContentValues();
            c.moveToFirst();
            cv.put(TeamMember.MEMBERID, c.getInt(0));
            cv.put(TeamMember.TEAMID, teamid);
            mContentResolver.insert(TeamMember.CONTENT_URI, cv);
        }
        c.close();
    }

    // クリック動作
    public void onClick(View v) {
        int id = v.getId();
        switch (id) {
            case R.id.add_btn :
            	String teamname = mTeamForm.getText().toString();
            	if (teamname.isEmpty()) {
            		showErrorDialog();
            		break;
            	}
                Intent intent = new Intent(TeamEditorActivity.this,
                        MemberSelectActivity.class);
                startActivityForResult(intent, REQUEST_CODE);
                break;
            case R.id.ok_btn :
                if (!mTeamForm.getText().toString().equals("")
                        && mAdapter.getCount() > 0) {
                    register();
                }
                finish();
                break;
            case R.id.cancel_btn :
                finish();
                break;
        }
    }

    @Override
    public boolean setViewValue(View view, Cursor cursor, int columnIndex) {
        // TODO 自動生成されたメソッド・スタブ
        return false;
    }

    /**
     * ヘッダの初期化処理を行います。
     */
    private void headerInitialize() {
    	TextView headerText = (TextView)findViewById(R.id.header_title);
    	headerText.setText(R.string.header_team_editor);
    }

    private void showErrorDialog() {
    	new AlertDialog.Builder(this)
		.setIcon(android.R.drawable.ic_dialog_info)
		.setMessage(R.string.error_member_add)
		.setPositiveButton("OK", new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int whichButton) {
			}
		}).show();
    }

	@Override
	public Loader<Cursor> onCreateLoader(int arg0, Bundle arg1) {
		return new CursorLoader(getApplicationContext(), Team.CONTENT_URI,
                new String[]{Team._ID, Team.TEAM}, null, null, Team.TEAM
                + " asc");
	}

	@Override
	public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
        if (cursor != null) {
            cursor.moveToFirst();
            do {
                try {
                    String team_name = cursor.getString(1);
                    mAdapter.addItem(team_name);
                } catch (Exception e) {

                }
            } while (cursor.moveToNext());
            cursor.close();
        }
	}

	@Override
	public void onLoaderReset(Loader<Cursor> arg0) {
	}
}
