/*
 * Copyright (C) 2009 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 */

package jp.co.versus.provider;

import jp.co.versus.provider.VersusContract.Member;
import jp.co.versus.provider.VersusContract.Point;
import jp.co.versus.provider.VersusContract.Result;
import jp.co.versus.provider.VersusContract.Team;
import jp.co.versus.provider.VersusContract.TeamMember;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

public class VersusDatabaseHelper extends SQLiteOpenHelper {
    private static final String TAG = "VersusDatabaseHelper";

    static final int DATABASE_VERSION = 1;

    private static final String DATABASE_NAME = "versus.db";

    public interface Tables {
        public static final String MEMBER = "member";
        public static final String TEAM = "team";
        public static final String TEAMMEMBER = "teammember";
        public static final String RESULT = "result";
        public static final String POINT = "point";
    }

    public interface MemberColumns {
        public static final String _ID = Member._ID;
        public static final String NAME = Member.NAME;
    }

    public interface TeamColumns {
    	public static final String _ID = Team._ID;
    	public static final String TEAM = Team.TEAM;
    }

    public interface TeamMemberColumns {
    	public static final String _ID = TeamMember._ID;
    	public static final String MEMBERID = TeamMember.MEMBERID;
    	public static final String TEAMID = TeamMember.TEAMID;
    }

    public interface ResultColumns {
    	public static final String _ID = Result._ID;
    	public static final String RESULTID = Result.RESULTID;
    	public static final String DATE = Result.DATE;
    	public static final String TEAM1 = Result.TEAM1;
    	public static final String TEAM2 = Result.TEAM2;
    }

    public interface PointColumns {
    	public static final String _ID = Point._ID;
    	public static final String RESULTID = Point.RESULTID;
    	public static final String TEAMID = Point.TEAMID;
    	public static final String SCORER = Point.SCORER;
    	public static final String ASSIST = Point.ASSIST;
    }

    private static VersusDatabaseHelper sSingleton = null;

    public static synchronized VersusDatabaseHelper getInstance(Context context) {
        if (sSingleton == null) {
            sSingleton = new VersusDatabaseHelper(context, DATABASE_NAME, true);
        }
        return sSingleton;
    }

    /**
     * Private constructor, callers except unit tests should obtain an instance through
     * {@link #getInstance(android.content.Context)} instead.
     */
    VersusDatabaseHelper(Context context) {
        this(context, null, false);
    }

    protected VersusDatabaseHelper(
            Context context, String databaseName, boolean optimizationEnabled) {
        super(context, databaseName, null, DATABASE_VERSION);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        Log.i(TAG, "Bootstrapping database version: " + DATABASE_VERSION);

        db.execSQL("CREATE TABLE " + Tables.MEMBER + " (" +
                MemberColumns._ID + " INTEGER PRIMARY KEY AUTOINCREMENT," +
                MemberColumns.NAME + " TEXT NOT NULL" +
        ");");

        db.execSQL("CREATE TABLE " + Tables.TEAM + " (" +
                TeamColumns._ID + " INTEGER PRIMARY KEY AUTOINCREMENT," +
                TeamColumns.TEAM + " TEXT NOT NULL" +
        ");");

        db.execSQL("CREATE TABLE " + Tables.TEAMMEMBER + " (" +
                TeamMemberColumns._ID + " INTEGER PRIMARY KEY AUTOINCREMENT," +
                TeamMemberColumns.MEMBERID + " INTEGER NOT NULL," +
                TeamMemberColumns.TEAMID + " INTEGER NOT NULL" +
        ");");

        db.execSQL("CREATE TABLE " + Tables.RESULT + " (" +
                ResultColumns._ID + " INTEGER PRIMARY KEY AUTOINCREMENT," +
                ResultColumns.DATE + " TEXT NOT NULL," +
                ResultColumns.RESULTID + " INTEGER NOT NULL," +
                ResultColumns.TEAM1 + " INTEGER NOT NULL," +
                ResultColumns.TEAM2 + " INTEGER NOT NULL" +
        ");");

        db.execSQL("CREATE TABLE " + Tables.POINT + " (" +
                PointColumns._ID + " INTEGER PRIMARY KEY AUTOINCREMENT," +
                PointColumns.RESULTID + " INTEGER NOT NULL," +
                PointColumns.TEAMID + " INTEGER NOT NULL," +
                PointColumns.SCORER + " INTEGER NOT NULL," +
                PointColumns.ASSIST + " INTEGER" +
        ");");

    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Log.i(TAG, "Upgrading from version " + oldVersion + " to " + newVersion);
    }
}
