//
//  ControllerSkin.h
//  VH7PC_Controller
//
//  Created by nya on Tue Aug 12 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#define BUTTON_NUM 21
#define DISPLAY_ITEM_NUM 8
#define DISPLAY_TEXT_NUM 3

typedef enum{
    tapeaux_b,
    md_b,
    tuner_b,
    cd_b,
    pcusb_b,
    band_b,
    repeat_b,
    mute_b,
    nb_b,
    auto_b,
    eject_b,
    skdn_b,
    fb_b,
    play_b,
    stop_b,
    ff_b,
    skup_b,
    power_b,
    random_b,
    volumePlus1_b,
    volumeMinus1_b
} button;

typedef enum{
    random_item,repeat,repeatall,tone,nb1,nb2,mute,automono
} display_item;

typedef enum{
    input_text,number_text,volume_text
} display_text;

@interface ControllerSkin : NSObject {
    NSBundle* _bundle;
    NSDictionary* _skinDictionary;
}

+(id)skinWithPath:(NSString*)path;

-(id)initWithPath:(NSString *)path;

-(NSString*)name;
-(NSImage*)backgroundImage;
-(NSTextField*)displayTextFieldForTag:(int)tag;
-(NSArray*)displayTextForTag:(int)tag inRect:(NSRect*)rect;
-(NSImage *)displayImageForTag:(int)tag andOrigin:(NSPoint*)point;
-(NSSlider*)volumeSlider;
-(NSButton*)buttonForTag:(button)tag;

@end
