#ifndef NODE_H
#define NODE_H

#include <QGraphicsTextItem>
#include <QPointer>
#include <QColor>
#include <QFont>

class Scene;
class QDataTime;
class QGraphicsPixmapItem;
struct GlobalSettings;

class ClpsExpndButton : public QGraphicsRectItem
{

public:
	ClpsExpndButton(QGraphicsItem * parent = 0);
	~ClpsExpndButton() {}

public:
	void	paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);

protected:
	Scene	*scene();

protected:
	//void	hoverEnterEvent ( QGraphicsSceneHoverEvent * event );
	//void	hoverLeaveEvent ( QGraphicsSceneHoverEvent * event );
	void	mousePressEvent ( QGraphicsSceneMouseEvent * event );
};

class LinkItem : public QGraphicsRectItem
{

public:
	LinkItem(QGraphicsItem * parent = 0);
	~LinkItem() {}

public:
	void	paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);

protected:
	Scene	*scene();

//signals:
//	void	openLink(const QString &);

protected:
	void	hoverEnterEvent ( QGraphicsSceneHoverEvent * event );
	void	hoverLeaveEvent ( QGraphicsSceneHoverEvent * event );
	void	mousePressEvent ( QGraphicsSceneMouseEvent * event );
};

class Node : public QGraphicsTextItem
{
	Q_OBJECT

public:
	enum { Type = UserType + 1 };
	enum {
		PADDING = 4,	//	qm[hԊu
		PC_SPACE = 16,	//	eqm[hԊu
		FORK_STYLE_BOTTOM_OFFSET = 4,
		RIGHT_SIDE = true,
		LEFT_SIDE = false,
	};
	enum {
		FORK_STYLE = 0,
		RECT_STYLE,
		ROUND_RECT_STYLE,
		CIRCLE_RECT_STYLE,
	};

public:
	Node(QGraphicsItem *parent = 0);
	Node(const QString & text, QGraphicsItem *parent = 0);
	~Node();

public:
	bool	isRightSide() const { return m_isRightSide; }
	bool	expanded() const { return m_expanded; }
	bool	isAlignColumn() const { return m_alignColumn; }
	bool	isNodeDownward() const { return m_nodeDownward; }
	bool	isRootNode() const { return parentNode() == 0; }
	bool	hasChildren() const { return !m_children.isEmpty(); }
	bool	isAncesterNodeSelected() const;
	bool	isDescendantNode(const Node *) const;
	bool	isFloatingNode() const { return m_isFloatingNode; }
	uchar	nodeStyle() const { return m_nodeStyle; }
	Qt::Alignment	textAlign() const { return m_textAlign; }
	QColor	fillColor() const { return m_fillColor; };
	uint	createdDT() const { return m_createdDT; }
	uint	mofifiedDT() const { return m_modifiedDT; }
	int		numberOfChildren() const { return m_children.size(); }
	int		numberOfLeafNode() const;
	//bool	collapsed() const { return m_collapsed; }
	qreal	textWidthEx() const;		//	eLXg̕Ԃ
	qreal	height(bool isRightSide) const;		//	q܂߂Ԃ
	qreal	childHeight(bool isRightSide) const;		//	q̍Ԃ
	void	getDescendantColumnWidth(QVector<qreal> &, bool, int) const;	//	eKw̍ő啝擾
	void	setChildrenTextWidth(const qreal *ptr, bool);
	void	resetChildrenTextWidthRecursive(bool);
	void	setTextWidthRecursive(bool = false);
	Node	*parentNode() const { return m_parentNode; }
	Node	*rootNode() const;
	QString toOutlineText(int lvl = 0) const;	//	"." ŃCfgꂽAEgCeLXgԂ
	QString	toXmlText() const;
	QString	infoText() const;	//	qm[hȂǂ̏Ԃ
	Node	*returnNode() const { return m_returnNode; }
	bool	isChildNode(Node *) const;
	int		childIndexOf(Node *);
	//QList<int>	nodePos();
	QPointF	rootConnectingPoint() const;	//	[gڑ_W
	QPointF	leafConnectingPoint() const;	//	[ڑ_W
	qreal	spaceForRootDirection() const;	//	[g
	qreal	spaceForLeafDirection() const;	//	[
	qreal	leftSideSpace() const;			//	
	qreal	rightSideSpace() const;			//	
	QList<QPointer<Node> >	children() const { return m_children; }
	QRectF	sceneRect() const;			//	ʒuEԂiV[Wnj
	QRectF	boundingRect() const;
	QString	linkedFileName() const { return m_linkedFileName; }
	QString	pixmapWidth() const { return m_pixmapWidth; }
	void	findNewerNode(const Node *rNode, Node *&node);
	void	findOlderNode(const Node *rNode, Node *&node);
	void	findNewestNode(Node *&node);
	void	findOldestNode(Node *&node);
	inline bool op_lt(const Node *lhs, const Node *rhs) const
	{
		return lhs->m_modifiedDT < rhs->m_modifiedDT ||
				lhs->m_modifiedDT == rhs->m_modifiedDT && lhs < rhs;
	}
	qreal 	lineHeight() const { return font().pointSize() * 2 + 8; }
	Scene	*scene();

public:
	//static bool alt() { return g_alt; }

public:
	void	selectAllChildren();
	void	expandAll(bool);		//	qm[hċAIɂׂēWJE܏
	void	setExpanded(bool b) { makeChildrenVisible(m_expanded = b); }
	void	setAlignColumn(bool b) { m_alignColumn = b; }
	void	setNodeDownward(bool b){ m_nodeDownward = b; }
	void	setNodeDownwardRcsv(bool b);	//{ m_nodeDownward = b; }
	void	makeChildrenVisible(bool b);	//	qm[h̕\\Ԑݒ
	void	setReturnNode(Node *node) { m_returnNode = QPointer<Node>(node); }
	void	setFillColor(const QColor col) { m_fillColor = col; }
	void	setNodeStyle(uchar);		//	this m[hƎqm[h̃X^CύX
	void	setCreatedDT(uint dt) { m_createdDT = dt; }
	void	setModifiedDT(uint dt) { m_modifiedDT = dt; }
	void	setModifiedDT();	// { setModifiedDT(QDateTime::currentDateTime().toTime_t()); }
	void	setToInsertMode(bool b) { m_toInsertMode = b; }
	void	setLink(const QString &);
	void	setPixmapWidth(const QString &);
	void	setTextAlign(Qt::Alignment);
	void	updateLinkIconPos();
	void	updateLinkIconPosRecursive();
	//void	updateLinkIconSize();
	Node	*addNode(Node *);	//	this ͊ Scene  add Ă̂Ƃ
	void	insert(int, Node *);	//	wԖڂ̎qƂăm[hǉ
	Node	*insertBefore(Node *);	//	this ̒OɃm[hǉ
	Node	*insertAfter(Node *);	//	this ̒Ƀm[hǉ
	Node	*firstChildNode();		//	ŏ̎qm[hԂBqǂꍇ 0 Ԃ
	Node	*firstChildNode(bool isRightSide);	//	wTCh̍ŏ̎qm[hԂBqǂꍇ 0 Ԃ
	Node	*lastChildNode();		//	wTCh̍Ō̎qm[hԂBqǂꍇ 0 Ԃ
	Node	*lastChildNode(bool isRightSide);		//	wTCh̍Ō̎qm[hԂBqǂꍇ 0 Ԃ
	Node	*lastDescendantNode(bool isRightSide);		//	wTCh̍Ō̎qm[hԂBqǂꍇ 0 Ԃ
	Node	*prevNode();		//	Om[hԂBZ̏ꍇ 0 Ԃ
	Node	*nextNode();		//	̃m[hԂBq̏ꍇ 0 Ԃ
	Node	*prevSiblingCousinNode();	//	̌Z or Ƃm[hԂBƂȂꍇ͏fԂB
	Node	*nextSiblingCousinNode();	//	̌Z or Ƃm[hԂBƂȂꍇ͏fԂB
	//Node	*pasteNext(Node *);
	QRectF	layoutChildren();	//	qm[ḧʒu߂
	QRectF	layoutChildren(bool isRightSide, bool expanded, bool = false);	//	qm[ḧʒu߂
	//void	layoutChildren(bool isRightSide, bool expanded, const qreal *wdPtr);	//	qm[ḧʒu߂
	void	removeFromChildrenList(Node *);
	Node	*removeFromScene();		//	qV[O
	void	addToScene(Scene *);		//	qV[ɒǉ
	void	freeNode();			//	qm[h̃
	Node	*moveUp();
	Node	*moveDown();
	Node	*moveLeft();
	Node	*moveRight();
	void	moveToLastChild();	//	m[hŌ̎qǂʒuɈړ
	Node	*levelUp();		//	m[h̊KwɈړ
	Node	*levelDown();	//	m[h̊KwɈړ
	void	setRightSide(bool b) { m_isRightSide = b; }
	void	setRightSideRecursive(bool b);
	void	setFloatingNode(bool b) { m_isFloatingNode = b; }
	//void	setCreatedDT(uint);
	//void	setModifiedDT(uint);
	//void	setCreatedDT(const QDataTime &);
	//void	setModifiedDT(const QDataTime &);
	void	collapse(int);
	void	switchingPixmapDisplay();
	void	onLinkIconClicked();
	void	emitSelectedNodeClicked() { emit selectedNodeClicked(this); }

public:
	//static Node *dragSource() { return g_dragSource; }
	//static Node *dropTarget() { return g_dropTarget; }
	//static void	setDropTarget(Node *node) { g_dropTarget = node; }
	//static void setShift(bool shift) { g_shift = shift; }
	//static void setDropedToSameScene(bool b) { g_dropedToSameScene = b; }
	//static void setMousePos(QPointF &p) { g_mousePos = p; }

protected:
	void	init();
	const Scene	*scene() const;
	void	setBranchPath(const QPointF &);
	void	updatePixmapPos();
	void	createBranch();
	const GlobalSettings	*globalSettings() const;

protected:
	void	mousePressEvent ( QGraphicsSceneMouseEvent * event );
	void	mouseMoveEvent ( QGraphicsSceneMouseEvent * event );
	void	mouseReleaseEvent ( QGraphicsSceneMouseEvent * event );
	void	mouseDoubleClickEvent ( QGraphicsSceneMouseEvent * mouseEvent );
	//void	contextMenuEvent ( QGraphicsSceneContextMenuEvent * event );
	void	keyPressEvent(QKeyEvent *event);
	void	focusOutEvent ( QFocusEvent * event );
#if 0
	//	hbO Scene Ɉړ
	void	dragEnterEvent ( QGraphicsSceneDragDropEvent * event );
	void	dragLeaveEvent ( QGraphicsSceneDragDropEvent * event );
	void	dragMoveEvent ( QGraphicsSceneDragDropEvent * event );
	void	dropEvent ( QGraphicsSceneDragDropEvent * event );
#endif
#if 0
	void	hoverEnterEvent ( QGraphicsSceneHoverEvent * event );
	void	hoverLeaveEvent ( QGraphicsSceneHoverEvent * event );
#endif
	void	paint ( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget );

protected slots:
	void	deleteThis();

signals:
	void	doDelete(Node *);
	void	selectedNodeClicked(Node *);
	void	openLink(const QString &);
	void	dragMove(Node *src, Node *dst, bool, bool);
	void	rootNodeMoved(Node *, const QPointF &);

private:
	bool	m_isRightSide;		//	Eɔzu
	bool	m_expanded;			//	WJ
	bool	m_alignColumn;		//	qm[h̃Jʒu𑵂
	bool	m_nodeDownward;		//	qm[hcɔzu
	bool	m_toInsertMode;		//	ҏW[hɈڍs
	bool	m_isFloatingNode;	//	t[eBOm[hH
	uchar	m_nodeStyle;		//	m[hX^C tH[N/`/...
	Qt::Alignment	m_textAlign;	//	E
	Node	*m_parentNode;		//	em[h
	//class QGraphicsLineItem	*m_branch;
	class QGraphicsPathItem	*m_branch;
	class QGraphicsPixmapItem	*m_pixmapItem;
	QString	m_linkedFileName;
	QString	m_pixmapWidth;		//	sNZ or \
	LinkItem	*m_linkItem;
	ClpsExpndButton	*m_clpsExpndButton;
	//QGraphicsPixmapItem	*m_linkItem;
	QColor	m_fillColor;		//	wiF
	uint	m_createdDT;		//	쐬t
	uint	m_modifiedDT;		//	ŏIXVt
	QPointer<Node>			m_returnNode;	//	qeɈړėꍇ̎qm[h
	QList<QPointer<Node> >	m_children;		//	q

private:
	//static Node	*g_dragSource;
	//static Node	*g_dropTarget;
	static bool	g_pressedNodeSelected;		//	}EXꂽm[hIĂ
	//static bool	g_shift;					//	hbOɃVtgL[Ă邩ǂ
	//static bool	g_alt;						//	hbOAltL[Ă邩ǂ
	//static bool	g_dropedToSameScene;		//	V[Ƀhbvꂽ

	static QPointF	g_clickedPos;			//	}EXNbNʒuiV[Wnj
	static QPointF	g_clickedItemPos;		//	NbNꂽm[hʒuiV[Wnj
	//static QPointF	g_mousePos;				//	hbv^[Qbgm[h̃}EX|C^ʒu
};

#endif // NODE_H
