#include <QtGui>
#include <QtXml>
//#include <QGLWidget>
#include "mainwindow.h"
#include "GlobalSettings.h"
#include "Scene.h"
#include "View.h"
#include "Node.h"
#include "NamedColorDlg.h"
#include "ScenePropDlg.h"
//#include "AboutDlg.h"
#include "SettingsDlg.h"
#include "PDView.h"
#include "ver.h"
#include <algorithm>

#ifdef	WIN32
#include	<windows.h>
#pragma comment(lib, "Imm32.lib")

bool shellExecute(QString fullPath)
{
	if( fullPath.isEmpty() ) return false;
	//fullPath.replace('/', '\\');
	HINSTANCE hi = ShellExecute(0 /*theApp.m_pMainWnd->m_hWnd*/, L"open",
									(LPCWSTR)fullPath.data(),
									NULL, NULL, SW_SHOWNORMAL);
	if( (int)hi <= 32 ) {
#if 0
		QString ext;
		getExtention(fullPath, ext);
		if( !ext.CompareNoCase("dsw") )
			hi = ShellExecute(theApp.m_pMainWnd->m_hWnd, "&Open with MSDev", fullPath,
										NULL, NULL, SW_SHOWNORMAL);
#endif
		if( (int)hi <= 32 ) {
			QMessageBox::warning(0, "error", QObject::tr("'%1' can't open").arg(fullPath));
			return false;
		}
	}
	return true;
}
#endif	//WIN32

static QStringList	g_windowsList;		//	I[vĂEBhẼtpX

MainWindow::MainWindow(const QString &fileName, QWidget *parent, Qt::WFlags flags)
	: QMainWindow(parent, flags)
{
	init();
	loadFile(fileName);
}
MainWindow::MainWindow(QWidget *parent, Qt::WFlags flags)
	: QMainWindow(parent, flags)
{
	init();
}
MainWindow::~MainWindow()
{
	removeFromWindowsList(m_curFullPath);
}

void MainWindow::init()
{
	setWindowIcon(QIcon(":viMind/Resources/positive.png"));
	m_isUntitled = true;
	m_isModified = false;
	m_isIMEOpenForMenu = false;
	m_isIMEOpen = false;
	m_notUpdateNodeFont = false;
	m_PDView = 0;
	m_scene = new Scene(0, 0, 1280, 960, globalSettings());
	//m_scene->setGlobalSettings(globalSettings());
	connect(m_scene, SIGNAL(modeChanged()), this, SLOT(modeChanged()));
    connect(m_scene, SIGNAL(contentsChanged()), this, SLOT(documentWasModified()));
    connect(m_scene, SIGNAL(toFind()), this, SLOT(toFind()));
    connect(m_scene, SIGNAL(toFindNext()), this, SLOT(findNext()));
    connect(m_scene, SIGNAL(toFindPrev()), this, SLOT(findPrev()));
    connect(m_scene, SIGNAL(showMessage(const QString &, int)),
   			this, SLOT(showMessage(const QString &, int)));
    connect(m_scene, SIGNAL(cleanChanged(bool)), this, SLOT(cleanChanged(bool)));
    connect(m_scene, SIGNAL(curNodeChanged(Node *)), this, SLOT(curNodeChanged(Node *)));
	connect(m_scene, SIGNAL(openLink(const QString &)), this, SLOT(openLink(const QString &)));
	connect(m_scene, SIGNAL(curFileName(QString &)), this, SLOT(curFileName(QString &)));
    //connect(m_scene, SIGNAL(nodeCreated(Node *)), this, SLOT(nodeCreated(Node *)));
	m_view = new View(m_scene);
	//m_view->setViewport(new QGLWidget(QGLFormat(QGL::SampleBuffers)));
	m_view->setDragMode(QGraphicsView::ScrollHandDrag);		//	NbNhbOɂXN[
	m_view->setRenderHints(QPainter::Antialiasing);
    setCentralWidget(m_view);
    //m_scene->createChildNode(0, tr("Root"));
    connect(m_view, SIGNAL(showMessage(const QString &, int)),
   			this, SLOT(showMessage(const QString &, int)));
	connect(m_scene, SIGNAL(toUpdateView()), m_view->viewport(), SLOT(update()));

	createActions();		//	m_scene ւRlNĝŁAm_scene ɃR[邱
	createMenus();
    createToolBars();
    createDockWindows();
    setupStatusBar();
    readSettings();			//	createActions() ̌ɃR[邱
    m_scene->updateBackground();
    m_scene->setRootNodeDefaultFont();		//	readSettings() ̌ɃR[邱
    m_scene->rootNode()->setNodeStyle(globalSettings()->m_nodeStyle);
    curNodeChanged(m_scene->rootNode());

    modeChanged();

	updateWindowTitle();
	setAttribute(Qt::WA_DeleteOnClose);		//	N[YɃf[g
	setAcceptDrops(true);		//	hbvt for t@Chbv
    statusBar()->showMessage(tr("Ready"), 5000);
}

void MainWindow::showMessage(const QString &mess, int limit)
{
	statusBar()->showMessage(mess, limit);
}
void MainWindow::createActions()
{
    m_newAct = new QAction(QIcon(":viMind/Resources/new.png"), tr("&New"), this);
    //m_newAct->setIconText(tr("new doc"));
    m_newAct->setShortcuts(QKeySequence::New);
    m_newAct->setToolTip(tr("new map"));
    m_newAct->setStatusTip(tr("Create a new map"));
    connect(m_newAct, SIGNAL(triggered()), this, SLOT(newFile()));

    m_openAct = new QAction(QIcon(":viMind/Resources/open.png"), tr("&Open..."), this);
    m_openAct->setShortcuts(QKeySequence::Open);
    m_openAct->setToolTip(tr("open map"));
    m_openAct->setStatusTip(tr("Open an existing file"));
    connect(m_openAct, SIGNAL(triggered()), this, SLOT(open()));

    m_saveAct = new QAction(QIcon(":viMind/Resources/save.png"), tr("&Save"), this);
    m_saveAct->setShortcuts(QKeySequence::Save);
    m_saveAct->setToolTip(tr("save map"));
    m_saveAct->setStatusTip(tr("Save the map to disk"));
    connect(m_saveAct, SIGNAL(triggered()), this, SLOT(save()));

    m_saveAsAct = new QAction(tr("Save&As..."), this);
    m_saveAsAct->setShortcuts(QKeySequence::SaveAs);
    m_saveAsAct->setToolTip(tr("save as new name"));
    m_saveAsAct->setStatusTip(tr("Save the map under a new fileName"));
    connect(m_saveAsAct, SIGNAL(triggered()), this, SLOT(saveAs()));

    m_saveAllAct = new QAction(tr("SaveA&ll"), this);
    m_saveAllAct->setToolTip(tr("save all maps"));
    m_saveAllAct->setStatusTip(tr("Save all maps to disk"));
    connect(m_saveAllAct, SIGNAL(triggered()), this, SLOT(saveAll()));

    m_saveAllExitAct = new QAction(tr("SaveAllExi&t"), this);
    m_saveAllExitAct->setToolTip(tr("Save all maps and Exit"));
    m_saveAllExitAct->setStatusTip(tr("Save all maps to disk and Exit"));
    connect(m_saveAllExitAct, SIGNAL(triggered()), this, SLOT(saveAllExit()));

    m_closeAct = new QAction(tr("&Close"), this);
    m_closeAct->setShortcuts(QKeySequence::Close);
    m_closeAct->setToolTip(tr("close this map"));
    m_closeAct->setStatusTip(tr("close this map"));
    connect(m_closeAct, SIGNAL(triggered()), this, SLOT(close()));

    m_exitAct = new QAction(tr("e&Xit"), this);
    m_exitAct->setShortcut(QKeySequence(Qt::ALT + Qt::CTRL + Qt::Key_F4));
    m_exitAct->setToolTip(tr("close all and exit"));
    m_exitAct->setStatusTip(tr("close all maps and exit"));
    connect(m_exitAct, SIGNAL(triggered()), this, SLOT(exit()));

    m_addFavMapAct = new QAction(tr("AddToFavorite"), this);
    m_addFavMapAct->setToolTip(tr("Add to the favorite Map files"));
    m_addFavMapAct->setStatusTip(tr("Add to the favorite Map files"));
    connect(m_addFavMapAct, SIGNAL(triggered()), this, SLOT(addToFavoriteFiles()));

    //	RecentFilesMenu ̂߂̏
    for (int i = 0; i < MaxRecentFiles; ++i) {
        m_recentFileActs[i] = new QAction(this);
        m_recentFileActs[i]->setVisible(false);
        connect(m_recentFileActs[i], SIGNAL(triggered()), this, SLOT(openRecentFile()));
    }
    //	FavoriteFilesMenu ̂߂̏
    for (int i = 0; i < MaxFavoriteFiles; ++i) {
        m_favoriteFileActs[i] = new QAction(this);
        m_favoriteFileActs[i]->setVisible(false);
        connect(m_favoriteFileActs[i], SIGNAL(triggered()), this, SLOT(openFavoriteFile()));
    }

    m_scenePropAct = new QAction(tr("ScenePropert&y..."), this);
    m_scenePropAct->setToolTip(tr("scene property"));
    m_scenePropAct->setStatusTip(tr("confirm and/or edit Scene Properties"));
    connect(m_scenePropAct, SIGNAL(triggered()), this, SLOT(sceneProp()));

    m_printAct = new QAction(tr("&Print"), this);
    m_printAct->setShortcuts(QKeySequence::Print);
    m_printAct->setToolTip(tr("print map"));
    m_printAct->setStatusTip(tr("Print the map"));
    connect(m_printAct, SIGNAL(triggered()), this, SLOT(print()));

    m_printPreviewAct = new QAction(tr("Print Pre&view"), this);
    m_printPreviewAct->setToolTip(tr("print preview"));
    m_printPreviewAct->setStatusTip(tr("Print previrew the map"));
    connect(m_printPreviewAct, SIGNAL(triggered()), this, SLOT(printPreview()));

    const QString todayStr1 = QDate::currentDate().toString("yy/MM/dd" /*Qt::DefaultLocaleShortDate*/);
    m_editInsertDateAct = new QAction(tr("today(&1) \"%1\"").arg(todayStr1), this);
    connect(m_editInsertDateAct, SIGNAL(triggered()), m_scene, SLOT(editInputDate()));

    m_editInsertImageAct = new QAction(tr("&Image"), this);
    connect(m_editInsertImageAct, SIGNAL(triggered()), m_scene, SLOT(editInputImage()));

	m_undoAct = new QAction(QIcon(":viMind/Resources/undo.png"), tr("&Undo"), this);
    m_undoAct->setShortcuts(QKeySequence::Undo);
    m_undoAct->setToolTip(tr("undo"));
    m_undoAct->setStatusTip(tr("undo edit command"));
	m_undoAct->setEnabled(false);
    connect(m_undoAct, SIGNAL(triggered()), m_scene, SLOT(undo()));
    connect(m_scene, SIGNAL(canUndoChanged(bool)), m_undoAct, SLOT(setEnabled(bool)));

	m_redoAct = new QAction(QIcon(":viMind/Resources/redo.png"), tr("&Redo"), this);
    m_redoAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_R));
    //m_redoAct->setShortcuts(QKeySequence::Redo);
    m_redoAct->setToolTip(tr("redo"));
    m_redoAct->setStatusTip(tr("redo edit commande"));
	m_redoAct->setEnabled(false);
    connect(m_redoAct, SIGNAL(triggered()), m_scene, SLOT(redo()));
    connect(m_scene, SIGNAL(canRedoChanged(bool)), m_redoAct, SLOT(setEnabled(bool)));

    m_deleteAct = new QAction(QIcon(":viMind/Resources/delete.png"), tr("&Delete"), this);
    m_deleteAct->setShortcuts(QKeySequence::Delete);
    m_deleteAct->setToolTip(tr("Delete"));
    m_deleteAct->setStatusTip(tr("Delete the current selected nodes"));
    connect(m_deleteAct, SIGNAL(triggered()), m_scene, SLOT(deleteSelectedItems()));

    m_cutAct = new QAction(QIcon(":viMind/Resources/cut.png"), tr("Cu&t"), this);
    m_cutAct->setShortcuts(QKeySequence::Cut);
    m_cutAct->setToolTip(tr("cut"));
    m_cutAct->setStatusTip(tr("Cut the current selection's contents to the clipboard"));
    connect(m_cutAct, SIGNAL(triggered()), m_scene, SLOT(cut()));

    m_copyAct = new QAction(QIcon(":viMind/Resources/copy.png"), tr("&Copy"), this);
    m_copyAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_C));
    //m_copyAct->setShortcuts(QKeySequence::Copy);
    m_copyAct->setToolTip(tr("copy"));
    m_copyAct->setStatusTip(tr("Copy the current selection's contents to the clipboard"));
    connect(m_copyAct, SIGNAL(triggered()), m_scene, SLOT(copy()));

    m_pasteAfterAct = new QAction(QIcon(":viMind/Resources/paste.png"), tr("&PasteAfter"), this);
    m_pasteAfterAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_V));
    m_pasteAfterAct->setToolTip(tr("paste"));
    m_pasteAfterAct->setStatusTip(tr("Paste the clipboard's contents into the current selection"));
    connect(m_pasteAfterAct, SIGNAL(triggered()), m_scene, SLOT(paste()));

    m_pasteChildAct = new QAction(tr("Pas&teChild"), this);
    m_pasteChildAct->setShortcut(QKeySequence(Qt::SHIFT + Qt::CTRL + Qt::Key_V));
    m_pasteChildAct->setToolTip(tr("paste child"));
    m_pasteChildAct->setStatusTip(tr("Paste the clipboard's contents as current node's child"));
    connect(m_pasteChildAct, SIGNAL(triggered()), m_scene, SLOT(pasteChildCB()));

    m_selectAllAct = new QAction(tr("Select&All"), this);
    m_selectAllAct->setShortcuts(QKeySequence::SelectAll);
    m_selectAllAct->setToolTip(tr("Select All Nodes"));
    m_selectAllAct->setStatusTip(tr("Select All Nodes"));
    connect(m_selectAllAct, SIGNAL(triggered()), m_scene, SLOT(selectAll()));

    m_editNodeAct = new QAction(tr("&EditNodeText"), this);
    m_editNodeAct->setShortcut(QKeySequence(Qt::Key_F2));
    m_editNodeAct->setStatusTip(tr("Edit selected node's text"));
    connect(m_editNodeAct, SIGNAL(triggered()), m_scene, SLOT(editNode()));

    m_editNodeAndSelectAct = new QAction(tr("&EditNodeAndSelectText"), this);
    m_editNodeAndSelectAct->setShortcut(QKeySequence(Qt::SHIFT + Qt::Key_F2));
    m_editNodeAndSelectAct->setStatusTip(tr("Edit selected node's text, and select text"));
    connect(m_editNodeAndSelectAct, SIGNAL(triggered()), m_scene, SLOT(editNodeAndSelect()));

    m_moveNodeLeftAct = new QAction(tr("&Left"), this);
    m_moveNodeLeftAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_Left));
    m_moveNodeLeftAct->setStatusTip(tr("move current node to left"));
    connect(m_moveNodeLeftAct, SIGNAL(triggered()), m_scene, SLOT(moveNodeLeft()));

    m_moveNodeRightAct = new QAction(tr("&Right"), this);
    m_moveNodeRightAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_Right));
    m_moveNodeRightAct->setStatusTip(tr("move current node to Right"));
    connect(m_moveNodeRightAct, SIGNAL(triggered()), m_scene, SLOT(moveNodeRight()));

    m_moveNodeUpAct = new QAction(tr("&Up"), this);
    m_moveNodeUpAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_Up));
    m_moveNodeUpAct->setStatusTip(tr("move current node to Up"));
    connect(m_moveNodeUpAct, SIGNAL(triggered()), m_scene, SLOT(moveNodeUp()));

    m_moveNodeDownAct = new QAction(tr("&Down"), this);
    m_moveNodeDownAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_Down));
    m_moveNodeDownAct->setStatusTip(tr("move current node to Down"));
    connect(m_moveNodeDownAct, SIGNAL(triggered()), m_scene, SLOT(moveNodeDown()));

    m_findAct = new QAction(QIcon(":viMind/Resources/find.png"), tr("&Find"), this);
    m_findAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_F));
    m_findAct->setToolTip(tr("find"));
    m_findAct->setStatusTip(tr("Find stirng"));
    connect(m_findAct, SIGNAL(triggered()), this, SLOT(toFind()));

    m_findNextAct = new QAction(QIcon(":viMind/Resources/findNext.png"), tr("find&Next"), this);
    m_findNextAct->setShortcuts(QKeySequence::FindNext);
    m_findNextAct->setToolTip(tr("find next"));
    m_findNextAct->setStatusTip(tr("Find next matched node"));
    connect(m_findNextAct, SIGNAL(triggered()), this, SLOT(findNext()));

    m_findPrevAct = new QAction(QIcon(":viMind/Resources/findPrev.png"), tr("find&Prev"), this);
    m_findPrevAct->setShortcuts(QKeySequence::FindPrevious);
    m_findPrevAct->setStatusTip(tr("Find prev matched node"));
    connect(m_findPrevAct, SIGNAL(triggered()), this, SLOT(findPrev()));

    m_insertParentNodeAct = new QAction(tr("&ParentNode"), this);
    //m_insertParentNodeAct->setShortcut(QKeySequence(Qt::Key_Insert));
    //m_insertParentNodeAct->setShortcut(QKeySequence(Qt::SHIFT + Qt::Key_Backspace));
    m_insertParentNodeAct->setShortcut(QKeySequence(Qt::SHIFT + Qt::Key_Insert));
    //m_insertParentNodeAct->setShortcut(QKeySequence("Shift+Insert"));
    m_insertParentNodeAct->setStatusTip(tr("insert a Parent node"));
    connect(m_insertParentNodeAct, SIGNAL(triggered()), m_scene, SLOT(addParentNode()));

    m_insertChildNodeAct = new QAction(tr("&ChildNode"), this);
    m_insertChildNodeAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_Insert));
    m_insertChildNodeAct->setStatusTip(tr("insert a child node"));
    connect(m_insertChildNodeAct, SIGNAL(triggered()), m_scene, SLOT(addChildNode()));

    m_insertNextNodeAct = new QAction(tr("&NextNode"), this);
    m_insertNextNodeAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_Return));
    m_insertNextNodeAct->setStatusTip(tr("insert a next node"));
    connect(m_insertNextNodeAct, SIGNAL(triggered()), m_scene, SLOT(openNextNode()));

    m_insertPrevNodeAct = new QAction(tr("&PrevNode"), this);
    m_insertPrevNodeAct->setShortcut(QKeySequence(Qt::SHIFT + Qt::Key_Return));
    m_insertPrevNodeAct->setStatusTip(tr("insert a prev node"));
    connect(m_insertPrevNodeAct, SIGNAL(triggered()), m_scene, SLOT(openPrevNode()));

    m_insertFloatingNodeAct = new QAction(tr("&FloatingNode"), this);
    m_insertFloatingNodeAct->setShortcut(QKeySequence(Qt::ALT + Qt::Key_Return));
    m_insertFloatingNodeAct->setStatusTip(tr("insert a floating node"));
    connect(m_insertFloatingNodeAct, SIGNAL(triggered()), m_scene, SLOT(addFloatingNode()));

    m_insertLinkAct = new QAction(tr("&Link"), this);
    m_insertLinkAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_K));
    m_insertLinkAct->setStatusTip(tr("insert a link"));
    connect(m_insertLinkAct, SIGNAL(triggered()), m_scene, SLOT(insertLink()));

    m_insertPictureAct = new QAction(tr("&Picture"), this);
    m_insertPictureAct->setShortcut(QKeySequence(Qt::ALT + Qt::CTRL + Qt::Key_K));
    m_insertPictureAct->setStatusTip(tr("insert a picture"));
    connect(m_insertPictureAct, SIGNAL(triggered()), m_scene, SLOT(insertPicture()));

    m_insertFileLinkAct = new QAction(tr("&FileLink"), this);
    m_insertFileLinkAct->setShortcut(QKeySequence(Qt::SHIFT + Qt::CTRL + Qt::Key_K));
    m_insertFileLinkAct->setStatusTip(tr("insert a file link"));
    connect(m_insertFileLinkAct, SIGNAL(triggered()), m_scene, SLOT(insertFileLink()));

    m_expandAllAct = new QAction(tr("&ExpandAll"), this);
    m_expandAllAct->setShortcut(QKeySequence(Qt::ALT + Qt::Key_End));
    m_expandAllAct->setStatusTip(tr("expand all nodes"));
    connect(m_expandAllAct, SIGNAL(triggered()), m_scene, SLOT(expandAll()));

    m_collapseAllAct = new QAction(tr("&CollapseAll"), this);
    m_collapseAllAct->setShortcut(QKeySequence(Qt::ALT + Qt::Key_Home));
    m_collapseAllAct->setStatusTip(tr("collapse all nodes"));
    connect(m_collapseAllAct, SIGNAL(triggered()), m_scene, SLOT(collapseAll()));

    m_collapseExpandAct = new QAction(tr("CollapseExpand"), this);
    m_collapseExpandAct->setShortcut(QKeySequence(Qt::Key_Space));
    m_collapseExpandAct->setStatusTip(tr("collapse or expand child nodes"));
    connect(m_collapseExpandAct, SIGNAL(triggered()), m_scene, SLOT(doCollapseExpand()));

    m_collapse1Act = new QAction(tr("CollapseUnderChild"), this);
    m_collapse1Act->setShortcut(QKeySequence(Qt::Key_1));
    m_collapse1Act->setStatusTip(tr("collapse under child nodes"));
    connect(m_collapse1Act, SIGNAL(triggered()), m_scene, SLOT(doCollapse1()));

    m_collapse2Act = new QAction(tr("CollapseUnderGrandchild"), this);
    m_collapse2Act->setShortcut(QKeySequence(Qt::Key_2));
    m_collapse2Act->setStatusTip(tr("collapse under grandchild nodes"));
    connect(m_collapse2Act, SIGNAL(triggered()), m_scene, SLOT(doCollapse2()));

    m_collapse3Act = new QAction(tr("CollapseUnderGreatGrandchild"), this);
    m_collapse3Act->setShortcut(QKeySequence(Qt::Key_3));
    m_collapse3Act->setStatusTip(tr("collapse under great-grandchild nodes"));
    connect(m_collapse3Act, SIGNAL(triggered()), m_scene, SLOT(doCollapse3()));

    m_viewRotateResetAct = new QAction(tr("resetView&Rotation"), this);
    m_viewRotateResetAct->setStatusTip(tr("reset view rotation"));
    connect(m_viewRotateResetAct, SIGNAL(triggered()), m_view, SLOT(viewRotateReset()));

    m_viewScaleResetAct = new QAction(tr("scale &100%"), this);
    m_viewScaleResetAct->setStatusTip(tr("reset view scale to 100%"));
    connect(m_viewScaleResetAct, SIGNAL(triggered()), m_view, SLOT(viewScaleReset()));

    m_viewZoomInAct = new QAction(tr("zoomIn(&+)"), this);
    m_viewZoomInAct->setStatusTip(tr("zoom in"));
    m_viewZoomInAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_Plus));
    connect(m_viewZoomInAct, SIGNAL(triggered()), m_view, SLOT(viewZoomIn()));

    m_viewZoomOutAct = new QAction(tr("zoomOut(&-)"), this);
    m_viewZoomOutAct->setStatusTip(tr("zoom out"));
    m_viewZoomOutAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_Minus));
    connect(m_viewZoomOutAct, SIGNAL(triggered()), m_view, SLOT(viewZoomOut()));

    m_viewAutoZoomAct = new QAction(tr("&AutoZoom"), this);
    m_viewAutoZoomAct->setStatusTip(tr("auto zoom"));
    m_viewAutoZoomAct->setCheckable(true);
    m_viewAutoZoomAct->setChecked(false);
    //m_viewAutoZoomAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_Minus));
    connect(m_viewAutoZoomAct, SIGNAL(triggered(bool)), m_view, SLOT(viewAutoZoom(bool)));

    m_viewFullScreenAct = new QAction(tr("&FullScreen"), this);
    m_viewFullScreenAct->setCheckable(true);
    m_viewFullScreenAct->setChecked(false);
    m_viewFullScreenAct->setStatusTip(tr("switch to full screen mode"));
    m_viewFullScreenAct->setShortcut(QKeySequence(Qt::Key_F11));
    connect(m_viewFullScreenAct, SIGNAL(triggered(bool)), this, SLOT(fullScreen(bool)));

    m_viewPDAct = new QAction(tr("&PDView"), this);
    m_viewPDAct->setCheckable(true);
    m_viewPDAct->setChecked(false);
    m_viewPDAct->setStatusTip(tr("show PD view"));
    m_viewPDAct->setShortcut(QKeySequence(Qt::Key_F12));
    connect(m_viewPDAct, SIGNAL(triggered(bool)), this, SLOT(viewPD(bool)));

    m_formatAlignLeftAct = new QAction(tr("Align&Left"), this);
    m_formatAlignLeftAct->setStatusTip(tr("Align left"));
    m_formatAlignLeftAct->setCheckable(true);
    connect(m_formatAlignLeftAct, SIGNAL(triggered()), m_scene, SLOT(formatALignLeft()));

    m_formatAlignCenterAct = new QAction(tr("Align&Center"), this);
    m_formatAlignCenterAct->setStatusTip(tr("Align center"));
    m_formatAlignCenterAct->setCheckable(true);
    connect(m_formatAlignCenterAct, SIGNAL(triggered()), m_scene, SLOT(formatALignCenter()));

    m_formatAlignRightAct = new QAction(tr("Align&Right"), this);
    m_formatAlignRightAct->setStatusTip(tr("Align right"));
    m_formatAlignRightAct->setCheckable(true);
    connect(m_formatAlignRightAct, SIGNAL(triggered()), m_scene, SLOT(formatALignRight()));

    m_alignGroup = new QActionGroup(this);
    m_alignGroup->setExclusive(true);
    m_alignGroup->addAction(m_formatAlignLeftAct);
    m_alignGroup->addAction(m_formatAlignCenterAct);
    m_alignGroup->addAction(m_formatAlignRightAct);

    m_formatAlignColumnAct = new QAction(tr("Align&Column"), this);
    m_formatAlignColumnAct->setStatusTip(tr("Align descendants' column"));
    m_formatAlignColumnAct->setCheckable(true);
    connect(m_formatAlignColumnAct, SIGNAL(triggered()), m_scene, SLOT(formatALignColumn()));

    m_formatForkAct = new QAction(tr("&Fork"), this);
    m_formatForkAct->setStatusTip(tr("Fork node style"));
    m_formatForkAct->setCheckable(true);
    connect(m_formatForkAct, SIGNAL(triggered()), m_scene, SLOT(formatFork()));

    m_formatRectAct = new QAction(tr("&Rect"), this);
    m_formatRectAct->setStatusTip(tr("Rect node style"));
    m_formatRectAct->setCheckable(true);
    connect(m_formatRectAct, SIGNAL(triggered()), m_scene, SLOT(formatRect()));

    m_formatRoundRectAct = new QAction(tr("&RoundRect"), this);
    m_formatRoundRectAct->setStatusTip(tr("RoundRect node style"));
    m_formatRoundRectAct->setCheckable(true);
    connect(m_formatRoundRectAct, SIGNAL(triggered()), m_scene, SLOT(formatRoundRect()));

    m_formatCircleRectAct = new QAction(tr("&CircleRect"), this);
    m_formatCircleRectAct->setStatusTip(tr("CircleRect node style"));
    m_formatCircleRectAct->setCheckable(true);
    connect(m_formatCircleRectAct, SIGNAL(triggered()), m_scene, SLOT(formatCircleRect()));

    m_nodeStyleGroup = new QActionGroup(this);
    m_nodeStyleGroup->setExclusive(true);
    m_nodeStyleGroup->addAction(m_formatForkAct);
    m_nodeStyleGroup->addAction(m_formatRectAct);
    m_nodeStyleGroup->addAction(m_formatRoundRectAct);
    m_nodeStyleGroup->addAction(m_formatCircleRectAct);

    m_nodeDownwardAct = new QAction(tr("node&Downword"), this);
    m_nodeDownwardAct->setStatusTip(tr("put node downward"));
    m_nodeDownwardAct->setCheckable(true);
    connect(m_nodeDownwardAct, SIGNAL(triggered(bool)), m_scene, SLOT(nodeDownward(bool)));

    m_naviRootAct = new QAction(tr("&RootNode"), this);
    m_naviRootAct->setStatusTip(tr("set current node to the Root node"));
    m_naviRootAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_Home));
    connect(m_naviRootAct, SIGNAL(triggered()), m_scene, SLOT(doCurRoot()));

    m_naviLastAct = new QAction(tr("&Last"), this);
    m_naviLastAct->setStatusTip(tr("set current node to the Last node"));
    m_naviLastAct->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_End));
    connect(m_naviLastAct, SIGNAL(triggered()), m_scene, SLOT(doCurLast()));

    m_naviNextTreeAct = new QAction(tr("&NextTree"), this);
    m_naviNextTreeAct->setStatusTip(tr("set current node to the Next tree"));
    m_naviNextTreeAct->setShortcut(QKeySequence(Qt::Key_Tab));
    connect(m_naviNextTreeAct, SIGNAL(triggered()), m_scene, SLOT(doCurNextTree()));

    m_naviPrevTreeAct = new QAction(tr("&PrevTree"), this);
    m_naviPrevTreeAct->setStatusTip(tr("set current node to the Prev tree"));
    m_naviPrevTreeAct->setShortcut(QKeySequence(Qt::SHIFT + Qt::Key_Tab));
    connect(m_naviPrevTreeAct, SIGNAL(triggered()), m_scene, SLOT(doCurPrevTree()));

    m_naviForwardNodeAct = new QAction(tr("&ForwardNode"), this);
    m_naviForwardNodeAct->setStatusTip(tr("move current node forward"));
    m_naviForwardNodeAct->setShortcut(QKeySequence(Qt::ALT + Qt::Key_Right));
    connect(m_naviForwardNodeAct, SIGNAL(triggered()), m_scene, SLOT(doCurForwardNode()));

    m_naviBackwardNodeAct = new QAction(tr("&BackwardNode"), this);
    m_naviBackwardNodeAct->setStatusTip(tr("move current node forward"));
    m_naviBackwardNodeAct->setShortcut(QKeySequence(Qt::ALT + Qt::Key_Left));
    connect(m_naviBackwardNodeAct, SIGNAL(triggered()), m_scene, SLOT(doCurBackwardNode()));

    m_settingsAct = new QAction(QIcon(":viMind/Resources/settings.png"), tr("&Settings..."), this);
    m_settingsAct->setStatusTip(tr("viMind settings"));
    connect(m_settingsAct, SIGNAL(triggered()), this, SLOT(settings()));

    m_howToUseAct = new QAction(tr("&HowToUse"), this);
    m_howToUseAct->setStatusTip(tr("open viMindHowToUse.vmd"));
    connect(m_howToUseAct, SIGNAL(triggered()), this, SLOT(howToUse()));

    m_revRefAct = new QAction(tr("&RevReference"), this);
    m_revRefAct->setStatusTip(tr("open viMindRevRef.vmd"));
    connect(m_revRefAct, SIGNAL(triggered()), this, SLOT(revRef()));

    m_viMindSiteAct = new QAction(tr("ViMind &Web Site"), this);
    m_viMindSiteAct->setStatusTip(tr("open viMind Web Site"));
    connect(m_viMindSiteAct, SIGNAL(triggered()), this, SLOT(viMindWebSite()));

    m_aboutAct = new QAction(tr("&AboutViMind..."), this);
    m_aboutAct->setStatusTip(tr("about viMind"));
    connect(m_aboutAct, SIGNAL(triggered()), this, SLOT(about()));

}
void MainWindow::createMenus()
{
    QMenu *fileMenu = menuBar()->addMenu(tr("&File"));
    connect(fileMenu, SIGNAL(aboutToShow()), this, SLOT(turnOffIME()));
    fileMenu->addAction(m_newAct);
    fileMenu->addAction(m_openAct);
    fileMenu->addAction(m_saveAct);
    fileMenu->addAction(m_saveAsAct);
    fileMenu->addAction(m_saveAllAct);
    fileMenu->addAction(m_saveAllExitAct);
    fileMenu->addAction(m_closeAct);

#if 1
    fileMenu->addSeparator();
    QMenu *recentFile = fileMenu->addMenu(tr("RecentFiles (&1)"));
    //	RecentFilesMenu ACeǉ
    for (int i = 0; i < MaxRecentFiles; ++i)
        recentFile->addAction(m_recentFileActs[i]);
#else
    m_separatorMRUAct = fileMenu->addSeparator();
    //	RecentFilesMenu ACeǉ
    for (int i = 0; i < MaxRecentFiles; ++i)
        fileMenu->addAction(m_recentFileActs[i]);
#endif
    updateRecentFileActions();
    QMenu *favMap = fileMenu->addMenu(tr("&FavoriteMap"));
    	favMap->addAction(m_addFavMapAct);
    	favMap->addSeparator();
	    for (int i = 0; i < MaxFavoriteFiles; ++i)
	        favMap->addAction(m_favoriteFileActs[i]);
	    updateFavoriteFileActions();
    fileMenu->addSeparator();
    fileMenu->addAction(m_scenePropAct);
    fileMenu->addSeparator();
    fileMenu->addAction(m_printAct);
    fileMenu->addAction(m_printPreviewAct);
    fileMenu->addSeparator();
    fileMenu->addAction(m_exitAct);

    QMenu *editMenu = menuBar()->addMenu(tr("&Edit"));
    connect(editMenu, SIGNAL(aboutToShow()), this, SLOT(turnOffIME()));
    editMenu->addAction(m_undoAct);
    editMenu->addAction(m_redoAct);
    editMenu->addAction(m_deleteAct);
    editMenu->addAction(m_cutAct);
    editMenu->addAction(m_copyAct);
    editMenu->addAction(m_pasteAfterAct);
    editMenu->addAction(m_pasteChildAct);
    editMenu->addAction(m_selectAllAct);
    //QMenu *editInput = editMenu->addMenu(tr("&Input"));
    //editInput->addAction(m_editInsertDateAct);
    //editInput->addAction(m_editInsertImageAct);
    editMenu->addSeparator();
    editMenu->addAction(m_editNodeAct);
    editMenu->addAction(m_editNodeAndSelectAct);
    QMenu *moveNodeMenu = editMenu->addMenu(tr("&MoveNode"));
    moveNodeMenu->addAction(m_moveNodeLeftAct);
    moveNodeMenu->addAction(m_moveNodeRightAct);
    moveNodeMenu->addAction(m_moveNodeUpAct);
    moveNodeMenu->addAction(m_moveNodeDownAct);

    QMenu *insertMenu = menuBar()->addMenu(tr("&Insert"));
    connect(insertMenu, SIGNAL(aboutToShow()), this, SLOT(turnOffIME()));
    insertMenu->addAction(m_insertParentNodeAct);
    insertMenu->addAction(m_insertChildNodeAct);
    insertMenu->addAction(m_insertNextNodeAct);
    insertMenu->addAction(m_insertPrevNodeAct);
    insertMenu->addAction(m_insertFloatingNodeAct);
    insertMenu->addSeparator();
    insertMenu->addAction(m_insertLinkAct);
    insertMenu->addAction(m_insertFileLinkAct);
    insertMenu->addAction(m_editInsertDateAct);

    QMenu *formatMenu = menuBar()->addMenu(tr("Forma&t"));
    formatMenu->addAction(m_formatForkAct);
    formatMenu->addAction(m_formatRectAct);
    formatMenu->addAction(m_formatRoundRectAct);
    formatMenu->addAction(m_formatCircleRectAct);
    formatMenu->addAction(m_formatAlignLeftAct);
    formatMenu->addAction(m_formatAlignCenterAct);
    formatMenu->addAction(m_formatAlignRightAct);
    formatMenu->addAction(m_formatAlignColumnAct);
    formatMenu->addAction(m_nodeDownwardAct);

    QMenu *naviMenu = menuBar()->addMenu(tr("Navi&gation"));
    naviMenu->addAction(m_naviRootAct);
    naviMenu->addAction(m_naviLastAct);
    naviMenu->addAction(m_naviNextTreeAct);
    naviMenu->addAction(m_naviPrevTreeAct);
    naviMenu->addAction(m_naviForwardNodeAct);
    naviMenu->addAction(m_naviBackwardNodeAct);
    naviMenu->addSeparator();
    naviMenu->addAction(m_expandAllAct);
    naviMenu->addAction(m_collapseAllAct);
    naviMenu->addAction(m_collapseExpandAct);
    naviMenu->addAction(m_collapse1Act);
    naviMenu->addAction(m_collapse2Act);
    naviMenu->addAction(m_collapse3Act);

    QMenu *findMenu = menuBar()->addMenu(tr("Fi&nd"));
    findMenu->addAction(m_findAct);
    findMenu->addAction(m_findNextAct);
    findMenu->addAction(m_findPrevAct);

    QMenu *viewMenu = menuBar()->addMenu(tr("&View"));
    viewMenu->addAction(m_viewAutoZoomAct);
    viewMenu->addAction(m_viewZoomInAct);
    viewMenu->addAction(m_viewZoomOutAct);
    viewMenu->addAction(m_viewScaleResetAct);
    viewMenu->addAction(m_viewRotateResetAct);
    viewMenu->addAction(m_viewFullScreenAct);
    viewMenu->addAction(m_viewPDAct);

    m_windowMenu = menuBar()->addMenu(tr("&Window"));
    //	RecentFilesMenu ̂߂̏
    for (int i = 0; i < MaxRecentWindows; ++i) {
        m_recentWindowActs[i] = new QAction(this);
        m_recentWindowActs[i]->setVisible(false);
        connect(m_recentWindowActs[i], SIGNAL(triggered()),
                this, SLOT(openRecentWindow()));
        m_windowMenu->addAction(m_recentWindowActs[i]);
    }
    connect(m_windowMenu, SIGNAL(aboutToShow()), this, SLOT(updateRecentWindowsActions()));

    QMenu *otherMenu = menuBar()->addMenu(tr("&Other"));
    otherMenu->addAction(m_settingsAct);
    otherMenu->addSeparator();
    otherMenu->addAction(m_howToUseAct);
    otherMenu->addAction(m_revRefAct);
    otherMenu->addSeparator();
    otherMenu->addAction(m_viMindSiteAct);
    otherMenu->addAction(m_aboutAct);
}
void MainWindow::createToolBars()
{
    QToolBar *fileToolBar = addToolBar(tr("File"));
    fileToolBar->setObjectName("File");
    fileToolBar->addAction(m_newAct);
    fileToolBar->addAction(m_openAct);
    fileToolBar->addAction(m_saveAct);

    QToolBar *editToolBar = addToolBar(tr("Edit"));
    editToolBar->addAction(m_undoAct);
    editToolBar->addAction(m_redoAct);
    editToolBar->addAction(m_deleteAct);
    editToolBar->addAction(m_cutAct);
    editToolBar->addAction(m_copyAct);
    editToolBar->addAction(m_pasteAfterAct);
    //editToolBar->addAction(m_pasteChildAct);

    m_findToolBar = addToolBar(tr("Find"));
    m_findToolBar->addWidget(m_findCombo = new QComboBox);
    m_findCombo->setEditable(true);
    connect(m_findCombo->lineEdit(), SIGNAL(returnPressed()), this, SLOT(findNext()));
    m_findCombo->setMinimumContentsLength(12);
    m_findCombo->lineEdit()->installEventFilter(this);		//	for Esc to cancel
#if 0
	QRect r = m_findCombo->geometry();
	r.setWidth(240);
	m_findCombo->setGeometry(r);
#endif
    m_findToolBar->addAction(m_findNextAct);

    QToolBar *formatToolBar = addToolBar(tr("Format"));
    //	tHg
    m_fontCombo = new QFontComboBox();
    formatToolBar->addWidget(m_fontCombo);
    connect(m_fontCombo, SIGNAL(currentFontChanged(QFont)),
            this, SLOT(currentFontChanged(QFont)));
    //	tHgTCY
    m_fontSizeCombo = new QComboBox;
    m_fontSizeCombo->setEditable(true);
    for (int i = 8; i <= 30; i = i + 2)
        m_fontSizeCombo->addItem(QString().setNum(i));
    for (int i = 40; i <= 60; i = i + 10)
        m_fontSizeCombo->addItem(QString().setNum(i));
    m_fontSizeCombo->addItem(QString().setNum(100));
    QIntValidator *validator = new QIntValidator(2, 999, this);
    m_fontSizeCombo->setValidator(validator);
    formatToolBar->addWidget(m_fontSizeCombo);
    connect(m_fontSizeCombo, SIGNAL(currentIndexChanged(QString)),
            this, SLOT(fontSizeChanged(QString)));
	//	hԂF
    m_fillColorToolButton = new QToolButton;
    m_fillColorToolButton->setToolTip(tr("main fill color"));
    m_fillColorToolButton->setPopupMode(QToolButton::MenuButtonPopup);
    m_fillColorToolButton->setMenu(createColorMenu(SLOT(fillColorChanged()), Qt::white));
    m_fillColorAct = m_fillColorToolButton->menu()->defaultAction();
    m_fillColorToolButton->setIcon(createColorToolButtonIcon(
									":viMind/Resources/floodfill.png", Qt::white));
    formatToolBar->addWidget(m_fillColorToolButton);
    connect(m_fillColorToolButton, SIGNAL(clicked()), this, SLOT(fillButtonTriggered()));
}
void MainWindow::createDockWindows()
{
#if 0
	QDockWidget *dock = new QDockWidget(tr("NodeList"));
	dock->setAllowedAreas(Qt::AllDockWidgetAreas);
	m_nodeList = new QTreeWidget(dock);
	m_nodeList->setIconSize(QSize(0, 0));
	connect(m_nodeList, SIGNAL(activated(const QModelIndex &)),
			this, SLOT(nodeListItemActivated(const QModelIndex &)));
	QStringList header;
	header << tr("text") << tr("created") << tr("modified");
	m_nodeList->setHeaderLabels(header);
	QHeaderView *hv = m_nodeList->header();
	hv->setSortIndicatorShown(true);
	hv->setClickable(true);
	connect(hv, SIGNAL(sectionPressed(int)), this, SLOT(nodeListHeaderPressed(int)));
	dock->setWidget(m_nodeList);
	addDockWidget(Qt::LeftDockWidgetArea, dock);
#endif
}
void MainWindow::nodeListItemActivated(const QModelIndex &index)
{
	const int row = index.row();
	qDebug() << row;
	QList<QTreeWidgetItem *> lst = m_nodeList->selectedItems();
	if( lst.isEmpty() ) return;
	QTreeWidgetItem *item = *lst.begin();
	Node *node = (Node *)item->data(0, 1).toUInt();
	if( !node ) return;
	m_scene->clearSelection();
	node->ensureVisible();
	node->setSelected(true);
	node->setFocus();
}
void MainWindow::nodeListHeaderPressed(int ix)
{
	qDebug() << "nodeListHeaderPressed(int) " << ix;
	QHeaderView *hv = m_nodeList->header();
	m_nodeList->sortItems(ix, hv->sortIndicatorOrder());
}
void MainWindow::setupStatusBar()
{
#if 1
	statusBar()->insertPermanentWidget(1, m_modePane = new QLabel());
#else
	statusBar()->addWidget(new QWidget(), 1);
	statusBar()->addPermanentWidget(m_modePane = new QLabel());
#endif
}
void MainWindow::fillColorChanged()
{
    m_fillColorAct = qobject_cast<QAction *>(sender());
    fillColorChanged(m_fillColorAct);
}
void MainWindow::fillColorChanged(QAction *fillColorAction)
{
    m_fillColorToolButton->setIcon(createColorToolButtonIcon(
                 ":viMind/Resources/floodfill.png",
                 qVariantValue<QColor>(m_fillColorAct->data())));
    fillButtonTriggered();
}
void MainWindow::fillButtonTriggered()
{
    m_scene->setFillColor(qVariantValue<QColor>(m_fillColorAct->data()));
	QMenu *menu = m_fillColorToolButton->menu();
	menu->setDefaultAction(m_fillColorAct);
	m_view->viewport()->update();
}
QMenu *MainWindow::createColorMenu(const char *slot, QColor defaultColor)
{
#if 0
    QList<QColor> colors;
    colors << Qt::transparent << Qt::black << Qt::white << Qt::red << Qt::green << Qt::blue << Qt::cyan
		<< Qt::magenta << Qt::yellow << Qt::lightGray << Qt::gray << Qt::darkGray;
#endif
    QStringList names;
    names << tr("transparent") << tr("white") << tr("pink") << tr("greenyellow") << tr("lightblue") << tr("cyan")
		<< tr("cornsilk") << tr("yellow") << tr("lightyellow") << tr("lightsalmon") << tr("lightGray") << tr("gray");

    QMenu *colorMenu = new QMenu(this);
#if 1
    foreach(QString name, names) {
        QAction *action = new QAction(name, this);
    	QColor color(name);
        action->setData(color);
        action->setIcon(createColorIcon(color));
        connect(action, SIGNAL(triggered()), this, slot);
        colorMenu->addAction(action);
        if (color == defaultColor) {
        	//	hbv_Eł͂ȂA̍̃ACRNbNꍇ̃ANVݒ
            colorMenu->setDefaultAction(action);
        }
    }
#else
    for (int i = 0; i < colors.count(); ++i) {
        QAction *action = new QAction(names.at(i), this);
        action->setData(colors.at(i));
        action->setIcon(createColorIcon(colors.at(i)));
        connect(action, SIGNAL(triggered()), this, slot);
        colorMenu->addAction(action);
        if (colors.at(i) == defaultColor) {
        	//	hbv_Eł͂ȂA̍̃ACRNbNꍇ̃ANVݒ
            colorMenu->setDefaultAction(action);
        }
    }
#endif
	QAction *action = new QAction("selected &Color", this);
	action->setData(Qt::white);
	action->setIcon(createColorIcon(Qt::white));
	connect(action, SIGNAL(triggered()), this, slot);
	colorMenu->addAction(action);

	QAction *selColorAct = new QAction("&Select a color...", this);
	QVariant v;
	v.setValue(qobject_cast<QObject*>(action));
	selColorAct->setData(v);
	connect(selColorAct, SIGNAL(triggered()), this, SLOT(fillColorSelect()));
	colorMenu->addAction(selColorAct);

	QAction *selNamedColorAct = new QAction("select a &Named color...", this);
	v.setValue(qobject_cast<QObject*>(action));
	selNamedColorAct->setData(v);
	connect(selNamedColorAct, SIGNAL(triggered()), this, SLOT(namedColorSelect()));
	colorMenu->addAction(selNamedColorAct);

    return colorMenu;
}
QIcon MainWindow::createColorIcon(QColor color)
{
    QPixmap pixmap(20, 20);
    QPainter painter(&pixmap);
    painter.setPen(Qt::NoPen);
    if( color != Qt::transparent )
	    painter.fillRect(QRect(0, 0, 20, 20), color);
    else {
	    painter.fillRect(QRect(0, 0, 20, 20), Qt::lightGray);
	    painter.setPen(Qt::black);
	    painter.drawLine(0, 0, 20, 20);
	    painter.drawLine(0, 20, 20, 0);
    }
    return QIcon(pixmap);
}
QIcon MainWindow::createColorToolButtonIcon(const QString &imageFile,
                        QColor color)
{
    QPixmap pixmap(50, 80);
    pixmap.fill(Qt::transparent);
    QPainter painter(&pixmap);
    QPixmap image(imageFile);
    QRect target(0, 0, 50, 60);
    QRect source(0, 0, 42, 42);
    painter.fillRect(QRect(0, 60, 50, 80), color);
    painter.drawPixmap(target, image, source);

    return QIcon(pixmap);
}
void MainWindow::fillColorSelect()
{
	QColorDialog aDlg;
	if( aDlg.exec() ) {
	    QAction *senderAction = qobject_cast<QAction *>(sender());
		QVariant v = senderAction->data();
		m_fillColorAct= qobject_cast<QAction*>(v.value<QObject*>());
	    m_fillColorAct->setData(aDlg.currentColor());
	    m_fillColorAct->setIcon(createColorIcon(aDlg.currentColor()));
	    emit m_fillColorAct->trigger();
	}
}
void MainWindow::namedColorSelect()
{
	NamedColorDlg aDlg;
	if( aDlg.exec() ) {
	    QAction *senderAction = qobject_cast<QAction *>(sender());
		QVariant v = senderAction->data();
		m_fillColorAct = qobject_cast<QAction*>(v.value<QObject*>());
	    m_fillColorAct->setData(QColor(aDlg.colorName()));
	    m_fillColorAct->setIcon(createColorIcon(QColor(aDlg.colorName())));
	    emit m_fillColorAct->trigger();
	}
}
void MainWindow::currentFontChanged(const QFont &font)
{
	handleFontChange();
}
void MainWindow::fontSizeChanged(const QString &size)
{
	handleFontChange();
}
void MainWindow::handleFontChange()
{
	if( m_notUpdateNodeFont ) return;
    QFont font = m_fontCombo->currentFont();
    font.setPointSize(m_fontSizeCombo->currentText().toInt());

    m_scene->setFont(font);
}
bool MainWindow::maybeSave()
{
    if (isWindowModified()) {
	QMessageBox::StandardButton ret;
        ret = QMessageBox::warning(this, tr("viMind"),
                     tr("The map '%1' has been modified.\n"
                        "Do you want to save your changes?").arg(m_curFile),
                     QMessageBox::Save | QMessageBox::Discard
		     | QMessageBox::Cancel);
        if (ret == QMessageBox::Save)
            return save();
        else if (ret == QMessageBox::Cancel)
            return false;
    }
    return true;
}
bool MainWindow::eventFilter(QObject *obj, QEvent *event)
{
	if( obj == m_findCombo->lineEdit() && event->type() == QEvent::KeyPress ) {
		QKeyEvent *keyEvent = static_cast<QKeyEvent *>(event);
		if( keyEvent->key() == Qt::Key_Escape ) {
			m_view->setFocus();
			turnOffIME();
			return true;
		}
	}
	return false;
}
void MainWindow::closeEvent(QCloseEvent *event)
{
	if (maybeSave()) {
		writeSettings();
		//event->accept();
		QMainWindow::closeEvent(event);
	} else {
		event->ignore();
	}
}
void MainWindow::writeSettings()
{
	QSettings settings;
	settings.setValue("geometry", saveGeometry());
	settings.setValue("windowState", saveState());
	settings.setValue("fontName", m_globSettings.m_fontName);
	settings.setValue("fontSize", m_globSettings.m_fontSize);
	settings.setValue("nodeStyle", m_globSettings.m_nodeStyle);
	settings.setValue("pcSpace", m_globSettings.m_pcSpace);
	settings.setValue("ccSpace", m_globSettings.m_ccSpace);
	settings.setValue("rccSpace", m_globSettings.m_rccSpace);
	settings.setValue("backgroundGrid", m_globSettings.m_backgroundGrid);
	settings.setValue("bgR", m_globSettings.m_bgGridColor.red());
	settings.setValue("bgG", m_globSettings.m_bgGridColor.green());
	settings.setValue("bgB", m_globSettings.m_bgGridColor.blue());
	settings.setValue("bgA", m_globSettings.m_bgGridColor.alpha());
	settings.setValue("outlinePrefix", m_globSettings.m_outlinePrefix);
}
void MainWindow::readSettings()
{
	QSettings settings;
	restoreGeometry(settings.value("geometry").toByteArray());
	restoreState(settings.value("windowState").toByteArray());

    QStringList strList = settings.value("recentFindStringList").toStringList();
    m_findCombo->addItems(strList);
    m_globSettings.m_fontName = settings.value("fontName", "Arial").toString();
    m_globSettings.m_fontSize = settings.value("fontSize", 8).toInt();
    m_globSettings.m_nodeStyle = settings.value("nodeStyle", 0).toInt();
    m_globSettings.m_pcSpace = settings.value("pcSpace", 16).toInt();
    m_globSettings.m_ccSpace = settings.value("ccSpace", 4).toInt();
    m_globSettings.m_rccSpace = settings.value("rccSpace", 6).toInt();
    m_globSettings.m_backgroundGrid = settings.value("backgroundGrid", true).toBool();
    m_globSettings.m_bgGridColor = QColor(	settings.value("bgR", 0xe0).toInt(),
										    settings.value("bgG", 0xe0).toInt(),
										    settings.value("bgB", 0xe0).toInt(),
										    settings.value("bgA", 128).toInt());
    m_globSettings.m_outlinePrefix = settings.value("outlinePrefix", ".").toString();
}
void MainWindow::openFavoriteFile()
{
	m_scene->setMode(Scene::COMMAND);
    QAction *action = qobject_cast<QAction *>(sender());
    if (action) {
    	const QString fileName = action->data().toString();
        loadFile(fileName);
		addToFavoriteFiles(fileName);
    }
}
void MainWindow::openRecentFile()
{
	m_scene->setMode(Scene::COMMAND);
    QAction *action = qobject_cast<QAction *>(sender());
    if (action)
        loadFile(action->data().toString());
}
void MainWindow::openRecentWindow()
{
	m_scene->setMode(Scene::COMMAND);
    QAction *action = qobject_cast<QAction *>(sender());
    if (action) {
        loadFile(action->data().toString());
    }
}
QString MainWindow::strippedName(const QString &fullFileName)
{
    return QFileInfo(fullFileName).fileName();
}
void MainWindow::updateRecentFileActionsOfAllMainWindows()
{
    foreach (QWidget *widget, qApp->topLevelWidgets()) {
        MainWindow *mainWin = qobject_cast<MainWindow *>(widget);
		if( mainWin )
	        mainWin->updateRecentFileActions();
    }
}
//	settings  RecentFile oAm_recentFileActs ɐݒ
void MainWindow::updateRecentFileActions()
{
    QSettings settings;
    QStringList files = settings.value("recentFileList").toStringList();
    int numRecentFiles = qMin(files.size(), (int)MaxRecentFiles);
    for (int i = 0; i < numRecentFiles; ++i) {
        QString temp = files[i];
        QString text = tr("&%1 %2")
        				.arg(QChar(i < 10 ? '0' + (i + 1) % 10 : 'A' + i - 10))
        				.arg(temp.replace("&", "&&"));
        				//.arg(strippedName(files[i]));
        m_recentFileActs[i]->setText(text);
        m_recentFileActs[i]->setData(files[i]);
        m_recentFileActs[i]->setStatusTip(files[i]);
        m_recentFileActs[i]->setVisible(true);
    }
    for (int j = numRecentFiles; j < MaxRecentFiles; ++j)
        m_recentFileActs[j]->setVisible(false);

    ///m_separatorMRUAct->setVisible(numRecentFiles > 0);
}
void MainWindow::addToFavoriteFiles()
{
    if( m_isUntitled || m_curFullPath.isEmpty() ) return;
    addToFavoriteFiles(m_curFullPath);
}
void MainWindow::addToFavoriteFiles(const QString &fileName)
{
    QSettings settings;
    QStringList files = settings.value("favoriteFileList").toStringList();
    files.removeAll(fileName);
    files.push_front(fileName);
    while (files.size() > MaxFavoriteFiles)
        files.removeLast();
    settings.setValue("favoriteFileList", files);
    updateFavoriteFileActionsOfAllMainWindows();
}
void MainWindow::updateFavoriteFileActionsOfAllMainWindows()
{
    foreach (QWidget *widget, qApp->topLevelWidgets()) {
        MainWindow *mainWin = qobject_cast<MainWindow *>(widget);
		if( mainWin )
	        mainWin->updateFavoriteFileActions();
    }
}
//	settings 炨Cɓ̃t@CoAm_favoriteFileActs ɐݒ
void MainWindow::updateFavoriteFileActions()
{
    QSettings settings;
    QStringList files = settings.value("favoriteFileList").toStringList();
    int numFiles = qMin(files.size(), (int)MaxFavoriteFiles);
    for (int i = 0; i < numFiles; ++i) {
        QString temp = files[i];
        QString text = tr("&%1 %2")
        				.arg(QChar(i < 10 ? '0' + (i + 1) % 10 : 'A' + i - 10))
        				.arg(temp.replace("&", "&&"));
        				//.arg(strippedName(files[i]));
        m_favoriteFileActs[i]->setText(text);
        m_favoriteFileActs[i]->setData(files[i]);
        m_favoriteFileActs[i]->setStatusTip(files[i]);
        m_favoriteFileActs[i]->setVisible(true);
    }
    for (int j = numFiles; j < MaxFavoriteFiles; ++j)
        m_favoriteFileActs[j]->setVisible(false);

    //m_separatorFavoAct->setVisible(numFiles > 0);
}
void MainWindow::updateRecentWindowsActions()
{
	int n = g_windowsList.size();
	foreach(QString path, g_windowsList) {
		--n;
		m_recentWindowActs[n]->setText(path);
		m_recentWindowActs[n]->setData(path);
		m_recentWindowActs[n]->setStatusTip(path);
		m_recentWindowActs[n]->setVisible(true);
 	}
}
void MainWindow::updateCurFile()
{
    static int sequenceNumber = 0;
    if( m_curFile.isEmpty() )
        m_curFile = tr("map%1.vmd").arg(++sequenceNumber);
}
void MainWindow::updateWindowTitle()
{
	updateCurFile();
	QString title = m_curFile;
	if( isWindowModified() )
 		title += "*";
	title += " - viMind ver. ";
	title += VERSION_STR;
    setWindowTitle(title);
}
void MainWindow::cleanChanged(bool clean)
{
    setWindowModified(!clean);
    updateWindowTitle();
}
void MainWindow::curNodeChanged(Node *node)
{
	Node *root = m_scene->rootNode();
	m_formatForkAct->setChecked(node && node != root && node->nodeStyle() == Node::FORK_STYLE);
	m_formatRectAct->setChecked(node && node != root && node->nodeStyle() == Node::RECT_STYLE);
	m_formatRoundRectAct->setChecked(node && node != root && node->nodeStyle() == Node::ROUND_RECT_STYLE);
	m_formatCircleRectAct->setChecked(node && node != root && node->nodeStyle() == Node::CIRCLE_RECT_STYLE);
	m_formatAlignLeftAct->setChecked(node && node->textAlign() == Qt::AlignLeft);
	m_formatAlignCenterAct->setChecked(node && node->textAlign() == Qt::AlignHCenter);
	m_formatAlignRightAct->setChecked(node && node->textAlign() == Qt::AlignRight);
	m_formatAlignColumnAct->setChecked(node && node->isAlignColumn());
	m_nodeDownwardAct->setChecked(node && node->isNodeDownward());
	if( node != 0 ) {
		m_notUpdateNodeFont = true;		//	tHgTCYύXȂ悤
		m_fontCombo->setCurrentFont(node->font().family());
		m_fontSizeCombo->lineEdit()->setText(QString("%1").arg(node->font().pointSize()));
		m_notUpdateNodeFont = false;
	}
}
void MainWindow::nodeCreated(Node *node)
{
	QDateTime cdt; cdt.setTime_t(node->createdDT());
	QDateTime mdt; mdt.setTime_t(node->mofifiedDT());
	QString text = node->toPlainText();
	text.replace("\n", "");
	QStringList lst;
	lst << text
		<< cdt.toString("MM/dd hh:mm:dd")
		<< mdt.toString("MM/dd hh:mm:dd");
	QTreeWidgetItem *item = new QTreeWidgetItem(lst);
	item->setData(0, 1, (const char *)node);
	m_nodeList->addTopLevelItem(item);
}
void MainWindow::documentWasModified()
{
    setWindowModified(true);
    updateWindowTitle();
    addToWindowsList(m_curFullPath);
}
void MainWindow::modeChanged()
{
	QString text;
	const Scene::Mode mode = m_scene->mode();
	if( mode == Scene::COMMAND ) {
		text = "CMD";
		m_isIMEOpen = isIMEOpen();
		turnOffIME();
		m_view->setAttribute(Qt::WA_InputMethodEnabled, false);
	} else if( mode == Scene::INSERT ) {
		if( m_isIMEOpen )
			turnOnIME();
		text = "EDIT";
	}
	m_modePane->setText(text);
	m_editInsertDateAct->setEnabled(mode == Scene::INSERT);
}
bool MainWindow::isIMEOpen()
{
#if	WIN32
		HWND hwnd = window()->winId();
		HIMC hC = ImmGetContext(hwnd);
		return ImmGetOpenStatus(hC) ? true : false;
#endif	//WIN32
}
void MainWindow::turnOnIME()
{
#if	WIN32
		HWND hwnd = window()->winId();
		HIMC hC = ImmGetContext(hwnd);
		ImmSetOpenStatus(hC, TRUE);		//	IME ON
#endif	//WIN32
}

void MainWindow::turnOffIME()
{
#if	WIN32
		HWND hwnd = window()->winId();
		HIMC hC = ImmGetContext(hwnd);
		ImmSetOpenStatus(hC, FALSE);		//	IME OFF
#endif	//WIN32
}
//	IME ON/OFF ۑ
void MainWindow::saveAndTurnOffIME()
{
}
//	IME ON/OFF ԕA
void MainWindow::restoreIMEOPenStatus()
{
}
//	"t@CpX" ... 𕪉 QStringList Ɋi[ĕԂ
QStringList stlipDQuotedString(const QString &textOrg)
{
	QString text(textOrg);
	QStringList lst;
	while( !text.isEmpty() && text[0] != '\n' ) {
		if( text[0] != '"' ) {
			lst.push_back(text);
			break;
		}
		text = text.mid(1);
		int ix = text.indexOf('"');
		if( ix < 0 ) {
			lst.push_back(text);
			break;
		}
		lst.push_back(text.left(ix));
		++ix;
		while( ix < text.length() && text[ix] == ' ' )
			++ix;
		text = text.mid(ix);
	}
	return lst;
}
void MainWindow::onRecieved(const QString cmd)
{
	qDebug() << cmd;
	if( cmd.isEmpty() )
		newFile();
	else {
		QStringList lst = stlipDQuotedString(cmd);
		foreach(QString fileName, lst) {
			loadFile(fileName);
		}
	}
}
void MainWindow::newFile()
{
    MainWindow *other = new MainWindow();
    other->move(x() + 40, y() + 40);
    other->show();
}
bool MainWindow::save()
{
	m_scene->setMode(Scene::COMMAND);
    if (m_isUntitled) {
        return saveAs();
    } else {
        return saveFile(m_curFullPath);
    }
}
void MainWindow::saveAllExit()
{
	saveAll();
	exit();
}
void MainWindow::saveAll()
{
    foreach (QWidget *widget, qApp->topLevelWidgets()) {
        MainWindow *mainWin = qobject_cast<MainWindow *>(widget);
        if( mainWin )
            mainWin->save();
    }
}
bool MainWindow::saveAs()
{
	m_scene->setMode(Scene::COMMAND);
	QString title = m_curFile;
	if( m_isUntitled ) {
		Node *node = m_scene->rootNode();
		QString text = node->toPlainText();
		if( !text.isEmpty() && text != tr("Root") ) {
			text.replace("\n", "");
			title = text;
		}
	}
	QString cdir = curDir();
	if( !cdir.isEmpty() )
		QDir::setCurrent(cdir);
	QString fileName = QFileDialog::getSaveFileName(this, tr("Save File"), title,
													tr("viMind(*.vmd *.mm);;All Files(*.*)"));
	if( fileName.isEmpty() ) return false;
    setCurrentFile(fileName);
	return saveFile(fileName);
}

bool MainWindow::saveFile(const QString &fileName)
{
	QFile fp(fileName);
	if( !fp.open(QIODevice::WriteOnly) ) {
		return false;
	}
	QString buffer = m_scene->toXmlText(geometry());
	QTextCodec *codec = QTextCodec::codecForName("UTF-8");
	QByteArray ba = codec->fromUnicode(buffer);
	fp.write(ba);
	fp.close();
	showMessage(tr("written %1 byte").arg(ba.size()),
				5000);
    setWindowModified(false);
    m_scene->setClean();
    updateWindowTitle();
	return true;
}
QString MainWindow::curDir() const
{
	QString curDir;
	if( !m_isUntitled && !m_curFullPath.isEmpty() ) {
		QDir dir(m_curFullPath);
		dir.cdUp();
		curDir = dir.path();
	}
	return curDir;
}
void MainWindow::open()
{
	m_scene->setMode(Scene::COMMAND);
	QString fileName = QFileDialog::getOpenFileName(this, tr("Open File"), curDir(),
													tr("viMind(*.vmd *.mm);;All Files(*.*)"));
	if( fileName.isEmpty() ) return;
	loadFile(fileName);
}
void MainWindow::loadFile(const QString &fileNameRaw)
{
	QString fileName(fileNameRaw);
	fileName.replace("\xa5", "/");		//	\ = 0xa5
#if 1
    MainWindow *existing = findMainWindow(fileName);
    if (existing) {
        existing->show();
        existing->raise();
        existing->activateWindow();
        return;
    }
#endif
    if (m_isUntitled //&& m_scene->isEmpty()
            && !isWindowModified())
	{
        loadFileToThisMainWindow(fileName);
    } else {
        MainWindow *other = new MainWindow(fileName);
        if (other->m_isUntitled) {
            delete other;
            return;
        }
        other->move(x() + 40, y() + 40);
        other->show();
	}
}
bool MainWindow::loadFileToThisMainWindow(const QString &fileName)
{
#if 0
	//	undone B N[ibv
    QFile file(fileName);
    if (!file.open(QFile::ReadOnly | QFile::Text)) {
        QMessageBox::warning(this, tr("viMind"),
                             tr("Cannot read file %1:\n%2.")
                             .arg(fileName)
                             .arg(file.errorString()));
        return;
    }
#endif
	QFile fp(fileName);
	if( !fp.open(QIODevice::ReadOnly) ) {
        QMessageBox::warning(this, tr("viMind"),
                             tr("Cannot read file %1:\n%2.")
                             .arg(fileName)
                             .arg(fp.errorString()));
		return false;
	}
	QByteArray ba = fp.readAll();
	fp.close();
	setContent(ba);
	m_scene->rootNode()->ensureVisible();
    setCurrentFile(fileName);
    statusBar()->showMessage(tr("File loaded"), 2000);
    addToWindowsList(fileName);
	return true;
}
bool MainWindow::setContent(const QByteArray &ba)
{
	QTextCodec *codec = QTextCodec::codecForName("UTF-8");
	QString buffer = codec->toUnicode(ba);
	QDomDocument doc;
	if( !doc.setContent(buffer) ) {
		QMessageBox::warning(0, tr("open failed."), tr("invalid contents."));
		return false;
	}
	QDomElement root = doc.documentElement();
	//printElement(root, 0);
	//	ŏ̃Gg <map version="...">
	if( root.tagName() != "map" ) {
		return false;
	}
	const qreal width = root.attribute("WIDTH", "-1").toDouble();
	const qreal height = root.attribute("HEIGHT", "-1").toDouble();
	const qreal rootX = root.attribute("ROOTX", "-1").toDouble();
	if( width > 0 && height > 0 ) {
		m_scene->setSceneRect(0, 0, width, height);
		m_scene->setDefaultSceneRect(QRectF(0, 0, width, height));
	}
	const int winWd = root.attribute("WINWD", "0").toInt();
	const int winHt = root.attribute("WINHT", "0").toInt();
	if( winWd > 0 && winHt > 0 ) {
		QRect g = geometry();
		g.setWidth(winWd);
		g.setHeight(winHt);
		setGeometry(g);
	}
	root = root.firstChildElement();
	if( root.tagName() != "node" ) {
		return false;
	}
	m_scene->removeAll();
	Node *rootNode = m_scene->createNode(0, Scene::LAST_CHILD, root, true, true);

	m_scene->setRootNode(rootNode);
	addNode(rootNode, root);
	//m_scene->layoutAll();		//	setRootNodeXPos() Ă΂̂ŕKvȂ
	m_scene->setSelectedNode(rootNode);
	rootNode->setTextWidthRecursive();
	//m_scene->setRootNodeXPos(rootX);
	const qreal sx = root.attribute("SX", QString("%1").arg(winWd/2)).toDouble();
	const qreal sy = root.attribute("SY", QString("%1").arg(winHt/2)).toDouble();
	rootNode->setPos(sx, sy);
	for(;;) {
		root = root.nextSiblingElement();
		if( root.isNull() || root.tagName() != "node" )
			break;
		Node *node = m_scene->createNode(0, Scene::LAST_CHILD, root, true, true);
		//m_floatingNodes.push_back(node);
		node->setFloatingNode(true);
		addNode(node, root);
		const qreal sx = root.attribute("SX", "0").toDouble();
		const qreal sy = root.attribute("SY", "0").toDouble();
		node->setPos(sx, sy);
	}
	m_scene->layoutAll();
	return true;
}
//	parentNode Ɏqm[hǉ
void MainWindow::addNode(Node *parentNode, QDomElement &element)
{
	const uint cdt = QDateTime::currentDateTime().toTime_t();
	QDomElement childEle = element.firstChildElement();
	while( !childEle.isNull() ) {
		//printElement(childEle, lvl + 1);
		const QString tagName = childEle.tagName();
		if( tagName == "node" ) {
			Node *node = m_scene->createNode(parentNode, Scene::LAST_CHILD, childEle, false, true);
			addNode(node, childEle);
			const QString position = childEle.attribute("POSITION");
			if( !position.isEmpty() ) {
				node->setRightSideRecursive(position == "right");
				node->updateLinkIconPosRecursive();
			}
		}
		childEle = childEle.nextSiblingElement();
	}
}
Node *MainWindow::newChild(Node *parentNode, const QString &title)
{
	return m_scene->createChildNode(parentNode, title);
}
void MainWindow::setCurrentFile(const QString &fullPath)
{
    //qDebug() << fullPath;
    m_isUntitled = fullPath.isEmpty();
    if (m_isUntitled) {
        m_curFullPath.clear();
        m_curFile.clear();
        //m_curFile = tr("map%1.vmd").arg(sequenceNumber++);
    } else {
        m_curFullPath = fullPath;
        m_curFile = QFileInfo(fullPath).fileName();
    }
    //qDebug() << m_curFile;
    updateCurFile();
    //setWindowTitle(m_curFile + "- viMind " + VERSION_STR);

    //textEdit->document()->setModified(false);
    setWindowModified(false);
    m_scene->setClean();
    updateWindowTitle();

    QSettings settings;
    QStringList files = settings.value("recentFileList").toStringList();
    files.removeAll(fullPath);
    files.push_front(fullPath);
    while (files.size() > MaxRecentFiles)
        files.removeLast();
    settings.setValue("recentFileList", files);
    updateRecentFileActionsOfAllMainWindows();
}
MainWindow *MainWindow::findMainWindow(const QString &fullPath)
{
    //QString canonicalFilePath = QFileInfo(fullPath).canonicalFilePath();

    foreach (QWidget *widget, qApp->topLevelWidgets()) {
        MainWindow *mainWin = qobject_cast<MainWindow *>(widget);
        if (mainWin && mainWin->m_curFullPath == fullPath)
            return mainWin;
    }
    return 0;
}
void MainWindow::toFind()
{
	m_findToolBar->setVisible(true);
	m_findCombo->setFocus();
	m_findCombo->lineEdit()->setSelection(0, m_findCombo->lineEdit()->text().length());
}
void MainWindow::find(bool forward)
{
	QString text = m_findCombo->currentText();
	if( text.isEmpty() ) return;
	const int ix = m_findCombo->findText(text);
	if( ix >= 0 )
		m_findCombo->removeItem(ix);
	m_findCombo->insertItem(0, text);
	m_findCombo->setCurrentIndex(0);
	const bool rc = forward ? m_scene->findNext(text) : m_scene->findPrev(text);
	//m_findCombo->clearFocus();
	//m_scene->setFocus();
	m_view->setFocus();
	turnOffIME();
	if( !rc )
		showMessage(tr("'%1' is not found.").arg(text), 5000);

    QSettings settings;
    QStringList strList = settings.value("recentFindStringList").toStringList();
    strList.removeAll(text);		//	d폜
    strList.prepend(text);
    while (strList.size() > MaxRecentFindStings)
        strList.removeLast();
    settings.setValue("recentFindStringList", strList);
}
void MainWindow::findNext()
{
	find(true);
}
void MainWindow::findPrev()
{
	find(false);
}
void MainWindow::sceneProp()
{
	QRectF r = m_scene->defaultSceneRect();
	//QRectF r = m_scene->sceneRect();
	ScenePropDlg aDlg(this);
	aDlg.m_sceneWidthLE->setText(QString("%1").arg(r.width()));
	aDlg.m_sceneHeightLE->setText(QString("%1").arg(r.height()));
	//aDlg.m_rootNodeXPosLE->setText(QString("%1").arg(m_scene->rootNodeXPos()));
	if( aDlg.exec() ) {
		r.setWidth(aDlg.m_sceneWidthLE->text().toDouble());
		r.setHeight(aDlg.m_sceneHeightLE->text().toDouble());
		m_scene->setSceneRect(r);
		m_scene->setDefaultSceneRect(r);
		//m_scene->setRootNodeXPos(aDlg.m_rootNodeXPosLE->text().toDouble());
		documentWasModified();
	}
}
void MainWindow::print()
{
	QPrinter printer(QPrinter::HighResolution);
	//printer.setPageSize(QPrinter::A4);
	if (QPrintDialog(&printer).exec() == QDialog::Accepted) {
		onPaintRequested(&printer);
#if 0
		QPainter painter(&printer);
		//painter.setRenderHint(QPainter::Antialiasing);
		m_scene->render(&painter);
#endif
	}
}
void MainWindow::printPreview()
{
	QPrinter printer(QPrinter::HighResolution);
	QPrintPreviewDialog pvDlg(&printer);
	connect(&pvDlg, SIGNAL(paintRequested ( QPrinter *)), this, SLOT(onPaintRequested(QPrinter*)));
	pvDlg.exec();
}
void MainWindow::onPaintRequested(QPrinter *printer)
{
	QPainter painter(printer);
    QRectF vrect = painter.viewport();
	QRectF srect = m_scene->nodeBoundingRect();
	const qreal vRatio = vrect.width() / vrect.height();
	if( srect.width() / srect.height() > vRatio ) {		//	m[h̏ꍇ
		const qreal ht = srect.width() / vRatio;
		srect.setTop(srect.top() - (ht - srect.height()) / 2);
		srect.setHeight(ht);
	} else if( srect.width() / srect.height() < vRatio ) {		//	m[hc̏ꍇ
		const qreal wd = vRatio * srect.height();
		srect.setLeft(srect.left() - (wd - srect.width()) / 2);
		srect.setWidth(wd);
	}
	painter.setRenderHint(QPainter::Antialiasing);
	m_scene->render(&painter, vrect, srect);
}
#if 0
void MainWindow::viewScaleReset()
{
}
#endif
void MainWindow::howToUse()
{
	QString path = qApp->applicationDirPath();
	path += "/help/viMindHowToUse.vmd";
	loadFile(path);
}
void MainWindow::revRef()
{
	QString path = qApp->applicationDirPath();
	path += "/help/viMindRevRef.vmd";
	loadFile(path);
}
void MainWindow::viMindWebSite()
{
	shellExecute("http://vivi.dyndns.org/viMind/viMind.html");
}
void MainWindow::about()
{
	QMessageBox msgBox;
	//msgBox.setIconPixmap(QPixmap(":vivi/Resources/images/ayabu-001.png"));
	msgBox.setText(tr("<div align=center><b><font size=5>viMind</font></b> version %1</div>").arg(VERSION_STR));
	msgBox.setInformativeText(QString("<br><br><div align=center>Copyright (C) 2011 by N.Tsuda<br>"
								"mailto:ntsuda@master.email.ne.jp<br>"
								"<a href=\"http://vivi.dyndns.org/?from=viMind%1\">http://vivi.dyndns.org/</a><br><br>"
								"Powered by <a href=\"http://qt.nokia.com/\">Qt</a>"
								"<p>Icons designed by <a href=\"http://www.visualpharm.com/\">VisualPharm</a>"
								//"<p>illustrated by <a href=\"http://www.pixiv.net/member.php?id=220294\"><img src=\":vivi/Resources/images/momoshiki.png\"></a>"
								"</div>").arg(VERSION_STR));
	msgBox.exec();
}
void MainWindow::viewPD(bool b)
{
	if( m_PDView == 0 ) {
		m_PDView = new PDView(m_scene);
		m_PDView->show();
	} else {
		delete m_PDView;
		m_PDView = 0;
	}
}
void MainWindow::fullScreen(bool b)
{
	if( b )
		showFullScreen();
	else
		showNormal();
}
void MainWindow::dragEnterEvent ( QDragEnterEvent * event )
{
	qDebug() << "MainWindow::dragEnterEvent";
	if( event->mimeData()->hasFormat("text/uri-list") ) {
		qDebug() << "has text/uri-list format";
		event->acceptProposedAction();
	}
}
void MainWindow::dropEvent ( QDropEvent * event )
{
	qDebug() << "MainWindow::dropEvent";
	QList<QUrl> fileList = event->mimeData()->urls();
	foreach(QUrl url, fileList) {
		QString fileName = QDir::toNativeSeparators(url.toLocalFile());
		qDebug() << fileName;
		loadFile(fileName);
	}
}
void MainWindow::exit()
{
    foreach (QWidget *widget, qApp->topLevelWidgets()) {
        MainWindow *mainWin = qobject_cast<MainWindow *>(widget);
		if( mainWin )
	        mainWin->close();
    }
}
void MainWindow::addToWindowsList(const QString &fullPath)
{
	removeFromWindowsList(fullPath);
	g_windowsList.push_back(fullPath);
}
void MainWindow::removeFromWindowsList(const QString &fullPath)
{
	QStringList::iterator itr = std::find(g_windowsList.begin(), g_windowsList.end(), fullPath);
	if( itr != g_windowsList.end() )
		g_windowsList.erase(itr);
}
void MainWindow::layoutAllWindows()
{
    foreach (QWidget *widget, qApp->topLevelWidgets()) {
        MainWindow *mainWin = qobject_cast<MainWindow *>(widget);
		if( mainWin )
			mainWin->m_scene->layoutAll();
    }
}
void MainWindow::settings()
{
	SettingsDlg dlg;
	dlg.m_fontCombo->setCurrentFont(QFont(m_globSettings.m_fontName));
	dlg.m_fontSizeCombo->lineEdit()->setText(QString("%1").arg(m_globSettings.m_fontSize));
	dlg.setNodeStyle(m_globSettings.m_nodeStyle);
	dlg.m_pcSpaceSB->setValue(m_globSettings.m_pcSpace);
	dlg.m_ccSpaceSB->setValue(m_globSettings.m_ccSpace);
	dlg.m_rccSpaceSB->setValue(m_globSettings.m_rccSpace);
	dlg.m_bgGridCheck->setChecked(m_globSettings.m_backgroundGrid);
	dlg.m_bgColorName->setText(m_globSettings.m_bgGridColor.name());
	dlg.m_bgColorAlpha->setValue(m_globSettings.m_bgGridColor.alpha());
	dlg.m_outlinePrefix->setText(m_globSettings.m_outlinePrefix);
	if( dlg.exec() ) {
		m_globSettings.m_fontName = dlg.m_fontCombo->currentFont().family();
		m_globSettings.m_fontSize = dlg.m_fontSizeCombo->lineEdit()->text().toInt();
		m_globSettings.m_nodeStyle = dlg.nodeStyle();
		m_globSettings.m_pcSpace = dlg.m_pcSpaceSB->value();
		m_globSettings.m_ccSpace = dlg.m_ccSpaceSB->value();
		m_globSettings.m_rccSpace = dlg.m_rccSpaceSB->value();
		m_globSettings.m_backgroundGrid = dlg.m_bgGridCheck->isChecked();
		m_globSettings.m_bgGridColor = QColor(dlg.m_bgColorName->text());
		m_globSettings.m_bgGridColor.setAlpha(dlg.m_bgColorAlpha->value());
		m_globSettings.m_outlinePrefix = dlg.m_outlinePrefix->text();
		writeSettings();
		m_scene->updateBackground();
		layoutAllWindows();
	}
}
void MainWindow::curFileName(QString &path)
{
	if( !m_isUntitled )
		path = m_curFullPath;
	else
		path = QString();
}
void MainWindow::openLink(const QString &path)
{
	QString fullPath = path;
	if( !fullPath.startsWith("http://") && !m_isUntitled ) {
		QDir dir(m_curFullPath);
		dir.cdUp();
		//qDebug() << "dirName() = " << dir.dirName();	//	pX̃t@CQbgł
		//qDebug() << "filePath() = " << dir.filePath();
		//qDebug() << "path() = " << dir.path();
		///QDir dir(m_curFullPath.left(m_curFullPath.length() - QDir(m_curFullPath).dirName().length()));
		fullPath = dir.absoluteFilePath(path);
	}
#ifdef	WIN32
	shellExecute(fullPath);
#endif
}
