package gnu.awt.virtual;

import gnu.awt.*;

import java.awt.*;
import java.awt.Rectangle;
import java.awt.peer.*;
import java.awt.BufferCapabilities.FlipContents;
import java.awt.event.*;
import java.awt.image.*;

import sun.awt.CausedFocusEvent.Cause;
import sun.java2d.pipe.Region;

/**
* Virtual frame peer. Satisfies the requirements for AWT frame peers without actually displaying
* anything (hence, it is virtual). It manages its own {@link java.awt.Graphics} by creating
* a {@link java.awt.image.Raster} (single pixel packed sample model) that can be accessed by
* a {@link gnu.awt.PixelsOwner}. Virtual frame peers are created by a {@link gnu.awt.virtual.VirtualToolkit}
* for frames that implement {@link gnu.awt.PixelsOwner}.
**/

public class VirtualFramePeer extends VirtualComponentPeer implements FramePeer
{
	//
	// Construction
	//
	
	public VirtualFramePeer( Frame frame, PixelsOwner pixelsOwner )
	{
		super( frame.getToolkit(), frame );
		this.pixelsOwner = pixelsOwner;
	}
	
	//
	// FramePeer
	//

	public void setTitle( String title )
	{
	}
	
	public void setIconImage( Image im )
	{
	}
	
	public void setMenuBar( MenuBar mb )
	{
		// TODO
	}
	
	public void setResizable( boolean resizeable )
	{
	}
	
	public void setState( int state )
	{
		// Always Frame.NORMAL
	}
	
	public int getState()
	{
		return Frame.NORMAL;
	}
	
	public void setMaximizedBounds( java.awt.Rectangle bounds )
	{
	}
	
	//
	// WindowPeer
	//

	public void toFront()
	{
		// Always "in front"
	}
	
	public void toBack()
	{
		// Always "in front"
	}
	
	public int handleFocusTraversalEvent( KeyEvent e )
	{
		return -1;
	}
	
	//
	// ContainerPeer
	//

	public Insets getInsets()
	{
		return insets;
	}

	public void beginValidate()
	{
	}
	
	public void endValidate()
	{
	}

	public void beginLayout()
	{
	}
	
	public void endLayout()
	{
	}
	
	public boolean isPaintPending()
	{
		return false;
	}
	
	public Insets insets()
	{
		return getInsets();
	}
	
	//
	// ComponentPeer
	//
	
	@Override
	public void setVisible( boolean b )
	{
		if( b == true )
		{
			// First paint
			component.paint( getGraphics() );
		}
	}
	
	@Override
	public Graphics getGraphics()
	{
		// We will always be writing to the same image
		if( image == null )
		{
			//Thread.dumpStack();
			/*if( size.width == 0 )
				size.width = 100;
			if( size.height == 0 )
				size.height = 100;*/
				
			if( ( size.width > 0 ) && ( size.height > 0 ) )
			{
				// Color model
				DirectColorModel colorModel = (DirectColorModel) getColorModel();
			
				// Pixel data
				int[] pixels = new int[ size.width * size.height ];
				DataBuffer dataBuffer = new DataBufferInt( pixels, pixels.length );
				
				// Sample model
				SampleModel sampleModel = new SinglePixelPackedSampleModel( DataBuffer.TYPE_INT, size.width, size.height, colorModel.getMasks() );

				// Raster				
				WritableRaster raster = Raster.createWritableRaster( sampleModel, dataBuffer, null );
				
				// Image
				image = new BufferedImage( colorModel, raster, true, null );
				
				// Set pixel owner
				pixelsOwner.setPixelArray( pixels, size.width, size.height );
			}
		}
		
		return image.getGraphics();
	}
	
	@Override
	public Image createImage( int width, int height )
	{
		//System.err.println( "createImage("+width+","+height+")" );
		
		// Color model
		DirectColorModel colorModel = (DirectColorModel) getColorModel();
		
		// Sample model
		SampleModel sampleModel = new SinglePixelPackedSampleModel( DataBuffer.TYPE_INT, width, height, colorModel.getMasks() );
		
		// Raster				
		WritableRaster raster = Raster.createWritableRaster( sampleModel, null );
		
		// Image
		return new BufferedImage( colorModel, raster, true, null );
	}
	
	///////////////////////////////////////////////////////////////////////////////////////
	// Private
	
	private PixelsOwner pixelsOwner;
	private Insets insets = new Insets( 0, 0, 0, 0 );
	private BufferedImage image = null;
	
	public Rectangle getBoundsPrivate() {
		// TODO Auto-generated method stub
		return null;
	}

	public void setBoundsPrivate(int arg0, int arg1, int arg2, int arg3) {
		// TODO Auto-generated method stub
		
	}

	public void repositionSecurityWarning() {
		// TODO Auto-generated method stub
		
	}

	public boolean requestWindowFocus() {
		// TODO Auto-generated method stub
		return false;
	}

	public void setAlwaysOnTop(boolean arg0) {
		// TODO Auto-generated method stub
		
	}

	public void setModalBlocked(Dialog arg0, boolean arg1) {
		// TODO Auto-generated method stub
		
	}

	public void setOpacity(float arg0) {
		// TODO Auto-generated method stub
		
	}

	public void setOpaque(boolean arg0) {
		// TODO Auto-generated method stub
		
	}

	public void updateFocusableWindowState() {
		// TODO Auto-generated method stub
		
	}

	public void updateIconImages() {
		// TODO Auto-generated method stub
		
	}

	public void updateMinimumSize() {
		// TODO Auto-generated method stub
		
	}

	public void updateWindow() {
		// TODO Auto-generated method stub
		
	}

	public boolean isRestackSupported() {
		// TODO Auto-generated method stub
		return false;
	}

	public void restack() {
		// TODO Auto-generated method stub
		
	}

	public void applyShape(Region arg0) {
		// TODO Auto-generated method stub
		
	}

	public void flip(int arg0, int arg1, int arg2, int arg3, FlipContents arg4) {
		// TODO Auto-generated method stub
		
	}

	public Rectangle getBounds() {
		// TODO Auto-generated method stub
		return null;
	}

	public boolean isReparentSupported() {
		// TODO Auto-generated method stub
		return false;
	}

	public void layout() {
		// TODO Auto-generated method stub
		
	}

	public void reparent(ContainerPeer arg0) {
		// TODO Auto-generated method stub
		
	}

	public boolean requestFocus(Component arg0, boolean arg1, boolean arg2,
			long arg3, Cause arg4) {
		// TODO Auto-generated method stub
		return false;
	}

	public void setBounds(int x, int y, int width, int height, int arg4) {
		// TODO Auto-generated method stub
	}
}
