/*
    avicore
    copyright (c) 2000-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/******************************************************************************
*                                                                             *
* Avi Core                                                                    *
*                                                                             *
******************************************************************************/
#ifndef __AVICORE_H__
#define __AVICORE_H__


#include "common.h"
#include "bitmap.h"
#include "chunk.h"
#include "wave.h"


#ifdef __cplusplus
extern "C" {
#endif


/******************************************************************************
*                                                                             *
* ե빽¤                                                              *
*                                                                             *
******************************************************************************/
#define AVIF_HASINDEX		0x00000010
#define AVIF_MUSTUSEINDEX	0x00000020
#define AVIF_ISINTERLEAVED	0x00000100
#define AVIF_TRUSTCKTYPE	0x00000800
#define AVIF_WASCAPTUREFILE	0x00010000
#define AVIF_COPYRIGHTED	0x00020000
#define AVISF_DISABLED		0x00000001
#define AVIIF_LIST			0x00000001
#define AVIIF_KEYFRAME		0x00000010
#define AVIIF_NOTIME		0x00000100
#define AVIIF_COMPUSE		0x0FFF0000
#define streamtypeAUDIO 	make4cc('a','u','d','s')
#define streamtypeVIDEO 	make4cc('v','i','d','s')


#define AMH_SIZE 56
#define RECT_SIZE 8
#define ASH_SIZE 56
#define AIE_SIZE 16


#ifdef USE_GCC


/* AVI Main File Header */
typedef struct AviMainHeader_Tag {
	guint32 micro_sec_per_frame __attribute__((packed));
	guint32 max_bytes_per_sec __attribute__((packed));
	guint32 padding_granularity __attribute__((packed));
	guint32 flags __attribute__((packed));
	guint32 total_frames __attribute__((packed));
	guint32 initial_frames __attribute__((packed));
	guint32 streams __attribute__((packed));
	guint32 suggested_buffer_size __attribute__((packed));
	guint32 width __attribute__((packed));
	guint32 height __attribute__((packed));
	guint32 reserved[4] __attribute__((packed));
} AviMainHeader;
/* Rectangle */
typedef struct Rect_Tag {
	gint16 left __attribute__((packed));
	gint16 top __attribute__((packed));
	gint16 right __attribute__((packed));
	gint16 bottom __attribute__((packed));
} Rect;
/* AVI Stream Header */
typedef struct AviStreamHeader_Tag {
	guint32 type __attribute__((packed));
	guint32 handler __attribute__((packed));
	guint32 flags __attribute__((packed));
	guint16 priority __attribute__((packed));
	guint16 language __attribute__((packed));
	guint32 initial_frames __attribute__((packed));
	guint32 scale __attribute__((packed));
	guint32 rate __attribute__((packed));
	guint32 start __attribute__((packed));
	guint32 length __attribute__((packed));
	guint32 suggested_buffer_size __attribute__((packed));
	guint32 quality __attribute__((packed));
	guint32 sample_size __attribute__((packed));
	Rect frame __attribute__((packed));
} AviStreamHeader;
/* AVI Index Entry */
typedef struct AviIndexEntry_Tag {
	guint32 ckid __attribute__((packed));
	guint32 flags __attribute__((packed));
	guint32 offset __attribute__((packed));
	guint32 length __attribute__((packed));
} AviIndexEntry;


#else


typedef struct { guint8 dummy[AMH_SIZE]; } AviMainHeader;
typedef struct { guint8 dummy[RECT_SIZE]; } Rect;
typedef struct { guint8 dummy[ASH_SIZE]; } AviStreamHeader;
typedef struct { guint8 dummy[AIE_SIZE]; } AviIndexEntry;


#endif


/******************************************************************************
*                                                                             *
* ¤Υޥ                                                                *
*                                                                             *
******************************************************************************/
#define amh_get_micro_sec_per_frame(amh) GUINT32_FROM_LE(*(guint32 *)(amh))
#define amh_get_max_bytes_per_sec(amh)										\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+4))
#define amh_get_padding_granularity(amh)									\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+8))
#define amh_get_flags(amh) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+12))
#define amh_get_total_frames(amh)											\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+16))
#define amh_get_initial_frames(amh)											\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+20))
#define amh_get_streams(amh) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+24))
#define amh_get_suggested_buffer_size(amh)									\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+28))
#define amh_get_width(amh) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+32))
#define amh_get_height(amh) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(amh)+36))
#define amh_set_micro_sec_per_frame(amh,micro_sec_per_frame)				\
						(*(guint32 *)(amh)=GUINT32_TO_LE(micro_sec_per_frame))
#define amh_set_max_bytes_per_sec(amh,max_bytes_per_sec)					\
			(*(guint32 *)((guint8 *)(amh)+4)=GUINT32_TO_LE(max_bytes_per_sec))
#define amh_set_padding_granularity(amh,padding_granularity)				\
		(*(guint32 *)((guint8 *)(amh)+8)=GUINT32_TO_LE(padding_granularity))
#define amh_set_flags(amh,flags)											\
						(*(guint32 *)((guint8 *)(amh)+12)=GUINT32_TO_LE(flags))
#define amh_set_total_frames(amh,total_frames)								\
				(*(guint32 *)((guint8 *)(amh)+16)=GUINT32_TO_LE(total_frames))
#define amh_set_initial_frames(amh,initial_frames)							\
			(*(guint32 *)((guint8 *)(amh)+20)=GUINT32_TO_LE(initial_frames))
#define amh_set_streams(amh,streams)										\
					(*(guint32 *)((guint8 *)(amh)+24)=GUINT32_TO_LE(streams))
#define amh_set_suggested_buffer_size(amh,suggested_buffer_size)			\
		(*(guint32 *)((guint8 *)(amh)+28)=GUINT32_TO_LE(suggested_buffer_size))
#define amh_set_width(amh,width)											\
						(*(guint32 *)((guint8 *)(amh)+32)=GUINT32_TO_LE(width))
#define amh_set_height(amh,height)											\
					(*(guint32 *)((guint8 *)(amh)+36)=GUINT32_TO_LE(height))


#define ash_get_type(ash) GUINT32_FROM_LE(*(guint32 *)(ash))
#define ash_get_handler(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+4))
#define ash_get_flags(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+8))
#define ash_get_priority(ash) GUINT16_FROM_LE(*(guint16 *)((guint8 *)(ash)+12))
#define ash_get_language(ash) GUINT16_FROM_LE(*(guint16 *)((guint8 *)(ash)+14))
#define ash_get_initial_frames(ash)											\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+16))
#define ash_get_scale(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+20))
#define ash_get_rate(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+24))
#define ash_get_start(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+28))
#define ash_get_length(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+32))
#define ash_get_suggested_buffer_size(ash)									\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+36))
#define ash_get_quality(ash) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+40))
#define ash_get_sample_size(ash)											\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(ash)+44))
#define ash_get_frame_left(ash)												\
							GUINT16_FROM_LE(*(guint16 *)((guint8 *)(ash)+48))
#define ash_get_frame_top(ash)												\
							GUINT16_FROM_LE(*(guint16 *)((guint8 *)(ash)+50))
#define ash_get_frame_right(ash)											\
							GUINT16_FROM_LE(*(guint16 *)((guint8 *)(ash)+52))
#define ash_get_frame_bottom(ash)											\
							GUINT16_FROM_LE(*(guint16 *)((guint8 *)(ash)+54))
#define ash_set_type(ash,type) (*(guint32 *)(ash)=GUINT32_TO_LE(type))
#define ash_set_handler(ash,handler)										\
					(*(guint32 *)((guint8 *)(ash)+4)=GUINT32_TO_LE(handler))
#define ash_set_flags(ash,flags)											\
						(*(guint32 *)((guint8 *)(ash)+8)=GUINT32_TO_LE(flags))
#define ash_set_priority(ash,priority)										\
					(*(guint16 *)((guint8 *)(ash)+12)=GUINT16_TO_LE(priority))
#define ash_set_language(ash,language)										\
					(*(guint16 *)((guint8 *)(ash)+14)=GUINT16_TO_LE(language))
#define ash_set_initial_frames(ash,initial_frames)							\
			(*(guint32 *)((guint8 *)(ash)+16)=GUINT32_TO_LE(initial_frames))
#define ash_set_scale(ash,scale)											\
						(*(guint32 *)((guint8 *)(ash)+20)=GUINT32_TO_LE(scale))
#define ash_set_rate(ash,rate)												\
						(*(guint32 *)((guint8 *)(ash)+24)=GUINT32_TO_LE(rate))
#define ash_set_start(ash,start)											\
						(*(guint32 *)((guint8 *)(ash)+28)=GUINT32_TO_LE(start))
#define ash_set_length(ash,length)											\
					(*(guint32 *)((guint8 *)(ash)+32)=GUINT32_TO_LE(length))
#define ash_set_suggested_buffer_size(ash,suggested_buffer_size)			\
		(*(guint32 *)((guint8 *)(ash)+36)=GUINT32_TO_LE(suggested_buffer_size))
#define ash_set_quality(ash,quality)										\
					(*(guint32 *)((guint8 *)(ash)+40)=GUINT32_TO_LE(quality))
#define ash_set_sample_size(ash,sample_size)								\
				(*(guint32 *)((guint8 *)(ash)+44)=GUINT32_TO_LE(sample_size))
#define ash_set_frame_left(ash,frame_left)									\
				(*(guint16 *)((guint8 *)(ash)+48)=GUINT16_TO_LE(frame_left))
#define ash_set_frame_top(ash,frame_top)									\
				(*(guint16 *)((guint8 *)(ash)+50)=GUINT16_TO_LE(frame_top))
#define ash_set_frame_right(ash,frame_right)								\
				(*(guint16 *)((guint8 *)(ash)+52)=GUINT16_TO_LE(frame_right))
#define ash_set_frame_bottom(ash,frame_bottom)								\
				(*(guint16 *)((guint8 *)(ash)+54)=GUINT16_TO_LE(frame_bottom))


#define aie_get_ckid(aie) GUINT32_FROM_LE(*(guint32 *)(aie))
#define aie_get_flags(aie) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(aie)+4))
#define aie_get_offset(aie) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(aie)+8))
#define aie_get_length(aie) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(aie)+12))

#define aie_set_type(aie,ckid) (*(guint32 *)(aie)=GUINT32_TO_LE(ckid))
#define aie_set_flags(aie,flags)											\
						(*(guint32 *)((guint8 *)(aie)+4)=GUINT32_TO_LE(flags))
#define aie_set_offset(aie,offset)											\
						(*(guint32 *)((guint8 *)(aie)+8)=GUINT32_TO_LE(offset))
#define aie_set_length(aie,length)											\
					(*(guint32 *)((guint8 *)(aie)+12)=GUINT32_TO_LE(length))


/******************************************************************************
*                                                                             *
* Խ¤                                                                  *
*                                                                             *
******************************************************************************/
typedef struct AviIndex_Tag {
	guint64 offset;
	guint32 size;
	guint32 flags;
} AviIndex;
typedef struct AviFile_Tag {
	int fd;						/* եǥ꥿ */
	gpointer *data;				/*  */
	gchar *name;				/* ե̾ */
	gint start,length;			/* ͭϰ */
	gint entries;				/* ǥåο */
	gint param;					/* ȥ꡼ֹ */
	AviIndex *index;			/* ǥå */
	/* ꥹ */
	struct AviFile_Tag *prev,*next;
	/* ӥǥͭ */
	BitmapInfoHeader *bmih;		/* ꥸʥΥեޥå */
	/* ǥͭ */
	WaveFormatEx *wfx;			/* ꥸʥΥեޥå */
} AviFile;
typedef struct AviEdit_Tag {
	gint offset;
	AviFile *file;
	guint32 type;				/* streamtypeAUDIO/streamtypeVIDEO */
	gint length;				/* ץ */
	guint32 rate;
	guint32 scale;				/* ratescale=1ô֤Υե졼 */
	gpointer buf;				/* ŸΥǡ */
	/* ӥǥͭ */
	BitmapInfoHeader *bmih;		/* ŸΥեޥå */
	gint pos;					/* Ǹ˼ե졼 */
	/* ǥͭ */
	WaveFormatEx *wfx;			/* ŸΥեޥå */
} AviEdit;


/******************************************************************************
*                                                                             *
* եޥåȥޥ                                                          *
*                                                                             *
******************************************************************************/
/*	AVI
	avi_edit,AVIԽϥɥ
	     RET,,0:顼													*/
#define avi_get_width(avi_edit)												\
					((avi_edit)->bmih!=NULL?bmih_get_width((avi_edit)->bmih):0)


/*	AVIι⤵
	avi_edit,AVIԽϥɥ
	     RET,⤵,0:顼													*/
#define avi_get_height(avi_edit)											\
				((avi_edit)->bmih!=NULL?bmih_get_height((avi_edit)->bmih):0)


/*	AVIο
	avi_edit,AVIԽϥɥ
	     RET,,0:顼													*/
#define avi_get_bit_count(avi_edit)											\
				((avi_edit)->bmih!=NULL?bmih_get_bit_count((avi_edit)->bmih):0)


/*	AVIX٤
	avi_edit,AVIԽϥɥ
	     RET,X,-1:顼												*/
#define avi_get_x_pixels_per_meter(avi_edit)								\
	((avi_edit)->bmih!=NULL?bmih_get_x_pixels_per_meter((avi_edit)->bmih):-1)


/*	AVIY٤
	avi_edit,AVIԽϥɥ
	     RET,Y,-1:顼												*/
#define avi_get_y_pixels_per_meter(avi_edit)								\
	((avi_edit)->bmih!=NULL?bmih_get_y_pixels_per_meter((avi_edit)->bmih):-1)


/*	AVIΥ졼Ȥ
	avi_edit,AVIԽϥɥ
	     RET,졼,0:顼												*/
#define avi_get_samples_per_sec(avi_edit)									\
			((avi_edit)->wfx!=NULL?wfx_get_samples_per_sec((avi_edit)->wfx):0)


/*	AVIΥͥ
	avi_edit,AVIԽϥɥ
	     RET,ͥ,0:顼											*/
#define avi_get_channels(avi_edit)											\
					((avi_edit)->wfx!=NULL?wfx_get_channels((avi_edit)->wfx):0)


/*	AVIΥӥåȤ
	avi_edit,AVIԽϥɥ
	     RET,ӥå,0:顼												*/
#define avi_get_bits_per_sample(avi_edit)									\
			((avi_edit)->wfx!=NULL?wfx_get_bits_per_sample((avi_edit)->wfx):0)


/*	AVIꤹ
	avi_edit,AVIԽϥɥ
	   width,																*/
#define avi_set_width(avi_edit,width)										\
			((avi_edit)->bmih!=NULL?bmih_set_width((avi_edit)->bmih,width):0)


/*	AVIι⤵ꤹ
	avi_edit,AVIԽϥɥ
	  height,⤵															*/
#define avi_set_height(avi_edit,height)										\
			((avi_edit)->bmih!=NULL?bmih_set_height((avi_edit)->bmih,height):0)


/*	AVIοꤹ
	 avi_edit,AVIԽϥɥ
	bit_count,															*/
#define avi_set_bit_count(avi_edit,bit_count)								\
	((avi_edit)->bmih!=NULL													\
		?(bm_header_bytes((avi_edit)->bmih)									\
			<bx_header_bytes(	bmih_get_width((avi_edit)->bmih),			\
								bmih_get_height((avi_edit)->bmih),			\
								bit_count,									\
								bmih_get_compression((avi_edit)->bmih),		\
								bmih_get_color_used((avi_edit)->bmih))		\
			?((avi_edit)->bmih=g_realloc((avi_edit)->bmih,					\
					bx_header_bytes(bmih_get_width((avi_edit)->bmih),		\
									bmih_get_height((avi_edit)->bmih),		\
									bit_count,								\
									bmih_get_compression((avi_edit)->bmih),	\
									bmih_get_color_used((avi_edit)->bmih))))\
			:NULL															\
		),bmih_set_bit_count((avi_edit)->bmih,bit_count)					\
		:0)


/*	AVIX٤ꤹ
	          avi_edit,AVIԽϥɥ
	x_pixels_per_meter,X												*/
#define avi_set_x_pixels_per_meter(avi_edit,x_pixels_per_meter)				\
		((avi_edit)->bmih!=NULL												\
		?bmih_set_x_pixels_per_meter((avi_edit)->bmih,x_pixels_per_meter):-1)


/*	AVIY٤ꤹ
	          avi_edit,AVIԽϥɥ
	y_pixels_per_meter,Y												*/
#define avi_set_y_pixels_per_meter(avi_edit,y_pixels_per_meter)				\
		((avi_edit)->bmih!=NULL												\
		?bmih_set_y_pixels_per_meter((avi_edit)->bmih,y_pixels_per_meter):-1)


/*	AVIΥ졼Ȥꤹ
	       avi_edit,AVIԽϥɥ
	samples_per_sec,졼													*/
#define avi_set_samples_per_sec(avi_edit,samples_per_sec)					\
				((avi_edit)->wfx!=NULL										\
				?wfx_set_samples_per_sec((avi_edit)->wfx,samples_per_sec):0)


/*	AVIΥͥꤹ
	avi_edit,AVIԽϥɥ
	channels,ͥ														*/
#define avi_set_channels(avi_edit,channels)									\
		((avi_edit)->wfx!=NULL?wfx_set_channels((avi_edit)->wfx,channels):0)


/*	AVIΥӥåȤꤹ
	       avi_edit,AVIԽϥɥ
	bits_per_sample,ӥå													*/
#define avi_set_bits_per_sample(avi_edit,bits_per_sample)					\
				((avi_edit)->wfx!=NULL										\
				?wfx_set_bits_per_sample((avi_edit)->wfx,bits_per_sample):0)


/******************************************************************************
*                                                                             *
* ץ/֥ޥ                                                         *
*                                                                             *
******************************************************************************/
/*	AVIΥפ
	avi_edit,AVIԽϥɥ
	     RET,streamtypeAUDIO/streamtypeVIDEO								*/
#define avi_type(avi_edit) (((AviEdit *)(avi_edit))->type)


/*	AVIRate
	avi_edit,AVIԽϥɥ
	     RET,Rate															*/
#define avi_rate(avi_edit) (((AviEdit *)(avi_edit))->rate)


/*	AVIScale
	avi_edit,AVIԽϥɥ
	     RET,Scale															*/
#define avi_scale(avi_edit) (((AviEdit *)(avi_edit))->scale)


/*	AVIΥץֹ椫֤
	avi_edit,AVIԽϥɥ
	  sample,ץֹ
	     RET,(ߥ)													*/
#define avi_sample_to_time(avi_edit,sample)									\
		(gint)((guint64)(sample)*avi_scale(avi_edit)*1000/avi_rate(avi_edit))


/*	AVIλ֤饵ץֹ
	avi_edit,AVIԽϥɥ
	    time,(ߥ)
	     RET,ץֹ													*/
#define avi_time_to_sample(avi_edit,time)									\
								(gint)((guint64)(time)*avi_rate(avi_edit)	\
										/((guint64)avi_scale(avi_edit)*1000))


/*	AVIĹ
	avi_edit,AVIԽϥɥ
	     RET,ץ														*/
#define avi_length(avi_edit) (((AviEdit *)(avi_edit))->length)


/*	AVIĹ֤ǵ
	avi_edit,AVIԽϥɥ
	     RET,(ߥ)													*/
#define avi_length_time(avi_edit)											\
							avi_sample_to_time(avi_edit,avi_length(avi_edit))


/******************************************************************************
*                                                                             *
* Խޥ                                                                  *
*                                                                             *
******************************************************************************/
/*	AVIʣ
	avi_edit,AVIԽϥɥ
	     RET,AVIԽϥɥ												*/
#define avi_clone(avi_edit) avi_copy(avi_edit,0,avi_length(avi_edit))


/******************************************************************************
*                                                                             *
* ؿ                                                                  *
*                                                                             *
******************************************************************************/
/*	AVI															*/
void avi_file_init(void);


/*	AVIλ															*/
void avi_file_exit(void);


/******************************************************************************
*                                                                             *
* AVIϴؿ()                                                         *
*                                                                             *
******************************************************************************/
/*	եȽ̤
	file,ե̾
	 RET,0:AVI,1:ӥåȥޥå,2:WAVEե,3:ʥꥪ֥,-1:	*/
gint avi_file_type(const gchar *file);


/*	AVIΥȥ꡼ο
	file,ե̾
	 RET,ȥ꡼ο,0:顼											*/
guint32 avi_main_streams(const gchar *file);


/*	AVIե뤫鳫
	 file,ե̾
	param,ȥ꡼ֹ
	  RET,AVIԽϥɥ,NULL:顼										*/
AviEdit *avi_open(const gchar *file,const gint param);


/*	AVIĤ
	avi_edit,AVIԽϥɥ
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean avi_release(AviEdit *avi_edit);


/*	AVIΥǡΥХȿ
	avi_edit,AVIԽϥɥ
	   start,ɤ߹ߤϤ륵ץֹ
	 samples,ץ
	     RET,Хȿ														*/
gint avi_sample_size(AviEdit *avi_edit,const gint start,const gint samples);


/*	AVIΥǡɤ߹
	avi_edit,AVIԽϥɥ
	   start,ɤ߹ߤϤ륵ץֹ
	 samples,ץ
	  buffer,ǡǼХåե
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean avi_read(AviEdit *avi_edit,const gint start,const gint samples,
															gpointer buffer);


/*	AVIΥեޥåȤΥ
	avi_edit,AVIԽϥɥ
	     RET,եޥåȤΥХȿ,0:顼								*/
gint avi_format_size(AviEdit *avi_edit);


/*	AVIΥեޥåȤɤ߹
	avi_edit,AVIԽϥɥ
	  format,ХåեؤΥݥ
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean avi_read_format(AviEdit *avi_edit,gpointer format);


/******************************************************************************
*                                                                             *
* ե졼ؿ(ߤ)                                                        *
*                                                                             *
******************************************************************************/
/*	DIBŸ줿ե졼
	 avi_edit,AVIԽϥɥ
	      pos,ե졼(ץֹ)
	    width,
	   height,⤵
	      RET,ѥåDIBؤΥݥ,NULL:顼								*/
BitmapInfoHeader *avi_get_frame(AviEdit *avi_edit,const gint pos,
										const gint width,const gint height);


/*	ե졼बե졼फȽꤹ
	avi_edit,AVIԽϥɥ
	     pos,ե졼(ץֹ)
	     RET,TRUE:ե졼,FALSE:󥭡ե졼							*/
gboolean avi_is_keyframe(AviEdit *avi_edit,const gint pos);


/******************************************************************************
*                                                                             *
* Խؿ(줿)                                                            *
*                                                                             *
******************************************************************************/
/*	AVI
	avi_edit,AVIԽϥɥ
	   start,Ϥ륵ץֹ
	 samples,ץ
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean avi_delete(AviEdit *avi_edit,const gint start,const gint samples);


/*	AVI򥳥ԡ
	avi_edit,AVIԽϥɥ
	   start,ԡϤ륵ץֹ
	 samples,ץ
	     RET,AVIԽϥɥ,NULL:顼									*/
AviEdit *avi_copy(AviEdit *avi_edit,const gint start,const gint samples);


/*	AVIŽդ
	avi_dst,ŽդAVIԽϥɥ
	    pos,Žդ륵ץֹ
	avi_src,ŽդAVIԽϥɥ
	    RET,TRUE:ｪλ,FALSE:顼										*/
gboolean avi_paste(AviEdit *avi_dst,const gint pos,AviEdit *avi_src);


/******************************************************************************
*                                                                             *
* ʥꥪ֥ȴؿ(פ)                                            *
*                                                                             *
******************************************************************************/
/*	AVI򥷥ʥꥪ֥ȤѴ
	  avi_edit,AVIԽϥɥؤΥݥ
	interleave,TRUE:󥿡꡼֤,FALSE:󥿡꡼֤ʤ
	       RET,ʥꥪ֥,NULL:顼								*/
gchar *avi_to_scenario(AviEdit *avi_edit[],const gboolean interleave);


/*	ʥꥪ֥ȤAVI
	scenario,ʥꥪ֥
	     RET,AVIԽϥɥؤΥݥ,NULL:顼						*/
AviEdit **avi_from_scenario(const gchar *scenario);


/******************************************************************************
*                                                                             *
* ¸ؿ()                                                            *
*                                                                             *
******************************************************************************/
/*	ӥåȥޥåץե¸
	 avi_edit,AVIԽϥɥ
	     file,ե̾
	    start,ǽΥե졼
	      end,ǸΥե졼
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean avi_save_bitmap(AviEdit *avi_edit,
						const gchar *file,const gint start,const gint end,
						gboolean (*func)(gint,gpointer),gpointer user_data);


/*	WAVEե¸
	 avi_edit,AVIԽϥɥ
	     file,ե̾
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean avi_save_wave(AviEdit *avi_edit,const gchar *file,
						gboolean (*func)(gint,gpointer),gpointer user_data);


/*	ե¸
	 avi_edit,AVIԽϥɥؤΥݥ
	     file,ե̾
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean avi_save(AviEdit *avi_edit[],const gchar *file,
						gboolean (*func)(gint,gpointer),gpointer user_data);


#ifdef __cplusplus
}
#endif
#endif
