/*
    dllloader
    (C)Copyright 2000 by Hiroshi Takekawa
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "advapi32.h"
#include "misc/profile.h"


/******************************************************************************
*                                                                             *
* 쥸ȥ                                                                  *
*                                                                             *
******************************************************************************/
#define ERROR_SUCCESS			0
#define ERROR_UNKNOWN			99999
#define HKEY_CLASSES_ROOT		0x80000000
#define HKEY_CURRENT_USER		0x80000001
#define HKEY_LOCAL_MACHINE		0x80000002
#define HKEY_USERS				0x80000003
#define HKEY_PERFORMANCE_DATA	0x80000004
#define HKEY_CURRENT_CONFIG		0x80000005
#define HKEY_DYN_DATA			0x80000006


typedef HANDLE HKEY,*PHKEY,*LPHKEY;
typedef DWORD REGSAM;


static LONG WINAPI RegCloseKey(HKEY hKey)
{
	g_debug("RegCloseKey");
	g_free(hKey);
	return ERROR_SUCCESS;
}


static LONG WINAPI RegCreateKeyA(HKEY hKey,LPCSTR lpSubKey,PHKEY phkResult)
{
	gchar *key;

	g_debug("RegCreateKeyA");
	if (hKey==NULL || phkResult==NULL)
		return ERROR_UNKNOWN;
	key=lpSubKey==NULL || lpSubKey[0]=='\0'
								?g_strdup(""):g_strdup_printf("\\%s",lpSubKey);
	switch ((gint)hKey) {
		case HKEY_CLASSES_ROOT:
			*phkResult=g_strdup_printf("HKEY_CLASSES_ROOT%s",key);
			break;
		case HKEY_CURRENT_USER:
			*phkResult=g_strdup_printf("HKEY_CURRENT_USER%s",key);
			break;
		case HKEY_LOCAL_MACHINE:
			*phkResult=g_strdup_printf("HKEY_LOCAL_MACHINE%s",key);
			break;
		case HKEY_USERS:
			*phkResult=g_strdup_printf("HKEY_USERS%s",key);
			break;
		case HKEY_PERFORMANCE_DATA:
			*phkResult=g_strdup_printf("HKEY_PERFORMANCE_DATA%s",key);
			break;
		case HKEY_CURRENT_CONFIG:
			*phkResult=g_strdup_printf("HKEY_CURRENT_CONFIG%s",key);
			break;
		case HKEY_DYN_DATA:
			*phkResult=g_strdup_printf("HKEY_DYN_DATA%s",key);
			break;
		default:
			*phkResult=g_strdup_printf("%s%s",(gchar *)hKey,key);
	}
	g_free(key);
	return ERROR_SUCCESS;
}


static LONG WINAPI RegCreateKeyExA(HKEY hKey,LPCSTR lpSubKey,DWORD Reserved,
							LPSTR lpClass,DWORD dwOptions,REGSAM samDesired,
									LPSECURITY_ATTRIBUTES lpSecurityAttributes,
									PHKEY phkResult,LPDWORD lpdwDisposition)
{
	g_debug("RegCreateKeyExA");
	return RegCreateKeyA(hKey,lpSubKey,phkResult);
}


static LONG WINAPI RegDeleteKeyA(HKEY hKey,LPCSTR lpSubKey)
{
	gboolean result=FALSE;
	gchar *file,*key;
	Profile *profile;

	g_debug("RegDeleteKeyA");
	if (hKey==NULL)
		return ERROR_UNKNOWN;
	file=g_strdup_printf("%s/.%s",
								g_get_home_dir(),g_basename(g_get_prgname()));
	if ((profile=profile_open(file))!=NULL) {
		if (RegCreateKeyA(hKey,lpSubKey,(PHKEY)&key)==ERROR_SUCCESS) {
			result=profile_delete_key(profile,"registry",key);
			RegCloseKey(key);
		}
		profile_close(profile);
	}
	g_free(file);
	return result?ERROR_SUCCESS:ERROR_UNKNOWN;
}


static LONG WINAPI RegEnumKeyA(HKEY hKey,DWORD dwIndex,LPSTR lpName,
																DWORD cchName)
{
	return ERROR_UNKNOWN;
}


static LONG WINAPI RegEnumKeyExA(HKEY hKey,DWORD dwIndex,LPSTR lpName,
			LPDWORD lpcName,LPDWORD lpReserved,LPSTR lpClass,LPDWORD lpcClass,
												PFILETIME lpftLastWriteTime)
{
	return RegEnumKeyA(hKey,dwIndex,lpName,*lpcName);
}


static LONG WINAPI RegOpenKeyExA(HKEY hKey,LPCSTR lpSubKey,
							DWORD ulOptions,REGSAM samDesired,PHKEY phkResult)
{
	g_debug("RegOpenKeyExA");
	return RegCreateKeyA(hKey,lpSubKey,phkResult);
}


static LONG WINAPI RegQueryValueA(HKEY hKey,LPCSTR lpSubKey,
												LPSTR lpValue,PLONG lpcbValue)
{
	gboolean result=FALSE;
	gchar *file,*key;
	gint size;
	Profile *profile;

	g_debug("RegQueryValueA");
	if (hKey==NULL)
		return ERROR_UNKNOWN;
	if (lpcbValue==NULL)
		return lpValue==NULL?ERROR_SUCCESS:ERROR_UNKNOWN;
	file=g_strdup_printf("%s/.%s",
								g_get_home_dir(),g_basename(g_get_prgname()));
	if ((profile=profile_open(file))!=NULL) {
		if (RegCreateKeyA(hKey,lpSubKey,(PHKEY)&key)==ERROR_SUCCESS) {
			if ((size=profile_get_size(profile,"registry",key,
												PROFILE_VALUE_TYPE_ARRAY))>0) {
				if (lpValue==NULL)
					result=TRUE;
				else if (size<=*lpcbValue)
					result=profile_get_value(profile,"registry",key,
								lpValue,*lpcbValue,PROFILE_VALUE_TYPE_ARRAY);
				*lpcbValue=size;
			}
			RegCloseKey(key);
		}
		profile_close(profile);
	}
	g_free(file);
	return result?ERROR_SUCCESS:ERROR_UNKNOWN;
}


static LONG WINAPI RegQueryValueExA(HKEY hKey,LPCSTR lpValueName,
			LPDWORD lpReserved,LPDWORD lpType,LPBYTE lpData,LPDWORD lpcbData)
{
	g_debug("RegQueryValueExA");
	return RegQueryValueA(hKey,lpValueName,lpData,lpcbData);
}


static LONG WINAPI RegSetValueA(HKEY hKey,LPCSTR lpSubKey,DWORD dwType,
													LPCSTR lpData,DWORD cbData)
{
	gboolean result=FALSE;
	gchar *file,*key;
	Profile *profile;

	g_debug("RegSetValueA");
	if (hKey==NULL)
		return ERROR_UNKNOWN;
	file=g_strdup_printf("%s/.%s",
								g_get_home_dir(),g_basename(g_get_prgname()));
	if ((profile=profile_open(file))!=NULL) {
		if (RegCreateKeyA(hKey,lpSubKey,(PHKEY)&key)==ERROR_SUCCESS) {
			result=profile_set_value(profile,"registry",key,
							(gpointer)lpData,cbData,PROFILE_VALUE_TYPE_ARRAY);
			RegCloseKey(key);
		}
		profile_close(profile);
	}
	g_free(file);
	return result?ERROR_SUCCESS:ERROR_UNKNOWN;
}


static LONG WINAPI RegSetValueExA(HKEY hKey,LPCSTR lpValueName,DWORD Reserved,
								DWORD dwType,CONST BYTE *lpData,DWORD cbData)
{
	g_debug("RegSetValueExA");
	return RegSetValueA(hKey,lpValueName,dwType,lpData,cbData);
}


/******************************************************************************
*                                                                             *
* Ͽ                                                                        *
*                                                                             *
******************************************************************************/
static VOID WINAPI UnknownSymbol(VOID)
{
	g_message("unknown symbol in advapi32 called");
}


static SymbolInfo symbol_infos[]={
	{"RegCloseKey",RegCloseKey},
	{"RegCreateKeyA",RegCreateKeyA},
	{"RegCreateKeyExA",RegCreateKeyExA},
	{"RegDeleteKeyA",RegDeleteKeyA},
	{"RegDeleteValueA",RegDeleteKeyA},
	{"RegEnumKeyA",RegEnumKeyA},
	{"RegEnumKeyExA",RegEnumKeyExA},
	{"RegOpenKeyA",RegCreateKeyA},
	{"RegOpenKeyExA",RegOpenKeyExA},
	{"RegQueryValueA",RegQueryValueA},
	{"RegQueryValueExA",RegQueryValueExA},
	{"RegSetValueA",RegSetValueA},
	{"RegSetValueExA",RegSetValueExA},
	{NULL,UnknownSymbol}
};


SymbolInfo *advapi32_get_export_symbols(void)
{
	return symbol_infos;
}
