/*
    dllloader
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "iso10646.h"


/******************************************************************************
*                                                                             *
* ISO-10646                                                                   *
*                                                                             *
******************************************************************************/
gint iso10646_multibyte_to_widechar(const gchar *src,const gint srclen,
												guint16 *dst,const gint dstlen)
{
	gint i,leng;

	if (src==NULL)
		return 0;
	leng=srclen<0?g_strlen(src)+1:srclen;
	if (dst==NULL || dstlen<=0)
		return leng;
	if (leng>dstlen)
		leng=dstlen;
	for (i=0;i<leng;i++)
		dst[i]=(src[i]&0x80)==0?src[i]:'?';
	return i;
}


gint iso10646_widechar_to_multibyte(const guint16 *src,const gint srclen,
												gchar *dst,const gint dstlen)
{
	gint i,leng;

	if (src==NULL)
		return 0;
	if (srclen<0) {
		for (leng=0;src[leng]>0;leng++);
		leng++;
	} else {
		leng=srclen;
	}
	if (dst==NULL || dstlen<=0)
		return leng;
	if (leng>dstlen)
		leng=dstlen;
	for (i=0;i<leng;i++)
		dst[i]=src[i]<0x80?src[i]:'?';
	return i;
/*	gchar *text;
	gint i,leng,result;
	GdkWChar wbuf[2];

	if (src==NULL)
		return 0;
	if (srclen<0) {
		for (leng=0;src[leng]>0;leng++);
		leng++;
	} else {
		leng=srclen;
	}
	wbuf[1]=0;
	result=0;
	if (dst==NULL || dstlen<=0) {
		for (i=0;i<leng;i++)
			if (src[i]!=0) {
				wbuf[0]=src[i];
				text=gdk_wcstombs(wbuf);
				if (text!=NULL) {
					result+=g_strlen(text);
					g_free(text);
				} else {
					result++;
				}
			} else {
				result++;
			}
	} else {
		for (i=0;i<leng;i++) {
			if (src[i]!=0) {
				wbuf[0]=src[i];
				text=gdk_wcstombs(wbuf);
				if (text!=NULL) {
					g_memmove(dst+result,text,g_strlen(text));
					result+=g_strlen(text);
					g_free(text);
				} else {
					dst[result++]='?';
				}
			} else {
				dst[result++]='\0';
			}
		}
	}
	return result;*/
}
