/*
    Video maid
    copyright (c) 1998-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "save.h"
#include <gdk/gdkkeysyms.h>


/******************************************************************************
*                                                                             *
* ̾դ¸ؿ                                            *
*                                                                             *
******************************************************************************/
static gboolean save_clicked_ok;
static GtkWidget *dialog,*button0,*frame1,*label0,*label1;
static GtkWidget *radio0,*radio1,*radio2,*radio3,*spin0,*spin1;


/* ԥܥͤѲ */
static void save_dialog_changed(GtkWidget *widget,FileSave *save)
{
	gint start=0,end=0;

	start=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin0));
	end=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
	gtk_widget_set_sensitive(button0,0<=start && start<=end && end<=save->max);
}


/* OKܥ󤬲줿 */
static void save_dialog_clicked(GtkWidget *widget,FileSave *save)
{
	if (radio0!=NULL
					&& gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio0)))
		save->mode=0;
	else if (radio1!=NULL
					&& gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio1)))
		save->mode=1;
	else if (radio2!=NULL
					&& gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio2)))
		save->mode=2;
	else
		save->mode=3;
	if (frame1!=NULL) {
		save->start=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin0));
		save->end=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
	}
	gtk_widget_destroy(dialog);
	save_clicked_ok=TRUE;
}


/* 饸ܥ󤬲줿 */
static void save_dialog_toggled(GtkWidget *widget,FileSave *save)
{
	gint start,end;

	if (frame1!=NULL) {
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio1))) {
			start=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin0));
			end=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
			gtk_widget_set_sensitive(button0,
									0<=start && start<=end && end<=save->max);
			gtk_widget_set_sensitive(frame1,TRUE);
		} else {
			gtk_widget_set_sensitive(button0,TRUE);
			gtk_widget_set_sensitive(frame1,FALSE);
		}
	}
}


/* ԥܥǥ꥿󤬲줿 */
static void save_dialog_activate(GtkWidget *widget,FileSave *save)
{
	gint start=0,end=0;

	if (frame1!=NULL) {
		start=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin0));
		end=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
	}
	if (frame1==NULL || (0<=start && start<=end && end<=save->max))
		save_dialog_clicked(widget,save);
}


/* ESC줿 */
static gboolean save_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


gboolean save_dialog(FileSave *save)
{
	guint key;
	GSList *glist;
	GtkAccelGroup *accel;
	GtkWidget *button1,*frame0,*hbox,*vbox;

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),_("Save As"));
	gtk_signal_connect_after(GTK_OBJECT(dialog),"key-press-event",
								GTK_SIGNAL_FUNC(save_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	/* 졼 */
	accel=gtk_accel_group_new();
	gtk_accel_group_attach(accel,GTK_OBJECT(dialog));
	/* ܥ */
	button0=gtk_button_new_with_label(_("OK"));
	button1=gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect(GTK_OBJECT(button0),"clicked",save_dialog_clicked,save);
	gtk_signal_connect_object(GTK_OBJECT(button1),"clicked",
										gtk_widget_destroy,GTK_OBJECT(dialog));
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	if (save->avi[0]!=NULL) {
		/* ԥܥ */
		spin0=gtk_spin_button_new(GTK_ADJUSTMENT(
					gtk_adjustment_new(save->start,0,save->max,1,5,0)),0,0);
		spin1=gtk_spin_button_new(GTK_ADJUSTMENT(
					gtk_adjustment_new(save->end,0,save->max,1,5,0)),0,0);
		gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin0),TRUE);
		gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin1),TRUE);
		gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(spin0),GTK_SHADOW_IN);
		gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(spin1),GTK_SHADOW_IN);
		gtk_signal_connect(GTK_OBJECT(spin0),"activate",
													save_dialog_activate,save);
		gtk_signal_connect(GTK_OBJECT(spin1),"activate",
													save_dialog_activate,save);
		gtk_signal_connect(GTK_OBJECT(spin0),"changed",
													save_dialog_changed,save);
		gtk_signal_connect(GTK_OBJECT(spin1),"changed",
													save_dialog_changed,save);
		/* ٥ */
		label0=gtk_label_new(NULL);
		label1=gtk_label_new(NULL);
		key=gtk_label_parse_uline(GTK_LABEL(label0),_("_Start"));
		gtk_widget_add_accelerator(spin0,"grab-focus",accel,key,
															GDK_MOD1_MASK,0);
		key=gtk_label_parse_uline(GTK_LABEL(label1),_("_End"));
		gtk_widget_add_accelerator(spin1,"grab-focus",accel,key,
															GDK_MOD1_MASK,0);
		/* 饸ܥ */
		radio0=gtk_radio_button_new_with_label(NULL,NULL);
		radio1=gtk_radio_button_new_with_label_from_widget(
												GTK_RADIO_BUTTON(radio0),NULL);
		key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(radio0)->child),
																_("_AVI"));
		gtk_widget_add_accelerator(radio0,"clicked",accel,key,GDK_MOD1_MASK,0);
		key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(radio1)->child),
																_("_Bitmap"));
		gtk_widget_add_accelerator(radio1,"clicked",accel,key,GDK_MOD1_MASK,0);
		gtk_signal_connect(GTK_OBJECT(radio0),"toggled",
									GTK_SIGNAL_FUNC(save_dialog_toggled),save);
		gtk_signal_connect(GTK_OBJECT(radio1),"toggled",
									GTK_SIGNAL_FUNC(save_dialog_toggled),save);
		glist=gtk_radio_button_group(GTK_RADIO_BUTTON(radio0));
		/* ե졼ȥܥå */
		vbox=gtk_vbox_new(FALSE,8);
		gtk_container_set_border_width(GTK_CONTAINER(vbox),8);
		hbox=gtk_hbox_new(FALSE,0);
		gtk_container_set_border_width(GTK_CONTAINER(hbox),8);
		gtk_box_pack_start(GTK_BOX(hbox),label0,FALSE,FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox),spin0,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
		hbox=gtk_hbox_new(FALSE,0);
		gtk_container_set_border_width(GTK_CONTAINER(hbox),8);
		gtk_box_pack_start(GTK_BOX(hbox),label1,FALSE,FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox),spin1,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
		frame1=gtk_frame_new(_("Range"));
	gtk_container_add(GTK_CONTAINER(frame1),vbox);
	} else {
		frame1=label0=label1=spin0=spin1=radio0=radio1=NULL;
		glist=NULL;
	}
	if (save->avi[1]!=NULL) {
		/* 饸ܥ */
		radio2=gtk_radio_button_new_with_label(glist,NULL);
		key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(radio2)->child),
																_("_WAVE"));
		gtk_widget_add_accelerator(radio2,"clicked",accel,key,GDK_MOD1_MASK,0);
		gtk_signal_connect(GTK_OBJECT(radio2),"toggled",
									GTK_SIGNAL_FUNC(save_dialog_toggled),save);
		glist=gtk_radio_button_group(GTK_RADIO_BUTTON(radio0));
	} else {
		radio2=NULL;
	}
	/* 饸ܥ */
	radio3=gtk_radio_button_new_with_label(glist,NULL);
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(radio3)->child),
														_("Scenario _Object"));
	gtk_widget_add_accelerator(radio3,"clicked",accel,key,GDK_MOD1_MASK,0);
	gtk_signal_connect(GTK_OBJECT(radio3),"toggled",
									GTK_SIGNAL_FUNC(save_dialog_toggled),save);

	/* ե졼ȥܥå */
	vbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),8);
	if (radio0!=NULL) {
		gtk_box_pack_start(GTK_BOX(vbox),radio0,FALSE,FALSE,0);
		gtk_box_pack_start(GTK_BOX(vbox),radio1,FALSE,FALSE,0);
	}
	if (radio2!=NULL)
		gtk_box_pack_start(GTK_BOX(vbox),radio2,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),radio3,FALSE,FALSE,0);
	frame0=gtk_frame_new(_("Format"));
	gtk_container_add(GTK_CONTAINER(frame0),vbox);

	vbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),8);

	if (frame1!=NULL) {
		hbox=gtk_hbox_new(FALSE,8);
		gtk_box_pack_start(GTK_BOX(hbox),frame0,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(hbox),frame1,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(vbox),hbox,TRUE,TRUE,0);
	} else {
		gtk_box_pack_start(GTK_BOX(vbox),frame0,TRUE,TRUE,0);
	}

	hbox=gtk_hbox_new(FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button1,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button0,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(dialog),vbox);

	/* ɽ */
	if (frame1!=NULL)
		gtk_widget_set_sensitive(frame1,FALSE);
	gtk_widget_grab_focus(button0);

	save_clicked_ok=FALSE;

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();

	return save_clicked_ok;
}
