/*
    Video maid
    copyright (c) 1998-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "thread.h"
#include <time.h>


/******************************************************************************
*                                                                             *
* åɴؿ                                                              *
*                                                                             *
******************************************************************************/
G_LOCK_DEFINE_STATIC(critical);
static volatile gint critical=FALSE;


/*	ꥹȤ˲ä
	  id,åID
	mode,⡼(0:λ,1:,2:¸,3:ե졼,4:ȿž)
	file,ե̾
	 RET,TRUE:ｪλ,FALSE:顼											*/
#ifdef USE_GTK2
gboolean thread_insert(GThread *id,const gint mode,const gchar *file)
#else
gboolean thread_insert(pthread_t id,const gint mode,const gchar *file)
#endif
{
	gchar *text[4];
	gchar *name[]={N_("Exit"),N_("Open"),N_("Save"),N_("Change Frames"),
																N_("Reverse")};
	time_t tm;
	ThreadList *tl;

	tl=g_malloc(sizeof(ThreadList));
	tl->mode=mode;
	tl->percent=0;
	tl->userbreak=TRUE;
	tl->id=id;
	/* ⡼ */
	text[0]=name[mode];
	/* ե̾ */
	text[1]=file!=NULL?(gchar *)file:"";
	/*  */
	tm=time(NULL);
	text[2]=ctime(&tm);
	/* ʹԾ */
	text[3]="0";
	/*  */
	G_LOCK(critical);
	critical=TRUE;
	gdk_threads_enter();
	gtk_clist_set_row_data(GTK_CLIST(clist),
								gtk_clist_append(GTK_CLIST(clist),text),tl);
	gtk_clist_columns_autosize(GTK_CLIST(clist));
	critical=FALSE;
	gdk_threads_leave();
	G_UNLOCK(critical);
	return TRUE;
}


/*	ꥹȤ˲ä
	     id,åID
	percent,ʹԾ
	    RET,TRUE:³,FALSE:											*/
#ifdef USE_GTK2
gboolean thread_idling(GThread *id,const gint percent)
#else
gboolean thread_idling(pthread_t id,const gint percent)
#endif
{
	gchar *text;
	gint i;
	ThreadList *tl=NULL;

	G_LOCK(critical);
	critical=TRUE;
	gdk_threads_enter();
	/* ID˰פ륢ƥõ */
	for (i=0;i<GTK_CLIST(clist)->rows;i++) {
		tl=gtk_clist_get_row_data(GTK_CLIST(clist),i);
		if (tl->id==id)
			break;
	}
	if (tl==NULL) {
		gdk_threads_leave();
		critical=FALSE;
		G_UNLOCK(critical);
		return FALSE;
	}
	if (tl->userbreak && tl->percent!=percent) {
		/* ǤǤϤʤĿʹԾۤʤȤ */
		tl->percent=percent;
		text=percent>=0?g_strdup_printf("%d",percent):g_strdup(_("Error"));
		gtk_clist_set_text(GTK_CLIST(clist),i,3,text);
		g_free(text);
		gtk_clist_set_column_width(GTK_CLIST(clist),3,
						gtk_clist_optimal_column_width(GTK_CLIST(clist),3));
	}
	critical=FALSE;
	gdk_threads_leave();
	G_UNLOCK(critical);
	return tl->userbreak;
}


/*	ꥹȤ
	 id,åID
	RET,TRUE:ｪλ,FALSE:顼											*/
#ifdef USE_GTK2
gboolean thread_delete(GThread *id)
#else
gboolean thread_delete(pthread_t id)
#endif
{
	gint i;
	ThreadList *tl;

	G_LOCK(critical);
	critical=TRUE;
	gdk_threads_enter();
	/* ID˰פ륢ƥõ */
	for (i=0;i<GTK_CLIST(clist)->rows;i++) {
		tl=gtk_clist_get_row_data(GTK_CLIST(clist),i);
		if (tl->id==id) {
			/* ꥹȤ˥ƥबȤ */
			g_free(tl);
			gtk_clist_remove(GTK_CLIST(clist),i);
			break;
		}
	}
	gdk_threads_leave();
	critical=FALSE;
	G_UNLOCK(critical);
	return TRUE;
}


/*	ꥹȤ
	all,TRUE:٤ƤΥå,FALSE:򤵤줿åɤΤ
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean thread_break(const gboolean all)
{
	gint i;
	ThreadList *tl;

	for (i=0;i<GTK_CLIST(clist)->rows;i++)
		if (all || ((GtkCListRow *)
					(g_list_nth(GTK_CLIST(clist)->row_list,i)->data))->state
														==GTK_STATE_SELECTED) {
			tl=gtk_clist_get_row_data(GTK_CLIST(clist),i);
			if (tl->userbreak) {
				/* ɽѹ */
				tl->userbreak=FALSE;
				gtk_clist_set_text(GTK_CLIST(clist),i,3,"*");
				gtk_clist_set_column_width(GTK_CLIST(clist),3,
						gtk_clist_optimal_column_width(GTK_CLIST(clist),3));
			}
		}
	return TRUE;
}


/*	ץνλ(Ωå)											*/
void *close_program(void)
{
	gboolean result;
	gint i,count,length;
#ifdef USE_GTK2
	GThread *id;
#else
	pthread_t id;
#endif
	GList *glist;
	ThreadList *tl;

#ifdef USE_GTK2
	id=g_thread_self();
#else
	id=pthread_self();
#endif
	thread_insert(id,0,NULL);

	do {
#ifdef USE_GTK2
		g_thread_yield();
#endif
		G_LOCK(critical);
		critical=TRUE;
		gdk_threads_enter();

		/* λåɤ˰פ륢ƥõ */
		count=GTK_CLIST(clist)->rows;
		result=FALSE;
		for (i=count-1;i>=0;i--) {
			tl=gtk_clist_get_row_data(GTK_CLIST(clist),i);
			if (tl->mode==0) {
				/* ꥹȤ˥ƥबȤ */
				result=tl->id!=id;
				break;
			}
		}
		/* Ρȥ֥åλҥɥ */
		glist=gtk_container_children(GTK_CONTAINER(notebook));
		length=g_list_length(glist);
		g_list_free(glist);

		gdk_threads_leave();
		critical=FALSE;
		G_UNLOCK(critical);

		/* ꥹȤ˽λꡢΥåɰʳʤФΥåɤ˴ */
		if (result || !thread_idling(id,0)) {
			thread_delete(id);
			return NULL;
		}
	} while (count>1 || length>0);
	thread_delete(id);
	gdk_threads_enter();
	gtk_widget_destroy(window);
	gdk_threads_leave();
	return NULL;
}
