/*
    fileio
    copyright (c) 2002-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "fileio.h"


/******************************************************************************
*                                                                             *
* եϴؿ                                                        *
*                                                                             *
******************************************************************************/
/*	ե¸߳ǧ
	file,ե̾
	test,
	 RET,TRUE:פ,FALSE:פʤ										*/
gboolean
fileio_test (const gchar *file, const guint test)
{
#ifdef G_OS_WIN32
	HANDLE hFind;			/* ϥɥ */
# ifdef UNICODE
	gchar *utf8file;
	LPTSTR lpszFile;
# endif /* UNICODE */
	SHFILEINFO rcInfo;
	WIN32_FIND_DATA rcFind;

	if (file == NULL)
		return FALSE;
# ifdef UNICODE
	utf8file = g_filename_to_utf8 (file, -1, NULL, NULL, NULL);
	if (utf8file == NULL)
		return FALSE;
	lpszFile = g_utf8_to_utf16 (utf8file, -1, NULL, NULL, NULL);
	if (lpszFile == NULL)
		return FALSE;
# else /* not UNICODE */
#   define lpszFile file
# endif /* not UNICODE */
	if ((test & FILEIO_TEST_IS_EXECUTABLE) != 0 && SHGetFileInfo (lpszFile, 0,
							&rcInfo, sizeof (SHFILEINFO), SHGFI_EXETYPE) != 0)
	  {
# ifdef UNICODE
		g_free (lpszFile);
# endif /* UNICODE */
		return TRUE;
	  }
	hFind = FindFirstFile(lpszFile, &rcFind);
# ifdef UNICODE
	g_free (lpszFile);
# else /* not UNICODE */
#   undef lpszFile
# endif /* not UNICODE */
	if (hFind != INVALID_HANDLE_VALUE)
	  {
		FindClose (hFind);
		if ((test & FILEIO_TEST_EXISTS) != 0
			|| ((test & FILEIO_TEST_IS_REGULAR) != 0
				&& (rcFind.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == 0)
			|| ((test & FILEIO_TEST_IS_DIR) != 0
				&& (rcFind.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) != 0))
			return TRUE;
	  }
	return FALSE;
#else /* not G_OS_WIN32 */
	struct stat buf;

	if (((test & FILEIO_TEST_EXISTS) != 0 && access (file, F_OK) == 0)
		|| ((test & FILEIO_TEST_IS_EXECUTABLE) != 0
								&& access (file, X_OK) == 0 && getuid () != 0))
		return TRUE;
	if (lstat (file, &buf) != 0)
		return FALSE;
	return ((test & FILEIO_TEST_IS_SYMLINK) != 0 && S_ISLNK (buf.st_mode))
			|| ((test & FILEIO_TEST_IS_REGULAR) != 0 && S_ISREG (buf.st_mode))
			|| ((test & FILEIO_TEST_IS_DIR) != 0 && S_ISDIR (buf.st_mode));
#endif /* not G_OS_WIN32 */
}


/*	եΥեѥ
	file,ե̾
	 RET,եѥ															*/
gchar *
fileio_get_full_path (const gchar *file)
{
#ifdef G_OS_WIN32
	int i = 0, j, s;
	DWORD dwSize;			/* եѥĹ */
	HANDLE hFind;			/* ϥɥ */
	LPTSTR p;
	TCHAR szFile[MAX_PATH];	/* եѥ */
	TCHAR lpszLongName[MAX_PATH];
	WIN32_FIND_DATA rcf;
# ifdef UNICODE
	gchar *utf8file, *utf16file, filename;
# endif /* UNICODE */

	if (file == NULL)
		return NULL;
# ifdef UNICODE
	utf8file = g_filename_to_utf8 (file, -1, NULL, NULL, NULL);
	if (utf8file == NULL)
		return g_strdup (file);
	utf16file = g_utf8_to_utf16 (utf8file, -1, NULL, NULL, NULL);
	g_free (utf8file);
	if (utf16file == NULL)
		return g_strdup (file);
	dwSize = GetFullPathName (utf16file, MAX_PATH, szFile, &p);
	g_free (utf16file);
# else /* not UNICODE */
	dwSize = GetFullPathName (file, MAX_PATH, szFile, &p);
# endif /* not UNICODE */
	if (dwSize == 0 || dwSize >= MAX_PATH)
		return g_strdup (file);
	if (dwSize >= 2)
	  {
		if (szFile[1] == ':')
		  {
			lpszLongName[0] = (TCHAR)CharUpper ((LPTSTR)szFile[0]);
			lpszLongName[1] = ':';
			if (szFile[2] == '\\')
			  {
				lpszLongName[2] = '\\';
				i = 3;
			  }
			else
			  {
				i = 2;
			  }
		  }
		else if (szFile[0] == '\\' && szFile[1] == '\\')
		  {
			i=2;
			while (i < dwSize)
			  {
				if (szFile[i] == '\\')
					break;
# ifdef UNICODE
				i++;
# else /* not UNICODE */
				i += IsDBCSLeadByteEx (CP_ACP, szFile[i]) ? 2 : 1;
# endif /* not UNICODE */
			  }
			i++;
			g_memmove (lpszLongName, szFile, i * sizeof (TCHAR));
		  }
	  }
	lpszLongName[i] = '\0';
	j = i;
	while (i <= dwSize)
	  {
		if (szFile[i] == '\0' || szFile[i] == '\\')
		  {
			s = lstrlen (lpszLongName);
			g_memmove (lpszLongName + s, szFile + j, (i - j) * sizeof (TCHAR));
			lpszLongName[s + i - j] = '\0';
			hFind = FindFirstFile (lpszLongName, &rcf);
			if (hFind != INVALID_HANDLE_VALUE)
				FindClose (hFind);
			else
				lstrcpy (rcf.cFileName, _T("."));
			if (lstrcmp (rcf.cFileName, _T(".")) != 0)
			  {
				g_memmove (lpszLongName + s, rcf.cFileName,
									lstrlen (rcf.cFileName) * sizeof (TCHAR));
				s += lstrlen (rcf.cFileName);
			  }
			else
			  {
				s += i - j;
			  }
			if (szFile[i] == '\\')
				lpszLongName[s++] = '\\';
			lpszLongName[s] = '\0';
			j = i + 1;
		  }
# ifdef UNICODE
		i++;
# else /* not UNICODE */
		i += IsDBCSLeadByteEx (CP_ACP, szFile[i]) ? 2 : 1;
# endif /* not UNICODE */
	  }
# ifdef UNICODE
	utf8file = g_utf16_to_utf8 (lpszLongName, -1, NULL, NULL, NULL);
	if (utf8file == NULL)
		return g_strdup (file);
	filename = g_filename_from_utf8 (utf8file, -1, NULL, NULL, NULL);
	g_free (utf8file);
	return filename != NULL ? filename : g_strdup (file);
# else /* not UNICODE */
	return g_strdup (lpszLongName);
# endif /* not UNICODE */
#else /* not G_OS_WIN32 */
	gchar *dir, *path;
	gint i, j, leng;

	if (file[0] != '/')
	  {
		dir = g_get_current_dir ();
		path = g_strjoin ("/", dir, file, NULL);
		g_free (dir);
	  }
	else
	  {
		path = g_strdup (file);
	  }
	leng = g_strlen (path);
	i = 0;
	while (i < leng)
		if (path[i] == '/' && path[i + 1] == '/')
		  {
			leng--;
			g_memmove (path + i + 1, path + i + 2, leng - i);
		  }
		else
		  {
			i++;
		  }
	i = 0;
	while (i < leng)
		if (path[i] == '/' && path[i + 1] == '.' && path[i + 2] == '/')
		  {
			leng -= 2;
			g_memmove (path + i + 1, path + i + 3, leng - i);
		  }
		else
		  {
			i++;
		  }
	i = 0;
	while (i < leng)
		if (path[i] == '/' && path[i + 1] == '.' && path[i + 2] == '.'
														&& path[i + 3] == '/')
		  {
			leng -= 3;
			g_memmove (path + i + 1, path + i + 4, leng - i);
			for (j = i - 1; j >= 0; j--)
				if (path[j] == '/')
					break;
			if (j >= 0)
			  {
				g_memmove (path + j + 1, path + i + 1, leng - i);
				leng -= i - j;
				i = j;
			  }
		  }
		else
		  {
			i++;
		  }
	return path;
#endif /* not G_OS_WIN32 */
}


#ifndef G_OS_WIN32
static GList *glist_fileio = NULL;
# ifdef USE_THREAD
G_LOCK_DEFINE_STATIC (critical);
static volatile gboolean critical = FALSE;
# endif /* USE_THREAD */
#endif /* not G_OS_WIN32 */


/*	եκ
	  file,ե̾
	access,
	 share,ͭ
	  mode,⡼
	   RET,եݥ,NULL:顼										*/
FileIO *
fileio_open (const gchar *file,
					const guint access, const guint share, const guint mode)
{
	FileIO *fio;
#ifdef G_OS_WIN32
	HANDLE hFile;
# ifdef UNICODE
	gchar *utf8file, *utf16file;
	LPTSTR lpszFile;
# endif /* UNICODE */

	if (file == NULL)
		return NULL;
# ifdef UNICODE
	utf8file = g_filename_to_utf8 (file, -1, NULL, NULL, NULL);
	if (utf8file == NULL)
		return NULL;
	utf16file = g_utf8_to_utf16 (utf8file, -1, NULL, NULL, NULL);
	g_free (utf8file);
	if (utf16file == NULL)
		return NULL;
	hFile = CreateFile (utf16file, access, share, NULL, mode,
												FILE_ATTRIBUTE_NORMAL, NULL);
	g_free (utf16file);
# else /* not UNICODE */
	hFile = CreateFile (file, access, share, NULL, mode,
												FILE_ATTRIBUTE_NORMAL, NULL);
# endif /* not UNICODE */
	if (hFile == INVALID_HANDLE_VALUE)
		return NULL;
	fio = g_malloc (sizeof (FileIO));
	fio->hFile = hFile;
#else /* not G_OS_WIN32 */
	int fd, flags;
	gchar *path;
	gint i;
	guint length;

	/* եѥ */
	path = fileio_get_full_path (file);
	if (path == NULL)
		return NULL;
	/* ե饰 */
	switch (access)
	  {
		case FILEIO_ACCESS_READ:	flags = O_RDONLY;	break;
		case FILEIO_ACCESS_WRITE:	flags = O_WRONLY;	break;
		case FILEIO_ACCESS_ALL:		flags = O_RDWR;		break;
		default:					g_free (path);		return NULL;
	  }
	switch (mode)
	  {
		case FILEIO_MODE_CREATE_NEW:	/* ̵п,м */
			flags |= O_CREAT | O_EXCL;
			break;
		case FILEIO_MODE_CREATE_ALWAYS:	/* ˿ */
			flags |= O_CREAT;
			break;
		case FILEIO_MODE_OPEN_EXISTING:	/* г,̵м */
			break;
		case FILEIO_MODE_OPEN_ALWAYS:	/* г,̵п */
			flags |= O_CREAT;
			break;
		default:
			g_free (path);
			return NULL;
	  }
	/* ͭå */
# ifdef USE_THREAD
	G_LOCK (critical);
	critical = TRUE;
# endif /* USE_THREAD */
	length = g_list_length (glist_fileio);
	for (i = 0; i < length; i++)
	  {
		fio = g_list_nth_data (glist_fileio, i);
		if (g_strcmp (fio->file, path) == 0
											&& (fio->share & access) != access)
			break;
	  }
# ifdef USE_THREAD
	critical = FALSE;
	G_UNLOCK (critical);
# endif /* USE_THREAD */
	if (i < length)
	  {
		g_free (path);
		return NULL;
	  }

	fd = open (path, flags,
					S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH);
	if (fd == -1)
	  {
		g_free (path);
		return NULL;
	  }
	if (
# ifdef HAVE_FLOCK
		flock (fd,
		(access == FILEIO_ACCESS_READ ? LOCK_SH : LOCK_EX) | LOCK_NB) != 0 ||
# endif /* HAVE_FLOCK */
		(mode == FILEIO_MODE_CREATE_ALWAYS
				&& (ftruncate (fd, 0) != 0 || lseek (fd, 0, SEEK_SET) == -1)))
	  {
		close (fd);
		g_free (path);
		return NULL;
	  }
	fio = g_malloc (sizeof (FileIO));
	fio->fd = fd;
	fio->file = path;
	fio->share = share;
# ifdef USE_THREAD
	G_LOCK (critical);
	critical = TRUE;
# endif /* USE_THREAD */
	glist_fileio = g_list_append (glist_fileio, fio);
# ifdef USE_THREAD
	critical = FALSE;
	G_UNLOCK (critical);
# endif /* USE_THREAD */
#endif /* not G_OS_WIN32 */
	return fio;
}


/*	եݥ󥿤Ĥ
	fio,եݥ
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean
fileio_close (FileIO *fio)
{
	gboolean result;

#ifdef G_OS_WIN32
	result = fio != NULL && CloseHandle (fio->hFile);
	g_free (fio);
#else /* not G_OS_WIN32 */
# ifdef USE_THREAD
	G_LOCK (critical);
	critical = TRUE;
# endif /* USE_THREAD */
	if (fio != NULL && g_list_find (glist_fileio, fio) != NULL)
	  {
		glist_fileio = g_list_remove (glist_fileio, fio);
		result = close (fio->fd) == 0;
		g_free (fio->file);
		g_free (fio);
	  }
	else
	  {
		result = FALSE;
	  }
# ifdef USE_THREAD
	critical = FALSE;
	G_UNLOCK (critical);
# endif /* USE_THREAD */
#endif /* not G_OS_WIN32 */
	return result;
}


/*	ե뤫ɤ߹
	   fio,եݥ
	  data,Хåե
	length,Хȿ
	   RET,Хȿ,-1:顼												*/
gssize
fileio_read (FileIO *fio, gpointer data, const gssize length)
{
#ifdef G_OS_WIN32
	DWORD dwRead;

	return fio != NULL && ReadFile (fio->hFile, data, length, &dwRead, NULL)
																? dwRead : -1;
#else /* not G_OS_WIN32 */
	gssize result;

# ifdef USE_THREAD
	G_LOCK (critical);
	critical = TRUE;
# endif /* USE_THREAD */
	result = fio != NULL && g_list_find (glist_fileio, fio) != NULL
										? read (fio->fd, data, length) : -1;
# ifdef USE_THREAD
	critical = FALSE;
	G_UNLOCK (critical);
# endif /* USE_THREAD */
	return result;
#endif /* not G_OS_WIN32 */
}


/*	ե˽񤭹
	   fio,եݥ
	  data,Хåե
	length,Хȿ
	   RET,Хȿ,-1:顼												*/
gssize
fileio_write (FileIO *fio, gpointer data, const gssize length)
{
#ifdef G_OS_WIN32
	DWORD dwWrite;

	return fio != NULL && WriteFile (fio->hFile, data, length, &dwWrite, NULL)
																? dwWrite : -1;
#else /* not G_OS_WIN32 */
	gssize result;

# ifdef USE_THREAD
	G_LOCK (critical);
	critical = TRUE;
# endif /* USE_THREAD */
	result = fio != NULL && g_list_find (glist_fileio, fio) != NULL
										? write (fio->fd, data, length) : -1;
# ifdef USE_THREAD
	critical = FALSE;
	G_UNLOCK (critical);
# endif /* USE_THREAD */
	return result;
#endif /* not G_OS_WIN32 */
}


/*	ե򥷡
	   fio,եݥ
	offset,
	whence,⡼
	   RET,,-1:顼													*/
goffset
fileio_seek (FileIO *fio, const goffset offset, const guint whence)
{
#ifdef G_OS_WIN32
# ifdef G_HAVE_GINT64
	LONG lHigh, lLow;

	if (fio == NULL)
		return -1;
	lHigh = offset >> 32;
	lLow = SetFilePointer (fio->hFile, (LONG)offset, &lHigh, whence);
	return lLow != 0xFFFFFFFF || GetLastError () == NO_ERROR
								? ((gint64)lHigh << 32) | (guint32)lLow : -1;
# else /* not G_HAVE_GINT64 */
	return SetFilePointer (fio->hFile, offset, NULL, whence);
# endif /* not G_HAVE_GINT64 */
#else /* not G_OS_WIN32 */
	gssize result;

# ifdef USE_THREAD
	G_LOCK (critical);
	critical = TRUE;
# endif /* USE_THREAD */
	result = fio != NULL && g_list_find (glist_fileio, fio) != NULL
										? lseek (fio->fd, offset, whence) : -1;
# ifdef USE_THREAD
	critical = FALSE;
	G_UNLOCK (critical);
# endif /* USE_THREAD */
	return result;
#endif /* not G_OS_WIN32 */
}


/*	1ʸɤ߹
	fio,եݥ
	RET,ʸ,EOF:顼														*/
gint
fileio_getc (FileIO *fio)
{
	gchar c;

	return fileio_read (fio, &c, sizeof (gchar)) == sizeof (gchar) ? c : EOF;
}


/*	1ʸ񤭹
	  c,ʸ
	fio,եݥ
	RET,ʸ,EOF:顼														*/
gint
fileio_putc (gint c, FileIO *fio)
{
	return fileio_write (fio, &c, sizeof (gchar)) == sizeof (gchar) ? c : EOF;
}


/*	1ɤ߹
	  data,Хåե
	length,Хȿ
	   fio,եݥ
	   RET,data:ｪλ,NULL:顼										*/
gchar *
fileio_gets (gchar *data, const gsize length, FileIO *fio)
{
	gchar c;
	gsize i = 0;
	gssize result;

	if (data == NULL || length <= 0)
		return NULL;
	while (i <= length - 2)
	  {
		result = fileio_read (fio, &c, sizeof (gchar));
		if (result < 0)
			return NULL;
		if (result < sizeof (gchar))
			break;
		data[i++] = c;
		if (c == '\n')
			break;
	  }
	if (i == 0)
		return NULL;
	data[i] = '\0';
	return data;
}


/*	1Խ񤭹
	  data,Хåե
	length,Хȿ
	   fio,եݥ
	   RET,:ｪλ,EOF:顼											*/
gint
fileio_puts (gchar *data, FileIO *fio)
{
	gsize i;
	gssize result;

	if (data == NULL)
		return EOF;
	for (i = 0; data[i] != '\0'; i++);
	result = fileio_write (fio, data, i * sizeof (gchar));
	return result >= 0 ? result : EOF;
}
