/*
    dllloader
    (C)Copyright 2000, 2001 by Hiroshi Takekawa
    copyright (c) 2002-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "kernel32.h"
#include <time.h>
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifndef USE_GTK2
# ifdef HAVE_BITS_SIGSET_H
#   include <bits/sigset.h>
# endif
# ifdef HAVE_PTHREAD_H
#   include <pthread.h>
# endif
#endif
#include "resource.h"
#include "misc/misc.h"
#include "misc/profile.h"


/******************************************************************************
*                                                                             *
*                                                                           *
*                                                                             *
******************************************************************************/
#define EXCEPTION_EXECUTE_HANDLER		1
#define EXCEPTION_CONTINUE_SEARCH		0
#define EXCEPTION_CONTINUE_EXECUTION	-1
#define EXCEPTION_MAXIMUM_PARAMETERS	15


#include "pshpack1.h"
typedef struct _CONTEXT
{
    DWORD ContextFlags;

    /* These are selected by CONTEXT_INTEGER */
    DWORD g0;
    DWORD g1;
    DWORD g2;
    DWORD g3;
    DWORD g4;
    DWORD g5;
    DWORD g6;
    DWORD g7;
    DWORD o0;
    DWORD o1;
    DWORD o2;
    DWORD o3;
    DWORD o4;
    DWORD o5;
    DWORD o6;
    DWORD o7;
    DWORD l0;
    DWORD l1;
    DWORD l2;
    DWORD l3;
    DWORD l4;
    DWORD l5;
    DWORD l6;
    DWORD l7;
    DWORD i0;
    DWORD i1;
    DWORD i2;
    DWORD i3;
    DWORD i4;
    DWORD i5;
    DWORD i6;
    DWORD i7;

    /* These are selected by CONTEXT_CONTROL */
    DWORD psr;
    DWORD pc;
    DWORD npc;
    DWORD y;
    DWORD wim;
    DWORD tbr;

    /* FIXME: floating point registers missing */

} CONTEXT,*PCONTEXT,*LPCONTEXT;
typedef struct __EXCEPTION_RECORD {
	DWORD ExceptionCode;
	DWORD ExceptionFlags;
	struct __EXCEPTION_RECORD *ExceptionRecord;
	LPVOID ExceptionAddress;
	DWORD NumberParameters;
	DWORD ExceptionInformation[EXCEPTION_MAXIMUM_PARAMETERS];
} EXCEPTION_RECORD,*PEXCEPTION_RECORD,*LPEXCEPTION_RECORD;
typedef struct _EXCEPTION_POINTERS {
	PEXCEPTION_RECORD ExceptionRecord;
	PCONTEXT ContextRecord;
} EXCEPTION_POINTERS,*PEXCEPTION_POINTERS,*LPEXCEPTION_POINTERS;
#include "poppack.h"
typedef LONG (CALLBACK *PTOP_LEVEL_EXCEPTION_FILTER)
										(PEXCEPTION_POINTERS ExceptionInfo);
typedef PTOP_LEVEL_EXCEPTION_FILTER LPTOP_LEVEL_EXCEPTION_FILTER;


static VOID WINAPI RtlUnwind(PVOID TargetFrame,PVOID TargetIp,
						PEXCEPTION_RECORD ExceptionRecord,PVOID ReturnValue)
{
	g_debug("RtlUnwind");
}


static VOID WINAPI RaiseException(DWORD dwExceptionCode,DWORD dwExceptionFlags,
						DWORD nNumberOfArguments,CONST ULONG_PTR *lpArguments)
{
	g_debug("RaiseException");
}


LPTOP_LEVEL_EXCEPTION_FILTER SetUnhandledExceptionFilter
					(LPTOP_LEVEL_EXCEPTION_FILTER lpTopLevelExceptionFilter)
{
	g_debug("SetUnhandledExceptionFilter");
	return NULL;
}


static LONG WINAPI UnhandledExceptionFilter(PEXCEPTION_POINTERS ExceptionInfo)
{
	g_debug("UnhandledExceptionFilter");
	return EXCEPTION_CONTINUE_SEARCH;
}


/******************************************************************************
*                                                                             *
* 黻                                                                        *
*                                                                             *
******************************************************************************/
static INT WINAPI MulDiv(INT nNumber,INT nNumerator,INT nDenominator)
{
	g_debug("MulDiv");
	if (nDenominator==0)
		return -1;
#ifdef G_HAVE_GINT64
	return (gint64)nNumber*(gint64)nNumerator/(gint64)nDenominator;
#else /* not G_HAVE_GINT64 */
	return nNumber * nNumerator / nDenominator;
#endif /* not G_HAVE_GINT64 */
}


/******************************************************************************
*                                                                             *
*                                                                       *
*                                                                             *
******************************************************************************/
#define LMEM_INVALID_HANDLE 0x8000


typedef HANDLE HLOCAL;
#include "pshpack1.h"
typedef struct _MEMORY_BASIC_INFORMATION {
	LPVOID BaseAddress;
	LPVOID AllocationBase;
	DWORD AllocationProtect;
	DWORD RegionSize;
	DWORD State;
	DWORD Protect;
	DWORD Type;
} MEMORY_BASIC_INFORMATION,
						*LPMEMORY_BASIC_INFORMATION,*PMEMORY_BASIC_INFORMATION;
typedef struct tagMEMORYSTATUS {
	DWORD dwLength;
	DWORD dwMemoryLoad;
	SIZE_T dwTotalPhys;
	SIZE_T dwAvailPhys;
	SIZE_T dwTotalPageFile;
	SIZE_T dwAvailPageFile;
	SIZE_T dwTotalVirtual;
	SIZE_T dwAvailVirtual;
} MEMORYSTATUS,*LPMEMORYSTATUS;
#include "poppack.h"


static VOID WINAPI GlobalMemoryStatus(LPMEMORYSTATUS lpBuffer)
{
	g_debug("GlobalMemoryStatus");
}


static BOOL WINAPI IsBadCodePtr(FARPROC lpfn)
{
	g_debug("IsBadCodePtr");
	return TRUE;
}


static BOOL WINAPI IsBadReadPtr(LPVOID lp,UINT ucb)
{
	g_debug("IsBadReadPtr");
	return TRUE;
}


static BOOL WINAPI IsBadWritePtr(LPVOID lp,UINT ucb)
{
	g_debug("IsBadWritePtr");
	return TRUE;
}


static HLOCAL WINAPI LocalAlloc(UINT uFlags,UINT uBytes)
{
	UINT_PTR hMem;

	g_debug("LocalAlloc");
	if (uBytes<=0 || (hMem=g_malloc0(uBytes+sizeof(UINT)*2))==NULL)
		return NULL;
	hMem[0]=uFlags;
	hMem[1]=uBytes;
	return hMem+2;
}


static HLOCAL WINAPI LocalDiscard(HLOCAL hMem)
{
	g_debug("LocalDiscard");
	return hMem;
}


static UINT WINAPI LocalFlags(HLOCAL hMem)
{
	g_debug("LocalFlags");
	return hMem!=NULL?((UINT_PTR)hMem)[-2]:LMEM_INVALID_HANDLE;
}


static HLOCAL WINAPI LocalFree(HLOCAL hMem)
{
	g_debug("LocalFree");
	if (hMem!=NULL)
		g_free((UINT_PTR)hMem-2);
	return NULL;
}


static HLOCAL WINAPI LocalHandle(LPCVOID pMem)
{
	g_debug("LocalHandle");
	return (HLOCAL)pMem;
}


static LPVOID WINAPI LocalLock(HLOCAL hMem)
{
	g_debug("LocalLock");
	return hMem;
}


static HLOCAL WINAPI LocalReAlloc(HLOCAL hMem,UINT uBytes,UINT uFlags)
{
	g_debug("LocalReAlloc");
	if (hMem==NULL)
		return LocalAlloc(uFlags,uBytes);
	if (uBytes<=0) {
		g_free((UINT_PTR)hMem-2);
		return NULL;
	}
	if ((hMem=g_realloc((UINT_PTR)hMem-2,uBytes+sizeof(UINT)*2))==NULL)
		return NULL;
	if (((UINT_PTR)hMem)[1]<uBytes)
		g_memset((guint8 *)hMem+sizeof(UINT)*2+((UINT_PTR)hMem)[1],0,
												uBytes-((UINT_PTR)hMem)[1]);
	((UINT_PTR)hMem)[1]=uBytes;
	return (UINT_PTR)hMem+2;
}


static UINT WINAPI LocalSize(HLOCAL hMem)
{
	g_debug("LocalSize");
	return hMem!=NULL?((UINT_PTR)hMem)[-1]:0;
}


static UINT WINAPI LocalUnlock(HLOCAL hMem)
{
	g_debug("LocalUnlock");
	return FALSE;
}


static LPVOID WINAPI VirtualAlloc(LPVOID lpAddress,DWORD dwSize,
										DWORD flAllocationType,DWORD flProtect)
{
	g_debug("VirtualAlloc");
	return g_malloc(dwSize);
}


static BOOL WINAPI VirtualFree(LPVOID lpAddress,DWORD dwSize,DWORD dwFreeType)
{
	g_debug("VirtualFree");
	g_free(lpAddress);
	return TRUE;
}


static BOOL WINAPI VirtualLock(LPVOID lpAddress,DWORD dwSize)
{
	g_debug("VirtualLock");
	return TRUE;
}


static BOOL WINAPI VirtualProtect(LPVOID lpAddress,DWORD dwSize,
									DWORD flNewProtect,PDWORD lpflOldProtect)
{
	g_debug("VirtualProtect");
	return TRUE;
}


static DWORD WINAPI VirtualQuery(LPCVOID lpAddress,
							PMEMORY_BASIC_INFORMATION lpBuffer,DWORD dwLength)
{
	g_debug("VirtualQuery");
	return sizeof(MEMORY_BASIC_INFORMATION);
}


static BOOL WINAPI VirtualUnlock(LPVOID lpAddress,DWORD dwSize)
{
	g_debug("VirtualUnlock");
	return TRUE;
}


/******************************************************************************
*                                                                             *
* ҡ                                                                      *
*                                                                             *
******************************************************************************/
static HANDLE WINAPI GetProcessHeap(VOID)
{
	g_debug("GetProcessHeap");
	return NULL;
}


static DWORD WINAPI GetProcessHeaps(DWORD NumberOfHeaps,HANDLE *ProcessHeaps)
{
	g_debug("GetProcessHeaps");
	return 0;
}


static LPVOID WINAPI HeapAlloc(HANDLE hHeap,DWORD dwFlags,DWORD dwBytes)
{
	gint i;
	LPDWORD hMem;

	g_debug("HeapAlloc");
	if (hHeap==NULL || dwBytes<=0
							|| (hMem=g_malloc0(dwBytes+sizeof(DWORD)*2))==NULL)
		return NULL;
	hMem[0]=dwFlags;
	hMem[1]=dwBytes;
	for (i=0;((LPDWORD *)hHeap)[i]!=NULL;i++);
	hHeap=g_realloc(hHeap,(i+2)*sizeof(LPDWORD));
	((LPDWORD *)hHeap)[i]=hMem;
	((LPDWORD *)hHeap)[i+1]=NULL;
	return hMem+2;
}


static HANDLE WINAPI HeapCreate(DWORD flOptions,
									DWORD dwInitialSize,DWORD dwMaximumSize)
{
	g_debug("HeapCreate");
	return g_malloc0(sizeof(LPDWORD));
}


static BOOL WINAPI HeapDestroy(HANDLE hHeap)
{
	gint i;

	g_debug("HeapDestroy");
	if (hHeap==NULL)
		return FALSE;
	for (i=0;((LPDWORD *)hHeap)[i]!=NULL;i++)
		g_free(((LPDWORD *)hHeap)[i]);
	g_free(hHeap);
	return TRUE;
}


static BOOL WINAPI HeapFree(HANDLE hHeap,DWORD dwFlags,LPVOID lpMem)
{
	gint i;

	g_debug("HeapFree");
	if (hHeap==NULL || lpMem==NULL)
		return FALSE;
	for (i=0;((LPDWORD *)hHeap)[i]!=NULL;i++)
		if (((LPDWORD *)hHeap)[i]==(LPDWORD)lpMem-2) {
			g_free((LPDWORD)lpMem-2);
			while (((LPDWORD *)hHeap)[i]!=NULL) {
				((LPDWORD *)hHeap)[i]=((LPDWORD *)hHeap)[i+1];
				i++;
			}
			return TRUE;
		}
	return FALSE;
}


static LPVOID WINAPI HeapReAlloc(HANDLE hHeap,DWORD dwFlags,
													LPVOID lpMem,DWORD dwBytes)
{
	gint i;

	g_debug("HeapReAlloc");
	if (hHeap==NULL || lpMem==NULL)
		return NULL;
	if (dwBytes<=0) {
		HeapFree(hHeap,dwFlags,lpMem);
		return NULL;
	}
	for (i=0;((LPDWORD *)hHeap)[i]!=NULL;i++)
		if (((LPDWORD *)hHeap)[i]==(LPDWORD)lpMem-2)
			break;
	if (((LPDWORD *)hHeap)[i]==NULL
		|| (lpMem=g_realloc((LPDWORD)lpMem-2,dwBytes+sizeof(DWORD)*2))==NULL)
		return NULL;
	if (((LPDWORD)lpMem)[1]<dwBytes)
		g_memset((guint8 *)lpMem+sizeof(DWORD)*2+((LPDWORD)lpMem)[1],0,
												dwBytes-((LPDWORD)lpMem)[1]);
	((LPDWORD)lpMem)[1]=dwBytes;
	((LPDWORD *)hHeap)[i]=lpMem;
	return (LPDWORD)lpMem+2;
}


static DWORD WINAPI HeapSize(HANDLE hHeap,DWORD dwFlags,LPCVOID lpMem)
{
	g_debug("HeapSize");
	return lpMem!=NULL?((LPDWORD)lpMem)[-1]:0;
}


/******************************************************************************
*                                                                             *
* ե                                                                    *
*                                                                             *
******************************************************************************/
#define STD_INPUT_HANDLE			(-10)
#define STD_OUTPUT_HANDLE			(-11)
#define STD_ERROR_HANDLE			(-12)
#define INVALID_HANDLE_VALUE		(-1)
#define INVALID_SET_FILE_POINTER	(-1)
#define FILE_TYPE_UNKNOWN			0x0000
#define FILE_TYPE_DISK				0x0001
#define FILE_TYPE_CHAR				0x0002
#define FILE_TYPE_PIPE				0x0003
#define FILE_TYPE_REMOTE			0x8000
#define FILE_BEGIN					0
#define FILE_CURRENT				1
#define FILE_END					2


typedef struct HandleCounter_Tag {
	gint count;
	HANDLE hHandle;
} HandleCounter;
#include "pshpack1.h"
typedef struct _OVERLAPPED {
	ULONG_PTR Internal;
	ULONG_PTR InternalHigh;
	DWORD Offset;
	DWORD OffsetHigh;
	HANDLE hEvent;
} OVERLAPPED,*POVERLAPPED,*LPOVERLAPPED;
#include "poppack.h"


static GList *glist=NULL;


static BOOL WINAPI CloseHandle(HANDLE hObject)
{
	gint i;
	HandleCounter *handle_counter;

	g_debug("CloseHandle");
	if (glist!=NULL)
		for (i=g_list_length(glist)-1;i>=0;i--) {
			handle_counter=g_list_nth_data(glist,i);
			if (handle_counter->hHandle==hObject) {
				handle_counter->count--;
				if (handle_counter->count<=0) {
					glist=g_list_remove(glist,handle_counter);
					g_free(handle_counter);
					fclose(hObject);
				}
				return TRUE;
			}
		}
	return FALSE;
}


static HANDLE WINAPI CreateFileA(LPCSTR lpFileName,DWORD dwDesiredAccess,
				DWORD dwShareMode,LPSECURITY_ATTRIBUTES lpSecurityAttributes,
						DWORD dwCreationDisposition,DWORD dwFlagsAndAttributes,
														HANDLE hTemplateFile)
{
	FILE *fp;
	HandleCounter *handle_counter;

	g_debug("CreateFileA");
	if ((fp=fopen(lpFileName,"rb"))!=NULL) {
		handle_counter=g_malloc(sizeof(HandleCounter));
		handle_counter->count=1;
		handle_counter->hHandle=fp;
		glist=g_list_append(glist,handle_counter);
	}
	return fp;
}


static HANDLE WINAPI CreateFileW(LPCWSTR lpFileName,DWORD dwDesiredAccess,
				DWORD dwShareMode,LPSECURITY_ATTRIBUTES lpSecurityAttributes,
						DWORD dwCreationDisposition,DWORD dwFlagsAndAttributes,
														HANDLE hTemplateFile)
{
	gchar *file;
	HANDLE hFile;

	g_debug("CreateFileW");
	file=misc_widestring_to_multistring(lpFileName);
	hFile=CreateFileA(file,dwDesiredAccess,dwShareMode,lpSecurityAttributes,
					dwCreationDisposition,dwFlagsAndAttributes,hTemplateFile);
	g_free(file);
	return hFile;
}


static HANDLE WINAPI CreateFileMappingA(HANDLE hFile,
							LPSECURITY_ATTRIBUTES lpAttributes,DWORD flProtect,
				DWORD dwMaximumSizeHigh,DWORD dwMaximumSizeLow,LPCSTR lpName)
{
	gint i;
	HandleCounter *handle_counter;

	g_debug("CreateFileMappingA");
	if (glist!=NULL)
		for (i=g_list_length(glist)-1;i>=0;i--) {
			handle_counter=g_list_nth_data(glist,i);
			if (handle_counter->hHandle==hFile) {
				handle_counter->count++;
				return hFile;
			}
		}
	return NULL;
}


static BOOL WINAPI FlushFileBuffers(HANDLE hFile)
{
	g_debug("FlushFileBuffers");
	return TRUE;
}


static DWORD WINAPI GetFileSize(HANDLE hFile,LPDWORD lpFileSizeHigh)
{
	int cur;
	long size;

	g_debug("GetFileSize");
	if (lpFileSizeHigh!=NULL)
		lpFileSizeHigh=0;
	cur=ftell(hFile);
	fseek(hFile,0,SEEK_END);
	size=ftell(hFile);
	fseek(hFile,cur,SEEK_SET);
	return size;
}


static DWORD WINAPI GetFileType(HANDLE hFile)
{
	g_debug("GetFileType");
	return FILE_TYPE_DISK;
}


static HANDLE WINAPI GetStdHandle(DWORD nStdHandle)
{
	g_debug("GetStdHandle");
	switch (nStdHandle) {
		case STD_INPUT_HANDLE:
			return (HANDLE)stdin;
		case STD_OUTPUT_HANDLE:
			return (HANDLE)stdout;
		case STD_ERROR_HANDLE:
			return (HANDLE)stderr;
	}
	return (HANDLE)INVALID_HANDLE_VALUE;
}


static LPVOID WINAPI MapViewOfFile(HANDLE hFileMappingObject,
			DWORD dwDesiredAccess,DWORD dwFileOffsetHigh,DWORD dwFileOffsetLow,
												SIZE_T dwNumberOfBytesToMap)
{
	int cur;
	LPVOID lpMap;

	g_debug("MapViewOfFile");
	if ((lpMap=g_malloc(dwNumberOfBytesToMap))==NULL)
		return NULL;
	cur=ftell(hFileMappingObject);
	fseek(hFileMappingObject,dwFileOffsetLow,SEEK_SET);
	fread(lpMap,1,dwNumberOfBytesToMap,hFileMappingObject);
	fseek(hFileMappingObject,cur,SEEK_SET);
	return lpMap;
}


static LPVOID WINAPI MapViewOfFileEx(HANDLE hFileMappingObject,
			DWORD dwDesiredAccess,DWORD dwFileOffsetHigh,DWORD dwFileOffsetLow,
							SIZE_T dwNumberOfBytesToMap,LPVOID lpBaseAddress)
{
	g_debug("MapViewOfFileEx");
	return MapViewOfFile(hFileMappingObject,dwDesiredAccess,
						dwFileOffsetHigh,dwFileOffsetLow,dwNumberOfBytesToMap);
}


static HANDLE WINAPI OpenFileMappingA(DWORD dwDesiredAccess,
											BOOL bInheritHandle,LPCSTR lpName)
{
	g_debug("OpenFileMappingA");
	return NULL;
}


static BOOL WINAPI ReadFile(HANDLE hFile,LPVOID lpBuffer,
						DWORD nNumberOfBytesToRead,LPDWORD lpNumberOfBytesRead,
													LPOVERLAPPED lpOverlapped)
{
	size_t bytes_read;

	g_debug("ReadFile");
	if (lpNumberOfBytesRead!=NULL)
		*lpNumberOfBytesRead=0;
	if (nNumberOfBytesToRead<=0)
		return TRUE;
	bytes_read=fread(lpBuffer,1,nNumberOfBytesToRead,hFile);
	if (lpNumberOfBytesRead!=NULL)
		*lpNumberOfBytesRead=bytes_read;
	return bytes_read>=0;
}


static BOOL WINAPI SetEndOfFile(HANDLE hFile)
{
	g_debug("SetEndOfFile");
	return TRUE;
}


static DWORD WINAPI SetFilePointer(HANDLE hFile,
			LONG lDistanceToMove,PLONG lpDistanceToMoveHigh,DWORD dwMoveMethod)
{
	int origin;

	g_debug("SetFilePointer");
	switch (dwMoveMethod) {
		case FILE_BEGIN:origin=SEEK_SET;break;
		case FILE_END:origin=SEEK_END;break;
		default:origin=SEEK_CUR;
	}
	return fseek(hFile,lDistanceToMove,origin)==0
								?ftell((FILE *)hFile):INVALID_SET_FILE_POINTER;
}


static UINT WINAPI SetHandleCount(UINT uNumber)
{
	g_debug("SetHandleCount");
	return MIN(uNumber,256);
}


static BOOL WINAPI SetStdHandle(DWORD nStdHandle,HANDLE hHandle)
{
	g_debug("SetStdHandle");
	return FALSE;
}


static BOOL WINAPI UnmapViewOfFile(LPCVOID lpBaseAddress)
{
	g_debug("UnmapViewOfFile");
	g_free((gpointer)lpBaseAddress);
	return TRUE;
}


static BOOL WINAPI WriteFile(HANDLE hFile,LPCVOID lpBuffer,
					DWORD nNumberOfBytesToWrite,LPDWORD lpNumberOfBytesWritten,
													LPOVERLAPPED lpOverlapped)
{
	g_debug("WriteFile");
	return FALSE;
}


/******************************************************************************
*                                                                             *
* ե&ե                                                           *
*                                                                             *
******************************************************************************/
static BOOL WINAPI CopyFileA(LPCSTR lpExistingFileName,LPCSTR lpNewFileName,
															BOOL bFailIfExists)
{
	g_debug("CopyFileA");
	return FALSE;
}


static BOOL WINAPI CreateDirectoryA(LPCSTR lpPathName,
									LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
	g_debug("CreateDirectoryA");
	return FALSE;
}


static BOOL WINAPI DeleteFileA(LPCSTR lpFileName)
{
	g_debug("DeleteFileA");
	return FALSE;
}


static BOOL WINAPI MoveFileA(LPCSTR lpExistingFileName,LPCSTR lpNewFileName)
{
	g_debug("MoveFileA");
	return FALSE;
}


static BOOL WINAPI MoveFileExA(LPCSTR lpExistingFileName,LPCSTR lpNewFileName,
																DWORD dwFlags)
{
	g_debug("MoveFileExA");
	return FALSE;
}


static BOOL WINAPI RemoveDirectoryA(LPCSTR lpPathName)
{
	g_debug("RemoveDirectoryA");
	return FALSE;
}


/******************************************************************************
*                                                                             *
* ѥ                                                                        *
*                                                                             *
******************************************************************************/
static DWORD WINAPI GetShortPathNameA(LPCSTR lpszLongPath,
										LPSTR lpszShortPath,DWORD cchBuffer)
{
	g_strncpy(lpszShortPath,lpszLongPath,cchBuffer);
	lpszShortPath[cchBuffer-1]='\0';
	return g_strlen(lpszShortPath);
}


static UINT WINAPI GetSystemDirectoryA(LPSTR lpBuffer,UINT uSize)
{
	if (lpBuffer==NULL || uSize<=0)
		return g_strlen(g_get_home_dir())+1;
	g_strncpy(lpBuffer,g_get_home_dir(),uSize);
	lpBuffer[uSize-1]='\0';
	return g_strlen(lpBuffer);
}


/******************************************************************************
*                                                                             *
* ե(Win16ߴ)                                                         *
*                                                                             *
******************************************************************************/
#define HFILE_ERROR ((HFILE)-1)


typedef HANDLE HFILE;


static HFILE WINAPI _lclose(HFILE hFile)
{
	g_debug("_lclose");
	return fclose(hFile)==0?0:HFILE_ERROR;
}


static HFILE WINAPI _lcreat(LPCSTR lpPathName,INT iAttribute)
{
	g_debug("_lcreat");
	return HFILE_ERROR;
}


static HFILE WINAPI _lopen(LPCSTR lpPathName,INT iReadWrite)
{
	g_debug("_lopen");
	return fopen(lpPathName,"rb");
}


static UINT WINAPI _lread(HFILE hFile,LPVOID lpBuffer,UINT uBytes)
{
	DWORD dwRead;

	g_debug("_lread");
	return ReadFile(hFile,lpBuffer,uBytes,&dwRead,NULL)
													?dwRead:(UINT)HFILE_ERROR;
}


static LONG WINAPI _llseek(HFILE hFile,LONG lOffset,INT iOrigin)
{
	int origin;

	g_debug("_llseek");
	switch (iOrigin) {
		case FILE_BEGIN:origin=SEEK_SET;break;
		case FILE_END:origin=SEEK_END;break;
		default:origin=SEEK_CUR;
	}
	return fseek(hFile,lOffset,origin)==0?ftell(hFile):(LONG)HFILE_ERROR;
}


static UINT WINAPI _lwrite(HFILE hFile,LPCSTR lpBuffer,UINT uBytes)
{
	g_debug("_lwrite");
	return (UINT)HFILE_ERROR;
}


/******************************************************************************
*                                                                             *
* ⥸塼                                                                  *
*                                                                             *
******************************************************************************/
/* flags that can be passed to LoadLibraryEx */
#define	DONT_RESOLVE_DLL_REFERENCES		0x00000001
#define	LOAD_LIBRARY_AS_DATAFILE		0x00000002
#define	LOAD_WITH_ALTERED_SEARCH_PATH	0x00000008


static BOOL WINAPI FreeLibrary(HMODULE hModule)
{
	gint i;

	g_debug("FreeLibrary");
	if (hModule==NULL)
		return FALSE;
	for (i=0;system_dll[i].name!=NULL;i++)
		if ((gint)hModule==i+1)
			return TRUE;
	peimage_destroy((PE_image *)hModule);
	return TRUE;
}


static DWORD WINAPI GetModuleFileNameA(HMODULE hModule,
												LPSTR lpFilename,DWORD nSize)
{
	gint i;

	g_debug("GetModuleFileNameA");
	if (lpFilename==NULL || nSize<=0)
		return 0;
	if (hModule==NULL) {
		g_strncpy(lpFilename,g_get_prgname(),nSize);
		lpFilename[nSize-1]='\0';
	} else {
		for (i=0;system_dll[i].name!=NULL;i++)
			if ((gint)hModule==i+1) {
				g_strncpy(lpFilename,system_dll[i].name,nSize);
				lpFilename[nSize-1]='\0';
				break;
			}
		if (system_dll[i].name==NULL) {
			g_strncpy(lpFilename,((PE_image *)hModule)->file,nSize);
			lpFilename[nSize-1]='\0';
		}
	}
	return g_strlen(lpFilename);
}


static DWORD WINAPI GetModuleFileNameW(HMODULE hModule,
												LPWSTR lpFilename,DWORD nSize)
{
	gchar *file;
	DWORD dwResult;

	g_debug("GetModuleFileNameW");
	file=g_malloc(nSize*sizeof(CHAR));
	GetModuleFileNameA(hModule,file,nSize);
	dwResult=misc_multibyte_to_widechar(file,-1,lpFilename,nSize);
	g_free(file);
	return dwResult;
}


static HMODULE WINAPI GetModuleHandleA(LPCSTR lpModuleName)
{
	gint i;

	g_debug("GetModuleHandleA");
	for (i=0;system_dll[i].name!=NULL;i++)
		if (g_strcasecmp(system_dll[i].name,lpModuleName)==0)
			return (HMODULE)(i+1);
	return NULL;
}


static HMODULE WINAPI GetModuleHandleW(LPCWSTR lpModuleName)
{
	gchar *file;
	HMODULE hModule;

	g_debug("GetModuleHandleW");
	file=misc_widestring_to_multistring(lpModuleName);
	hModule=GetModuleHandleA(file);
	g_free(file);
	return hModule;
}


static FARPROC WINAPI GetProcAddress(HMODULE hModule,LPCSTR lpProcName)
{
	gint i;
	SymbolInfo *syminfo;

	g_debug("GetProcAddress");
	if (hModule==NULL || lpProcName==NULL)
		return NULL;
	for (i=0;system_dll[i].name!=NULL;i++)
		if ((gint)hModule==i+1) {
			syminfo=system_dll[i].get_symbols();
			while (syminfo->name!=NULL) {
				if (g_strcmp(lpProcName,syminfo->name)==0)
					break;
				syminfo++;
			}
			return syminfo->value;
		}
	return peimage_resolve((PE_image *)hModule,lpProcName);
}


static HINSTANCE WINAPI LoadLibraryExA(LPCSTR lpLibFileName,
													HANDLE hFile,DWORD dwFlags)
{
	gint i;
	PE_image *pe;

	g_debug("LoadLibraryExA");
	if (lpLibFileName==NULL)
		return NULL;

	pe=peimage_create();
	if (peimage_loadex(pe,lpLibFileName,(dwFlags
				&(DONT_RESOLVE_DLL_REFERENCES|LOAD_LIBRARY_AS_DATAFILE))==0))
		return pe;
	peimage_destroy(pe);

	for (i=0;system_dll[i].name!=NULL;i++)
		if (g_strcasecmp(system_dll[i].name,lpLibFileName)==0)
			return (HINSTANCE)(i+1);
	return NULL;
}


static HINSTANCE WINAPI LoadLibraryA(LPCSTR lpFileName)
{
	g_debug("LoadLibraryA");
	return LoadLibraryExA(lpFileName,NULL,0);
}


/******************************************************************************
*                                                                             *
* ץ/å                                                           *
*                                                                             *
******************************************************************************/
typedef LPVOID LPCRITICAL_SECTION;
typedef DWORD CALLBACK (*LPTHREAD_START_ROUTINE)(LPVOID);


static HANDLE WINAPI CreateThread(LPSECURITY_ATTRIBUTES lpThreadAttributes,
				DWORD dwStackSize,LPTHREAD_START_ROUTINE lpStartAddress,
				LPVOID lpParameter,DWORD dwCreationFlags,LPDWORD lpThreadId)
{
#ifdef USE_THREAD
# ifdef USE_GTK2
	GThread* gthread;

	g_debug("CreateThread");
	gthread=g_thread_create((GThreadFunc)lpStartAddress,lpParameter,TRUE,NULL);
	if (lpThreadId!=NULL)
		*lpThreadId=(DWORD)gthread;
	return gthread;
# else /* not USE_GTK2 */
	pthread_t id;

	g_debug("CreateThread");
	pthread_create(&id,NULL,(void *)lpStartAddress,lpParameter);
	pthread_detach(id);
	if (lpThreadId!=NULL)
		*lpThreadId=id;
	return (HANDLE)id;
# endif /* not USE_GTK2 */
#else /* not USE_THREAD */
	g_debug("CreateThread");
	return NULL;
#endif /* not USE_THREAD */
}


static BOOL WINAPI DisableThreadLibraryCalls(HMODULE hLibModule)
{
	g_debug("DisableThreadLibraryCalls");
	return TRUE;
}


static VOID WINAPI ExitProcess(UINT uExitCode)
{
	g_debug("ExitProcess");
	gtk_exit(uExitCode);
}


static HANDLE WINAPI GetCurrentProcess(VOID)
{
	g_debug("GetCurrentProcess");
	return (HANDLE)0xffffffff;
}


static HANDLE WINAPI GetCurrentThread(VOID)
{
	g_debug("GetCurrentThread");
#ifdef USE_THREAD
# ifdef USE_GTK2
	return g_thread_self();
# else /* not USE_GTK2 */
	return (HANDLE)pthread_self();
# endif /* not USE_GTK2 */
#else /* not USE_THREAD */
	return (HANDLE)0xfffffffe;
#endif /* not USE_THREAD */
}


static DWORD WINAPI GetCurrentThreadId(VOID)
{
	g_debug("GetCurrentThreadId");
#ifdef USE_THREAD
# ifdef USE_GTK2
	return (DWORD)g_thread_self();
# else /* not USE_GTK2 */
	return pthread_self();
# endif /* not USE_GTK2 */
#else /* not USE_THREAD */
	return 0xfffffffe;
#endif /* not USE_THREAD */
}


static VOID WINAPI Sleep(DWORD dwMilliseconds)
{
	g_debug("Sleep");
	usleep(dwMilliseconds);
}


static BOOL WINAPI TerminateProcess(HANDLE hProcess,UINT uExitCode)
{
	g_debug("TerminateProcess");
	if (hProcess==(HANDLE)0xffffffff)
		gtk_exit(uExitCode);
	return TRUE;
}


static DWORD WINAPI TlsAlloc(VOID)
{
	g_debug("TlsAlloc");
	return (DWORD)g_malloc(sizeof(LPVOID));
}


static BOOL WINAPI TlsFree(DWORD dwTlsIndex)
{
	g_debug("TlsFree");
	g_free((gpointer)dwTlsIndex);
	return TRUE;
}


static LPVOID WINAPI TlsGetValue(DWORD dwTlsIndex)
{
	g_debug("TlsGetValue");
	return *(LPVOID *)dwTlsIndex;
}


static BOOL WINAPI TlsSetValue(DWORD dwTlsIndex,LPVOID lpTlsValue)
{
	g_debug("TlsSetValue");
	*(LPVOID *)dwTlsIndex=lpTlsValue;
	return TRUE;
}


/******************************************************************************
*                                                                             *
* ޥե                                                                    *
*                                                                             *
******************************************************************************/
#define WAIT_FAILED 0xffffffff


static HANDLE WINAPI CreateSemaphoreA(
						LPSECURITY_ATTRIBUTES lpSemaphoreAttributes,
						LONG lInitialCount,LONG lMaximumCount,LPCSTR lpName)
{
	g_debug("CreateSemaphoreA");
	return NULL;
}


static BOOL WINAPI ReleaseSemaphore(HANDLE hSemaphore,
									LONG lReleaseCount,LPLONG lpPreviousCount)
{
	g_debug("ReleaseSemaphore");
	return FALSE;
}


static DWORD WINAPI WaitForSingleObject(HANDLE hHandle,DWORD dwMilliseconds)
{
	g_debug("WaitForSingleObject");
	return WAIT_FAILED;
}


/******************************************************************************
*                                                                             *
* ƥ륻                                                      *
*                                                                             *
******************************************************************************/
static HANDLE WINAPI CreateEventA(LPSECURITY_ATTRIBUTES lpEventAttributes,
							BOOL bManualReset,BOOL bInitialState,LPCSTR lpName)
{
	g_debug("CreateEventA");
	return NULL;
}


static VOID WINAPI DeleteCriticalSection(LPCRITICAL_SECTION lpCriticalSection)
{
	g_debug("DeleteCriticalSection");
	g_mutex_free(*(GMutex **)lpCriticalSection);
}


static VOID WINAPI EnterCriticalSection(LPCRITICAL_SECTION lpCriticalSection)
{
	g_debug("EnterCriticalSection");
	g_mutex_lock(*(GMutex **)lpCriticalSection);
}


static VOID WINAPI InitializeCriticalSection
										(LPCRITICAL_SECTION lpCriticalSection)
{
	g_debug("InitializeCriticalSection");
	*(GMutex **)lpCriticalSection=g_mutex_new();
}


static VOID WINAPI LeaveCriticalSection(LPCRITICAL_SECTION lpCriticalSection)
{
	g_debug("LeaveCriticalSection");
	g_mutex_unlock(*(GMutex **)lpCriticalSection);
}


static BOOL WINAPI SetEvent(HANDLE hEvent)
{
	g_debug("SetEvent");
	return FALSE;
}


static BOOL WINAPI TryEnterCriticalSection
										(LPCRITICAL_SECTION lpCriticalSection)
{
	g_debug("TryEnterCriticalSection");
	return g_mutex_trylock(*(GMutex **)lpCriticalSection);
}


/******************************************************************************
*                                                                             *
* ƱѴؿ                                                                  *
*                                                                             *
******************************************************************************/
static PVOID WINAPI InterlockedCompareExchange(PVOID *Destination,
												PVOID Exchange,PVOID Comperand)
{
	PVOID pResult;

	g_debug("InterlockedCompareExchange");
	pResult=*Destination;
	if (*Destination==Comperand)
		*Destination=Exchange;
	return pResult;
}


static LONG WINAPI InterlockedExchangeAdd(PLONG lpAddend,LONG Increment)
{
	LONG lResult=0;

	g_debug("InterlockedExchangeAdd");
	if (lpAddend!=NULL) {
		lResult=*lpAddend;
		*lpAddend+=Increment;
	}
	return lResult;
}


static LONG WINAPI InterlockedDecrement(LPLONG lpAddend)
{
	g_debug("InterlockedDecrement");
	InterlockedExchangeAdd(lpAddend,-1);
	return lpAddend!=NULL?*lpAddend:0;
}


static LONG WINAPI InterlockedExchange(LPLONG Target,LONG Value)
{
	LONG lResult=0;

	g_debug("InterlockedExchange");
	if (Target!=NULL) {
		lResult=*Target;
		*Target=Value;
	}
	return lResult;
}


static LONG WINAPI InterlockedIncrement(LPLONG lpAddend)
{
	g_debug("InterlockedIncrement");
	InterlockedExchangeAdd(lpAddend,1);
	return lpAddend!=NULL?*lpAddend:0;
}


/******************************************************************************
*                                                                             *
* ʸ/Code Page                                                            *
*                                                                             *
******************************************************************************/
#define MAX_DEFAULTCHAR	2
#define MAX_LEADBYTES	12
/* Locale Dependent Mapping Flags */
#define LCMAP_LOWERCASE	0x00000100	/* lower case letters */
#define LCMAP_UPPERCASE	0x00000200	/* upper case letters */
#define LCMAP_SORTKEY	0x00000400	/* WC sort key (normalize) */
#define LCMAP_BYTEREV	0x00000800	/* byte reversal */


typedef DWORD CALID;
typedef DWORD CALTYPE;
typedef DWORD LCID;
typedef DWORD LCTYPE;
typedef BOOL CALLBACK (*CALINFO_ENUMPROCA)(LPSTR);
#include "pshpack1.h"
typedef struct {
	UINT MaxCharSize;
	BYTE DefaultChar[MAX_DEFAULTCHAR];
	BYTE LeadByte[MAX_LEADBYTES];
} CPINFO,*PCPINFO,*LPCPINFO;
#include "poppack.h"


static BOOL WINAPI EnumCalendarInfo(CALINFO_ENUMPROCA lpCalInfoEnumProc,
									LCID Locale,CALID Calendar,CALTYPE CalType)
{
	g_debug("EnumCalendarInfo");
	return FALSE;
}


static UINT WINAPI GetACP(VOID)
{
	g_debug("GetACP");
	return 0;
}


static BOOL WINAPI GetCPInfo(UINT CodePage,LPCPINFO lpCPInfo)
{
	g_debug("GetCPInfo");
	if (lpCPInfo!=NULL)
		return FALSE;
	g_memset(lpCPInfo,0,sizeof(CPINFO));
	lpCPInfo->MaxCharSize=1;
	lpCPInfo->DefaultChar[0]='?';
	return TRUE;
}


static INT WINAPI GetLocaleInfoA(LCID Locale,LCTYPE LCType,
													LPSTR lpLCData,INT cchData)
{
	g_debug("GetLocaleInfoA");
	if (lpLCData!=NULL && cchData>0)
		lpLCData[0]='\0';
	return 0;
}


static INT WINAPI GetLocaleInfoW(LCID Locale,LCTYPE LCType,
												LPWSTR lpLCData,INT cchData)
{
	g_debug("GetLocaleInfoW");
	if (lpLCData!=NULL && cchData>0)
		lpLCData[0]='\0';
	return 0;
}


static UINT WINAPI GetOEMCP(void)
{
	g_debug("GetOEMCP");
	return 0;
}


static BOOL WINAPI GetStringTypeA(LCID Locale,DWORD dwInfoType,
								LPCSTR lpSrcStr,INT cchSrc,LPWORD lpCharType)
{
	g_debug("GetStringTypeA");
	if (lpSrcStr==NULL || lpCharType==NULL)
		return FALSE;
	g_memset(lpCharType,0,(cchSrc<0?g_strlen(lpSrcStr):cchSrc)*sizeof(WORD));
	return TRUE;
}


static BOOL WINAPI GetStringTypeW(DWORD dwInfoType,
								LPCWSTR lpSrcStr,INT cchSrc,LPWORD lpCharType)
{
	gint leng;

	g_debug("GetStringTypeW");
	if (lpSrcStr==NULL || lpCharType==NULL)
		return FALSE;
	if (cchSrc>=0)
		leng=cchSrc;
	else
		for (leng=0;lpSrcStr[leng]!=0;leng++);
	g_memset(lpCharType,0,leng*sizeof(WORD));
	return TRUE;
}


static LCID WINAPI GetThreadLocale(VOID)
{
	g_debug("GetThreadLocale");
	return 0;
}


static BOOL WINAPI IsDBCSLeadByte(BYTE TestChar)
{
	g_debug("IsDBCSLeadByte");
	return FALSE;
}


static INT WINAPI LCMapStringA(LCID Locale,DWORD dwMapFlags,
						LPCSTR lpSrcStr,INT cchSrc,LPSTR lpDestStr,INT cchDest)
{
	gint leng;

	g_debug("LCMapStringA");
	if (lpSrcStr==NULL)
		return 0;
	leng=cchSrc>=0?cchSrc:g_strlen(lpSrcStr)+1;
	if (lpDestStr==NULL || cchDest<=0)
		return leng;
	if (leng>cchDest)
		return 0;
	if ((dwMapFlags&LCMAP_SORTKEY)!=0)
		g_memset(lpDestStr,0,leng);
	else
		g_strcpy(lpDestStr,lpSrcStr);
	return leng;
}


static INT WINAPI LCMapStringW(LCID Locale,DWORD dwMapFlags,
					LPCWSTR lpSrcStr,INT cchSrc,LPWSTR lpDestStr,INT cchDest)
{
	gint leng;

	g_debug("LCMapStringW");
	if (lpSrcStr==NULL)
		return 0;
	if (cchSrc>=0) {
		leng=cchSrc;
	} else {
		for (leng=0;lpSrcStr[leng]!=0;leng++);
		leng++;
	}
	if (lpDestStr==NULL || cchDest<=0)
		return leng;
	if (leng>cchDest)
		return 0;
	if ((dwMapFlags&LCMAP_SORTKEY)!=0)
		g_memset(lpDestStr,0,leng);
	else
		g_memmove(lpDestStr,lpSrcStr,leng*sizeof(WCHAR));
	return leng;
}


static LPSTR WINAPI lstrcatA(LPSTR lpString1,LPCSTR lpString2)
{
	g_debug("lstrcatA");
	if (lpString1==NULL || lpString2==NULL)
		return NULL;
	g_strcat(lpString1,lpString2);
	return lpString1;
}


static INT WINAPI lstrcmpA(LPCSTR lpString1,LPCSTR lpString2)
{
	g_debug("lstrcmpA");
	return g_strcmp(lpString1,lpString2);
}


static INT WINAPI lstrcmpiA(LPCSTR lpString1,LPCSTR lpString2)
{
	g_debug("lstrcmpiA");
	return g_strcasecmp(lpString1,lpString2);
}


static INT WINAPI lstrcmpiW(LPCWSTR lpString1,LPCWSTR lpString2)
{
	gint i;

	g_debug("lstrcmpiW");
	if (lpString1==NULL || lpString2==NULL)
		return 0;
	for (i=0;lpString1[i]!=0 && lpString2[i]!=0;i++)
		if (g_ascii_tolower(lpString1[i])!=g_ascii_tolower(lpString2[i]))
			break;
	return lpString1[i]-lpString2[i];
}


static LPSTR WINAPI lstrcpyA(LPSTR lpString1,LPCSTR lpString2)
{
	g_debug("lstrcpyA");
	if (lpString1==NULL || lpString2==NULL)
		return NULL;
	g_strcpy(lpString1,lpString2);
	return lpString1;
}


static INT WINAPI lstrlenA(LPCSTR lpString)
{
	g_debug("lstrlenA");
	return lpString!=NULL?g_strlen(lpString):0;
}


static INT WINAPI lstrlenW(LPCWSTR lpString)
{
	gint i;

	g_debug("lstrlenW");
	if (lpString==NULL)
		return 0;
	for (i=0;lpString[i]!=0;i++);
	return i;
}


static INT WINAPI MultiByteToWideChar(UINT CodePage,DWORD dwFlags,
  LPCSTR lpMultiByteStr,INT cchMultiByte,LPWSTR lpWideCharStr,INT cchWideChar)
{
	g_debug("MultiByteToWideChar");
	return misc_multibyte_to_widechar(lpMultiByteStr,cchMultiByte,
													lpWideCharStr,cchWideChar);
}


static INT WINAPI WideCharToMultiByte(UINT CodePage,DWORD dwFlags,
								LPCWSTR lpWideCharStr,INT cchWideChar,
								LPSTR lpMultiByteStr,INT cchMultiByte,
								LPCSTR lpDefaultChar,LPBOOL lpUsedDefaultChar)
{
	g_debug("WideCharToMultiByte");
	return misc_widechar_to_multibyte(lpWideCharStr,cchWideChar,
												lpMultiByteStr,cchMultiByte);
}


/******************************************************************************
*                                                                             *
* Ķ                                                                        *
*                                                                             *
******************************************************************************/
#define	VER_PLATFORM_WIN32s			0
#define	VER_PLATFORM_WIN32_WINDOWS	1
#define	VER_PLATFORM_WIN32_NT		2


#ifdef G_HAVE_GINT64
typedef gint64 LARGE_INTEGER,*PLARGE_INTEGER,*LPLARGE_INTEGER;
#else /* not G_HAVE_GINT64 */
typedef gint32 LARGE_INTEGER,*PLARGE_INTEGER,*LPLARGE_INTEGER;
#endif /* not G_HAVE_GINT64 */
#include "pshpack1.h"
typedef struct {
	DWORD dwOSVersionInfoSize;
	DWORD dwMajorVersion;
	DWORD dwMinorVersion;
	DWORD dwBuildNumber;
	DWORD dwPlatformId;
	CHAR szCSDVersion[128];
} OSVERSIONINFOA,*POSVERSIONINFOA,*LPOSVERSIONINFOA;
typedef struct _STARTUPINFOA {
	DWORD cb;
	LPSTR lpReserved;
	LPSTR lpDesktop;
	LPSTR lpTitle;
	DWORD dwX;
	DWORD dwY;
	DWORD dwXSize;
	DWORD dwYSize;
	DWORD dwXCountChars;
	DWORD dwYCountChars;
	DWORD dwFillAttribute;
	DWORD dwFlags;
	WORD  wShowWindow;
	WORD cbReserved2;
	LPBYTE lpReserved2;
	HANDLE hStdInput;
	HANDLE hStdOutput;
	HANDLE hStdError;
} STARTUPINFOA,*PSTARTUPINFOA,*LPSTARTUPINFOA;
typedef struct tagSYSTEM_INFO {
	union {
		DWORD dwOemId; /* Obsolete field - do not use */
		struct {
			WORD wProcessorArchitecture;
			WORD wReserved;
		} DUMMYSTRUCTNAME;
	} DUMMYUNIONNAME;
	DWORD dwPageSize;
	LPVOID lpMinimumApplicationAddress;
	LPVOID lpMaximumApplicationAddress;
	DWORD dwActiveProcessorMask;
	DWORD dwNumberOfProcessors;
	DWORD dwProcessorType;
	DWORD dwAllocationGranularity;
	WORD wProcessorLevel;
	WORD wProcessorRevision;
} SYSTEM_INFO,*PSYSTEM_INFO,*LPSYSTEM_INFO;
typedef struct _SYSTEMTIME {
	WORD wYear;
	WORD wMonth;
	WORD wDayOfWeek;
	WORD wDay;
	WORD wHour;
	WORD wMinute;
	WORD wSecond;
	WORD wMilliseconds;
} SYSTEMTIME,*PSYSTEMTIME,*LPSYSTEMTIME;
#include "poppack.h"


static BOOL WINAPI FreeEnvironmentStringsA(LPSTR lpszEnvironmentBlock)
{
	g_debug("FreeEnvironmentStringsA");
	return TRUE;
}


static BOOL WINAPI FreeEnvironmentStringsW(LPWSTR lpszEnvironmentBlock)
{
	g_debug("FreeEnvironmentStringsW");
	return TRUE;
}


static LPSTR WINAPI GetCommandLineA(VOID)
{
	g_debug("GetCommandLineA");
	return g_get_prgname();
}


static LPVOID WINAPI GetEnvironmentStrings(VOID)
{
	static CHAR cEnv[]={'\0','\0','\0','\0'};

	g_debug("GetEnvironmentStrings");
	return cEnv;
}


static DWORD WINAPI GetEnvironmentVariableA(LPCSTR lpName,
													LPSTR lpBuffer,DWORD nSize)
{
	gint leng;

	g_debug("GetEnvironmentVariableA");
	if (lpName==NULL || g_getenv(lpName)==NULL)
		return 0;
	leng=g_strlen(g_getenv(lpName));
	if (lpBuffer==NULL || nSize<=leng)
		return leng+1;
	g_strcpy(lpBuffer,g_getenv(lpName));
	return g_strlen(lpBuffer);
}


static VOID WINAPI GetLocalTime(LPSYSTEMTIME lpSystemTime)
{
	time_t t;
	struct tm *tm;

	g_debug("GetLocalTime");
	if (lpSystemTime!=NULL) {
		t=time(NULL);
		if ((tm=localtime(&t))!=NULL) {
			lpSystemTime->wYear=tm->tm_year+1900;
			lpSystemTime->wMonth=tm->tm_mon+1;
			lpSystemTime->wDayOfWeek=tm->tm_wday;
			lpSystemTime->wDay=tm->tm_mday;
			lpSystemTime->wHour=tm->tm_hour;
			lpSystemTime->wMinute=tm->tm_min;
			lpSystemTime->wSecond=tm->tm_sec;
		} else {
			lpSystemTime->wYear=1980;
			lpSystemTime->wMonth=1;
			lpSystemTime->wDayOfWeek=2;
			lpSystemTime->wDay=1;
			lpSystemTime->wHour=0;
			lpSystemTime->wMinute=0;
			lpSystemTime->wSecond=0;
		}
		lpSystemTime->wMilliseconds=0;
	}
}


VOID GetStartupInfoA(LPSTARTUPINFOA lpStartupInfo)
{
	g_debug("GetStartupInfoA");
	if (lpStartupInfo!=NULL) {
		g_memset(lpStartupInfo,0,sizeof(STARTUPINFOA));
		lpStartupInfo->cb=sizeof(STARTUPINFOA);
		lpStartupInfo->hStdInput=stdin;
		lpStartupInfo->hStdOutput=stdout;
		lpStartupInfo->hStdError=stderr;
	}
}


static VOID WINAPI GetSystemInfo(LPSYSTEM_INFO lpSystemInfo)
{
	g_debug("GetSystemInfo");
	if (lpSystemInfo!=NULL) {
		lpSystemInfo->DUMMYUNIONNAME.DUMMYSTRUCTNAME.wProcessorArchitecture=0;
		lpSystemInfo->DUMMYUNIONNAME.DUMMYSTRUCTNAME.wReserved=0;
		lpSystemInfo->dwPageSize=4096;
		lpSystemInfo->lpMinimumApplicationAddress=(LPVOID)0x00400000;
		lpSystemInfo->lpMaximumApplicationAddress=(LPVOID)0x7fffffff;
		lpSystemInfo->dwActiveProcessorMask=1;
		lpSystemInfo->dwNumberOfProcessors=1;
		lpSystemInfo->dwProcessorType=386;
		lpSystemInfo->dwAllocationGranularity=1;
		lpSystemInfo->wProcessorLevel=3;
		lpSystemInfo->wProcessorRevision=0xFF00;
	}
}


static DWORD WINAPI GetVersion(VOID)
{
	g_debug("GetVersion");
	return 0;
}


static BOOL WINAPI GetVersionExA(LPOSVERSIONINFOA lpVersionInfo)
{
	g_debug("GetVersionExA");
	if (lpVersionInfo==NULL)
		return FALSE;
	lpVersionInfo->dwMajorVersion=0;
	lpVersionInfo->dwMinorVersion=0;
	lpVersionInfo->dwBuildNumber=0;
	lpVersionInfo->dwPlatformId=VER_PLATFORM_WIN32_WINDOWS;
	g_strcpy(lpVersionInfo->szCSDVersion,"dllloader");
	return TRUE;
}


static BOOL WINAPI QueryPerformanceCounter(LARGE_INTEGER *lpPerformanceCount)
{
	g_debug("QueryPerformanceCounter");
	return FALSE;
}


static BOOL WINAPI QueryPerformanceFrequency(LARGE_INTEGER *lpFrequency)
{
	g_debug("QueryPerformanceFrequency");
	return FALSE;
}


/******************************************************************************
*                                                                             *
* ե                                                              *
*                                                                             *
******************************************************************************/
static UINT WINAPI GetPrivateProfileIntA(LPCSTR lpAppName,LPCSTR lpKeyName,
												INT nDefault,LPCSTR lpFileName)
{
	gchar *file;
	Profile *profile;
	INT nValue;

	g_debug("GetPrivateProfileIntA");
	if (lpAppName==NULL || lpKeyName==NULL)
		return nDefault;
	nValue=nDefault;
	file=g_strconcat(g_get_home_dir(),"/.",
		lpFileName==NULL?g_basename(g_get_prgname()):(gchar *)lpFileName,NULL);
	if ((profile=profile_open(file))!=NULL) {
		if (!profile_get_value(profile,lpAppName,lpKeyName,
								&nValue,sizeof(INT),PROFILE_VALUE_TYPE_INT))
			nValue=nDefault;
		profile_close(profile);
	}
	g_free(file);
	return nValue;
}


static UINT WINAPI GetPrivateProfileIntW(LPCWSTR lpAppName,LPCWSTR lpKeyName,
											INT nDefault,LPCWSTR lpFileName)
{
	gchar *section,*key,*file;
	UINT uResult;

	g_debug("GetPrivateProfileIntW");
	section=misc_widestring_to_multistring(lpAppName);
	key=misc_widestring_to_multistring(lpKeyName);
	file=misc_widestring_to_multistring(lpFileName);
	uResult=GetPrivateProfileIntA(section,key,nDefault,file);
	g_free(section);
	g_free(key);
	g_free(file);
	return uResult;
}


static DWORD WINAPI GetPrivateProfileStringA(LPCSTR lpAppName,LPCSTR lpKeyName,
		LPCSTR lpDefault,LPSTR lpReturnedString,DWORD nSize,LPCSTR lpFileName)
{
	gchar *file,*text;
	gint i,leng,length;
	GList *glist;
	Profile *profile;
	DWORD dwResult;

	g_debug("GetPrivateProfileStringA");
	if (lpDefault==NULL || lpReturnedString==NULL || nSize<=0)
		return 0;
	g_strncpy(lpReturnedString,lpDefault,nSize);
	lpReturnedString[nSize-1]='\0';
	dwResult=g_strlen(lpReturnedString);

	file=g_strconcat(g_get_home_dir(),"/.",
		lpFileName==NULL?g_basename(g_get_prgname()):(gchar *)lpFileName,NULL);
	if ((profile=profile_open(file))!=NULL) {
		if (lpAppName==NULL || lpKeyName==NULL) {
			dwResult=0;
			lpReturnedString[0]='\0';
			if (nSize>=2) {
				lpReturnedString[1]='\0';
				glist=lpAppName==NULL?profile_enum_section(profile)
										:profile_enum_key(profile,lpAppName);
				if (glist!=NULL) {
					dwResult=0;
					length=g_list_length(glist);
					for (i=0;i<length && dwResult<nSize-1;i++) {
						text=g_list_nth_data(glist,i);
						leng=g_strlen(text)+1;
						g_memmove(lpReturnedString+dwResult,text,
													MIN(leng,nSize-dwResult));
						dwResult+=leng;
					}
					if (dwResult<nSize) {
						lpReturnedString[dwResult]='\0';
						dwResult--;
					} else  {
						lpReturnedString[nSize-1]='\0';
						lpReturnedString[nSize-2]='\0';
						dwResult=nSize-2;
					}
					g_list_free(glist);
				}
			}
		} else if ((text=profile_get_string(profile,
												lpAppName,lpKeyName))!=NULL){
			g_strncpy(lpReturnedString,text,nSize);
			g_free(text);
			lpReturnedString[nSize-1]='\0';
			dwResult=g_strlen(lpReturnedString);
		} else if (lpDefault!=NULL) {
			g_strncpy(lpReturnedString,lpDefault,nSize);
			lpReturnedString[nSize-1]='\0';
			dwResult=g_strlen(lpReturnedString);
		}
		profile_close(profile);
	} else if (lpDefault!=NULL) {
		g_strncpy(lpReturnedString,lpDefault,nSize);
		lpReturnedString[nSize-1]='\0';
		dwResult=g_strlen(lpReturnedString);
	}
	g_free(file);
	return dwResult;
}


static DWORD WINAPI GetPrivateProfileStringW(
										LPCWSTR lpAppName,LPCWSTR lpKeyName,
	LPCWSTR lpDefault,LPWSTR lpReturnedString,DWORD nSize,LPCWSTR lpFileName)
{
	gchar *section,*key,*text,*file,*result;
	DWORD dwResult;

	g_debug("GetPrivateProfileStringW");
	section=misc_widestring_to_multistring(lpAppName);
	key=misc_widestring_to_multistring(lpKeyName);
	text=misc_widestring_to_multistring(lpDefault);
	file=misc_widestring_to_multistring(lpFileName);
	result=g_malloc0(nSize*sizeof(gchar));
	dwResult=GetPrivateProfileStringA(section,key,text,result,nSize,file);
	dwResult=misc_multibyte_to_widechar(result,
						dwResult+((lpAppName==NULL || lpKeyName==NULL)?2:1),
													lpReturnedString,nSize);
	g_free(section);
	g_free(key);
	g_free(text);
	g_free(file);
	g_free(result);
	return dwResult;
}


static BOOL WINAPI WritePrivateProfileStringA(
		LPCSTR lpAppName,LPCSTR lpKeyName,LPCSTR lpString,LPCSTR lpFileName)
{
	gchar *file;
	Profile *profile;
	BOOL fResult=FALSE;

	g_debug("WritePrivateProfileStringA");
	if (lpAppName==NULL)
		return FALSE;
	file=g_strconcat(g_get_home_dir(),"/.",
		lpFileName==NULL?g_basename(g_get_prgname()):(gchar *)lpFileName,NULL);
	if ((profile=profile_open(file))!=NULL) {
		if (lpKeyName==NULL)
			fResult=profile_delete_section(profile,lpAppName);
		else if (lpString==NULL)
			fResult=profile_delete_key(profile,lpAppName,lpKeyName);
		else
			fResult=profile_set_value(profile,lpAppName,lpKeyName,
								(const gpointer)lpString,g_strlen(lpString),
													PROFILE_VALUE_TYPE_STRING);
		profile_close(profile);
	}
	g_free(file);
	return fResult;
}


static BOOL WINAPI WritePrivateProfileStringW(
	LPCWSTR lpAppName,LPCWSTR lpKeyName,LPCWSTR lpString,LPCWSTR lpFileName)
{
	gchar *section,*key,*text,*file;
	BOOL fResult;

	g_debug("WritePrivateProfileStringW");
	section=misc_widestring_to_multistring(lpAppName);
	key=misc_widestring_to_multistring(lpKeyName);
	text=misc_widestring_to_multistring(lpString);
	file=misc_widestring_to_multistring(lpFileName);
	fResult=WritePrivateProfileStringA(section,key,text,file);
	g_free(section);
	g_free(key);
	g_free(text);
	g_free(file);
	return fResult;
}


static UINT WINAPI GetProfileIntA(LPCSTR lpAppName,LPCSTR lpKeyName,
												INT nDefault,LPCSTR lpFileName)
{
	g_debug("GetProfileIntA");
	return GetPrivateProfileIntA(lpAppName,lpKeyName,nDefault,lpFileName);
}


static UINT WINAPI GetProfileIntW(LPCWSTR lpAppName,LPCWSTR lpKeyName,
											INT nDefault,LPCWSTR lpFileName)
{
	g_debug("GetProfileIntW");
	return GetPrivateProfileIntW(lpAppName,lpKeyName,nDefault,lpFileName);
}


static DWORD WINAPI GetProfileStringA(LPCSTR lpAppName,LPCSTR lpKeyName,
		LPCSTR lpDefault,LPSTR lpReturnedString,DWORD nSize,LPCSTR lpFileName)
{
	g_debug("GetProfileStringA");
	return GetPrivateProfileStringA(lpAppName,lpKeyName,
								lpDefault,lpReturnedString,nSize,lpFileName);
}


static DWORD WINAPI GetProfileStringW(LPCWSTR lpAppName,LPCWSTR lpKeyName,
	LPCWSTR lpDefault,LPWSTR lpReturnedString,DWORD nSize,LPCWSTR lpFileName)
{
	g_debug("GetProfileStringW");
	return GetPrivateProfileStringW(lpAppName,lpKeyName,
								lpDefault,lpReturnedString,nSize,lpFileName);
}


static BOOL WINAPI WriteProfileStringA(LPCSTR lpAppName,LPCSTR lpKeyName,
											LPCSTR lpString,LPCSTR lpFileName)
{
	g_debug("WriteProfileStringA");
	return WritePrivateProfileStringA(lpAppName,lpKeyName,lpString,NULL);
}


static BOOL WINAPI WriteProfileStringW(LPCWSTR lpAppName,LPCWSTR lpKeyName,
															LPCWSTR lpString)
{
	g_debug("WriteProfileStringA");
	return WritePrivateProfileStringW(lpAppName,lpKeyName,lpString,NULL);
}


/******************************************************************************
*                                                                             *
* 󥽡                                                                  *
*                                                                             *
******************************************************************************/
static BOOL WINAPI AllocConsole(VOID)
{
	g_debug("AllocConsole");
	return TRUE;
}


static VOID WINAPI OutputDebugStringA(LPCSTR lpOutputString)
{
	g_debug("OutputDebugStringA");
	g_print(lpOutputString);
}


static BOOL WINAPI SetConsoleScreenBufferSize(HANDLE hConsoleOutput,
																DWORD dwSize)
{
	g_debug("SetConsoleScreenBufferSize");
	return TRUE;
}


static BOOL WINAPI WriteConsoleA(HANDLE hConsoleOutput,CONST VOID *lpBuffer,
					DWORD nNumberOfCharsToWrite,LPDWORD lpNumberOfCharsWritten,
															LPVOID lpReserved)
{
	gint i;

	g_debug("WriteConsoleA");
	if (lpBuffer==NULL)
		return FALSE;
	for (i=0;i<nNumberOfCharsToWrite;i++)
		g_print("%c",((gchar *)lpBuffer)[i]);
	if (lpNumberOfCharsWritten!=NULL)
		*lpNumberOfCharsWritten=i;
	return TRUE;
}


/******************************************************************************
*                                                                             *
* ꥽                                                                    *
*                                                                             *
******************************************************************************/
static HRSRC WINAPI kernel32_FindResourceExA(HMODULE hModule,
									LPCSTR lpType,LPCSTR lpName,WORD wLanguage)
{
	g_debug("FindResourceExA");
	return FindResourceExA(hModule,lpType,lpName,wLanguage);
}


static HRSRC WINAPI kernel32_FindResourceExW(HMODULE hModule,
								LPCWSTR lpType,LPCWSTR lpName,WORD wLanguage)
{
	g_debug("FindResourceExW");
	return FindResourceExW(hModule,lpType,lpName,wLanguage);
}


static HRSRC WINAPI kernel32_FindResourceA(HMODULE hModule,
												LPCSTR lpName,LPCSTR lpType)
{
	g_debug("FindResourceA");
	return FindResourceA(hModule,lpName,lpType);
}


static HRSRC WINAPI kernel32_FindResourceW(HMODULE hModule,
												LPCWSTR lpName,LPCWSTR lpType)
{
	g_debug("FindResourceW");
	return FindResourceW(hModule,lpName,lpType);
}


static BOOL WINAPI kernel32_FreeResource(HGLOBAL hResData)
{
	g_debug("FreeResource");
	return FreeResource(hResData);
}


static HBITMAP WINAPI kernel32_LoadBitmapA(HINSTANCE hInstance,
														LPCSTR lpBitmapName)
{
	g_debug("LoadBitmapA");
	return LoadBitmapA(hInstance,lpBitmapName);
}


static HGLOBAL WINAPI kernel32_LoadResource(HMODULE hModule,HRSRC hResInfo)
{
	g_debug("LoadResource");
	return LoadResource(hModule,hResInfo);
}


static INT WINAPI kernel32_LoadStringA(HINSTANCE hInstance,UINT uID,
												LPSTR lpBuffer,INT nBufferMax)
{
	g_debug("LoadStringA");
	return LoadStringA(hInstance,uID,lpBuffer,nBufferMax);
}


static INT WINAPI kernel32_LoadStringW(HINSTANCE hInstance,UINT uID,
												LPWSTR lpBuffer,INT nBufferMax)
{
	g_debug("LoadStringW");
	return LoadStringW(hInstance,uID,lpBuffer,nBufferMax);
}


static LPVOID WINAPI kernel32_LockResource(HGLOBAL hResData)
{
	g_debug("LockResource");
	return LockResource(hResData);
}


static DWORD WINAPI kernel32_SizeofResource(HMODULE hModule,HRSRC hResInfo)
{
	g_debug("SizeofResource");
	return SizeofResource(hModule,hResInfo);
}


/******************************************************************************
*                                                                             *
* 顼                                                                  *
*                                                                             *
******************************************************************************/
static DWORD WINAPI GetLastError(VOID)
{
	g_debug("GetLastError");
	return 0;
}


static VOID WINAPI SetLastError(DWORD dwErrCode)
{
	g_debug("SetLastError");
}


/******************************************************************************
*                                                                             *
* Ͽ                                                                        *
*                                                                             *
******************************************************************************/
static VOID WINAPI UnknownSymbol(VOID)
{
	g_message("unknown symbol in kernel32 called");
}


static SymbolInfo symbol_infos[]={
	{"RtlUnwind",RtlUnwind},
	{"RaiseException",RaiseException},
	{"SetUnhandledExceptionFilter",SetUnhandledExceptionFilter},
	{"UnhandledExceptionFilter",UnhandledExceptionFilter},

	{"MulDiv",MulDiv},

	{"GlobalAlloc",LocalAlloc},
	{"GlobalDiscard",LocalDiscard},
	{"GlobalFlags",LocalFlags},
	{"GlobalFree",LocalFree},
	{"GlobalHandle",LocalHandle},
	{"GlobalLock",LocalLock},
	{"GlobalMemoryStatus",GlobalMemoryStatus},
	{"GlobalReAlloc",LocalReAlloc},
	{"GlobalSize",LocalSize},
	{"GlobalUnlock",LocalUnlock},
	{"IsBadCodePtr",IsBadCodePtr},
	{"IsBadReadPtr",IsBadReadPtr},
	{"IsBadWritePtr",IsBadWritePtr},
	{"LocalAlloc",LocalAlloc},
	{"LocalDiscard",LocalDiscard},
	{"LocalFlags",LocalFlags},
	{"LocalFree",LocalFree},
	{"LocalHandle",LocalHandle},
	{"LocalLock",LocalLock},
	{"LocalReAlloc",LocalReAlloc},
	{"LocalSize",LocalSize},
	{"LocalUnlock",LocalUnlock},
	{"VirtualAlloc",VirtualAlloc},
	{"VirtualFree",VirtualFree},
	{"VirtualLock",VirtualLock},
	{"VirtualProtect",VirtualProtect},
	{"VirtualQuery",VirtualQuery},
	{"VirtualUnlock",VirtualUnlock},

	{"GetProcessHeap",GetProcessHeap},
	{"GetProcessHeaps",GetProcessHeaps},
	{"HeapAlloc",HeapAlloc},
	{"HeapCreate",HeapCreate},
	{"HeapDestroy",HeapDestroy},
	{"HeapFree",HeapFree},
	{"HeapReAlloc",HeapReAlloc},
	{"HeapSize",HeapSize},

	{"CloseHandle",CloseHandle},
	{"CreateFileA",CreateFileA},
	{"CreateFileW",CreateFileW},
	{"CreateFileMappingA",CreateFileMappingA},
	{"CreateFileMappingW",CreateFileMappingA},
	{"FlushFileBuffers",FlushFileBuffers},
	{"GetFileSize",GetFileSize},
	{"GetFileType",GetFileType},
	{"GetStdHandle",GetStdHandle},
	{"MapViewOfFile",MapViewOfFile},
	{"MapViewOfFileEx",MapViewOfFileEx},
	{"OpenFileMappingA",OpenFileMappingA},
	{"OpenFileMappingW",OpenFileMappingA},
	{"ReadFile",ReadFile},
	{"SetEndOfFile",SetEndOfFile},
	{"SetFilePointer",SetFilePointer},
	{"SetHandleCount",SetHandleCount},
	{"SetStdHandle",SetStdHandle},
	{"UnmapViewOfFile",UnmapViewOfFile},
	{"WriteFile",WriteFile},

	{"CopyFileA",CopyFileA},
	{"CopyFileW",CopyFileA},
	{"CreateDirectoryA",CreateDirectoryA},
	{"CreateDirectoryW",CreateDirectoryA},
	{"DeleteFileA",DeleteFileA},
	{"DeleteFileW",DeleteFileA},
	{"MoveFileA",MoveFileA},
	{"MoveFileW",MoveFileA},
	{"MoveFileExA",MoveFileExA},
	{"MoveFileExW",MoveFileExA},
	{"RemoveDirectoryA",RemoveDirectoryA},
	{"RemoveDirectoryW",RemoveDirectoryA},

	{"GetShortPathNameA",GetShortPathNameA},
	{"GetSystemDirectoryA",GetSystemDirectoryA},

	{"_lclose",_lclose},
	{"_lcreat",_lcreat},
	{"_llseek",_llseek},
	{"_lopen",_lopen},
	{"_lread",_lread},
	{"_lwrite",_lwrite},

	{"FreeLibrary",FreeLibrary},
	{"GetModuleFileNameA",GetModuleFileNameA},
	{"GetModuleFileNameW",GetModuleFileNameW},
	{"GetModuleHandleA",GetModuleHandleA},
	{"GetModuleHandleW",GetModuleHandleW},
	{"GetProcAddress",GetProcAddress},
	{"LoadLibraryA",LoadLibraryA},
	{"LoadLibraryExA",LoadLibraryExA},

	{"CreateThread",CreateThread},
	{"DisableThreadLibraryCalls",DisableThreadLibraryCalls},
	{"ExitProcess",ExitProcess},
	{"GetCurrentProcess",GetCurrentProcess},
	{"GetCurrentThread",GetCurrentThread},
	{"GetCurrentThreadId",GetCurrentThreadId},
	{"Sleep",Sleep},
	{"TerminateProcess",TerminateProcess},
	{"TlsAlloc",TlsAlloc},
	{"TlsFree",TlsFree},
	{"TlsGetValue",TlsGetValue},
	{"TlsSetValue",TlsSetValue},

	{"CreateSemaphoreA",CreateSemaphoreA},
	{"ReleaseSemaphore",ReleaseSemaphore},
	{"WaitForSingleObject",WaitForSingleObject},

	{"CreateEventA",CreateEventA},
	{"DeleteCriticalSection",DeleteCriticalSection},
	{"EnterCriticalSection",EnterCriticalSection},
	{"InitializeCriticalSection",InitializeCriticalSection},
	{"LeaveCriticalSection",LeaveCriticalSection},
	{"SetEvent",SetEvent},
	{"TryEnterCriticalSection",TryEnterCriticalSection},

	{"InterlockedCompareExchange",InterlockedCompareExchange},
	{"InterlockedDecrement",InterlockedDecrement},
	{"InterlockedExchange",InterlockedExchange},
	{"InterlockedExchangeAdd",InterlockedExchangeAdd},
	{"InterlockedIncrement",InterlockedIncrement},

	{"EnumCalendarInfo",EnumCalendarInfo},
	{"GetACP",GetACP},
	{"GetCPInfo",GetCPInfo},
	{"GetLocaleInfoA",GetLocaleInfoA},
	{"GetLocaleInfoW",GetLocaleInfoW},
	{"GetOEMCP",GetOEMCP},
	{"GetStringTypeA",GetStringTypeA},
	{"GetStringTypeW",GetStringTypeW},
	{"GetThreadLocale",GetThreadLocale},
	{"IsDBCSLeadByte",IsDBCSLeadByte},
	{"LCMapStringA",LCMapStringA},
	{"LCMapStringW",LCMapStringW},
	{"lstrcatA",lstrcatA},
	{"lstrcmpA",lstrcmpA},
	{"lstrcmpiA",lstrcmpiA},
	{"lstrcmpiW",lstrcmpiW},
	{"lstrcpyA",lstrcpyA},
	{"lstrlenA",lstrlenA},
	{"lstrlenW",lstrlenW},
	{"MultiByteToWideChar",MultiByteToWideChar},
	{"WideCharToMultiByte",WideCharToMultiByte},

	{"FreeEnvironmentStringsA",FreeEnvironmentStringsA},
	{"FreeEnvironmentStringsW",FreeEnvironmentStringsW},
	{"GetCommandLineA",GetCommandLineA},
	{"GetEnvironmentStrings",GetEnvironmentStrings},
	{"GetEnvironmentStringsW",GetEnvironmentStrings},
	{"GetEnvironmentVariableA",GetEnvironmentVariableA},
	{"GetLocalTime",GetLocalTime},
	{"GetStartupInfoA",GetStartupInfoA},
	{"GetSystemInfo",GetSystemInfo},
	{"GetVersion",GetVersion},
	{"GetVersionExA",GetVersionExA},
	{"QueryPerformanceCounter",QueryPerformanceCounter},
	{"QueryPerformanceFrequency",QueryPerformanceFrequency},

	{"GetPrivateProfileIntA",GetPrivateProfileIntA},
	{"GetPrivateProfileIntW",GetPrivateProfileIntW},
	{"GetPrivateProfileStringA",GetPrivateProfileStringA},
	{"GetPrivateProfileStringW",GetPrivateProfileStringW},
	{"WritePrivateProfileStringA",WritePrivateProfileStringA},
	{"WritePrivateProfileStringW",WritePrivateProfileStringW},
	{"GetProfileIntA",GetProfileIntA},
	{"GetProfileIntW",GetProfileIntW},
	{"GetProfileStringA",GetProfileStringA},
	{"GetProfileStringW",GetProfileStringW},
	{"WriteProfileStringA",WriteProfileStringA},
	{"WriteProfileStringW",WriteProfileStringW},

	{"AllocConsole",AllocConsole},
	{"SetConsoleScreenBufferSize",SetConsoleScreenBufferSize},
	{"OutputDebugStringA",OutputDebugStringA},
	{"WriteConsoleA",WriteConsoleA},

	{"FindResourceExA",kernel32_FindResourceExA},
	{"FindResourceExW",kernel32_FindResourceExW},
	{"FindResourceA",kernel32_FindResourceA},
	{"FindResourceW",kernel32_FindResourceW},
	{"FreeResource",kernel32_FreeResource},
	{"LoadBitmapA",	kernel32_LoadBitmapA},
	{"LoadResource",kernel32_LoadResource},
	{"LoadStringA",kernel32_LoadStringA},
	{"LoadStringW",kernel32_LoadStringW},
	{"LockResource",kernel32_LockResource},
	{"SizeofResource",kernel32_SizeofResource},

	{"GetLastError",GetLastError},
	{"SetLastError",SetLastError},

	{NULL,UnknownSymbol}
};


SymbolInfo *kernel32_get_export_symbols(void)
{
	return symbol_infos;
}
