/*
    fileio
    copyright (c) 2002-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __FILEIO_H__
#define __FILEIO_H__


#include "common.h"
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif
#ifdef HAVE_SYS_FILE_H
# include <sys/file.h>
#endif
#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif
#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef G_OS_WIN32
# include <tchar.h>
# include <windows.h>
#endif


#ifdef __cplusplus
extern "C" {
#endif


#ifdef G_OS_WIN32
# define FILEIO_ACCESS_READ			GENERIC_READ
# define FILEIO_ACCESS_WRITE		GENERIC_WRITE
# define FILEIO_SHARE_READ			FILE_SHARE_READ
# define FILEIO_SHARE_WRITE			FILE_SHARE_WRITE
# define FILEIO_MODE_CREATE_NEW		CREATE_NEW
# define FILEIO_MODE_CREATE_ALWAYS	CREATE_ALWAYS
# define FILEIO_MODE_OPEN_EXISTING	OPEN_EXISTING
# define FILEIO_MODE_OPEN_ALWAYS	OPEN_ALWAYS
# define FILEIO_SEEK_SET			FILE_BEGIN
# define FILEIO_SEEK_CUR			FILE_CURRENT
# define FILEIO_SEEK_END			FILE_END
#else /* not G_OS_WIN32 */
# define FILEIO_ACCESS_READ			1
# define FILEIO_ACCESS_WRITE		2
# define FILEIO_SHARE_READ			1
# define FILEIO_SHARE_WRITE			2
# define FILEIO_MODE_CREATE_NEW		0
# define FILEIO_MODE_CREATE_ALWAYS	1
# define FILEIO_MODE_OPEN_EXISTING	2
# define FILEIO_MODE_OPEN_ALWAYS	3
# define FILEIO_SEEK_SET			SEEK_SET
# define FILEIO_SEEK_CUR			SEEK_CUR
# define FILEIO_SEEK_END			SEEK_END
#endif /* not G_OS_WIN32 */
#define FILEIO_SHARE_DENY			0
#define FILEIO_ACCESS_ALL			(FILEIO_ACCESS_READ | FILEIO_ACCESS_WRITE)
#define FILEIO_SHARE_ALL			(FILEIO_SHARE_READ | FILEIO_SHARE_WRITE)
#define FILEIO_TEST_IS_REGULAR		(1 << 0)
#define FILEIO_TEST_IS_SYMLINK		(1 << 1)
#define FILEIO_TEST_IS_DIR			(1 << 2)
#define FILEIO_TEST_IS_EXECUTABLE	(1 << 3)
#define FILEIO_TEST_EXISTS			(1 << 4)


# define fileio_isfile(file) g_file_test(file,G_FILE_TEST_EXISTS)


typedef struct FileIO_Tag {
#ifdef G_OS_WIN32
	HANDLE hFile;
#else /* not G_OS_WIN32 */
	int fd;
	gchar *file;
	guint share;
#endif /* not G_OS_WIN32 */
} FileIO;


/******************************************************************************
*                                                                             *
* եϴؿ                                                        *
*                                                                             *
******************************************************************************/
/*	ե¸߳ǧ
	file,ե̾
	test,
	 RET,TRUE:פ,FALSE:פʤ										*/
gboolean
fileio_test (const gchar *file, const guint test);


/*	եΥեѥ
	file,ե̾
	 RET,եѥ															*/
gchar *
fileio_get_full_path (const gchar *file);


/*	եκ
	  file,ե̾
	access,
	 share,ͭ
	  mode,⡼
	   RET,եݥ,NULL:顼										*/
FileIO *
fileio_open (const gchar *file,
					const guint access, const guint share, const guint mode);


/*	եݥ󥿤Ĥ
	fio,եݥ
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean
fileio_close (FileIO *fio);


/*	ե뤫ɤ߹
	   fio,եݥ
	  data,Хåե
	length,Хȿ
	   RET,Хȿ,-1:顼												*/
gssize
fileio_read (FileIO *fio, gpointer data, const gssize length);


/*	ե˽񤭹
	   fio,եݥ
	  data,Хåե
	length,Хȿ
	   RET,Хȿ,-1:顼												*/
gssize
fileio_write (FileIO *fio, gpointer data, const gssize length);


/*	ե򥷡
	   fio,եݥ
	offset,
	whence,⡼
	   RET,Хȿ,-1:顼												*/
goffset
fileio_seek (FileIO *fio, const goffset offset, const guint whence);


/*	1ʸɤ߹
	fio,եݥ
	RET,ʸ,EOF:顼														*/
gint
fileio_getc (FileIO *fio);


/*	1ʸ񤭹
	  c,ʸ
	fio,եݥ
	RET,ʸ,EOF:顼														*/
gint
fileio_putc (gint c, FileIO *fio);


/*	1ɤ߹
	  data,Хåե
	length,Хȿ
	   fio,եݥ
	   RET,data:ｪλ,NULL:顼										*/
gchar *
fileio_gets (gchar *data, const gsize length, FileIO *fio);


/*	1Խ񤭹
	  data,Хåե
	length,Хȿ
	   fio,եݥ
	   RET,:ｪλ,EOF:顼											*/
gint
fileio_puts (gchar *data, FileIO *fio);


#ifdef __cplusplus
}
#endif
#endif
