/*
    avicore
    copyright (c) 2000-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/******************************************************************************
*                                                                             *
* Avi Core                                                                    *
*                                                                             *
******************************************************************************/
#ifndef __AVICORE_H__
#define __AVICORE_H__


#include "common.h"
#include "avifmt.h"
#include "bitmap.h"
#include "icm.h"
#include "wave.h"
#include "misc/fileio.h"


#ifdef __cplusplus
extern "C" {
#endif


/******************************************************************************
*                                                                             *
* Խ¤                                                                  *
*                                                                             *
******************************************************************************/
#define AVI_TYPE_UNKNOW		(-1)
#define AVI_TYPE_AVI		0
#define AVI_TYPE_BITMAP		1
#define AVI_TYPE_WAVE		2
#define AVI_TYPE_SCENARIO	3


#define AVI_EDIT_CACHE		20


typedef struct AviIndex_Tag {
	goffset offset;
	guint32 size;
	guint32 flags;
} AviIndex;
typedef struct AviFile_Tag {
	FileIO *fio;					/* եݥ */
	gpointer *data;					/*  */
	gchar *name;					/* ե̾ */
	gint start,length;				/* ͭϰ */
	gint entries;					/* ǥåο */
	gint param;						/* ȥ꡼ֹ */
	AviIndex *index;				/* ǥå */
	/* ꥹ */
	struct AviFile_Tag *prev,*next;
	/* ӥǥͭ */
	guint32 handler;
	BitmapInfoHeader *bmih;			/* ꥸʥΥեޥå */
	/* ǥͭ */
	WaveFormatEx *wfx;				/* ꥸʥΥեޥå */
} AviFile;
typedef struct AviBuffer_Tag {
	gpointer data;					/* å */
	/* ӥǥͭ */
	gboolean raw;					/* TRUE:32ӥåRAW,FALSE:ӥåȥޥå */
	gint pos;						/*  */
	gint width,height;				/* (RAWͭ) */
} AviBuffer;
typedef struct AviEdit_Tag {
	gint offset;
	AviFile *file;
	guint32 type;					/* streamtypeAUDIO/streamtypeVIDEO */
	gint length;					/* ץ */
	guint32 rate;
	guint32 scale;					/* ratescale=1ô֤Υե졼 */
	guint16 priority;				/* ͥ */
	guint16 language;				/*  */
	gchar *name;					/* ̾ */
	AviBuffer buf[AVI_EDIT_CACHE];	/* å */
	/* ӥǥͭ */
	BitmapInfoHeader *bmih;			/* ŸΥեޥå */
	/* ǥͭ */
	WaveFormatEx *wfx;				/* ŸΥեޥå */
} AviEdit;
typedef struct AviFrame_Tag {
	guint32 handler;				/* 4ʸ */
	gint pos;						/* Ǹ˼ե졼 */
	AviEdit *avi_edit;
	IcmObject *icm_object;			/* ICMŸ */
} AviFrame;
typedef struct AviOptions_Tag {
	guint32 type;					/* streamtypeAUDIO/streamtypeVIDEO */
	/* ӥǥͭ */
	guint32 handler;				/* 4ʸ */
	gint key_frame;					/* (0:٤ƥե졼) */
	gint quality;					/* ʼ010000,-1:ǥե */
	gsize data_rate;				/* 1ô֤Υ(0:̵) */
	gboolean recompress;			/* TRUE:ư̤,FALSE:ư̤ʤ */
	gpointer param;					/* ץǡ */
	gsize param_size;				/* ץǡΥ */
	BitmapInfoHeader *bmih;			/* ̸Υեޥå */
	gsize bmih_size;				/* ̸ΥեޥåȤΥ */
	/* ǥͭ */
	WaveFormatEx *wfx;				/* ̸Υեޥå */
} AviOptions;
typedef struct AviSave_Tag {
	gint type;						/* ¸եμ */
	/* AVIͭ */
	AviOptions *avi_opt;			/* ץ */
	/* ӥåȥޥå׸ͭ */
	gint stream;					/* оݥȥ꡼ */
	gint start;						/* ǽΥե졼 */
	gint end;						/* ǸΥե졼 */
} AviSave;


/******************************************************************************
*                                                                             *
* եޥåȥޥ                                                          *
*                                                                             *
******************************************************************************/
/*	AVIRate
	avi_edit,AVIԽϥɥ
	     RET,Rate															*/
#define avi_get_rate(avi_edit) (((AviEdit *)(avi_edit))->rate)


/*	AVIScale
	avi_edit,AVIԽϥɥ
	     RET,Scale															*/
#define avi_get_scale(avi_edit) (((AviEdit *)(avi_edit))->scale)


/*	AVIͥ٤
	avi_edit,AVIԽϥɥ
	     RET,ͥ															*/
#define avi_get_priority(avi_edit) (((AviEdit *)(avi_edit))->priority)


/*	AVIθ
	avi_edit,AVIԽϥɥ
	     RET,															*/
#define avi_get_language(avi_edit) (((AviEdit *)(avi_edit))->language)


/*	AVI̾
	avi_edit,AVIԽϥɥ
	     RET,̾															*/
#define avi_get_name(avi_edit) (((AviEdit *)(avi_edit))->name)


/*	AVI
	avi_edit,AVIԽϥɥ
	     RET,,0:顼													*/
#define avi_get_width(avi_edit)												\
					((avi_edit)->bmih!=NULL?bmih_get_width((avi_edit)->bmih):0)


/*	AVIι⤵
	avi_edit,AVIԽϥɥ
	     RET,⤵,0:顼													*/
#define avi_get_height(avi_edit)											\
				((avi_edit)->bmih!=NULL?bmih_get_height((avi_edit)->bmih):0)


/*	AVIο
	avi_edit,AVIԽϥɥ
	     RET,,0:顼													*/
#define avi_get_bit_count(avi_edit)											\
				((avi_edit)->bmih!=NULL?bmih_get_bit_count((avi_edit)->bmih):0)


/*	AVIΰ̷
	avi_edit,AVIԽϥɥ
	     RET,̷,-1:顼												*/
#define avi_get_compression(avi_edit)										\
	((avi_edit)->bmih!=NULL?bmih_get_compression((avi_edit)->bmih):(guint32)-1)


/*	AVIX٤
	avi_edit,AVIԽϥɥ
	     RET,X,-1:顼												*/
#define avi_get_x_pixels_per_meter(avi_edit)								\
	((avi_edit)->bmih!=NULL?bmih_get_x_pixels_per_meter((avi_edit)->bmih):-1)


/*	AVIY٤
	avi_edit,AVIԽϥɥ
	     RET,Y,-1:顼												*/
#define avi_get_y_pixels_per_meter(avi_edit)								\
	((avi_edit)->bmih!=NULL?bmih_get_y_pixels_per_meter((avi_edit)->bmih):-1)


/*	AVIΥ졼Ȥ
	avi_edit,AVIԽϥɥ
	     RET,졼,0:顼												*/
#define avi_get_samples_per_sec(avi_edit)									\
			((avi_edit)->wfx!=NULL?wfx_get_samples_per_sec((avi_edit)->wfx):0)


/*	AVIΥͥ
	avi_edit,AVIԽϥɥ
	     RET,ͥ,0:顼											*/
#define avi_get_channels(avi_edit)											\
					((avi_edit)->wfx!=NULL?wfx_get_channels((avi_edit)->wfx):0)


/*	AVIΥӥåȤ
	avi_edit,AVIԽϥɥ
	     RET,ӥå,0:顼												*/
#define avi_get_bits_per_sample(avi_edit)									\
			((avi_edit)->wfx!=NULL?wfx_get_bits_per_sample((avi_edit)->wfx):0)


/*	AVIRateꤹ
	avi_edit,AVIԽϥɥ
	   value,Rate															*/
#define avi_set_rate(avi_edit,value) (((AviEdit *)(avi_edit))->rate=(value))


/*	AVIScaleꤹ
	avi_edit,AVIԽϥɥ
	   value,Scale															*/
#define avi_set_scale(avi_edit,value) (((AviEdit *)(avi_edit))->scale=(value))


/*	AVIͥ٤ꤹ
	avi_edit,AVIԽϥɥ
	   value,ͥ															*/
#define avi_set_priority(avi_edit,value)									\
									(((AviEdit *)(avi_edit))->priority=(value))


/*	AVIθꤹ
	avi_edit,AVIԽϥɥ
	   value,															*/
#define avi_set_language(avi_edit,value)									\
									(((AviEdit *)(avi_edit))->language=(value))


/*	AVI̾ꤹ
	avi_edit,AVIԽϥɥ
	   value,̾															*/
#define avi_set_name(avi_edit,value)										\
	(																		\
		g_free(((AviEdit *)(avi_edit))->name),								\
		((AviEdit *)(avi_edit))->name=value!=NULL?g_strdup(value):NULL		\
	)


/*	AVIꤹ
	avi_edit,AVIԽϥɥ
	   width,																*/
#define avi_set_width(avi_edit,width)										\
	((avi_edit)->bmih!=NULL?(bmih_set_width((avi_edit)->bmih,width),		\
	bmih_set_size_image((avi_edit)->bmih,bm_image_bytes((avi_edit)->bmih))):0)


/*	AVIι⤵ꤹ
	avi_edit,AVIԽϥɥ
	  height,⤵															*/
#define avi_set_height(avi_edit,height)										\
	((avi_edit)->bmih!=NULL?(bmih_set_height((avi_edit)->bmih,height),		\
	bmih_set_size_image((avi_edit)->bmih,bm_image_bytes((avi_edit)->bmih))):0)


/*	AVIοꤹ
	 avi_edit,AVIԽϥɥ
	bit_count,															*/
#define avi_set_bit_count(avi_edit,bit_count)								\
	((avi_edit)->bmih!=NULL													\
		?(bm_header_bytes((avi_edit)->bmih)									\
			<bx_header_bytes(	bmih_get_width((avi_edit)->bmih),			\
								bmih_get_height((avi_edit)->bmih),			\
								bit_count,									\
								bmih_get_compression((avi_edit)->bmih),		\
								bmih_get_color_used((avi_edit)->bmih))		\
			?((avi_edit)->bmih=g_realloc((avi_edit)->bmih,					\
					bx_header_bytes(bmih_get_width((avi_edit)->bmih),		\
									bmih_get_height((avi_edit)->bmih),		\
									bit_count,								\
									bmih_get_compression((avi_edit)->bmih),	\
									bmih_get_color_used((avi_edit)->bmih))))\
			:NULL															\
		),bmih_set_bit_count((avi_edit)->bmih,bit_count)					\
		:0)


/*	AVIX٤ꤹ
	          avi_edit,AVIԽϥɥ
	x_pixels_per_meter,X												*/
#define avi_set_x_pixels_per_meter(avi_edit,x_pixels_per_meter)				\
		((avi_edit)->bmih!=NULL												\
		?bmih_set_x_pixels_per_meter((avi_edit)->bmih,x_pixels_per_meter):-1)


/*	AVIY٤ꤹ
	          avi_edit,AVIԽϥɥ
	y_pixels_per_meter,Y												*/
#define avi_set_y_pixels_per_meter(avi_edit,y_pixels_per_meter)				\
		((avi_edit)->bmih!=NULL												\
		?bmih_set_y_pixels_per_meter((avi_edit)->bmih,y_pixels_per_meter):-1)


/*	AVIΥ졼Ȥꤹ
	       avi_edit,AVIԽϥɥ
	samples_per_sec,졼													*/
#define avi_set_samples_per_sec(avi_edit,samples_per_sec)					\
				((avi_edit)->wfx!=NULL										\
				?wfx_set_samples_per_sec((avi_edit)->wfx,samples_per_sec):0)


/*	AVIΥͥꤹ
	avi_edit,AVIԽϥɥ
	channels,ͥ														*/
#define avi_set_channels(avi_edit,channels)									\
		((avi_edit)->wfx!=NULL?wfx_set_channels((avi_edit)->wfx,channels):0)


/*	AVIΥӥåȤꤹ
	       avi_edit,AVIԽϥɥ
	bits_per_sample,ӥå													*/
#define avi_set_bits_per_sample(avi_edit,bits_per_sample)					\
				((avi_edit)->wfx!=NULL										\
				?wfx_set_bits_per_sample((avi_edit)->wfx,bits_per_sample):0)


/******************************************************************************
*                                                                             *
* ץ/֥ޥ                                                         *
*                                                                             *
******************************************************************************/
/*	AVIΥפ
	avi_edit,AVIԽϥɥ
	     RET,streamtypeAUDIO/streamtypeVIDEO								*/
#define avi_type(avi_edit) (((AviEdit *)(avi_edit))->type)


/*	AVIΥץֹ椫֤
	avi_edit,AVIԽϥɥ
	  sample,ץֹ
	     RET,(ߥ)													*/
#ifdef G_HAVE_GINT64
# define avi_sample_to_time(avi_edit,sample)								\
					(gint)((guint64)(sample)*avi_get_scale(avi_edit)*1000	\
													/avi_get_rate(avi_edit))
#else /* not G_HAVE_GINT64 */
# define avi_sample_to_time(avi_edit,sample)								\
				((sample)*avi_get_scale(avi_edit)*1000/avi_get_rate(avi_edit))
#endif /* not G_HAVE_GINT64 */


/*	AVIλ֤饵ץֹ
	avi_edit,AVIԽϥɥ
	    time,(ߥ)
	     RET,ץֹ													*/
#ifdef G_HAVE_GINT64
# define avi_time_to_sample(avi_edit,time)									\
							(gint)((guint64)(time)*avi_get_rate(avi_edit)	\
									/((guint64)avi_get_scale(avi_edit)*1000))
#else /* not G_HAVE_GINT64 */
# define avi_time_to_sample(avi_edit,time)									\
				((time)*avi_get_rate(avi_edit)/(avi_get_scale(avi_edit)*1000))
#endif /* not G_HAVE_GINT64 */


/*	AVIĹ
	avi_edit,AVIԽϥɥ
	     RET,ץ														*/
#define avi_length(avi_edit) (((AviEdit *)(avi_edit))->length)


/*	AVIĹ֤ǵ
	avi_edit,AVIԽϥɥ
	     RET,(ߥ)													*/
#define avi_length_time(avi_edit)											\
							avi_sample_to_time(avi_edit,avi_length(avi_edit))


/******************************************************************************
*                                                                             *
* ؿ                                                                  *
*                                                                             *
******************************************************************************/
/*	AVI															*/
gboolean
avi_init (void);


/*	AVIλ															*/
gboolean
avi_exit (void);


/******************************************************************************
*                                                                             *
* AVIϴؿ()                                                         *
*                                                                             *
******************************************************************************/
/*	եȽ̤
	file,ե̾
	 RET,0:AVI,1:ӥåȥޥå,2:WAVEե,3:ʥꥪ֥,-1:	*/
gint
avi_file_type (const gchar *file);


/*	AVIΥȥ꡼ο
	file,ե̾
	 RET,ȥ꡼ο,0:顼											*/
guint32
avi_main_streams (const gchar *file);


/*	AVIե뤫鳫
	 file,ե̾
	param,ȥ꡼ֹ
	  RET,AVIԽϥɥ,NULL:顼										*/
AviEdit *
avi_open (const gchar *file, const gint param);


/*	AVIĤ
	avi_edit,AVIԽϥɥ
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean
avi_release (AviEdit *avi_edit);


/*	AVIΥǡΥХȿ
	avi_edit,AVIԽϥɥ
	   start,ɤ߹ߤϤ륵ץֹ
	 samples,ץ
	     RET,Хȿ														*/
gint
avi_sample_size (AviEdit *avi_edit, const gint start, const gint samples);


/*	AVIΥǡɤ߹
	avi_edit,AVIԽϥɥ
	   start,ɤ߹ߤϤ륵ץֹ
	 samples,ץ
	  buffer,ǡǼХåե
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean
avi_read (AviEdit *avi_edit, const gint start, const gint samples,
															gpointer buffer);


/*	AVIΥեޥåȤΥ
	avi_edit,AVIԽϥɥ
	     RET,եޥåȤΥХȿ,0:顼								*/
gint
avi_format_size (AviEdit *avi_edit);


/*	AVIΥեޥåȤɤ߹
	avi_edit,AVIԽϥɥ
	  format,ХåեؤΥݥ
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean
avi_read_format (AviEdit *avi_edit, gpointer format);


/******************************************************************************
*                                                                             *
* ե졼ؿ(ߤ)                                                        *
*                                                                             *
******************************************************************************/
/*	DIBŸ줿ե졼򳫤
	avi_edit,AVIԽϥɥ
	     RET,AVIե졼๽¤,NULL:顼									*/
AviFrame *
avi_get_frame_open (AviEdit *avi_edit);


/*	DIBŸ줿ե졼Ĥ
	avi_frame,AVIե졼๽¤
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean
avi_get_frame_close (AviFrame *avi_frame);


/*	DIBŸ줿ե졼
	avi_frame,AVIե졼๽¤
	      pos,ե졼(ץֹ)
	    width,
	   height,⤵
	bit_count,
	      RET,ѥåDIBؤΥݥ,NULL:顼								*/
BitmapInfoHeader *
avi_get_frame (AviFrame *avi_frame, const gint pos,
					const gint width, const gint height, const gint bit_count);


/*	RAWŸ줿ե졼
	avi_frame,AVIե졼๽¤
	      pos,ե졼(ץֹ)
	    width,
	   height,⤵
	      RET,RAWؤΥݥ,NULL:顼								*/
guint8 *
avi_get_frame32 (AviFrame *avi_frame, const gint pos,
										const gint width, const gint height);


/*	ե졼बե졼फȽꤹ
	avi_edit,AVIԽϥɥ
	     pos,ե졼(ץֹ)
	     RET,TRUE:ե졼,FALSE:󥭡ե졼							*/
gboolean
avi_is_keyframe (AviEdit *avi_edit, const gint pos);


/******************************************************************************
*                                                                             *
* Խؿ(줿)                                                            *
*                                                                             *
******************************************************************************/
/*	AVI
	avi_edit,AVIԽϥɥ
	   start,Ϥ륵ץֹ
	 samples,ץ
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean
avi_delete (AviEdit *avi_edit, const gint start, const gint samples);


/*	AVI򥳥ԡ
	avi_edit,AVIԽϥɥ
	   start,ԡϤ륵ץֹ
	 samples,ץ
	     RET,AVIԽϥɥ,NULL:顼									*/
AviEdit *
avi_copy (AviEdit *avi_edit, const gint start, const gint samples);


/*	AVIŽդ
	avi_dst,ŽդAVIԽϥɥ
	    pos,Žդ륵ץֹ
	avi_src,ŽդAVIԽϥɥ
	    RET,TRUE:ｪλ,FALSE:顼										*/
gboolean
avi_paste (AviEdit *avi_dst, const gint pos, AviEdit *avi_src);


/*	AVIʣ
	avi_edit,AVIԽϥɥ
	     RET,AVIԽϥɥ												*/
#define avi_clone(avi_edit) avi_copy(avi_edit,0,avi_length(avi_edit))


/******************************************************************************
*                                                                             *
* ʥꥪ֥ȴؿ(פ)                                            *
*                                                                             *
******************************************************************************/
/*	AVI򥷥ʥꥪ֥ȤѴ
	  avi_edit,AVIԽϥɥؤΥݥ
	interleave,TRUE:󥿡꡼֤,FALSE:󥿡꡼֤ʤ
	       RET,ʥꥪ֥,NULL:顼								*/
gchar *
avi_to_scenario (AviEdit *avi_edit[], const gboolean interleave);


/*	ʥꥪ֥ȤAVI
	scenario,ʥꥪ֥
	     RET,AVIԽϥɥؤΥݥ,NULL:顼						*/
AviEdit **
avi_from_scenario (const gchar *scenario);


/******************************************************************************
*                                                                             *
* ¸ؿ()                                                            *
*                                                                             *
******************************************************************************/
/*	¸ѤΥץ
	avi_save,ץ
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean
avi_save_free (AviSave *avi_save);


/*	٤¸뤫å
	avi_edit,AVIԽϥɥ
	avi_save,ץ
	     RET,TRUE:٤¸,FALSE:٤¸ʤ					*/
#define avi_save_is_all(avi_edit,avi_save) ((AviEdit **)(avi_edit)!=NULL	\
		&& ((AviEdit **)(avi_edit))[0]!=NULL && (AviSave *)(avi_save)!=NULL	\
		&& (((AviSave *)(avi_save))->type==AVI_TYPE_AVI						\
			|| ((AviSave *)(avi_save))->type==AVI_TYPE_SCENARIO				\
			|| (((AviEdit **)(avi_edit))[1]==NULL							\
							&& ((AviSave *)(avi_save))->type==AVI_TYPE_WAVE)))


/*	ե¸
	 avi_edit,AVIԽϥɥؤΥݥ
	     file,ե̾
	  avi_opt,ץ
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean
avi_save_avi (AviEdit *avi_edit[], const gchar *file, AviOptions *avi_opt,
						gboolean (*func)(gint, gpointer), gpointer user_data);


/*	ӥåȥޥåץե¸
	 avi_edit,AVIԽϥɥ
	     file,ե̾
	    start,ǽΥե졼
	      end,ǸΥե졼
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean
avi_save_bitmap (AviEdit *avi_edit,
						const gchar *file, const gint start, const gint end,
						gboolean (*func)(gint, gpointer), gpointer user_data);


/*	WAVEե¸
	 avi_edit,AVIԽϥɥ
	     file,ե̾
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean
avi_save_wave (AviEdit *avi_edit, const gchar *file,
						gboolean (*func)(gint, gpointer), gpointer user_data);


/*	ե¸
	 avi_edit,AVIԽϥɥؤΥݥ
	     file,ե̾
	 avi_save,ץ
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean
avi_save_with_options (AviEdit *avi_edit[], const gchar *file,
	AviSave *avi_save, gboolean (*func)(gint, gpointer), gpointer user_data);


/******************************************************************************
*                                                                             *
* ؿ()                                                      *
*                                                                             *
******************************************************************************/
/*	¸ѤΥץ
	avi_edit,AVIԽϥɥؤΥݥ
	     RET,ץ,NULL:󥻥:顼								*/
AviSave *
avi_save_dialog (AviEdit *avi_edit[]);


/*	¸ѤΥץ
	avi_edit,AVIԽϥɥؤΥݥ
	    file,򤷤ե
	    path,ǥեȤΥǥ쥯ȥ
	     RET,ץ,NULL:顼											*/
AviSave *
avi_save_dialog_with_file (AviEdit *avi_edit[],
											gchar **file, const gchar *path);


#ifdef __cplusplus
}
#endif
#endif
