/*
    Video maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "vmaid.h"
#include <gdk/gdkrgb.h>
#include <locale.h>
#include "command.h"
#include "file.h"
#include "general.h"
#include "sigfile.h"
#include "sigmain.h"
#include "thread.h"
#include "toolbar.h"
#include "version.h"
#include "misc/argument.h"
#include "misc/fileio.h"
#include "misc/license.h"
#include "misc/misc_accel.h"
#include "misc/misc_comm.h"
#include "misc/profile.h"


gboolean caret=FALSE;               /* キャレットの形 */
gboolean newfile=FALSE;             /* TRUE:新規ファイル,FALSE:なし */
gboolean second=FALSE;              /* TRUE:新規,FALSE:既存 */
gboolean default_ratio=FALSE;       /* TRUE:縦/横の比率を保持しない */
gboolean file_merge=FALSE;          /* TRUE:連番,FALSE:単独 */
gchar *history_files[10];           /* ファイルの履歴 */
gchar *open_path=NULL;              /* 開くのパス */
gchar *save_path=NULL;              /* 名前を付けて保存のパス */
gchar *clipboard_scenario=NULL;     /* クリップボードのテキスト */
gint def_width,def_height;          /* デフォルトのウインドウのサイズ */
gint history=4;                     /* ファイルの履歴 */
gint default_view=6;                /* ウインドウが作成時の初期値 */
guint default_rate=15;              /* ウインドウが作成時の初期値 */
guint timer_id=0;                   /* タイマID */
GdkAtom atom_targets;               /* ターゲット */
GdkAtom atom_scenario;              /* シナリオオブジェクト */
GdkBitmap *bitmap0;                 /* 波背景 */
GdkBitmap *bitmap1;                 /* 網背景 */
GtkWidget *window;                  /* ウインドウ */
GtkWidget *notebook;                /* ノートブック */
GtkWidget *tview;                   /* リストボックス */
GtkWidget *status;                  /* ステータスウインドウ */
GtkPositionType n_pos=GTK_POS_TOP;  /* ノートブックの位置 */
GtkItemFactory *ifactory_menu;      /* メニュー */
GtkItemFactory *ifactory_popup;     /* ポップアップ */
GtkItemFactory *ifactory_tview;     /* ポップアップ */
GdkFont *system_font=NULL;
gint system_font_height;            /* フォントの高さ */
gint system_font_ascent;            /* フォントのアクセントの高さ */
GtkListStore *list_store;           /* リスト */
GdkColor system_color[4]={  {0,0x0000,0x0000,0x0000},{0,0xffff,0xffff,0xffff},
                            {0,0xffff,0xffff,0xffff},{0,0x0000,0x0000,0x8000}};
#ifdef G_OS_WIN32
UINT uFormat = 0;                   /* クリップボード */
#endif /* G_OS_WIN32 */


/******************************************************************************
*                                                                             *
* メイン関数                                                                  *
*                                                                             *
******************************************************************************/
static gchar *
menu_translate (const gchar *path,
                gpointer     func_data)
{
 return (gchar *)_(path);
}


int main(int argc,char *argv[])
{
    gboolean *arg_files, license = FALSE;
    gchar *utf8str, *key;
    gint i, count = 0, ascent, height;
    FileOpen *file_open;
    Profile *profile;
    GObject *accel;
    GdkBitmap *mask;
    GdkPixmap *pixmap;
    GtkAccelGroup *accel_group;
    GtkCellRenderer *renderer;
    GtkStyle *style;
    GtkTreeSelection *select;
    GtkTreeViewColumn *column;
    GtkWidget *toolbar,*text,*handle,*scroll,*vbox;
    GtkWidget *menu_bar, *menu_shell, *menu_item;
    gchar *title[4]={N_("Mode"),N_("File"),N_("Time"),N_("Status")};
    GtkItemFactoryEntry menu_items[]={
{N_("/_File"),                   NULL,         NULL,            0,"<Branch>"},
{N_("/File/_New"),               "<control>N", command_new,     0,"<Item>"},
{N_("/File/_Open..."),           "<control>O", command_open,    0,"<Item>"},
{N_("/File/_Close"),             "<control>W", command_close,   0,"<Item>"},
{N_("/File/Save _As..."),        "<control>S", command_save,    0,"<Item>"},
{N_("/File/Sep1"),               NULL,         NULL,            0,"<Separator>"},
{N_("/File/Pre_view..."),        "<control>P", NULL,            0,"<Item>"},
{N_("/File/Propert_ies..."),     "<alt>Return",command_property,0,"<Item>"},
{N_("/File/Sep2"),               NULL,         NULL,            0,"<Separator>"},
{N_("/File/E_xit"),              "<control>Q", command_exit,    0,"<Item>"},
{N_("/_Edit"),                   NULL,         NULL,            0,"<Branch>"},
{N_("/Edit/_Undo"),              "<control>Z", command_undo,    0,"<Item>"},
{N_("/Edit/_Redo"),              "F4",         command_redo,    0,"<Item>"},
{N_("/Edit/Sep1"),               NULL,         NULL,            0,"<Separator>"},
{N_("/Edit/Cu_t"),               "<control>X", command_cut,     0,"<Item>"},
{N_("/Edit/_Copy"),              "<control>C", command_copy,    0,"<Item>"},
{N_("/Edit/_Paste"),             "<control>V", command_paste,   0,"<Item>"},
{N_("/Edit/De_lete"),            NULL,         command_delete,  0,"<Item>"},
{N_("/Edit/Sep2"),               NULL,         NULL,            0,"<Separator>"},
{N_("/Edit/_Merge..."),          "<control>M", NULL,            0,"<Item>"},
{N_("/Edit/_Jump..."),           "<control>J", command_jump,    0,"<Item>"},
{N_("/Edit/Sep3"),               NULL,         NULL,            0,"<Separator>"},
{N_("/Edit/_All"),               "<control>A", command_all,     0,"<Item>"},
{N_("/_View"),                   NULL,         NULL,            0,"<Branch>"},
{N_("/View/S_ize..."),           NULL,         command_size,    0,"<Item>"},
{N_("/_Option"),                 NULL,         NULL,            0,"<Branch>"},
{N_("/Option/_Configuration..."),NULL,         command_conf,    0,"<Item>"},
{N_("/_Task"),                   NULL,         NULL,            0,"<Branch>"},
{N_("/Task/_Cancel"),            NULL,         command_cancel,  0,"<Item>"},
{N_("/_Window"),                 NULL,         NULL,            0,"<Branch>"},
{N_("/_Help"),                   NULL,         NULL,            0,"<Branch>"},
{N_("/Help/_About..."),          NULL,         version_dialog,  0,"<Item>"}};
    GtkItemFactoryEntry popup_items[]={
{N_("/_Undo"),                   "<control>Z", command_undo,            0,"<Item>"},
{"/Sep1",                        NULL,         NULL,            0,"<Separator>"},
{N_("/Cu_t"),                    "<control>X", command_cut,     0,"<Item>"},
{N_("/_Copy"),                   "<control>C", command_copy,    0,"<Item>"},
{N_("/_Paste"),                  "<control>V", command_paste,   0,"<Item>"},
{N_("/De_lete"),                 NULL,         command_delete,  0,"<Item>"},
{"/Sep2",                        NULL,         NULL,            0,"<Separator>"},
{N_("/_All"),                    "<control>A", command_all,     0,"<Item>"}};
    GtkItemFactoryEntry tview_items[]={
{N_("/_Cancel"),                 NULL,         command_cancel,  0,"<Item>"}};
    /* Drag&Drop */
    GtkTargetEntry drag_types[1]={{"text/uri-list",0,0}};
    /* ja:Video maidが提供可能なセレクション */
    GtkTargetEntry targets_vmaid[]
                        = {{"Video maid Scenario Object", 0, TARGET_VMAID}};
    static gchar *xpm0[]={
"4 8 2 1",
"   c None",
".  c #000000",
".   ",
".   ",
"   .",
"   .",
"  . ",
"  . ",
" .  ",
" .  "};
    static gchar *xpm1[]={
"2 2 2 1",
"   c None",
".  c #000000",
". ",
" ."};


    /* 初期化 */
    setlocale(LC_ALL,"");
#ifdef LOCALEDIR
    bindtextdomain(PACKAGE,LOCALEDIR);
#else /* not LOCALEDIR */
    {
        gchar *dirname, *path, *locale;

        path = fileio_get_full_path (argv[0]);
        dirname = g_path_get_dirname (path);
        g_free (path);
        locale = g_strconcat (dirname, G_DIR_SEPARATOR_S, "locale", NULL);
        g_free (dirname);
        bindtextdomain (PACKAGE, locale);
        g_free (locale);
    }
#endif /* not LOCALEDIR */
    bind_textdomain_codeset(PACKAGE,"UTF-8");
    textdomain(PACKAGE);
#ifdef USE_THREAD
    g_thread_init(NULL);
    gdk_threads_init();
#endif /* USE_THREAD */
    gtk_set_locale();
    gtk_init(&argc,&argv);
    gdk_rgb_init();
    avi_init();
    g_atexit((GVoidFunc)avi_exit);

    def_width=gdk_screen_width()*2/3;
    def_height=gdk_screen_height()*2/3;
    g_memset(history_files,0,sizeof(gchar *)*10);
    /* レジストリから読み出す */
    if ((profile=profile_open(NULL))!=NULL) {
        if (!profile_get_value (profile, "vmaid", "license",
                (gpointer)&license, sizeof (gboolean),
                                                    PROFILE_VALUE_TYPE_BOOL))
            license = FALSE;
        if (!profile_get_value(profile,"vmaid","history",
                (gpointer)&history,sizeof(gint),PROFILE_VALUE_TYPE_INT))
            history=4;
        if (!profile_get_value(profile,"vmaid","newfile",
                (gpointer)&newfile,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL))
            newfile=FALSE;
        if (!profile_get_value(profile,"vmaid","second",
                (gpointer)&second,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL))
            second=FALSE;
        if (!profile_get_value(profile,"vmaid","def_width",
                (gpointer)&def_width,sizeof(gint),PROFILE_VALUE_TYPE_INT))
            def_width=gdk_screen_width()*2/3;
        if (!profile_get_value(profile,"vmaid","def_height",
                (gpointer)&def_height,sizeof(gint),PROFILE_VALUE_TYPE_INT))
            def_height=gdk_screen_height()*2/3;
        if (!profile_get_value(profile,"vmaid","n_pos",
                (gpointer)&n_pos,sizeof(gint),PROFILE_VALUE_TYPE_INT))
            n_pos=GTK_POS_TOP;
        if (!profile_get_value(profile,"vmaid","ratio",
                (gpointer)&default_ratio,sizeof(gboolean),
                                                    PROFILE_VALUE_TYPE_BOOL))
            default_ratio=FALSE;
        if (!profile_get_value(profile,"vmaid","merge",
                (gpointer)&file_merge,sizeof(gboolean),
                                                    PROFILE_VALUE_TYPE_BOOL))
            file_merge=FALSE;
        if (!profile_get_value(profile,"vmaid","view",
                (gpointer)&default_view,sizeof(gint),PROFILE_VALUE_TYPE_INT))
            default_view=6;
        if (!profile_get_value(profile,"vmaid","rate",
                (gpointer)&default_rate,sizeof(guint),PROFILE_VALUE_TYPE_INT))
            default_rate=15;
        utf8str = profile_get_string (profile, "vmaid", "openpath");
        open_path = utf8str != NULL
                ? g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL) : NULL;
        g_free (utf8str);
        utf8str = profile_get_string (profile, "vmaid", "savepath");
        save_path = utf8str != NULL
                ? g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL) : NULL;
        g_free (utf8str);
        /* ファイルの履歴 */
        for (i=0;i<history;i++) {
            key=g_strdup_printf("history%d",i);
            utf8str = profile_get_string (profile, "vmaid", key);
            history_files[i] = utf8str != NULL
                ? g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL) : NULL;
            g_free (utf8str);
            g_free(key);
            if (history_files[i]==NULL)
                break;
            if (*history_files[i]=='\0') {
                g_free(history_files[i]);
                history_files[i]=NULL;
                break;
            }
        }
        profile_close(profile);
    }
    if (!license)
      {
#ifdef USE_THREAD
        gdk_threads_enter ();
#endif /* USE_THREAD */
        license = license_dialog ();
#ifdef USE_THREAD
        gdk_threads_leave ();
#endif /* USE_THREAD */
      }
    if (!license)
        gtk_exit (0);

    /* ja:コマンドラインの解析 */
    {
      gint array[2], def[2];
      ArgumentBool arg_n, arg_x;
      ArgumentValue arg_h;
      ArgumentArray arg_s;
      ArgumentExit arg_v;
      ArgumentHelp arg_q;
      ArgumentList arg_opts[] = {
{"history", 'h',  "NUM",          N_("History"),     ARGUMENT_TYPE_VALUE, &arg_h},
{"new",     'n',  "ON/OFF",       N_("New File"),    ARGUMENT_TYPE_BOOL,  &arg_n},
{"size",    's',  "WIDTH,HEIGHT", N_("Window Size"), ARGUMENT_TYPE_ARRAY, &arg_s},
{"second",  'x',  "ON/OFF",       N_("Open Window"), ARGUMENT_TYPE_BOOL,  &arg_x},
{"version", 'v',  NULL,           N_("About"),       ARGUMENT_TYPE_EXIT,  &arg_v},
{"help",    '?',  NULL,           N_("Help"),        ARGUMENT_TYPE_HELP,  &arg_q},
{NULL,      '\0', NULL,           NULL,              0,                   NULL}};

      /* ja:ファイルの履歴 */
      arg_h.val = history;
      arg_h.def = 4;
      /* ja:新規ファイル */
      arg_n.flag = newfile;
      arg_n.def = FALSE;
      /* ja:ウインドウサイズ */
      array[0] = def_width;
      array[1] = def_height;
      def[0] = gdk_screen_width ()  * 2 / 3;
      def[1] = gdk_screen_height () * 2 / 3;
      arg_s.leng = 2;
      arg_s.array = array;
      arg_s.def = def;
      /* ja:新規ウインドウ */
      arg_x.flag = second;
      arg_x.def = FALSE;
      /* ja:バージョン */
      arg_v.str =
VMAID_VERSION_NOTICE"\n"
VMAID_COPYRIGHT_NOTICE"\n"
"This is free software; see the source for copying conditions.  There is NO\n"
"warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n";
      /* ja:ヘルプ */
      arg_q.str = VMAID_COPYRIGHT_NOTICE"\n\n";
      arg_files = arg_analyse (argv, arg_opts);
      if (0 <= arg_h.val && arg_h.val <= 10)
        history = arg_h.val;
      def_width = array[0];
      def_height = array[1];
      second = arg_x.flag;
    }

    /* メインウインドウ */
    window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(window),"Video maid");
    gtk_window_set_default_size(GTK_WINDOW(window),def_width,def_height);
    g_signal_connect (G_OBJECT (window), "delete-event",
                                            G_CALLBACK (signal_delete), NULL);
    g_signal_connect (G_OBJECT (window), "destroy",
                                    G_CALLBACK (signal_destroy_window), NULL);
    gtk_widget_realize(window);
    /* Drag and Drop */
    gtk_drag_dest_set(window,GTK_DEST_DEFAULT_MOTION
                        | GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_DROP,
                                                drag_types,1,GDK_ACTION_COPY);
    g_signal_connect (G_OBJECT (window), "drag-data-received",
                                G_CALLBACK (signal_drag_data_received), NULL);
#ifdef G_OS_WIN32
    /* クリップボード */
    uFormat = RegisterClipboardFormat (_T("Video maid Scenario Object"));
#endif /* G_OS_WIN32 */
    /* クリップボード */
    atom_targets=gdk_atom_intern("TARGETS",FALSE);
    atom_scenario=gdk_atom_intern("Video maid Scenario Object",FALSE);
    gtk_selection_add_targets (window, GDK_SELECTION_CLIPBOARD,
            targets_vmaid, sizeof (targets_vmaid) / sizeof (GtkTargetEntry));
    g_signal_connect (G_OBJECT (window), "selection-clear-event",
                                G_CALLBACK (signal_selection_clear), NULL);
    g_signal_connect (G_OBJECT(window), "selection-get",
                                G_CALLBACK (signal_selection_get), NULL);
    g_signal_connect (G_OBJECT (window), "selection-received",
                                G_CALLBACK (signal_selection_received), NULL);
    /* ノートブック */
    notebook=gtk_notebook_new();
    gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook),TRUE);
    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook),n_pos);
    g_signal_connect (G_OBJECT (notebook), "switch-page",
                                G_CALLBACK (signal_switch_page), NULL);
    g_signal_connect (GTK_OBJECT (notebook), "destroy",
                                G_CALLBACK (signal_destroy_notebook), NULL);
    /* ポップアップ */
    accel_group=gtk_accel_group_new();
    ifactory_popup = gtk_item_factory_new (GTK_TYPE_MENU,
                                                        "<main>", accel_group);
    gtk_item_factory_set_translate_func(ifactory_popup, menu_translate,
                                                                NULL, NULL);
    gtk_item_factory_create_items (ifactory_popup,
                        sizeof (popup_items) / sizeof (GtkItemFactoryEntry),
                                                            popup_items, NULL);
    /* ポップアップ */
    accel_group=gtk_accel_group_new();
    ifactory_tview = gtk_item_factory_new (GTK_TYPE_MENU,
                                                        "<main>", accel_group);
    gtk_item_factory_set_translate_func (ifactory_tview, menu_translate,
                                                                NULL, NULL);
    gtk_item_factory_create_items (ifactory_tview,
                        sizeof (tview_items) / sizeof (GtkItemFactoryEntry),
                                                            tview_items, NULL);
    /* メニュー */
    accel_group=gtk_accel_group_new();
    ifactory_menu = gtk_item_factory_new (GTK_TYPE_MENU_BAR,
                                                        "<main>", accel_group);
    gtk_item_factory_set_translate_func (ifactory_menu, menu_translate,
                                                                NULL, NULL);
    gtk_item_factory_create_items (ifactory_menu,
                        sizeof (menu_items) / sizeof (GtkItemFactoryEntry),
                                                            menu_items, NULL);
    gtk_window_add_accel_group(GTK_WINDOW(window),accel_group);
    menu_bar = gtk_item_factory_get_widget (ifactory_menu, "<main>");
    /* ja:アクセルグループ */
    accel = misc_accel_new ();
    misc_accel_set_window (MISC_ACCEL (accel), GTK_WINDOW (window));
    misc_accel_add_accel_group (MISC_ACCEL (accel), accel_group);
    /* ツールバー */
    toolbar=gtk_toolbar_new();
    gtk_toolbar_set_orientation(GTK_TOOLBAR(toolbar),
                                                GTK_ORIENTATION_HORIZONTAL);
    gtk_toolbar_set_style(GTK_TOOLBAR(toolbar),GTK_TOOLBAR_ICONS);
    for (i=0;toolbar_items[i].name!=(gpointer)-1;i++)
        if (toolbar_items[i].name==NULL) {
            gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
        } else {
            pixmap=gdk_pixmap_create_from_xpm_d(window->window,
                                            &mask,NULL,toolbar_items[i].xpm);
            toolbar_items[i].item = gtk_toolbar_append_item
                        (GTK_TOOLBAR(toolbar),
                        NULL, _(toolbar_items[i].name), NULL,
                        gtk_pixmap_new (pixmap,mask),
                        G_CALLBACK (toolbar_items[i].callback),
                        toolbar_items[i].user_data);
        }
    /* リストボックス */
    list_store = gtk_list_store_new (5,
                                    G_TYPE_STRING,
                                    G_TYPE_STRING,
                                    G_TYPE_STRING,
                                    G_TYPE_STRING,
                                    G_TYPE_POINTER);
    tview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (list_store));
    gtk_tree_view_set_enable_search (GTK_TREE_VIEW (tview), FALSE);
    for (i = 0; i < 4; i++)
      {
        renderer = gtk_cell_renderer_text_new ();
        column = gtk_tree_view_column_new_with_attributes (gettext (title[i]),
                                                    renderer, "text", i, NULL);
        gtk_tree_view_column_set_resizable (column, TRUE);
        gtk_tree_view_append_column (GTK_TREE_VIEW (tview), column);
      }
    g_object_set (G_OBJECT (renderer), "xalign", (gfloat)1.0, NULL);
    gtk_tree_view_column_set_alignment (column, 1.0);
    select = gtk_tree_view_get_selection (GTK_TREE_VIEW (tview));
    gtk_tree_selection_set_mode (select, GTK_SELECTION_MULTIPLE);
    g_signal_connect (G_OBJECT (select), "changed",
                                            G_CALLBACK (signal_changed), NULL);
    /* スクロールウインドウ */
    scroll=gtk_scrolled_window_new(NULL,NULL);
    gtk_container_add (GTK_CONTAINER (scroll), tview);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
                                    GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
    /* ステータスバー */
    status=gtk_statusbar_new();
    /* テキスト */
    text=gtk_label_new("");
    g_signal_connect (G_OBJECT (text), "style-set",
                                        G_CALLBACK (signal_style_set), NULL);
    /* 垂直ボックス/ハンドルボックス */
    vbox=gtk_vbox_new(FALSE,0);
    handle=gtk_handle_box_new();
    gtk_container_set_border_width(GTK_CONTAINER(handle),2);
    gtk_container_add (GTK_CONTAINER (handle), menu_bar);
    gtk_box_pack_start(GTK_BOX(vbox),handle,FALSE,FALSE,0);
    handle=gtk_handle_box_new();
    gtk_container_set_border_width(GTK_CONTAINER(handle),2);
    gtk_container_add(GTK_CONTAINER(handle),toolbar);
    gtk_box_pack_start(GTK_BOX(vbox),handle,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(vbox),notebook,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(vbox),scroll,TRUE,TRUE,0);
    gtk_box_pack_end(GTK_BOX(vbox),status,FALSE,FALSE,0);
    gtk_box_pack_end(GTK_BOX(vbox),text,FALSE,FALSE,0);
    gtk_container_add(GTK_CONTAINER(window),vbox);
    /* ファイルの履歴 */
    menu_shell = gtk_item_factory_get_widget (ifactory_menu, "<main>/File");
    for (i=0;i<history && history_files[i]!=NULL;i++) {
        utf8str = g_filename_to_utf8 (history_files[i], -1, NULL, NULL, NULL);
        menu_item = gtk_menu_item_new_with_label (utf8str);
        g_free (utf8str);
        g_signal_connect (G_OBJECT (menu_item), "activate",
                G_CALLBACK (signal_activate_menu_history), history_files[i]);
        g_signal_connect (G_OBJECT (menu_item), "destroy",
                G_CALLBACK (signal_destroy_menu_history), history_files[i]);
        g_object_set_data (G_OBJECT (menu_item), "user_data",
                                                            history_files[i]);
        gtk_menu_insert (GTK_MENU (menu_shell), menu_item, i + MENUFILE - 1);
    }
    if (i>0)
        gtk_menu_insert (GTK_MENU (menu_shell), gtk_menu_item_new (),
                                                            i + MENUFILE - 1);
    /* タイマ */
    timer_id=gtk_timeout_add(500,signal_timeout,NULL);

    /* メニュー表示 */
    set_menu_bar(NULL);

  /* ja:既に起動しているかチェックする */
  if (!second)
    {
      GObject *comm;

      comm = misc_comm_new (window, "Video maid InterProcess communication");
      if (!misc_comm_is_first (MISC_COMM (comm)))
        {
          misc_comm_send_with_files (MISC_COMM (comm), argc, argv, arg_files);
          gtk_exit (0);
        }
      g_signal_connect (G_OBJECT (comm), "recv",
                                    G_CALLBACK (signal_selection_recv), NULL);
    }

    /* 表示 */
    gtk_widget_set_sensitive (gtk_menu_get_attach_widget (GTK_MENU
        (gtk_item_factory_get_widget (ifactory_menu, "<main>/Task"))), FALSE);
    gtk_widget_show_all(window);
    gtk_widget_hide_all(text);
    gtk_window_set_policy(GTK_WINDOW(window),FALSE,TRUE,TRUE);

    /* ピクスマップ */
    pixmap=gdk_pixmap_create_from_xpm_d(window->window,&bitmap0,NULL,xpm0);
    gdk_pixmap_unref(pixmap);
    pixmap=gdk_pixmap_create_from_xpm_d(window->window,&bitmap1,NULL,xpm1);
    gdk_pixmap_unref(pixmap);

    /* システム色 */
    style=gtk_widget_get_style(text);
    system_color[0]=style->text[0];
    system_color[1]=style->base[0];
    system_color[2]=style->dark[0];
    system_color[3]=style->bg[3];
    /* システムフォント */
    system_font=gdk_font_ref(gtk_style_get_font(style));
    for (i=0;i<256;i++) {
        gdk_text_extents(system_font,(gchar *)&i,1,
                                                NULL,NULL,NULL,&ascent,NULL);
        if (system_font_ascent<ascent)
            system_font_ascent=ascent;
        height = gdk_char_height (system_font, (gchar)i);
        if (system_font_height<height)
            system_font_height=height;
    }

    /* 新規ウインドウ */
    for (i=1;i<argc;i++)
        if (arg_files[i]) {
            file_open=g_malloc(sizeof(FileOpen));
            file_open->file=g_strdup(argv[i]);
            file_open->merge=file_merge;
#ifdef USE_THREAD
            g_thread_create((GThreadFunc)file_open_edit,file_open,TRUE,NULL);
#else /* not USE_THREAD */
            file_open_edit (file_open);
#endif /* not USE_THREAD */
            count++;
        }
    g_free(arg_files);
    if (newfile && count<=0)
#ifdef USE_THREAD
        g_thread_create((GThreadFunc)file_open_edit,NULL,TRUE,NULL);
#else /* not USE_THREAD */
        file_open_edit (NULL);
#endif /* not USE_THREAD */

#ifdef USE_THREAD
    gdk_threads_enter();
#endif /* USE_THREAD */
    gtk_main();
#ifdef USE_THREAD
    gdk_threads_leave();
#endif /* USE_THREAD */

    gdk_bitmap_unref(bitmap0);
    gdk_bitmap_unref(bitmap1);

    /* レジストリに書き込む */
    if ((profile=profile_open(NULL))!=NULL) {
        profile_set_value (profile, "vmaid", "license",
            (gpointer)&license, sizeof (gboolean), PROFILE_VALUE_TYPE_BOOL);
        profile_set_value(profile,"vmaid","history",
                (gpointer)&history,sizeof(gint),PROFILE_VALUE_TYPE_INT);
        profile_set_value(profile,"vmaid","newfile",
                (gpointer)&newfile,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL);
        profile_set_value(profile,"vmaid","second",
                (gpointer)&second,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL);
        profile_set_value(profile,"vmaid","def_width",
                (gpointer)&def_width,sizeof(gint),PROFILE_VALUE_TYPE_INT);
        profile_set_value(profile,"vmaid","def_height",
                (gpointer)&def_height,sizeof(gint),PROFILE_VALUE_TYPE_INT);
        profile_set_value(profile,"vmaid","n_pos",
                (gpointer)&n_pos,sizeof(gint),PROFILE_VALUE_TYPE_INT);
        profile_set_value(profile,"vmaid","ratio",
            (gpointer)&default_ratio,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL);
        profile_set_value(profile,"vmaid","merge",
            (gpointer)&file_merge,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL);
        profile_set_value(profile,"vmaid","view",
                (gpointer)&default_view,sizeof(gint),PROFILE_VALUE_TYPE_INT);
        profile_set_value(profile,"vmaid","rate",
                (gpointer)&default_rate,sizeof(guint),PROFILE_VALUE_TYPE_INT);
        if (open_path != NULL)
          {
            utf8str = g_filename_to_utf8 (open_path, -1, NULL, NULL, NULL);
            if (utf8str != NULL)
              {
                profile_set_value (profile, "vmaid", "openpath",
                                    (gpointer)utf8str,
                                    (g_strlen (utf8str) + 1) * sizeof (gchar),
                                                    PROFILE_VALUE_TYPE_STRING);
                g_free (utf8str);
              }
          }
        if (save_path != NULL)
          {
            utf8str = g_filename_to_utf8 (save_path, -1, NULL, NULL, NULL);
            if (utf8str != NULL)
              {
                profile_set_value (profile, "vmaid", "savepath",
                                    (gpointer)utf8str,
                                    (g_strlen (utf8str) + 1) * sizeof (gchar),
                                                    PROFILE_VALUE_TYPE_STRING);
                g_free (utf8str);
              }
          }
        /* ファイルの履歴 */
        for (i=0;i<history && history_files[i]!=NULL;i++) {
            key=g_strdup_printf("history%d",i);
            utf8str = g_filename_to_utf8 (history_files[i], -1,
                                                            NULL, NULL, NULL);
            if (utf8str != NULL)
              {
                profile_set_value (profile, "vmaid", key, (gpointer)utf8str,
                                    (g_strlen (utf8str) + 1) * sizeof (gchar),
                                                    PROFILE_VALUE_TYPE_STRING);
                g_free (utf8str);
              }
            g_free(key);
        }
        while (i<10) {
            key=g_strdup_printf("history%d",i++);
            profile_delete_key (profile, "vmaid", key);
            g_free(key);
        }
        profile_close(profile);
    }
    gdk_font_unref(system_font);
    g_free(clipboard_scenario);
    g_free(open_path);
    g_free(save_path);
    for (i=0;i<history;i++)
        g_free(history_files[i]);
    gtk_exit(0);
    return 0;
}
