/*
    Video maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __GENERAL_H__
#define __GENERAL_H__


#include "vmaid.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:一般関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:キャレットを消す
    vmaid,ウインドウ情報                                                    */
void
hide_caret (VmaidWindow *vmaid);


/*  ja:キャレットの描画
     vmaid,ウインドウ情報
    cursor,古いキャレット位置                                               */
void
draw_caret (VmaidWindow *vmaid,
            VmaidCursor *cursor);


/*  ja:メニューを設定する
    vmaid,ウインドウ情報                                                    */
void
set_menu_bar (VmaidWindow *vmaid);


/*  ja:指定範囲を再描画する
     vmaid,ウインドウ情報
    cursor,古いキャレット位置
    select,古い選択開始位置
       top,古い左の座標                                                     */
void
clear_sel (VmaidWindow *vmaid,
           VmaidCursor *cursor,
           VmaidCursor *select,
           const gint   top);


/*  ja:リストから削除する
      d,リストの先頭
    RET,削除したリストの数                                                  */
gint
delete_list (VmaidHistory **d);


/*  ja:編集履歴操作
    vmaid,ウインドウ情報
     kind,TRUE:redo,FALSE:undo                                              */
void
history_operation (VmaidWindow    *vmaid,
                   const gboolean  kind);


/*  ja:ファイルの保存を問い合わせる
    vmaid,ウインドウ情報
      RET,TRUE:ファイルは閉じる,FALSE:ファイルを閉じない                    */
gboolean
prompt_close (VmaidWindow *vmaid);


/*  ja:タブの編集済みマークの変更
      vmaid,ウインドウ情報
    is_edit,TRUE:編集済み,FALSE:未編集                                      */
void
vmaid_change_edit (VmaidWindow *vmaid,
                   gboolean     is_edit);


/******************************************************************************
*                                                                             *
* ja:高レベル関数群                                                           *
*                                                                             *
******************************************************************************/
/*  ja:最大フレーム数を求める
     vmaid,ウインドウ情報
    stream,有効なストリーム
       RET,最大フレーム数                                                   */
gint
get_max_frame (VmaidWindow *vmaid,
               const gint   stream);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif
