/*
    dllloader
    (C)Copyright 2000 by Hiroshi Takekawa
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __PE_IMAGE_H__
#define __PE_IMAGE_H__


#include "common.h"
#include "pe.h"


#ifdef __cplusplus
extern "C" {
#endif


#define g_debug(format,args...) g_message(format,##args)
//#define g_debug(format, args...)


typedef struct SymbolInfo_Tag {
	const gchar *name;
	gpointer value;
} SymbolInfo;
typedef struct SystemDll_Tag {
	const gchar *name;
	SymbolInfo *(*get_symbols)(void);
} SystemDll;
typedef struct _pe_image PE_image;
struct _pe_image {
	gchar *file;
	IMAGE_FILE_HEADER pe_header;
	IMAGE_OPTIONAL_HEADER opt_header;
	IMAGE_SECTION_HEADER *sect_headers;
	GHashTable *export;
	GHashTable *resource;
	guint8 *image;
	/* methods */
	gboolean (*load)(PE_image *,const gchar *,const gboolean);
	gpointer (*resolve)(PE_image *,const gchar *);
	void (*destroy)(PE_image *);
};


#define peimage_load(pe,path) (pe)->load(pe,path,TRUE)
#define peimage_loadex(pe,path,flags) (pe)->load(pe,path,flags)
#define peimage_resolve(pe,name) (pe)->resolve(pe,name)
#define peimage_destroy(pe) (pe)->destroy(pe)


extern SystemDll system_dll[];


gboolean module_register(const gchar *,PE_image *pe);
gboolean module_deregister(const gchar *);
PE_image *module_lookup(const gchar *);


PE_image *peimage_create(void);


#ifdef __cplusplus
}
#endif
#endif
